<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    <?php include('assets/inc/head.php');?>
    <style>
        body {
            background-color: #f9f9f9;
        }
        .card-box {
            border: none;
            box-shadow: 0 0 15px rgba(0,0,0,0.05);
            border-radius: 10px;
            background-color: #fff;
        }
        .table thead th {
            background-color: #f8f9fa;
            border-bottom: 2px solid #e9ecef;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.75rem;
            letter-spacing: 0.5px;
        }
        .table td, .table th {
            padding: 1rem;
            vertical-align: middle;
        }
        .badge-success {
            background-color: #28a745;
            padding: 0.35em 0.5em;
        }
        .btn-primary {
            background-color: #5b73e8;
            border-color: #5b73e8;
            padding: 0.5rem 1.5rem;
            border-radius: 0.3rem;
        }
        .page-title-box {
            padding: 20px 0;
        }
        .text-muted {
            color: #6c757d!important;
        }
        h3 {
            color: #5b73e8;
            margin-top: 1rem;
        }
        .print-section {
            border-top: 2px dashed #e9ecef;
            margin-top: 2rem;
            padding-top: 1.5rem;
        }
    </style>

    <body>
        <!-- Begin page -->
        <div id="wrapper">
            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include ('assets/inc/sidebar.php');?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <?php
                $pay_number = $_GET['pay_number'];
                $ret = "SELECT * FROM his_payrolls WHERE pay_number = ?";
                $stmt = $mysqli->prepare($ret);
                $stmt->bind_param('s',$pay_number);
                $stmt->execute();
                $res = $stmt->get_result();
                $cnt = 1;
                
                while($row = $res->fetch_object()) {
                    $mysqlDateTime = $row->pay_date_generated;
                    $tax = 16/100;
                    $salary = $row->pay_emp_salary;
                    $taxable_salary = $tax*$salary;
                    $total_salary = $salary - $taxable_salary;
            ?>
                <div class="content-page">
                    <div class="content">
                        <!-- Start Content-->
                        <div class="container-fluid">
                            <!-- start page title -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-title-box">
                                        <div class="page-title-right">
                                            <ol class="breadcrumb m-0">
                                                <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="javascript: void(0);">Payrolls</a></li>
                                                <li class="breadcrumb-item active">Generate Payrolls</li>
                                            </ol>
                                        </div>
                                        <h4 class="page-title">Employee Payroll</h4>
                                    </div>
                                </div>
                            </div>     
                            <!-- end page title --> 

                            <div class="row">
                                <div class="col-12">
                                    <div class="card-box p-4">
                                        <!-- Header Section -->
                                        <div class="row mb-4">
                                            <div class="col-md-8">
                                                <h3 class="mb-1"><?php echo htmlspecialchars($row->pay_doc_name); ?></h3>
                                                <p class="text-muted mb-0">Employee Payroll Statement</p>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="text-md-right">
                                                    <p class="mb-1"><strong>Generated Date:</strong> <?php echo date("M d, Y H:i", strtotime($mysqlDateTime)); ?></p>
                                                    <p class="mb-1"><strong>Status:</strong> <span class="badge badge-success"><?php echo htmlspecialchars($row->pay_status); ?></span></p>
                                                    <p class="mb-1"><strong>Payroll #:</strong> <?php echo htmlspecialchars($row->pay_number); ?></p>
                                                    <p class="mb-1"><strong>Employee #:</strong> <?php echo htmlspecialchars($row->pay_doc_number); ?></p>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Salary Details Table -->
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered mb-0">
                                                        <thead class="bg-light">
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Employee Department</th>
                                                                <th>Salary</th>
                                                                <th>PAYE Tax Rate</th>
                                                                <th class="text-right">Total Tax</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td><?php echo $cnt;?></td>
                                                                <td>
                                                                    <?php
                                                                        $doc_number = $_GET['pay_doc_number'];
                                                                        $ret = "SELECT * FROM his_docs WHERE doc_number = ?";
                                                                        $stmt = $mysqli->prepare($ret);
                                                                        $stmt->bind_param('s',$doc_number);
                                                                        $stmt->execute();
                                                                        $res = $stmt->get_result();
                                                                        while($dept_row = $res->fetch_object()) {
                                                                            echo htmlspecialchars($dept_row->doc_dept);
                                                                        }
                                                                    ?>
                                                                </td>
                                                                <td>$<?php echo number_format($row->pay_emp_salary, 2);?></td>
                                                                <td>16%</td>
                                                                <td class="text-right">$<?php echo number_format($taxable_salary, 2);?></td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Summary Section -->
                                        <div class="row print-section">
                                            <div class="col-md-6">
                                                <div class="pt-4">
                                                    <h6 class="text-muted">Notes:</h6>
                                                    <p class="text-muted">
                                                        <?php echo htmlspecialchars($row->pay_descr); ?>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="text-md-right pt-4">
                                                    <p class="mb-1"><b>Gross Salary:</b> <span class="float-right">$<?php echo number_format($row->pay_emp_salary, 2);?></span></p>
                                                    <p class="mb-1"><b>Tax Deduction (16%):</b> <span class="float-right">$<?php echo number_format($taxable_salary, 2);?></span></p>
                                                    <h3 class="mt-3">Net Salary: $<?php echo number_format($total_salary, 2);?></h3>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Action Buttons -->
                                        <div class="row mt-4">
                                            <div class="col-12 text-right d-print-none">
                                                <a href="javascript:window.print()" class="btn btn-primary">
                                                    <i class="fas fa-print mr-1"></i> Print Payroll
                                                </a>
                                            </div>
                                        </div>
                                    </div> <!-- end card-box -->
                                </div> <!-- end col -->
                            </div>
                            <!-- end row --> 
                        </div> <!-- container -->
                    </div> <!-- content -->

                    <!-- Footer Start -->
                    <?php include ("assets/inc/footer.php");?>
                    <!-- end Footer -->
                </div>
            <?php $cnt++; } ?>
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
    </body>
</html>