<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

if(isset($_GET['delete_account'])) {
    $id = intval($_GET['delete_account']);
    $adn = "DELETE FROM his_accounts WHERE acc_number=?";
    $stmt = $mysqli->prepare($adn);
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $stmt->close();     
  
    if($stmt) {
        $_SESSION['success'] = "Payable Account Records Deleted";
        header("Location: manage_acc_payable.php");
        exit();
    } else {
        $_SESSION['err'] = "Try Again Later";
        header("Location: manage_acc_payable.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #495057;
            --border: #e0e3ff;
        }

        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
            font-family: 'Inter', sans-serif;
            color: var(--dark);
            min-height: 100vh;
        }

        #wrapper {
            background: rgba(255, 255, 255, 0.95);
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }

        .card-box {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
            background-color: white;
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .page-title-box {
            padding: 20px 0;
            background: transparent;
        }

        .page-title {
            color: var(--dark);
            font-weight: 700;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
        }

        .table-responsive {
            border-radius: 12px;
            overflow: hidden;
        }

        .table {
            margin-bottom: 0;
        }

        .table thead th {
            background-color: var(--primary);
            color: white;
            border-color: var(--primary);
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.8rem;
            letter-spacing: 0.5px;
        }

        .table tbody tr {
            transition: background-color 0.2s ease;
        }

        .table tbody tr:hover {
            background-color: var(--primary-light);
        }

        .table tbody td {
            vertical-align: middle;
            border-color: var(--border);
        }

        .badge {
            padding: 0.5em 0.8em;
            font-weight: 500;
            letter-spacing: 0.5px;
            border-radius: 6px;
            transition: all 0.2s ease;
        }

        .badge-success {
            background-color: var(--success);
        }

        .badge-warning {
            background-color: var(--warning);
            color: white;
        }

        .badge-danger {
            background-color: var(--danger);
        }

        .badge:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            opacity: 0.9;
        }

        .form-control {
            border-radius: 8px;
            border: 1px solid var(--border);
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.15);
        }

        .alert {
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: none;
        }

        .pagination .page-link {
            color: var(--primary);
            border-radius: 8px !important;
            margin: 0 3px;
            border: none;
        }

        .pagination .page-item.active .page-link {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        .content-page {
            background: transparent;
        }

        .content {
            padding-bottom: 60px;
        }

        @media (max-width: 768px) {
            .table-responsive {
                border-radius: 8px;
            }
            
            .badge {
                margin-bottom: 5px;
                display: inline-block;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                                        <li class="breadcrumb-item active">Manage Payable Accounts</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Payable Accounts</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <!-- Display alerts -->
                    <?php if(isset($_SESSION['success'])): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle mr-2"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <?php if(isset($_SESSION['err'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-circle mr-2"></i> <?php echo $_SESSION['err']; unset($_SESSION['err']); ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <h4 class="header-title mb-3">Payable Accounts List</h4>
                                <div class="mb-2">
                                    <div class="row">
                                        <div class="col-12 text-sm-center form-inline">
                                            <div class="form-group">
                                                <input id="demo-foo-search" type="text" placeholder="Search accounts..." class="form-control form-control-sm" autocomplete="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table table-bordered toggle-circle mb-0" data-page-size="10">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th data-toggle="true">Account Name</th>
                                                <th data-hide="phone">Account Number</th>
                                                <th data-hide="phone">Account Amount</th>
                                                <th data-hide="phone">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                $ret = "SELECT * FROM his_accounts WHERE acc_type = 'Payable Account' ORDER BY acc_name ASC"; 
                                                $stmt = $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res = $stmt->get_result();
                                                $cnt = 1;
                                                
                                                while($row = $res->fetch_object()):
                                            ?>
                                                <tr>
                                                    <td><?php echo $cnt; ?></td>
                                                    <td><?php echo htmlspecialchars($row->acc_name); ?></td>
                                                    <td><?php echo htmlspecialchars($row->acc_number); ?></td>
                                                    <td>$ <?php echo number_format($row->acc_amount, 2); ?></td>
                                                    <td>
                                                        <div class="d-flex flex-wrap">
                                                            <a href="view_single_payable_account.php?acc_number=<?php echo $row->acc_number; ?>" class="badge badge-success mr-1 mb-1">
                                                                <i class="fas fa-eye mr-1"></i> View
                                                            </a>
                                                            <a href="update_single_payable_account.php?acc_number=<?php echo $row->acc_number; ?>" class="badge badge-warning mr-1 mb-1">
                                                                <i class="fas fa-edit mr-1"></i> Update
                                                            </a>
                                                            <a href="manage_acc_payable.php?delete_account=<?php echo $row->acc_number; ?>" 
                                                               class="badge badge-danger mr-1 mb-1" 
                                                               onclick="return confirm('Are you sure you want to delete this account?');">
                                                                <i class="fas fa-trash-alt mr-1"></i> Delete
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php 
                                                $cnt++;
                                                endwhile; 
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="active">
                                                <td colspan="5">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>
</html>