<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
  if(isset($_GET['delete']))
  {
        $id=intval($_GET['delete']);
        $adn="delete from his_docs where doc_id=?";
        $stmt= $mysqli->prepare($adn);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $stmt->close();     
  
          if($stmt)
          {
            $success = "Employee Fired";
          }
            else
            {
                $err = "Try Again Later";
            }
    }
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body style="background-color: #f5f7fb">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="padding: 15px 0">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: #6c757d">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: #6c757d">Employee</a></li>
                                            <li class="breadcrumb-item active" style="color: #4361ee">Manage Employees</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title" style="color: #2b2d42; font-weight: 600">Employee Management</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <style>
                            /* Modern Table Styling */
                            .modern-card {
                                background: white;
                                border-radius: 12px;
                                box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
                                border: none;
                                overflow: hidden;
                                transition: all 0.3s ease;
                            }
                            
                            .modern-card:hover {
                                box-shadow: 0 10px 30px rgba(67, 97, 238, 0.1);
                            }
                            
                            .modern-table {
                                width: 100%;
                                border-collapse: separate;
                                border-spacing: 0;
                            }
                            
                            .modern-table th {
                                background-color: #f8f9fc;
                                color: #4361ee;
                                font-weight: 600;
                                padding: 15px;
                                border-bottom: 2px solid #e0e3ff;
                                text-transform: uppercase;
                                font-size: 0.75rem;
                                letter-spacing: 0.5px;
                            }
                            
                            .modern-table td {
                                padding: 15px;
                                border-bottom: 1px solid #f1f3f9;
                                vertical-align: middle;
                                color: #495057;
                            }
                            
                            .modern-table tr:last-child td {
                                border-bottom: none;
                            }
                            
                            .modern-table tr:hover {
                                background-color: #f8f9ff;
                            }
                            
                            /* Action Buttons */
                            .action-badge {
                                border-radius: 6px;
                                padding: 6px 12px;
                                font-size: 0.75rem;
                                font-weight: 500;
                                display: inline-flex;
                                align-items: center;
                                gap: 5px;
                                margin: 2px;
                                transition: all 0.2s ease;
                            }
                            
                            .view-btn {
                                background-color: rgba(0, 180, 110, 0.1);
                                color: #00b46e;
                            }
                            
                            .view-btn:hover {
                                background-color: #00b46e;
                                color: white;
                                transform: translateY(-2px);
                                box-shadow: 0 4px 8px rgba(0, 180, 110, 0.2);
                            }
                            
                            .update-btn {
                                background-color: rgba(67, 97, 238, 0.1);
                                color: #4361ee;
                            }
                            
                            .update-btn:hover {
                                background-color: #4361ee;
                                color: white;
                                transform: translateY(-2px);
                                box-shadow: 0 4px 8px rgba(67, 97, 238, 0.2);
                            }
                            
                            .delete-btn {
                                background-color: rgba(220, 53, 69, 0.1);
                                color: #dc3545;
                            }
                            
                            .delete-btn:hover {
                                background-color: #dc3545;
                                color: white;
                                transform: translateY(-2px);
                                box-shadow: 0 4px 8px rgba(220, 53, 69, 0.2);
                            }
                            
                            /* Search Box */
                            .modern-search {
                                position: relative;
                                margin-left: auto;
                            }
                            
                            .modern-search input {
                                background: white;
                                border: 1px solid #e0e3ff;
                                color: #495057;
                                padding-left: 40px;
                                border-radius: 8px;
                                height: 40px;
                                width: 250px;
                                transition: all 0.3s ease;
                            }
                            
                            .modern-search input:focus {
                                border-color: #4361ee;
                                box-shadow: 0 0 0 2px rgba(67, 97, 238, 0.1);
                            }
                            
                            .modern-search i {
                                position: absolute;
                                left: 15px;
                                top: 12px;
                                color: #6c757d;
                            }
                            
                            /* Responsive Adjustments */
                            @media (max-width: 768px) {
                                .modern-table th, 
                                .modern-table td {
                                    padding: 10px;
                                    font-size: 14px;
                                }
                                
                                .modern-search input {
                                    width: 100%;
                                }
                                
                                .action-badge {
                                    margin-bottom: 5px;
                                    display: inline-flex;
                                }
                            }
                        </style>

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box modern-card">
                                    <div class="mb-3">
                                        <div class="row align-items-center">
                                            <div class="col-md-6">
                                                <h4 class="header-title mb-0" style="color: #2b2d42">Employee Records</h4>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="modern-search">
                                                    <i class="mdi mdi-magnify"></i>
                                                    <input id="demo-foo-search" type="text" placeholder="Search employees..." class="form-control" autocomplete="on">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering" class="table modern-table mb-0" data-page-size="10">
                                            <thead>
                                            <tr>
                                                <th style="width: 50px">#</th>
                                                <th data-toggle="true">Employee Name</th>
                                                <th data-hide="phone">ID Number</th>
                                                <th data-hide="phone">Department</th>
                                                <th data-hide="phone">Email</th>
                                                <th style="width: 200px">Actions</th>
                                            </tr>
                                            </thead>
                                            <?php
                                                $ret="SELECT * FROM his_docs ORDER BY RAND()"; 
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object())
                                                {
                                            ?>

                                                <tbody>
                                                <tr>
                                                    <td><?php echo $cnt;?></td>
                                                    <td>
                                                        <div style="display: flex; align-items: center; gap: 10px">
                                                            <div style="width: 36px; height: 36px; border-radius: 50%; background-color: #f0f4ff; display: flex; align-items: center; justify-content: center; color: #4361ee">
                                                                <?php echo strtoupper(substr($row->doc_fname, 0, 1)); ?>
                                                            </div>
                                                            <?php echo $row->doc_fname;?> <?php echo $row->doc_lname;?>
                                                        </div>
                                                    </td>
                                                    <td><?php echo $row->doc_number;?></td>
                                                    <td><?php echo $row->doc_dept;?></td>
                                                    <td><?php echo $row->doc_email;?></td>
                                                    
                                                    <td>
                                                        <div style="display: flex; flex-wrap: wrap; gap: 5px">
                                                            <a href="view_single_employee.php?doc_id=<?php echo $row->doc_id;?>&&doc_number=<?php echo $row->doc_number;?>" class="action-badge view-btn">
                                                                <i class="mdi mdi-eye"></i> View
                                                            </a>
                                                            <a href="update_single_employee.php?doc_number=<?php echo $row->doc_number;?>" class="action-badge update-btn">
                                                                <i class="mdi mdi-pencil"></i> Edit
                                                            </a>
                                                            <a href="manage_employee.php?delete=<?php echo $row->doc_id;?>" class="action-badge delete-btn" onclick="return confirm('Are you sure you want to delete this employee?')">
                                                                <i class="mdi mdi-delete"></i> Delete
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            <?php $cnt = $cnt +1; }?>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="6">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>