<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
  if(isset($_GET['delete_eqp']))
  {
        $id=intval($_GET['delete_eqp']);
        $adn="delete from his_equipments where eqp_code=?";
        $stmt= $mysqli->prepare($adn);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $stmt->close();  
  
          if($stmt)
          {
            $success = "Equipment Deleted";
          }
            else
            {
                $err = "Try Again Later";
            }
    }
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Surgery | Theatre </a></li>
                                            <li class="breadcrumb-item active">Manage Equipments</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">Manage Surgery | Theatre Equipments</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h4 class="header-title">Equipment List</h4>
                                        <div class="btn-group">
                                            <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="fas fa-download mr-1"></i> Export
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item" href="#" onclick="exportToExcel()">Excel</a>
                                                <a class="dropdown-item" href="#" onclick="exportToCSV()">CSV</a>
                                                <a class="dropdown-item" href="#" onclick="printTable()">Print</a>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <div class="row">
                                            <div class="col-12 text-sm-center form-inline">
                                                <div class="form-group mr-2">
                                                    <input id="demo-foo-search" type="text" placeholder="Search" class="form-control form-control-sm" autocomplete="on">
                                                </div>
                                                <div class="form-group">
                                                    <select id="status-filter" class="custom-select custom-select-sm">
                                                        <option value="">All Status</option>
                                                        <option value="Available">Available</option>
                                                        <option value="In Use">In Use</option>
                                                        <option value="Maintenance">Maintenance</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering" class="table table-bordered table-hover toggle-circle mb-0" data-page-size="7">
                                            <thead class="thead-light">
                                            <tr>
                                                <th>#</th>
                                                <th data-toggle="true">Name</th>
                                                <th data-hide="phone">Vendor</th>
                                                <th data-hide="phone">Barcode</th>
                                                <th data-hide="phone">Status</th>
                                                <th data-hide="phone">Quantity</th>
                                                <th data-hide="phone">Action</th>
                                            </tr>
                                            </thead>
                                            <?php
                                            /*
                                                *get details of allpatients
                                                *
                                            */
                                                $ret="SELECT * FROM  his_equipments WHERE eqp_dept = 'Surgical | Theatre' ORDER BY RAND() "; 
                                                $stmt= $mysqli->prepare($ret) ;
                                                $stmt->execute() ;//ok
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object())
                                                {
                                            ?>

                                                <tbody>
                                                <tr>
                                                    <td><?php echo $cnt;?></td>
                                                    <td><?php echo $row->eqp_name;?></td>
                                                    <td><?php echo $row->eqp_vendor;?></td>
                                                    <td><?php echo $row->eqp_code;?></td>
                                                    <td><span class="badge 
                                                        <?php 
                                                            if($row->eqp_status == 'Available') echo 'badge-success';
                                                            elseif($row->eqp_status == 'In Use') echo 'badge-primary';
                                                            else echo 'badge-warning';
                                                        ?>">
                                                        <?php echo $row->eqp_status;?>
                                                    </span></td>
                                                    <td><?php echo $row->eqp_qty;?></td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="view_single_eqp.php?eqp_code=<?php echo $row->eqp_code;?>" class="btn btn-sm btn-success"><i class="far fa-eye mr-1"></i> View</a>
                                                            <a href="update_single_eqp.php?eqp_code=<?php echo $row->eqp_code;?>" class="btn btn-sm btn-warning"><i class="fas fa-clipboard-check mr-1"></i> Update</a>
                                                            <a href="manage_equipment.php?delete_eqp=<?php echo $row->eqp_code;?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this equipment?');"><i class="fas fa-trash-alt mr-1"></i> Delete</a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            <?php  $cnt = $cnt +1 ; }?>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="8">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <!-- Table export and print functionality -->
        <script src="https://cdn.jsdelivr.net/npm/xlsx@0.17.0/dist/xlsx.full.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/file-saver@2.0.5/dist/FileSaver.min.js"></script>
        
        <style>
            @media print {
                body * {
                    visibility: hidden;
                }
                .card-box, .card-box * {
                    visibility: visible;
                }
                .card-box {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                }
                .no-print, .dropdown-menu, .btn-group {
                    display: none !important;
                }
                table {
                    width: 100% !important;
                }
                .badge {
                    color: black !important;
                    border: 1px solid #ddd;
                    background-color: transparent !important;
                }
            }
            
            .table-hover tbody tr:hover {
                background-color: rgba(0, 0, 0, 0.03);
            }
            
            .btn-group .btn {
                margin-right: 5px;
            }
            
            .btn-group .btn:last-child {
                margin-right: 0;
            }
        </style>
        
        <script>
            // Export to Excel function
            function exportToExcel() {
                const table = document.getElementById("demo-foo-filtering");
                const wb = XLSX.utils.table_to_book(table, {sheet:"Equipment Data"});
                XLSX.writeFile(wb, "Surgical_Equipment.xlsx");
            }
            
            // Export to CSV function
            function exportToCSV() {
                const table = document.getElementById("demo-foo-filtering");
                const ws = XLSX.utils.table_to_sheet(table);
                const csv = XLSX.utils.sheet_to_csv(ws);
                const blob = new Blob([csv], {type: "text/csv;charset=utf-8;"});
                saveAs(blob, "Surgical_Equipment.csv");
            }
            
            // Print function
            function printTable() {
                window.print();
            }
            
            // Enhanced filtering
            $(document).ready(function() {
                $('#status-filter').change(function() {
                    const filter = $(this).val().toLowerCase();
                    $('table tbody tr').each(function() {
                        const status = $(this).find('td:eq(4)').text().toLowerCase();
                        if (filter === '' || status === filter.toLowerCase()) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });
                });
            });
        </script>
    </body>
</html>