
<?php
session_start();
include('assets/inc/config.php');

// Ensure database connection is established
if(!isset($mysqli)) {
    die("Database connection not established. Please check your config.php file.");
}

include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

if(isset($_GET['delete_eqp'])) {
    $id = intval($_GET['delete_eqp']);
    $adn = "delete from his_equipments where eqp_code=?";
    $stmt = $mysqli->prepare($adn);
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $stmt->close();     
  
    if($stmt) {
        $success = "Equipment Deleted";
    } else {
        $err = "Try Again Later";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                            <li class="breadcrumb-item active">Manage Laboratory Equipment</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">Manage Laboratory Equipments</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <style>
                                        /* Modern styling enhancements */
                                        .card-box {
                                            border-radius: 12px;
                                            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
                                            transition: transform 0.3s ease, box-shadow 0.3s ease;
                                            border: none;
                                            overflow: hidden;
                                        }
                                        
                                        .card-box:hover {
                                            transform: translateY(-5px);
                                            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.12);
                                        }
                                        
                                        .table {
                                            border-collapse: separate;
                                            border-spacing: 0;
                                        }
                                        
                                        .table thead th {
                                            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
                                            color: white;
                                            border: none;
                                            font-weight: 500;
                                            padding: 15px 12px;
                                        }
                                        
                                        .table tbody tr {
                                            transition: all 0.3s ease;
                                        }
                                        
                                        .table tbody tr:hover {
                                            background-color: rgba(106, 17, 203, 0.05);
                                            transform: scale(1.005);
                                            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.05);
                                        }
                                        
                                        .table tbody td {
                                            padding: 12px;
                                            vertical-align: middle;
                                            border-top: 1px solid rgba(0, 0, 0, 0.03);
                                        }
                                        
                                        .badge {
                                            padding: 8px 12px;
                                            font-weight: 500;
                                            border-radius: 6px;
                                            transition: all 0.3s ease;
                                            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
                                        }
                                        
                                        .badge-success {
                                            background-color: #28a745;
                                        }
                                        
                                        .badge-warning {
                                            background-color: #ffc107;
                                        }
                                        
                                        .badge-danger {
                                            background-color: #dc3545;
                                        }
                                        
                                        .badge:hover {
                                            transform: translateY(-2px);
                                            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                                            opacity: 0.9;
                                        }
                                        
                                        /* Status indicators */
                                        td[data-hide="phone"]:nth-child(5) {
                                            position: relative;
                                            padding-left: 20px;
                                        }
                                        
                                        td[data-hide="phone"]:nth-child(5):before {
                                            content: "";
                                            position: absolute;
                                            left: 5px;
                                            top: 50%;
                                            transform: translateY(-50%);
                                            width: 10px;
                                            height: 10px;
                                            border-radius: 50%;
                                            background: #ccc;
                                        }
                                        
                                        td[data-hide="phone"]:nth-child(5):contains("Available"):before {
                                            background: #28a745;
                                        }
                                        
                                        td[data-hide="phone"]:nth-child(5):contains("In Use"):before {
                                            background: #ffc107;
                                        }
                                        
                                        td[data-hide="phone"]:nth-child(5):contains("Maintenance"):before {
                                            background: #dc3545;
                                        }
                                        
                                        /* Search box styling */
                                        #demo-foo-search {
                                            border-radius: 20px;
                                            padding: 10px 15px;
                                            border: 1px solid #e0e0e0;
                                            transition: all 0.3s ease;
                                        }
                                        
                                        #demo-foo-search:focus {
                                            border-color: #6a11cb;
                                            box-shadow: 0 0 0 0.2rem rgba(106, 17, 203, 0.25);
                                            outline: none;
                                        }
                                        
                                        /* Pagination styling */
                                        .pagination-rounded .page-item.active .page-link {
                                            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
                                            border-color: transparent;
                                        }
                                        
                                        .pagination-rounded .page-link {
                                            border-radius: 50% !important;
                                            margin: 0 5px;
                                            width: 36px;
                                            height: 36px;
                                            display: flex;
                                            align-items: center;
                                            justify-content: center;
                                            transition: all 0.3s ease;
                                        }
                                        
                                        /* Animation for table rows */
                                        @keyframes fadeIn {
                                            from { opacity: 0; transform: translateY(10px); }
                                            to { opacity: 1; transform: translateY(0); }
                                        }
                                        
                                        .table tbody tr {
                                            animation: fadeIn 0.5s ease forwards;
                                            opacity: 0;
                                        }
                                        
                                        .table tbody tr:nth-child(1) { animation-delay: 0.1s; }
                                        .table tbody tr:nth-child(2) { animation-delay: 0.2s; }
                                        .table tbody tr:nth-child(3) { animation-delay: 0.3s; }
                                        .table tbody tr:nth-child(4) { animation-delay: 0.4s; }
                                        .table tbody tr:nth-child(5) { animation-delay: 0.5s; }
                                        .table tbody tr:nth-child(6) { animation-delay: 0.6s; }
                                        .table tbody tr:nth-child(7) { animation-delay: 0.7s; }
                                        .table tbody tr:nth-child(8) { animation-delay: 0.8s; }
                                        .table tbody tr:nth-child(9) { animation-delay: 0.9s; }
                                        .table tbody tr:nth-child(10) { animation-delay: 1.0s; }
                                    </style>
                                    
                                    <h4 class="header-title"></h4>
                                    <div class="mb-2">
                                        <div class="row">
                                            <div class="col-12 text-sm-center form-inline" >
                                                <div class="form-group mr-2" style="display:none">
                                                    <select id="demo-foo-filter-status" class="custom-select custom-select-sm">
                                                        <option value="">Show all</option>
                                                        <option value="Discharged">Discharged</option>
                                                        <option value="OutPatients">OutPatients</option>
                                                        <option value="InPatients">InPatients</option>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <input id="demo-foo-search" type="text" placeholder="Search equipment..." class="form-control form-control-sm" autocomplete="on">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering" class="table table-bordered toggle-circle mb-0" data-page-size="7">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th data-toggle="true">Name</th>
                                                <th data-hide="phone">Vendor</th>
                                                <th data-hide="phone">Barcode</th>
                                                <th data-hide="phone">Status</th>
                                                <th data-hide="phone">Quantity</th>
                                                <th data-hide="phone">Action</th>
                                            </tr>
                                            </thead>
                                            <?php
                                            /*
                                                *get details of allpatients
                                                *
                                            */
                                                $ret="SELECT * FROM  his_equipments WHERE eqp_dept = 'Laboratory' ORDER BY RAND() "; 
                                                $stmt= $mysqli->prepare($ret) ;
                                                $stmt->execute() ;//ok
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object())
                                                {
                                            ?>

                                                <tbody>
                                                <tr>
                                                    <td><?php echo $cnt;?></td>
                                                    <td><?php echo $row->eqp_name;?></td>
                                                    <td><?php echo $row->eqp_vendor;?></td>
                                                    <td><?php echo $row->eqp_code;?></td>
                                                    <td>
                                                        <span class="status-badge 
                                                            <?php 
                                                                if($row->eqp_status == 'Available') echo 'badge-success'; 
                                                                elseif($row->eqp_status == 'In Use') echo 'badge-warning'; 
                                                                else echo 'badge-danger';
                                                            ?>">
                                                            <?php echo $row->eqp_status;?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <div class="quantity-indicator">
                                                            <?php echo $row->eqp_qty;?>
                                                            <div class="quantity-bar" style="width: <?php echo min(100, ($row->eqp_qty / 10) * 100); ?>%"></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="action-buttons">
                                                            <a href="view_single_eqp.php?eqp_code=<?php echo $row->eqp_code;?>" class="badge badge-success"><i class="far fa-eye "></i> View</a>
                                                            <a href="update_single_eqp.php?eqp_code=<?php echo $row->eqp_code;?>" class="badge badge-warning"><i class="fas fa-clipboard-check "></i> Update</a>
                                                            <a href="manage_lab_equipment.php?delete_eqp=<?php echo $row->eqp_code;?>" class="badge badge-danger" onclick="return confirm('Are you sure you want to delete this equipment?')"><i class="fas fa-trash-alt "></i> Delete</a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            <?php  $cnt = $cnt +1 ; }?>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="8">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->


        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <script>
            // Additional JavaScript for enhanced interactivity
            $(document).ready(function() {
                // Add confirmation for delete actions
                $('.badge-danger').on('click', function(e) {
                    if(!confirm('Are you sure you want to delete this equipment? This action cannot be undone.')) {
                        e.preventDefault();
                    }
                });
                
                // Add hover effects to table rows
                $('table tbody tr').hover(
                    function() {
                        $(this).css('transform', 'scale(1.01)');
                        $(this).css('box-shadow', '0 5px 15px rgba(0,0,0,0.1)');
                    },
                    function() {
                        $(this).css('transform', 'scale(1)');
                        $(this).css('box-shadow', 'none');
                    }
                );
                
                // Enhance search functionality
                $('#demo-foo-search').on('keyup', function() {
                    const searchTerm = $(this).val().toLowerCase();
                    $('table tbody tr').each(function() {
                        const rowText = $(this).text().toLowerCase();
                        $(this).toggle(rowText.indexOf(searchTerm) > -1);
                    });
                });
            });
        </script>
        
        <style>
            /* Additional CSS for the new elements */
            .status-badge {
                padding: 6px 10px;
                border-radius: 12px;
                font-size: 12px;
                font-weight: 500;
                display: inline-block;
                min-width: 80px;
                text-align: center;
            }
            
            .quantity-indicator {
                position: relative;
                padding: 5px;
            }
            
            .quantity-bar {
                position: absolute;
                bottom: 0;
                left: 0;
                height: 2px;
                background: linear-gradient(90deg, #6a11cb 0%, #2575fc 100%);
                transition: width 0.5s ease;
            }
            
            .action-buttons {
                display: flex;
                gap: 8px;
                flex-wrap: wrap;
            }
            
            /* Responsive adjustments */
            @media (max-width: 768px) {
                .action-buttons {
                    flex-direction: column;
                    gap: 5px;
                }
                
                .badge {
                    width: 100%;
                    text-align: center;
                }
            }
        </style>
    </body>
</html>