<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
  if(isset($_GET['deleteRequest']))
  {
        $id=intval($_GET['deleteRequest']);
        $adn="DELETE FROM his_pwdresets WHERE id = ?";
        $stmt= $mysqli->prepare($adn);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $stmt->close();     
  
          if($stmt)
          {
            $success = "Password reset request deleted successfully";
          }
            else
            {
                $err = "Error deleting request. Please try again later";
            }
    }
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Password Resets</a></li>
                                            <li class="breadcrumb-item active">Manage</li>
                                        </ol>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h4 class="page-title">Password Reset Requests</h4>
                                        <div class="search-box">
                                            <div class="form-group mb-0">
                                                <input id="request-search" type="text" placeholder="Search requests..." class="form-control form-control-sm" autocomplete="on">
                                                <i class="fas fa-search search-icon"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <?php if(isset($success)) { ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <?php echo $success; ?>
                            </div>
                        <?php } ?>
                        
                        <?php if(isset($err)) { ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <?php echo $err; ?>
                            </div>
                        <?php } ?>

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <div class="table-responsive">
                                        <table id="requests-table" class="table table-hover table-striped table-bordered mb-0" data-page-size="7">
                                            <thead class="thead-dark">
                                            <tr>
                                                <th width="5%">#</th>
                                                <th>Email</th>
                                                <th data-hide="phone">Reset Token</th>
                                                <th data-hide="phone">Date Requested</th>
                                                <th width="25%">Status</th>
                                                <th width="20%">Actions</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                                $ret="SELECT * FROM his_pwdresets"; 
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object()):
                                                    $requestedtime = $row->created_at;
                                            ?>
                                                <tr>
                                                    <td><?php echo $cnt;?></td>
                                                    <td>
                                                        <a href="mailto:<?php echo $row->email;?>">
                                                            <?php echo $row->email;?>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <code><?php echo $row->token;?></code>
                                                    </td>
                                                    <td><?php echo date('d-M-Y H:i', strtotime($requestedtime));?></td>
                                                    <td>
                                                        <?php if($row->status == 'Pending'): ?>
                                                            <span class="badge badge-warning p-2">Pending</span>
                                                        <?php else: ?>
                                                            <span class="badge badge-success p-2">Completed</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <div class="btn-group btn-group-sm" role="group">
                                                            <?php if($row->status == 'Pending'): ?>
                                                                <a href="update_doc_password.php?email=<?php echo $row->email;?>&pwd=<?php echo $row->pwd;?>" 
                                                                   class="btn btn-primary" title="Reset Password">
                                                                    <i class="fas fa-key"></i>
                                                                </a>
                                                            <?php else: ?>
                                                                <a href="mailto:<?php echo $row->email;?>?subject=Password Reset Request&body=Token: <?php echo $row->token;?>, New Password: <?php echo $row->pwd;?>" 
                                                                   class="btn btn-info" title="Send Email">
                                                                    <i class="fas fa-envelope"></i>
                                                                </a>
                                                            <?php endif; ?>
                                                            <a href="manage_medical_record.php?deleteRequest=<?php echo $row->id;?>" 
                                                               class="btn btn-danger" title="Delete Request"
                                                               onclick="return confirm('Are you sure you want to delete this request?')">
                                                                <i class="fas fa-trash-alt"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php 
                                                $cnt++;
                                                endwhile;
                                            ?>
                                            </tbody>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="6">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="dataTables_info">
                                                            Showing <?php echo max(1, $cnt-1); ?> requests
                                                        </div>
                                                        <div>
                                                            <ul class="pagination pagination-rounded justify-content-end mb-0"></ul>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            /* Custom styling */
            .search-box {
                position: relative;
                width: 250px;
            }
            
            .search-box .search-icon {
                position: absolute;
                right: 10px;
                top: 8px;
                color: #98a6ad;
            }
            
            #requests-table thead th {
                position: sticky;
                top: 0;
                background-color: #343a40;
                color: white;
                font-weight: 500;
            }
            
            #requests-table tbody tr:hover {
                background-color: rgba(0, 123, 255, 0.05);
            }
            
            .btn-group-sm > .btn {
                padding: 0.25rem 0.5rem;
                font-size: 0.75rem;
            }
            
            code {
                color: #e83e8c;
                background-color: #f8f9fa;
                padding: 2px 4px;
                border-radius: 3px;
                font-size: 0.9em;
            }
            
            .dataTables_info {
                font-size: 0.9rem;
                color: #6c757d;
            }
            
            .badge {
                font-weight: 500;
                padding: 0.5em 0.75em;
            }
        </style>
        
        <script>
        $(document).ready(function() {
            // Search functionality
            $('#request-search').keyup(function() {
                var searchText = $(this).val().toLowerCase();
                $('#requests-table tbody tr').each(function() {
                    var rowText = $(this).text().toLowerCase();
                    $(this).toggle(rowText.indexOf(searchText) > -1);
                });
            });
        });
        </script>
    </body>
</html>