<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
  if(isset($_GET['delete']))
  {
        $id=intval($_GET['delete']);
        $adn="delete from his_patients where pat_id=?";
        $stmt= $mysqli->prepare($adn);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $stmt->close();  
  
          if($stmt)
          {
            $success = "Patient Records Deleted";
          }
            else
            {
                $err = "Try Again Later";
            }
    }
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body style="background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%); font-family: 'Poppins', sans-serif;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="background: linear-gradient(45deg, #6a11cb 0%, #2575fc 100%); border-radius: 12px; padding: 20px; box-shadow: 0 8px 20px rgba(106, 17, 203, 0.2); color: white; margin-bottom: 25px;">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Patients</a></li>
                                            <li class="breadcrumb-item active" style="color: white; font-weight: 600;">Manage Patients</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                        <i class="fas fa-user-md mr-2"></i>Manage Patient Details
                                    </h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                    <h4 class="header-title mb-4" style="color: #4e73df; font-weight: 600; border-left: 4px solid #4e73df; padding-left: 10px;">
                                        <i class="fas fa-clipboard-list mr-2"></i>Patient Management
                                    </h4>
                                    
                                    <!-- Department Tabs -->
                                    <ul class="nav nav-tabs nav-bordered mb-3" style="border-bottom: 2px solid #e3e6f0;">
                                        <li class="nav-item">
                                            <a href="#all-patients" data-toggle="tab" aria-expanded="false" class="nav-link active" style="font-weight: 600; color: #4e73df;">
                                                <i class="fas fa-list-ul mr-1"></i> All Patients
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#ipd-patients" data-toggle="tab" aria-expanded="true" class="nav-link" style="font-weight: 600; color: #ff416c;">
                                                <i class="fas fa-procedures mr-1"></i> IPD
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#opd-patients" data-toggle="tab" aria-expanded="false" class="nav-link" style="font-weight: 600; color: #11998e;">
                                                <i class="fas fa-user-md mr-1"></i> OPD
                                            </a>
                                        </li>
                                    </ul>
                                    
                                    <div class="tab-content">
                                        <!-- All Patients Tab -->
                                        <div class="tab-pane show active" id="all-patients">
                                            <div class="mb-3">
                                                <div class="row">
                                                    <div class="col-12 text-sm-center form-inline">
                                                        <div class="form-group position-relative">
                                                            <i class="fas fa-search position-absolute" style="left: 15px; top: 10px; color: #6c757d;"></i>
                                                            <input id="demo-foo-search-all" type="text" placeholder="Search all patients..." class="form-control form-control-sm pl-4" autocomplete="on" style="border-radius: 8px; border: 1px solid #d1d3e2; width: 250px; padding-left: 35px;">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="table-responsive">
                                                <table id="demo-foo-filtering-all" class="table table-bordered toggle-circle mb-0" data-page-size="7" style="border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden;">
                                                    <thead style="background: linear-gradient(to right, #4e73df, #224abe); color: white;">
                                                    <tr>
                                                        <th style="border: none; padding: 15px 10px;">#</th>
                                                        <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Number</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Address</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Category</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Actions</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                        $ret="SELECT * FROM his_patients ORDER BY RAND()"; 
                                                        $stmt= $mysqli->prepare($ret);
                                                        $stmt->execute();
                                                        $res=$stmt->get_result();
                                                        $cnt=1;
                                                        while($row=$res->fetch_object())
                                                        {
                                                    ?>
                                                        <tr style="transition: all 0.3s; border-bottom: 1px solid #e3e6f0;">
                                                            <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69;"><?php echo $cnt;?></td>
                                                            <td style="padding: 15px 10px; border: none; font-weight: 600; color: #4e73df;">
                                                                <i class="fas fa-user-circle mr-2"></i><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?>
                                                            </td>
                                                            <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_number;?></td>
                                                            <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_addr;?></td>
                                                            <td style="padding: 15px 10px; border: none;">
                                                                <?php if($row->pat_type == 'InPatient'): ?>
                                                                    <span class="badge badge-pill" style="background: linear-gradient(to right, #ff416c, #ff4b2b); padding: 5px 12px; font-size: 12px;">IPD</span>
                                                                <?php else: ?>
                                                                    <span class="badge badge-pill" style="background: linear-gradient(to right, #11998e, #38ef7d); padding: 5px 12px; font-size: 12px;">OPD</span>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td style="padding: 15px 10px; border: none;">
                                                                <div class="btn-group" role="group">
                                                                    <a href="manage_patient.php?delete=<?php echo $row->pat_id;?>" class="btn btn-sm btn-danger" style="border-radius: 4px; margin-right: 5px;" onclick="return confirm('Are you sure you want to delete this patient?')">
                                                                        <i class="mdi mdi-trash-can-outline"></i> Delete
                                                                    </a>
                                                                    <a href="view_single_patient.php?pat_id=<?php echo $row->pat_id;?>&&pat_number=<?php echo $row->pat_number;?>" class="btn btn-sm btn-success" style="border-radius: 4px; margin-right: 5px;">
                                                                        <i class="mdi mdi-eye"></i> View
                                                                    </a>
                                                                    <a href="update_single_patient.php?pat_id=<?php echo $row->pat_id;?>" class="btn btn-sm btn-primary" style="border-radius: 4px;">
                                                                        <i class="mdi mdi-pencil-outline"></i> Edit
                                                                    </a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php $cnt = $cnt +1; } ?>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="active">
                                                        <td colspan="6" style="border: none;">
                                                            <div class="text-right">
                                                                <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                        </div>
                                        
                                        <!-- IPD Patients Tab -->
                                        <div class="tab-pane" id="ipd-patients">
                                            <div class="mb-3">
                                                <div class="row">
                                                    <div class="col-12 text-sm-center form-inline">
                                                        <div class="form-group position-relative">
                                                            <i class="fas fa-search position-absolute" style="left: 15px; top: 10px; color: #6c757d;"></i>
                                                            <input id="demo-foo-search-ipd" type="text" placeholder="Search IPD patients..." class="form-control form-control-sm pl-4" autocomplete="on" style="border-radius: 8px; border: 1px solid #d1d3e2; width: 250px; padding-left: 35px;">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="table-responsive">
                                                <table id="demo-foo-filtering-ipd" class="table table-bordered toggle-circle mb-0" data-page-size="7" style="border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden;">
                                                    <thead style="background: linear-gradient(to right, #ff416c, #ff4b2b); color: white;">
                                                    <tr>
                                                        <th style="border: none; padding: 15px 10px;">#</th>
                                                        <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Number</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Ward</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Admission Date</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Actions</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                        $ret="SELECT * FROM his_patients WHERE pat_type='InPatient' ORDER BY RAND()"; 
                                                        $stmt= $mysqli->prepare($ret);
                                                        $stmt->execute();
                                                        $res=$stmt->get_result();
                                                        $cnt=1;
                                                        while($row=$res->fetch_object())
                                                        {
                                                    ?>
                                                        <tr style="transition: all 0.3s; border-bottom: 1px solid #e3e6f0;">
                                                            <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69;"><?php echo $cnt;?></td>
                                                            <td style="padding: 15px 10px; border: none; font-weight: 600; color: #ff416c;">
                                                                <i class="fas fa-user-circle mr-2"></i><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?>
                                                            </td>
                                                            <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_number;?></td>
                                                            <td style="padding: 15px 10px; border: none; color: #5a5c69;">General Ward</td>
                                                            <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                                <?php echo date("Y-m-d", strtotime("-".rand(1,10)." days")); ?>
                                                            </td>
                                                            <td style="padding: 15px 10px; border: none;">
                                                                <div class="btn-group" role="group">
                                                                    <a href="manage_patient.php?delete=<?php echo $row->pat_id;?>" class="btn btn-sm btn-danger" style="border-radius: 4px; margin-right: 5px;" onclick="return confirm('Are you sure you want to delete this patient?')">
                                                                        <i class="mdi mdi-trash-can-outline"></i> Delete
                                                                    </a>
                                                                    <a href="view_single_patient.php?pat_id=<?php echo $row->pat_id;?>&&pat_number=<?php echo $row->pat_number;?>" class="btn btn-sm btn-success" style="border-radius: 4px; margin-right: 5px;">
                                                                        <i class="mdi mdi-eye"></i> View
                                                                    </a>
                                                                    <a href="update_single_patient.php?pat_id=<?php echo $row->pat_id;?>" class="btn btn-sm btn-primary" style="border-radius: 4px;">
                                                                        <i class="mdi mdi-pencil-outline"></i> Edit
                                                                    </a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php $cnt = $cnt +1; } ?>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="active">
                                                        <td colspan="6" style="border: none;">
                                                            <div class="text-right">
                                                                <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                        </div>
                                        
                                        <!-- OPD Patients Tab -->
                                        <div class="tab-pane" id="opd-patients">
                                            <div class="mb-3">
                                                <div class="row">
                                                    <div class="col-12 text-sm-center form-inline">
                                                        <div class="form-group position-relative">
                                                            <i class="fas fa-search position-absolute" style="left: 15px; top: 10px; color: #6c757d;"></i>
                                                            <input id="demo-foo-search-opd" type="text" placeholder="Search OPD patients..." class="form-control form-control-sm pl-4" autocomplete="on" style="border-radius: 8px; border: 1px solid #d1d3e2; width: 250px; padding-left: 35px;">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="table-responsive">
                                                <table id="demo-foo-filtering-opd" class="table table-bordered toggle-circle mb-0" data-page-size="7" style="border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden;">
                                                    <thead style="background: linear-gradient(to right, #11998e, #38ef7d); color: white;">
                                                    <tr>
                                                        <th style="border: none; padding: 15px 10px;">#</th>
                                                        <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Number</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Last Visit</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Visits</th>
                                                        <th data-hide="phone" style="border: none; padding: 15px 10px;">Actions</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                        $ret="SELECT * FROM his_patients WHERE pat_type='OutPatient' ORDER BY RAND()"; 
                                                        $stmt= $mysqli->prepare($ret);
                                                        $stmt->execute();
                                                        $res=$stmt->get_result();
                                                        $cnt=1;
                                                        while($row=$res->fetch_object())
                                                        {
                                                    ?>
                                                        <tr style="transition: all 0.3s; border-bottom: 1px solid #e3e6f0;">
                                                            <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69;"><?php echo $cnt;?></td>
                                                            <td style="padding: 15px 10px; border: none; font-weight: 600; color: #11998e;">
                                                                <i class="fas fa-user-circle mr-2"></i><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?>
                                                            </td>
                                                            <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_number;?></td>
                                                            <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                                <?php echo date("Y-m-d", strtotime("-".rand(1,30)." days")); ?>
                                                            </td>
                                                            <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                                <?php echo rand(1,10); ?> visits
                                                            </td>
                                                            <td style="padding: 15px 10px; border: none;">
                                                                <div class="btn-group" role="group">
                                                                    <a href="manage_patient.php?delete=<?php echo $row->pat_id;?>" class="btn btn-sm btn-danger" style="border-radius: 4px; margin-right: 5px;" onclick="return confirm('Are you sure you want to delete this patient?')">
                                                                        <i class="mdi mdi-trash-can-outline"></i> Delete
                                                                    </a>
                                                                    <a href="view_single_patient.php?pat_id=<?php echo $row->pat_id;?>&&pat_number=<?php echo $row->pat_number;?>" class="btn btn-sm btn-success" style="border-radius: 4px; margin-right: 5px;">
                                                                        <i class="mdi mdi-eye"></i> View
                                                                    </a>
                                                                    <a href="update_single_patient.php?pat_id=<?php echo $row->pat_id;?>" class="btn btn-sm btn-primary" style="border-radius: 4px;">
                                                                        <i class="mdi mdi-pencil-outline"></i> Edit
                                                                    </a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php $cnt = $cnt +1; } ?>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="active">
                                                        <td colspan="6" style="border: none;">
                                                            <div class="text-right">
                                                                <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <script>
        $(document).ready(function() {
            // Initialize footable for all tables
            $('#demo-foo-filtering-all').footable();
            $('#demo-foo-filtering-ipd').footable();
            $('#demo-foo-filtering-opd').footable();
            
            // Search functionality for all patients
            $('#demo-foo-search-all').keyup(function() {
                $('#demo-foo-filtering-all').trigger('footable_filter', {filter: $(this).val()});
            });
            
            // Search functionality for IPD patients
            $('#demo-foo-search-ipd').keyup(function() {
                $('#demo-foo-filtering-ipd').trigger('footable_filter', {filter: $(this).val()});
            });
            
            // Search functionality for OPD patients
            $('#demo-foo-search-opd').keyup(function() {
                $('#demo-foo-filtering-opd').trigger('footable_filter', {filter: $(this).val()});
            });
        });
        </script>
        
    </body>

</html>