<?php
session_start();
require_once('assets/inc/config.php');
require_once('assets/inc/checklogin.php');
check_login();

$aid = $_SESSION['ad_id'];
$success = $err = '';

// Secure deletion with confirmation
if(isset($_GET['delete_mdr_number']) && is_numeric($_GET['delete_mdr_number'])) {
    $id = intval($_GET['delete_mdr_number']);
    
    // First check if record exists
    $check = $mysqli->prepare("SELECT mdr_number FROM his_medical_records WHERE mdr_number = ?");
    $check->bind_param('i', $id);
    $check->execute();
    $check->store_result();
    
    if($check->num_rows > 0) {
        $adn = "DELETE FROM his_medical_records WHERE mdr_number = ?";
        $stmt = $mysqli->prepare($adn);
        $stmt->bind_param('i', $id);
        
        if($stmt->execute()) {
            $success = "Medical Record Deleted Successfully";
        } else {
            $err = "Error deleting record: " . $stmt->error;
        }
        
        $stmt->close();
    } else {
        $err = "Record not found";
    }
    
    $check->close();
}
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

<body>
    <!-- Begin page -->
    <div id="wrapper">
        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">
                <!-- Start Content-->
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Reporting</a></li>
                                        <li class="breadcrumb-item active">Medical Records</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Medical Records Management</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <!-- Display alerts -->
                    <?php if($success) { ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <?php echo $success; ?>
                        </div>
                    <?php } ?>
                    
                    <?php if($err) { ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <?php echo $err; ?>
                        </div>
                    <?php } ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <div class="mb-2">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <h4 class="header-title">Medical Records</h4>
                                            <p class="text-muted">View and manage patient medical records</p>
                                        </div>
                                        <div class="col-md-6 text-right">
                                            <div class="btn-group">
                                                <a href="add_medical_record.php" class="btn btn-primary">
                                                    <i class="fas fa-plus"></i> Add New
                                                </a>
                                                <button id="printBtn" class="btn btn-secondary">
                                                    <i class="fas fa-print"></i> Print
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-12 text-sm-center form-inline">
                                            <div class="form-group mr-2">
                                                <input id="demo-foo-search" type="text" placeholder="Search records..." class="form-control form-control-sm" autocomplete="on">
                                            </div>
                                            <div class="form-group">
                                                <button id="clear-search" class="btn btn-sm btn-outline-secondary">Clear</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="medical-records-table" class="table table-hover table-striped table-bordered" data-page-size="10">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th width="5%">#</th>
                                                <th width="15%">Patient Name</th>
                                                <th width="10%" data-hide="phone">Patient ID</th>
                                                <th width="15%" data-hide="phone">Address</th>
                                                <th width="20%" data-hide="phone">Diagnosis</th>
                                                <th width="8%" data-hide="phone">Age</th>
                                                <th width="12%" data-hide="phone">Last Updated</th>
                                                <th width="15%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $ret = "SELECT * FROM his_medical_records ORDER BY mdr_updated_at DESC"; 
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            
                                            while($row = $res->fetch_object()) {
                                                $lastUpdated = date('M d, Y', strtotime($row->mdr_updated_at));
                                            ?>
                                                <tr>
                                                    <td class="text-center"><?php echo $cnt; ?></td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm mr-2">
                                                                <span class="avatar-title bg-soft-primary rounded">
                                                                    <?php echo strtoupper(substr(htmlspecialchars($row->mdr_pat_name), 0, 1)); ?>
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-0"><?php echo htmlspecialchars($row->mdr_pat_name); ?></h6>
                                                                <small class="text-muted">ID: <?php echo htmlspecialchars($row->mdr_pat_number); ?></small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td><?php echo htmlspecialchars($row->mdr_pat_number); ?></td>
                                                    <td>
                                                        <span class="d-inline-block text-truncate" style="max-width: 150px;" 
                                                              title="<?php echo htmlspecialchars($row->mdr_pat_adr); ?>">
                                                            <?php echo htmlspecialchars($row->mdr_pat_adr); ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="d-inline-block text-truncate" style="max-width: 200px;" 
                                                              title="<?php echo htmlspecialchars($row->mdr_pat_ailment); ?>">
                                                            <?php echo htmlspecialchars($row->mdr_pat_ailment); ?>
                                                        </span>
                                                    </td>
                                                    <td class="text-center">
                                                        
                                                            <?php echo htmlspecialchars($row->mdr_pat_age); ?> Years
                                                       
                                                    </td>
                                                    <td>
                                                        <small class="text-muted"><?php echo $lastUpdated; ?></small>
                                                    </td>
                                                    <td class="text-center">
                                                        <div class="btn-group btn-group-sm" role="group">
                                                            <a href="view_single_medical_record.php?mdr_id=<?php echo $row->mdr_id; ?>&mdr_number=<?php echo $row->mdr_number; ?>" 
                                                               class="btn btn-primary btn-sm rounded-left" title="View Details">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                            <a href="update_medical_record.php?mdr_id=<?php echo $row->mdr_id; ?>&mdr_number=<?php echo $row->mdr_number; ?>" 
                                                               class="btn btn-success btn-sm" title="Edit Record">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                            <button type="button" 
                                                                   onclick="confirmDelete(<?php echo $row->mdr_number; ?>)" 
                                                                   class="btn btn-danger btn-sm rounded-right" title="Delete Record">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php 
                                                $cnt++;
                                            } 
                                            
                                            if($cnt == 1) {
                                                echo '<tr><td colspan="8" class="text-center py-4"><div class="alert alert-info mb-0">No medical records found</div></td></tr>';
                                            }
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="8">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="dataTables_info">
                                                            Showing <?php echo max(1, $cnt-1); ?> records
                                                        </div>
                                                        <div>
                                                            <ul class="pagination pagination-rounded justify-content-end mb-0"></ul>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->
        </div>
    </div>

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Sweet Alert js -->
    <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>

    <!-- PrintThis js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/printThis/1.15.0/printThis.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <style>
        #medical-records-table {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 0.9rem;
        }
        
        #medical-records-table thead th {
            position: sticky;
            top: 0;
            background-color: #343a40;
            color: white;
            font-weight: 500;
        }
        
        #medical-records-table tbody tr:hover {
            background-color: rgba(0, 123, 255, 0.05);
        }
        
        .avatar-sm {
            width: 32px;
            height: 32px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
        
        .avatar-title {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            height: 100%;
            font-weight: bold;
            color: #fff;
        }
        
        .btn-group-sm > .btn {
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
        }
        
        .text-truncate {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        
        @media print {
            body * {
                visibility: hidden;
            }
            #printable-area, #printable-area * {
                visibility: visible;
            }
            #printable-area {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
            }
            .no-print {
                display: none !important;
            }
            .table-responsive {
                overflow: visible !important;
            }
        }
    </style>
    
    <script>
    // Confirm before deletion
    function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = '?delete_mdr_number=' + id;
            }
        });
    }
    
    // Clear search
    document.getElementById('clear-search').addEventListener('click', function() {
        document.getElementById('demo-foo-search').value = '';
        FooTable.get('#demo-foo-filtering').filter();
    });
    
    // Print functionality
    $('#printBtn').click(function() {
        // Create a printable version of the table
        var printContent = `
            <div id="printable-area">
                <h2 class="text-center">Medical Records Report</h2>
                <p class="text-center">Generated on: ${new Date().toLocaleString()}</p>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Patient Name</th>
                            <th>Patient ID</th>
                            <th>Diagnosis</th>
                            <th>Age</th>
                            <th>Last Updated</th>
                        </tr>
                    </thead>
                    <tbody>
                        ${$('#medical-records-table tbody tr').map(function() {
                            const cells = $(this).find('td');
                            return `
                                <tr>
                                    <td>${cells.eq(0).text()}</td>
                                    <td>${cells.eq(1).find('h6').text()}</td>
                                    <td>${cells.eq(2).text()}</td>
                                    <td>${cells.eq(4).text()}</td>
                                    <td>${cells.eq(5).text()}</td>
                                    <td>${cells.eq(6).text()}</td>
                                </tr>
                            `;
                        }).get().join('')}
                    </tbody>
                </table>
            </div>
        `;
        
        // Open print dialog
        var printWindow = window.open('', '_blank');
        printWindow.document.write(`
            <html>
                <head>
                    <title>Medical Records Report</title>
                    <style>
                        body { font-family: Arial; margin: 20px; }
                        h2 { color: #333; text-align: center; }
                        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
                        th { background-color: #f2f2f2; text-align: left; padding: 8px; border: 1px solid #ddd; }
                        td { padding: 8px; border: 1px solid #ddd; }
                        .text-center { text-align: center; }
                    </style>
                </head>
                <body>
                    ${printContent}
                    <script>
                        window.onload = function() {
                            window.print();
                            setTimeout(function() {
                                window.close();
                            }, 100);
                        };
                    <\/script>
                </body>
            </html>
        `);
        printWindow.document.close();
    });
    </script>
</body>
</html>