<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <!-- Buttons extension -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --info: #17a2b8;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #6c757d;
            --border: #e0e3ff;
        }

     
        #wrapper {
            background-color: rgba(255, 255, 255, 0.95);
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.05);
        }

        .content-page {
            background: transparent;
        }

        .card-box {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
            background-color: white;
            overflow: hidden;
            padding: 25px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .page-title-box {
            padding: 20px 0;
            background: transparent;
            animation: fadeIn 0.5s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .page-title {
            color: var(--dark);
            font-weight: 700;
        }

        .header-title {
            color: var(--primary);
            font-weight: 700;
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
            border-bottom: 2px solid var(--primary-light);
            padding-bottom: 0.75rem;
        }

        .table-responsive {
            border-radius: 12px;
            overflow: hidden;
        }

        table.dataTable {
            border-collapse: collapse !important;
            margin-top: 0 !important;
            margin-bottom: 0 !important;
        }

        .dataTables_wrapper .dataTables_filter input {
            border-radius: 8px;
            border: 1px solid var(--border);
            padding: 5px 10px;
            margin-left: 10px;
        }

        .dataTables_wrapper .dataTables_length select {
            border-radius: 8px;
            border: 1px solid var(--border);
            padding: 5px;
        }

        .table thead th {
            background-color: var(--primary);
            color: white;
            border-color: var(--primary);
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.8rem;
            letter-spacing: 0.5px;
            position: sticky;
            top: 0;
        }

        .table tbody tr {
            transition: all 0.2s ease;
        }

        .table tbody tr:hover {
            background-color: var(--primary-light);
            transform: translateX(5px);
        }

        .table tbody td {
            vertical-align: middle;
            border-color: var(--border);
            padding: 12px 15px !important;
        }

        .badge {
            padding: 0.5em 0.8em;
            font-weight: 600;
            letter-spacing: 0.5px;
            border-radius: 6px;
            transition: all 0.2s ease;
        }

        .badge-success {
            background-color: var(--success);
        }

        .badge-warning {
            background-color: var(--warning);
            color: var(--dark);
        }

        .badge-danger {
            background-color: var(--danger);
        }

        .badge:hover {
            transform: translateY(-2px);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            opacity: 0.9;
        }

        .dt-buttons .btn {
            border-radius: 8px;
            padding: 8px 15px;
            font-weight: 500;
            margin-right: 10px;
            transition: all 0.3s ease;
        }

        .dt-buttons .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .dt-buttons .btn-secondary {
            background-color: var(--primary);
            border-color: var(--primary);
            color: white;
        }

        .dt-buttons .btn-secondary:hover {
            background-color: var(--secondary);
            border-color: var(--secondary);
        }

        /* Quantity indicator styling */
        .quantity-low {
            color: var(--danger);
            font-weight: bold;
        }
        .quantity-medium {
            color: var(--warning);
        }
        .quantity-high {
            color: var(--success);
        }

        /* Category color coding */
        .category-medicine { color: var(--primary); font-weight: 600; }
        .category-equipment { color: var(--info); font-weight: 600; }
        .category-supplies { color: var(--success); font-weight: 600; }
        .category-other { color: var(--gray); font-weight: 600; }

        /* Print styles */
        @media print {
            body * {
                visibility: hidden;
            }
            .card-box, .card-box * {
                visibility: visible;
            }
            .card-box {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                border: none;
                box-shadow: none;
            }
            .no-print, .dataTables_length, .dataTables_filter, .dataTables_info, 
            .dataTables_paginate, .dt-buttons {
                display: none !important;
            }
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .card-box {
                padding: 15px;
            }
            .dt-buttons {
                margin-bottom: 15px;
            }
            .dt-buttons .btn {
                margin-bottom: 10px;
                width: 100%;
            }
        }

        /* Animation for table rows */
        @keyframes slideIn {
            from { transform: translateX(-20px); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Reporting</a></li>
                                        <li class="breadcrumb-item active">Pharmaceutical Records</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Pharmaceutical Inventory</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h4 class="header-title">Pharmaceutical Products</h4>
                                    <div>
                                       
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="pharmaceutical-table" class="table table-bordered mb-0" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Name</th>
                                                <th>Barcode</th>
                                                <th>Vendor</th>
                                                <th>Category</th>
                                                <th>Quantity</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                $ret = "SELECT * FROM his_pharmaceuticals ORDER BY RAND()"; 
                                                $stmt = $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res = $stmt->get_result();
                                                $cnt = 1;
                                                while($row = $res->fetch_object()):
                                                    // Determine quantity class
                                                    $quantityClass = 'quantity-high';
                                                    if ($row->phar_qty < 10) {
                                                        $quantityClass = 'quantity-low';
                                                    } elseif ($row->phar_qty < 20) {
                                                        $quantityClass = 'quantity-medium';
                                                    }
                                                    
                                                    // Determine category class
                                                    $categoryClass = 'category-other';
                                                    if (stripos($row->phar_cat, 'medicine') !== false) {
                                                        $categoryClass = 'category-medicine';
                                                    } elseif (stripos($row->phar_cat, 'equipment') !== false) {
                                                        $categoryClass = 'category-equipment';
                                                    } elseif (stripos($row->phar_cat, 'supplies') !== false) {
                                                        $categoryClass = 'category-supplies';
                                                    }
                                            ?>
                                            <tr>
                                                <td><?php echo $cnt;?></td>
                                                <td><?php echo htmlspecialchars($row->phar_name);?></td>
                                                <td><?php echo htmlspecialchars($row->phar_bcode);?></td>
                                                <td><?php echo htmlspecialchars($row->phar_vendor);?></td>
                                                <td class="<?php echo $categoryClass; ?>"><?php echo htmlspecialchars($row->phar_cat);?></td>
                                                <td class="<?php echo $quantityClass; ?>"><?php echo htmlspecialchars($row->phar_qty);?> Cartons</td>
                                                <td>
                                                    <div class="d-flex" style="gap: 5px;">
                                                        <a href="view_single_pharm.php?phar_bcode=<?php echo $row->phar_bcode;?>" class="badge badge-success">
                                                            <i class="fas fa-eye mr-1"></i> View
                                                        </a>
                                                      
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php $cnt++; endwhile; ?>
                                        </tbody>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- DataTables JS -->
    <script type="text/javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <script>
        $(document).ready(function() {
            var table = $('#pharmaceutical-table').DataTable({
                dom: '<"top"Bf>rt<"bottom"lip><"clear">',
                buttons: [
                    {
                        extend: 'copy',
                        text: '<i class="far fa-copy"></i> Copy',
                        className: 'btn btn-sm btn-light',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: '<i class="far fa-file-excel"></i> Excel',
                        className: 'btn btn-sm btn-light',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: '<i class="far fa-file-pdf"></i> PDF',
                        className: 'btn btn-sm btn-light',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: '<i class="fas fa-print"></i> Print',
                        className: 'btn btn-sm btn-light',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        },
                        customize: function (win) {
                            $(win.document.body).find('h1').css('text-align','center');
                            $(win.document.body).find('table')
                                .addClass('compact')
                                .css('font-size', 'inherit');
                        }
                    }
                ],
                pageLength: 10,
                responsive: true,
                initComplete: function() {
                    // Add animation to table rows
                    $('#pharmaceutical-table tbody tr').each(function(i) {
                        $(this).css('animation', 'slideIn 0.3s ease ' + (i * 0.1) + 's forwards');
                    });
                },
                drawCallback: function() {
                    // Reapply animation when pagination changes
                    $('#pharmaceutical-table tbody tr').css('opacity', '0').each(function(i) {
                        $(this).css('animation', 'slideIn 0.3s ease ' + (i * 0.1) + 's forwards');
                    });
                }
            });

            // Add custom search box
            $('.dataTables_filter input').attr('placeholder', 'Search pharmaceuticals...');
        });
    </script>
</body>
</html>