<?php
// update_department.php

// Start session and include database connection
session_start();

include('assets/inc/config.php');

// Check if database connection is established
if (!isset($mysqli)) {
    http_response_code(500);
    die(json_encode(['status' => 'error', 'message' => 'Database connection failed']));
}

// Check if request is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die(json_encode(['status' => 'error', 'message' => 'Method not allowed']));
}

// Get and sanitize input data
$department_id = isset($_POST['department_id']) ? intval($_POST['department_id']) : 0;
$department_type = isset($_POST['department_type']) ? trim($_POST['department_type']) : '';
$department_name = isset($_POST['department_name']) ? trim($_POST['department_name']) : '';
$department_description = isset($_POST['department_description']) ? trim($_POST['department_description']) : '';
$department_fee = isset($_POST['department_fee']) ? floatval($_POST['department_fee']) : 0;
$ailment_name = isset($_POST['ailment_name']) ? trim($_POST['ailment_name']) : '';

// Validate required fields
if ($department_id <= 0 || empty($department_type) || empty($department_name)) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'Invalid input data']));
}

try {
    // Prepare the update query based on department type
    if ($department_type === 'OPD') {
        $sql = "UPDATE his_departments SET 
                department_type = ?, 
                department_name = ?, 
                department_description = ?, 
                department_fee = ?,
                ailment_name = NULL
                WHERE department_id = ?";
        
        $stmt = $mysqli->prepare($sql);
        $stmt->bind_param("sssdi", 
            $department_type, 
            $department_name, 
            $department_description, 
            $department_fee, 
            $department_id);
    } else {
        $sql = "UPDATE his_departments SET 
                department_type = ?, 
                department_name = ?, 
                department_description = ?, 
                department_fee = NULL,
                ailment_name = ?
                WHERE department_id = ?";
        
        $stmt = $mysqli->prepare($sql);
        $stmt->bind_param("ssssi", 
            $department_type, 
            $department_name, 
            $department_description, 
            $ailment_name, 
            $department_id);
    }

    // Execute the query
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(['status' => 'success', 'message' => 'Department updated successfully']);
        } else {
            echo json_encode(['status' => 'info', 'message' => 'No changes made to the department']);
        }
    } else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $mysqli->error]);
    }

    $stmt->close();
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
}

$mysqli->close();
?>