<?php
    session_start();
    include('assets/inc/config.php');
        if(isset($_POST['update_doc']))
        {
            $doc_fname=$_POST['doc_fname'];
            $doc_lname=$_POST['doc_lname'];
            $doc_number=$_GET['doc_number'];
            $doc_email=$_POST['doc_email'];
            $doc_pwd=sha1(md5($_POST['doc_pwd']));
            $doc_dpic=$_FILES["doc_dpic"]["name"];
            move_uploaded_file($_FILES["doc_dpic"]["tmp_name"],"../doc/assets/images/users/".$_FILES["doc_dpic"]["name"]);

            //sql to insert captured values
            $query="UPDATE his_docs SET doc_fname=?, doc_lname=?,  doc_email=?, doc_pwd=?, doc_dpic=? WHERE doc_number = ?";
            $stmt = $mysqli->prepare($query);
            $rc=$stmt->bind_param('ssssss', $doc_fname, $doc_lname, $doc_email, $doc_pwd, $doc_dpic, $doc_number);
            $stmt->execute();
            
            if($stmt)
            {
                $success = "Employee Details Updated";
            }
            else {
                $err = "Please Try Again Or Try Later";
            }
        }
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --success-color: #4cc9f0;
            --light-bg: #f8f9fc;
            --card-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            --form-border: #e0e3ff;
        }
        
        body {
            background-color: var(--light-bg);
            font-family: 'Inter', sans-serif;
        }
        
        .profile-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 30px 0;
            border-radius: 12px 12px 0 0;
            margin-bottom: 30px;
        }
        
        .profile-card {
            background: white;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .profile-card:hover {
            box-shadow: 0 10px 30px rgba(67, 97, 238, 0.15);
        }
        
        .profile-img-container {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            border: 5px solid white;
            overflow: hidden;
            margin: -60px auto 20px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .profile-img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .form-control {
            border: 1px solid var(--form-border);
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(67, 97, 238, 0.1);
        }
        
        .btn-update {
            background: var(--primary-color);
            border: none;
            padding: 12px 30px;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        .btn-update:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }
        
        .form-section {
            padding: 30px;
        }
        
        .section-title {
            color: var(--primary-color);
            font-weight: 600;
            margin-bottom: 25px;
            position: relative;
            padding-bottom: 10px;
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 50px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .file-upload {
            position: relative;
            overflow: hidden;
        }
        
        .file-upload-input {
            position: absolute;
            font-size: 100px;
            opacity: 0;
            right: 0;
            top: 0;
        }
        
        .file-upload-label {
            display: block;
            padding: 12px 15px;
            background: #f8f9fc;
            border: 1px dashed #d1d7e0;
            border-radius: 8px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .file-upload-label:hover {
            border-color: var(--primary-color);
            background: rgba(67, 97, 238, 0.05);
        }
        
        @media (max-width: 768px) {
            .profile-img-container {
                width: 100px;
                height: 100px;
                margin-top: -50px;
            }
            
            .form-section {
                padding: 20px;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Employee</a></li>
                                        <li class="breadcrumb-item active">Update Employee</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Employee Profile Update</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <?php
                        $doc_number=$_GET['doc_number'];
                        $ret="SELECT * FROM his_docs WHERE doc_number=?";
                        $stmt= $mysqli->prepare($ret);
                        $stmt->bind_param('i',$doc_number);
                        $stmt->execute();
                        $res=$stmt->get_result();
                        $row=$res->fetch_object();
                    ?>
                    
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="profile-card">
                                <div class="profile-header text-center">
                                    <h3>Update Employee Details</h3>
                                </div>
                                
                                <div class="profile-img-container">
                                    <img src="../doc/assets/images/users/<?php echo $row->doc_dpic;?>" class="profile-img" alt="Profile Image">
                                </div>
                                
                                <div class="form-section">
                                    <h4 class="section-title">Personal Information</h4>
                                    <form method="post" enctype="multipart/form-data">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>First Name</label>
                                                <input type="text" required value="<?php echo $row->doc_fname;?>" name="doc_fname" class="form-control">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Last Name</label>
                                                <input required type="text" value="<?php echo $row->doc_lname;?>" name="doc_lname" class="form-control">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label>Email Address</label>
                                            <input required type="email" value="<?php echo $row->doc_email;?>" class="form-control" name="doc_email">
                                        </div>
                                        
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Password</label>
                                                <input required type="password" name="doc_pwd" class="form-control" placeholder="Enter new password">
                                            </div> 
                                            
                                            <div class="form-group col-md-6">
                                                <label>Profile Picture</label>
                                                <div class="file-upload">
                                                    <label class="file-upload-label">
                                                        <i class="mdi mdi-cloud-upload mr-1"></i> Choose File
                                                        <input type="file" name="doc_dpic" class="file-upload-input">
                                                    </label>
                                                </div>
                                            </div>
                                        </div>                                            

                                        <div class="text-center mt-4">
                                            <button type="submit" name="update_doc" class="btn btn-update btn-lg">
                                                <i class="mdi mdi-content-save mr-1"></i> Update Profile
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
</body>
</html>