<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['update_payroll'])) {
    $pay_number = $_GET['pay_number'];
    $pay_doc_name = $_POST['pay_doc_name'];
    $pay_doc_number = $_POST['pay_doc_number'];
    $pay_doc_email = $_POST['pay_doc_email'];
    $pay_emp_salary = $_POST['pay_emp_salary'];
    $pay_descr = $_POST['pay_descr'];
    $pay_status = $_POST['pay_status'];
    
    $query = "UPDATE his_payrolls SET pay_doc_name=?, pay_doc_number=?, pay_doc_email=?, pay_emp_salary=?, pay_descr=?, pay_status=? WHERE pay_number=?";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('sssssss', $pay_doc_name, $pay_doc_number, $pay_doc_email, $pay_emp_salary, $pay_descr, $pay_status, $pay_number);
    $stmt->execute();
    
    if($stmt) {
        $success = "Payroll Record Updated Successfully";
    } else {
        $err = "Error Updating Payroll. Please Try Again";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #5b73e8;
            --secondary-color: #6c757d;
            --success-color: #34c38f;
            --danger-color: #f46a6a;
            --warning-color: #f1b44c;
            --info-color: #50a5f1;
            --dark-color: #343a40;
            --light-color: #f8f9fa;
        }
        
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.05);
        }
        
        .card-header {
            background-color: var(--primary-color);
            color: white;
            border-radius: 10px 10px 0 0 !important;
        }
        
        .form-control, .form-select {
            border-radius: 8px;
            padding: 10px 15px;
            border: 1px solid #e0e0e0;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(91, 115, 232, 0.25);
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 500;
        }
        
        .btn-primary:hover {
            background-color: #4a62d4;
            border-color: #4a62d4;
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .breadcrumb {
            background-color: transparent;
            padding: 0;
        }
        
        hr {
            border-top: 1px solid rgba(0,0,0,0.1);
        }
    </style>
</head>

<body>
    <!-- Begin page -->
    <div id="wrapper">
        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <?php
            $pay_number = $_GET['pay_number'];
            $ret = "SELECT * FROM his_payrolls WHERE pay_number=?";
            $stmt = $mysqli->prepare($ret);
            $stmt->bind_param('s', $pay_number);
            $stmt->execute();
            $res = $stmt->get_result();
            while($row = $res->fetch_object()) {
        ?>
        <div class="content-page">
            <div class="content">
                <!-- Start Content-->
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Payrolls</a></li>
                                        <li class="breadcrumb-item active">Update Payroll</li>
                                    </ol>
                                </div>
                                <h4 class="page-title text-primary">Update Employee Payroll Record</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <!-- Alert Messages -->
                    <?php if(isset($success)) { ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            <?php echo $success; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php } ?>
                    
                    <?php if(isset($err)) { ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <?php echo $err; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php } ?>

                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h4 class="header-title mb-0">Employee Payroll Details</h4>
                                </div>
                                <div class="card-body">
                                    <form method="post">
                                        <div class="row g-3">
                                            <div class="col-md-4">
                                                <label for="pay_doc_name" class="form-label">Employee Name</label>
                                                <input type="text" class="form-control" id="pay_doc_name" name="pay_doc_name" 
                                                    value="<?php echo $row->pay_doc_name;?>" readonly>
                                            </div>

                                            <div class="col-md-4">
                                                <label for="pay_doc_email" class="form-label">Employee Email</label>
                                                <input type="text" class="form-control" id="pay_doc_email" name="pay_doc_email" 
                                                    value="<?php echo $row->pay_doc_email;?>" readonly>
                                            </div>

                                            <div class="col-md-4">
                                                <label for="pay_doc_number" class="form-label">Employee Number</label>
                                                <input type="text" class="form-control" id="pay_doc_number" name="pay_doc_number" 
                                                    value="<?php echo $row->pay_doc_number;?>" readonly>
                                            </div>

                                            <div class="col-md-6">
                                                <label for="pay_emp_salary" class="form-label">Employee Salary ($)</label>
                                                <input type="text" class="form-control" id="pay_emp_salary" name="pay_emp_salary" 
                                                    value="<?php echo $row->pay_emp_salary;?>" required>
                                            </div>

                                            <div class="col-md-6">
                                                <label for="pay_status" class="form-label">Payroll Status</label>
                                                <select class="form-select" id="pay_status" name="pay_status" required>
                                                    <option value="">Choose Status</option>
                                                    <option value="Paid" <?php echo ($row->pay_status == 'Paid') ? 'selected' : ''; ?>>Paid</option>
                                                    <option value="Unpaid" <?php echo ($row->pay_status == 'Unpaid') ? 'selected' : ''; ?>>Unpaid</option>
                                                </select>
                                            </div>

                                            <div class="col-12">
                                                <label for="editor" class="form-label">Payroll Description</label>
                                                <textarea class="form-control" id="editor" name="pay_descr" rows="5"><?php echo $row->pay_descr;?></textarea>
                                            </div>

                                            <div class="col-12 mt-3">
                                                <button type="submit" name="update_payroll" class="btn btn-primary px-4 py-2">
                                                    <i class="fas fa-save me-2"></i>Update Payroll Record
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row -->
                </div> <!-- container -->
            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->
        </div>
        <?php } ?>
        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- CKEditor -->
   <!-- CKEditor 5 Script -->
<script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    ClassicEditor
        .create(document.querySelector('#editor'), {
            toolbar: {
                items: [
                    'heading',
                    '|',
                    'bold',
                    'italic',
                    'underline',
                    'strikethrough',
                    '|',
                    'bulletedList',
                    'numberedList',
                    '|',
                    'blockQuote',
                    'link',
                    '|',
                    'undo',
                    'redo',
                    '|',
                    'sourceEditing'
                ],
                shouldNotGroupWhenFull: true
            },
            heading: {
                options: [
                    { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                    { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
                    { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' }
                ]
            },
            height: '200px',
            placeholder: 'Enter payroll description here...',
            language: 'en',
            licenseKey: ''
        })
        .then(editor => {
            window.editor = editor;
            
            // Handle form submission to update editor content
            document.querySelector('form').addEventListener('submit', function() {
                document.getElementById('editor').value = editor.getData();
            });
        })
        .catch(error => {
            console.error('There was a problem initializing the editor.', error);
            
            // Fallback to textarea if CKEditor fails to load
            const editorElement = document.querySelector('#editor');
            editorElement.style.display = 'block';
            editorElement.style.width = '100%';
            editorElement.style.minHeight = '200px';
            editorElement.style.padding = '10px';
            editorElement.style.border = '1px solid #e0e0e0';
            editorElement.style.borderRadius = '8px';
        });
});
</script>

<style>
/* CKEditor 5 Custom Styling */
.ck-editor__editable {
    min-height: 200px;
    border-radius: 8px !important;
    border: 1px solid #e0e0e0 !important;
    padding: 15px !important;
}

.ck.ck-toolbar {
    border-radius: 8px 8px 0 0 !important;
    border: 1px solid #e0e0e0 !important;
    border-bottom: none !important;
}

.ck.ck-editor__main>.ck-editor__editable:not(.ck-focused) {
    border-color: #e0e0e0 !important;
}

.ck.ck-editor__main>.ck-editor__editable.ck-focused {
    border-color: var(--primary-color) !important;
    box-shadow: 0 0 0 1px var(--primary-color) !important;
}

.ck.ck-button:not(.ck-disabled):hover, 
.ck.ck-button:not(.ck-disabled):active, 
.ck.ck-button.ck-on {
    color: var(--primary-color) !important;
}

.ck.ck-dropdown__panel, 
.ck.ck-balloon-panel {
    border-radius: 8px !important;
}
</style>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
</body>
</html>