<!--Server side code to handle Patient Registration-->
<?php
    session_start();
    include('assets/inc/config.php');
        if(isset($_POST['update_patient']))
        {
            $pat_id = $_GET['pat_id'];
            $pat_fname=$_POST['pat_fname'];
            $pat_lname=$_POST['pat_lname'];
            $pat_number=$_POST['pat_number'];
            $pat_phone=$_POST['pat_phone'];
            $pat_type=$_POST['pat_type'];
            $pat_addr=$_POST['pat_addr'];
            $pat_age = $_POST['pat_age'];
            $pat_dob = $_POST['pat_dob'];
            $pat_ailment = $_POST['pat_ailment'];
             $doc_dept= $_POST['doc_dept'];
            $doc_id= $_POST['doc_id'];

             $insurance = $_POST['insurance'];
            $status = $_POST['status'];
            $gender= $_POST['gender'];
            $card_no= $_POST['card_no'];
                 $title= $_POST['title'];
            //sql to insert captured values
            $query="UPDATE his_patients SET pat_fname=?, pat_lname=?, pat_age=?, pat_dob=?,  pat_phone=?, pat_type=?, pat_addr=?, pat_ailment=?, dept=? ,doc_id=?,insurance=?,status=?,gender=?,card_no=?,title=? WHERE pat_id = ?";
            $stmt = $mysqli->prepare($query);
            $rc=$stmt->bind_param('sssssssssssssssi', $pat_fname, $pat_lname, $pat_age, $pat_dob, $pat_phone, $pat_type, $pat_addr, $pat_ailment, $doc_dept, $doc_id, $insurance, $status ,  $gender,$card_no,$title, $pat_id);
            $stmt->execute();
            
            if($stmt)
            {
                $success = "Patient Details Updated Successfully";
            }
            else {
                $err = "Please Try Again Or Try Later";
            }
        }
?>
<!--End Server Side-->
<!--End Patient Registration-->
<!DOCTYPE html>
<html lang="en">
    <!-- Add this to your head section or CSS file -->
<style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
    
    /* Add smooth transitions and animations */
    :root {
        --primary-color: #4e73df;
        --secondary-color: #1cc88a;
        --accent-color: #f6c23e;
        --dark-color: #5a5c69;
        --light-color: #f8f9fc;
        --transition-speed: 0.3s;
    }
    
    /* Form element animations */
    .form-control {
        transition: all var(--transition-speed) ease, box-shadow 0.3s ease;
        box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }
    
    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        transform: translateY(-2px);
    }
    
    .form-group {
        transition: transform 0.3s ease;
    }
    
    .form-group:hover {
        transform: translateY(-3px);
    }
    
    /* Card animation */
    .card {
        transition: transform 0.4s ease, box-shadow 0.4s ease;
    }
    
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.15) !important;
    }
    
    /* Button animations */
    .btn-success {
        position: relative;
        overflow: hidden;
        transition: all 0.4s ease;
    }
    
    .btn-success:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(17, 153, 142, 0.4) !important;
    }
    
    .btn-success:active {
        transform: translateY(1px);
    }
    
    .btn-success::after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 5px;
        height: 5px;
        background: rgba(255, 255, 255, 0.5);
        opacity: 0;
        border-radius: 100%;
        transform: scale(1, 1) translate(-50%);
        transform-origin: 50% 50%;
    }
    
    .btn-success:focus:not(:active)::after {
        animation: ripple 1s ease-out;
    }
    
    @keyframes ripple {
        0% {
            transform: scale(0, 0);
            opacity: 0.5;
        }
        100% {
            transform: scale(20, 20);
            opacity: 0;
        }
    }
    
    /* Page title animation */
    .page-title-box {
        position: relative;
        overflow: hidden;
    }
    
    .page-title-box::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: linear-gradient(
            to bottom right,
            rgba(255,255,255,0.3) 0%,
            rgba(255,255,255,0) 60%
        );
        transform: rotate(30deg);
        animation: shine 3s infinite;
    }
    
    @keyframes shine {
        0% { transform: rotate(30deg) translate(-30%, -30%); }
        100% { transform: rotate(30deg) translate(30%, 30%); }
    }
    
    /* Input label animation */
    .col-form-label {
        position: relative;
        display: inline-block;
        transition: all 0.3s ease;
    }
    
    .form-group:focus-within .col-form-label {
        color: var(--primary-color);
        transform: translateY(-2px);
    }
    
    /* Select dropdown arrow animation */
    select {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%235a5c69' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e") !important;
        background-repeat: no-repeat !important;
        background-position: right 0.75rem center !important;
        background-size: 16px 12px !important;
        transition: all var(--transition-speed) ease;
    }
    
    select:focus {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%234e73df' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e") !important;
    }
    
    /* Floating animation for important elements */
    @keyframes float {
        0% { transform: translateY(0px); }
        50% { transform: translateY(-8px); }
        100% { transform: translateY(0px); }
    }
    
    .floating {
        animation: float 3s ease-in-out infinite;
    }
    
    /* Pulse animation for notifications */
    @keyframes pulse {
        0% { box-shadow: 0 0 0 0 rgba(30, 204, 138, 0.7); }
        70% { box-shadow: 0 0 0 10px rgba(30, 204, 138, 0); }
        100% { box-shadow: 0 0 0 0 rgba(30, 204, 138, 0); }
    }
    
    .pulse {
        animation: pulse 2s infinite;
    }
    
    /* Loading animation */
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .loading {
        animation: spin 1s linear infinite;
    }
    
    /* Add these to your existing style tags */
    .form-control {
        border-radius: 10px !important;
        padding: 12px 20px !important;
        height: auto !important;
    }
    
    select.form-control {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
    }
    
    /* Enhanced dropdown styling */
    .dropdown-menu {
        border: none;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        border-radius: 10px;
        overflow: hidden;
        animation: fadeIn 0.3s ease-out;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    
    /* Tooltip animations */
    [data-toggle="tooltip"] {
        position: relative;
    }
    
    [data-toggle="tooltip"]::after {
        content: attr(data-title);
        position: absolute;
        bottom: 100%;
        left: 50%;
        transform: translateX(-50%);
        background: #333;
        color: #fff;
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 12px;
        opacity: 0;
        transition: all 0.3s;
        pointer-events: none;
        white-space: nowrap;
    }
    
    [data-toggle="tooltip"]:hover::after {
        opacity: 1;
        transform: translateX(-50%) translateY(-5px);
    }
</style>

<!-- Add this script at the end of your body for interactive animations -->
<script>
    // Add animation to form elements when page loads
    document.addEventListener('DOMContentLoaded', function() {
        // Animate form elements sequentially
        const formGroups = document.querySelectorAll('.form-group');
        formGroups.forEach((group, index) => {
            setTimeout(() => {
                group.style.opacity = '0';
                group.style.transform = 'translateY(20px)';
                group.style.transition = 'all 0.5s ease';
                
                // Trigger reflow
                void group.offsetWidth;
                
                group.style.opacity = '1';
                group.style.transform = 'translateY(0)';
            }, index * 100);
        });
        
        // Add floating animation to important elements
        const pageTitle = document.querySelector('.page-title');
        if (pageTitle) {
            pageTitle.classList.add('floating');
        }
        
        // Add pulse animation to success messages
        const successMessages = document.querySelectorAll('.alert-success');
        successMessages.forEach(msg => {
            msg.classList.add('pulse');
        });
        
        // Enhanced input interactions
        document.querySelectorAll('.form-control').forEach(input => {
            // Add focus/blur effects
            input.addEventListener('focus', function() {
                this.parentNode.querySelector('.col-form-label').style.color = '#4e73df';
                this.parentNode.querySelector('.col-form-label').style.transform = 'translateY(-5px)';
                this.parentNode.style.transform = 'scale(1.01)';
            });
            
            input.addEventListener('blur', function() {
                this.parentNode.querySelector('.col-form-label').style.color = '#5a5c69';
                this.parentNode.querySelector('.col-form-label').style.transform = 'translateY(0)';
                this.parentNode.style.transform = 'scale(1)';
            });
            
            // Add input validation effects
            input.addEventListener('input', function() {
                if (this.checkValidity()) {
                    this.style.borderColor = '#1cc88a';
                    setTimeout(() => {
                        this.style.borderColor = '#d1d3e2';
                    }, 2000);
                }
            });
        });
        
        // Button hover effects
        document.querySelectorAll('.btn').forEach(button => {
            button.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-3px)';
            });
            
            button.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
            
            button.addEventListener('mousedown', function() {
                this.style.transform = 'translateY(1px)';
            });
            
            button.addEventListener('mouseup', function() {
                this.style.transform = 'translateY(-3px)';
            });
        });
        
        // Card hover effects
        document.querySelectorAll('.card').forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-5px)';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });
    });
    
    // Enhanced filterDoctors function with animation
    function filterDoctors() {
        var department = document.getElementById('department').value;
        var doctorDropdown = document.getElementById('doctor');
        var options = doctorDropdown.options;
        
        // Add loading animation
        doctorDropdown.disabled = true;
        doctorDropdown.style.opacity = '0.5';
        
        setTimeout(() => {
            // First option is "Select Doctor"
            for (var i = 1; i < options.length; i++) {
                var option = options[i];
                if (department === "" || option.getAttribute('data-dept') === department) {
                    option.style.display = '';
                    option.style.animation = 'fadeIn 0.3s ease-out';
                } else {
                    option.style.display = 'none';
                }
            }
            
            // Reset selection
            doctorDropdown.selectedIndex = 0;
            doctorDropdown.disabled = false;
            doctorDropdown.style.opacity = '1';
            
            // Animate the dropdown
            doctorDropdown.style.transform = 'scale(1.05)';
            setTimeout(() => {
                doctorDropdown.style.transform = 'scale(1)';
            }, 300);
        }, 500);
    }
</script>
    <!--Head-->
    <?php include('assets/inc/head.php');?>
    <body style="background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%); font-family: 'Poppins', sans-serif;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="background: linear-gradient(45deg, #6a11cb 0%, #2575fc 100%); border-radius: 12px; padding: 20px; box-shadow: 0 8px 20px rgba(106, 17, 203, 0.2); color: white; margin-bottom: 25px;">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Patients</a></li>
                                            <li class="breadcrumb-item active" style="color: white; font-weight: 600;">Update Patient</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                        <i class="fas fa-user-edit mr-2"></i>Update Patient Details
                                    </h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 
                        <!-- Form row -->
                        <!--LETS GET DETAILS OF SINGLE PATIENT GIVEN THEIR ID-->
                        <?php
                            $pat_id=$_GET['pat_id'];
                            $ret="SELECT * FROM his_patients WHERE pat_id=?";
                            $stmt= $mysqli->prepare($ret);
                            $stmt->bind_param('i',$pat_id);
                            $stmt->execute();
                            $res=$stmt->get_result();
                            while($row=$res->fetch_object())
                            {
                        ?>
                        <div class="row">
                            <div class="col-12">
                                <div class="card" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                    <div class="card-body" style="padding: 2rem;">
                                        <h4 class="header-title" style="color: #4e73df; border-bottom: 2px solid #f8f9fc; padding-bottom: 10px; margin-bottom: 20px;">
                                            <i class="fas fa-user-injured mr-2"></i>Patient Information
                                        </h4>
                                        <!--Add Patient Form-->
                                        <form method="post">
                                            <div class="form-row">
                                                <!-- Personal Information Section -->
                                                <div class="form-group col-md-4">
                                                    <label for="patientTitle">Patient Title</label>
                                                    <select required="required" name="title" class="form-control" id="patientTitle">
                                                        <option value="" disabled selected>Select Title</option>
                                                        <option value="Male">Mr</option>
                                                        <option value="Female">Miss</option>
                                                        <option value="Other">Mrs</option>
                                                        <option value="Other">Master</option>
                                                        <option value="Other">Baby</option>
                                                        <option value="Other">Prof</option>
                                                        <option value="Other">Doc</option>
                                                    </select>
                                                    <small class="form-text text-muted">Select Title</small>
                                                </div>
                                                
                                                <div class="form-group col-md-6">
                                                    <label for="inputFirstName" class="col-form-label" style="font-weight: 600; color: #5a5c69;">First Name</label>
                                                    <input type="text" required="required" value="<?php echo $row->pat_fname;?>" name="pat_fname" class="form-control" id="inputFirstName" placeholder="Patient's First Name" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; transition: all 0.3s; background-color: #f8f9fc;">
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Enter patient's legal first name</small>
                                                </div>
                                                
                                                <div class="form-group col-md-6">
                                                    <label for="inputLastName" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Last Name</label>
                                                    <input required="required" type="text" value="<?php echo $row->pat_lname;?>" name="pat_lname" class="form-control" id="inputLastName" placeholder="Patient's Last Name" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; transition: all 0.3s; background-color: #f8f9fc;">
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Enter patient's legal last name</small>
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="inputAadhar">Aadhar Card No</label>
                                                    <input required="required" type="text" name="card_no" value="<?php echo $row->card_no;?>" class="form-control" id="inputAadhar" placeholder="Aadhar card No">
                                                    <small class="form-text text-muted">Enter Aadhar card number</small>
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="patientGender">Gender</label>
                                                    <select required="required" name="gender" class="form-control" id="patientGender">
                                                        <option value="" disabled selected>Select Gender</option>
                                                        <option value="Male" <?php echo ($row->gender == 'Male') ? 'selected' : ''; ?>>Male</option>
                                                        <option value="Female" <?php echo ($row->gender == 'Female') ? 'selected' : ''; ?>>Female</option>
                                                        <option value="Other" <?php echo ($row->gender == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                    <small class="form-text text-muted">Select gender</small>
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="patientStatus">Marital Status</label>
                                                    <select required="required" name="status" class="form-control" id="patientStatus">
                                                        <option value="" disabled selected>Select status</option>
                                                        <option value="Single" <?php echo ($row->status == 'Single') ? 'selected' : ''; ?>>Single</option>
                                                        <option value="Married" <?php echo ($row->status == 'Married') ? 'selected' : ''; ?>>Married</option>
                                                        <option value="Divorced" <?php echo ($row->status == 'Divorced') ? 'selected' : ''; ?>>Divorced</option>
                                                        <option value="Other" <?php echo ($row->status == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                    <small class="form-text text-muted">Select Status</small>
                                                </div>
                                                
                                                <div class="form-group col-md-6">
                                                    <label for="inputDOB" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Date Of Birth</label>
                                                    <input type="date" required="required" value="<?php echo $row->pat_dob;?>" name="pat_dob" class="form-control" id="inputDOB" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; transition: all 0.3s; background-color: #f8f9fc;">
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Patient's date of birth</small>
                                                </div>
                                                
                                                <div class="form-group col-md-6">
                                                    <label for="inputAge" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Age</label>
                                                    <input required="required" type="number" value="<?php echo $row->pat_age;?>" name="pat_age" class="form-control" id="inputAge" placeholder="Patient's Age" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; transition: all 0.3s; background-color: #f8f9fc;">
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Patient's current age</small>
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="inputInsurance">Insurance Company</label>
                                                    <input required="required" type="text" name="insurance" value="<?php echo $row->insurance;?>" class="form-control" id="inputInsurance" placeholder="Insurance company">
                                                    <small class="form-text text-muted">Insurance Company</small>
                                                </div>
                                                
                                                <!-- Contact Information Section -->
                                                <div class="form-group">
                                                    <label for="inputAddress" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Address</label>
                                                    <input required="required" type="text" value="<?php echo $row->pat_addr;?>" class="form-control" name="pat_addr" id="inputAddress" placeholder="Patient's Address" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; transition: all 0.3s; background-color: #f8f9fc;">
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Full residential address</small>
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="inputPhone" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Mobile Number</label>
                                                    <input required="required" type="tel" value="<?php echo $row->pat_phone;?>" name="pat_phone" class="form-control" id="inputPhone" placeholder="e.g. +254700000000" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; transition: all 0.3s; background-color: #f8f9fc;">
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">With country code</small>
                                                </div>
                                                
                                                <!-- Medical Information Section -->
                                                <div class="form-group col-md-4">
                                                    <label for="patientAilment" class="col-form-label" style="font-weight: 600; color: #5a5c69; margin-bottom: 8px;">Patient Ailment</label>
                                                    <select required="required" name="pat_ailment" class="form-control" id="patientAilment" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; transition: all 0.3s; background-color: #f8f9fc; appearance: none; background-image: url('data:image/svg+xml;utf8,<svg fill="%235a5c69" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>'); background-repeat: no-repeat; background-position: right 10px center;">
                                                        <option value="" disabled selected>Select Ailment Type</option>
                                                        <option value="Normal" <?php echo (isset($row->pat_ailment) && $row->pat_ailment == 'Normal') ? 'selected' : ''; ?>>Normal</option>
                                                        <option value="Normal+Emergency" <?php echo (isset($row->pat_ailment) && $row->pat_ailment == 'Normal+Emergency') ? 'selected' : ''; ?>>Normal+Emergency</option>
                                                    </select>
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Select the patient's condition type</small>
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="inputPatientType" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Patient's Type</label>
                                                    <select id="inputPatientType" required="required" name="pat_type" class="form-control" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; height: auto; transition: all 0.3s; background-color: #f8f9fc; appearance: none; background-image: url('data:image/svg+xml;utf8,<svg fill="%235a5c69" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>'); background-repeat: no-repeat; background-position: right 10px center;">
                                                        <option value="" disabled>Select Patient Type</option>
                                                        <option value="InPatient" <?php echo ($row->pat_type == 'InPatient') ? 'selected' : ''; ?>>IPD</option>
                                                        <option value="OutPatient" <?php echo ($row->pat_type == 'OutPatient') ? 'selected' : ''; ?>>OPD</option>
                                                    </select>
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Select admission type</small>
                                                </div>
                                                
                                                <!-- Doctor Information Section -->
                                                <div class="form-group col-md-4">
                                                    <?php
                                                    $ret = "SELECT * FROM his_docs ";
                                                    $stmt = $mysqli->prepare($ret);
                                                    $stmt->execute();
                                                    $res = $stmt->get_result();
                                                    $row = $res->fetch_object();
                                                    ?>
                                                    <label for="department">Department</label>
                                                    <select required name="doc_dept" id="department" class="form-control" onchange="filterDoctors()">
                                                        <option value="">Select Department</option>
                                                        <option value="Laboratory" <?php echo ($row->doc_dept == 'Laboratory') ? 'selected' : ''; ?>>Laboratory</option>
                                                        <option value="Pharmacy" <?php echo ($row->doc_dept == 'Pharmacy') ? 'selected' : ''; ?>>Pharmacy</option>
                                                        <option value="Surgery | Theatre" <?php echo ($row->doc_dept == 'Surgery | Theatre') ? 'selected' : ''; ?>>Surgery | Theatre</option>
                                                    </select>
                                                    <small class="form-text text-muted">Select department</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label for="doctor">Doctor</label>
                                                    <select required name="doc_id" id="doctor" class="form-control">
                                                        <option value="">Select Doctor</option>
                                                        <?php
                                                        $ret = "SELECT * FROM his_docs";
                                                        $stmt = $mysqli->prepare($ret);
                                                        $stmt->execute();
                                                        $res = $stmt->get_result();
                                                        while ($row = $res->fetch_object()) {
                                                            echo '<option value="' . $row->doc_id . '" data-dept="' . $row->doc_dept . '">' . $row->doc_fname . ' ' . $row->doc_lname . '</option>';
                                                        }
                                                        ?>
                                                    </select>
                                                    <small class="form-text text-muted">Select doctor</small>
                                                </div>
                                                
                                                <div class="form-group col-md-2" style="display:none">
                                                    <?php 
                                                        $length = 5;    
                                                        $patient_number =  substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                                                    ?>
                                                    <label for="inputPatientNumber" class="col-form-label">Patient Number</label>
                                                    <input type="text" name="pat_number" value="<?php echo $row->pat_number;?>" class="form-control" id="inputPatientNumber">
                                                </div>
                                            </div>

                                            <div class="text-right mt-4">
                                                <button type="submit" name="update_patient" class="ladda-button btn btn-success" data-style="expand-right" style="background: linear-gradient(to right, #11998e, #38ef7d); border: none; padding: 12px 30px; font-weight: 600; border-radius: 8px; box-shadow: 0 4px 15px rgba(17, 153, 142, 0.3); transition: all 0.3s; position: relative; overflow: hidden;">
                                                    <span class="ladda-label" style="position: relative; z-index: 2;">
                                                        <i class="fas fa-save mr-2"></i>Update Patient
                                                    </span>
                                                    <span class="ladda-spinner"></span>
                                                </button>
                                            </div>

                                        </form>
                                        <!--End Patient Form-->
                                    </div> <!-- end card-body -->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        <?php } ?>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>

        <!-- Loading buttons js -->
        <script src="assets/libs/ladda/spin.js"></script>
        <script src="assets/libs/ladda/ladda.js"></script>

        <!-- Buttons init js-->
        <script src="assets/js/pages/loading-btn.init.js"></script>
          <script>
        function filterDoctors() {
            var department = document.getElementById('department').value;
            var doctorDropdown = document.getElementById('doctor');
            var options = doctorDropdown.options;
            
            // First option is "Select Doctor"
            for (var i = 1; i < options.length; i++) {
                var option = options[i];
                if (department === "" || option.getAttribute('data-dept') === department) {
                    option.style.display = '';
                } else {
                    option.style.display = 'none';
                }
            }
            
            // Reset selection
            doctorDropdown.selectedIndex = 0;
        }

        // Initialize by filtering doctors on page load
        window.onload = function() {
            filterDoctors();
            
            // Add animation to form elements on focus
            document.querySelectorAll('.form-control').forEach(input => {
                input.addEventListener('focus', function() {
                    this.parentElement.style.transform = 'translateY(-3px)';
                });
                
                input.addEventListener('blur', function() {
                    this.parentElement.style.transform = '';
                });
            });
        };
        </script>
    </body>

</html>