<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['update_pharmaceutical'])) {
    $phar_name = $_POST['phar_name'];
    $phar_desc = $_POST['phar_desc'];
    $phar_qty = $_POST['phar_qty'];
    $phar_cat = $_POST['phar_cat'];
    $phar_bcode = $_GET['phar_bcode'];
    $phar_vendor = $_POST['phar_vendor'];
        
    $query = "UPDATE his_pharmaceuticals SET phar_name=?, phar_desc=?, phar_qty=?, phar_cat=?, phar_vendor=? WHERE phar_bcode=?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssssss', $phar_name, $phar_desc, $phar_qty, $phar_cat, $phar_vendor, $phar_bcode);
    $stmt->execute();
    
    if($stmt) {
        $success = "Pharmaceutical updated successfully!";
    } else {
        $err = "Error updating pharmaceutical. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #495057;
            --border: #e0e3ff;
        }
        
        body {
            background-color: var(--light);
            font-family: 'Inter', sans-serif;
        }
        
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .page-title {
            color: var(--dark);
            font-weight: 700;
            position: relative;
            display: inline-block;
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: -8px;
            width: 60px;
            height: 3px;
            background: var(--primary);
            border-radius: 3px;
        }
        
        .form-control, .form-select {
            border: 1px solid var(--border);
            border-radius: 8px;
            padding: 12px 15px;
            height: auto;
            transition: all 0.3s;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.15);
        }
        
        label {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 8px;
        }
        
        .btn-warning {
            background-color: var(--warning);
            border-color: var(--warning);
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s;
            color: #fff;
        }
        
        .btn-warning:hover {
            background-color: #e69500;
            border-color: #d98e00;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(255, 158, 0, 0.2);
        }
        
        .header-title {
            color: var(--primary);
            font-weight: 700;
            margin-bottom: 20px;
            position: relative;
            padding-bottom: 10px;
        }
        
        .header-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 60px;
            height: 3px;
            background: var(--primary);
            border-radius: 3px;
        }
        
        /* CKEditor 5 Styling */
        .ck.ck-editor {
            border-radius: 8px;
            overflow: hidden;
            margin-top: 10px;
        }
        
        .ck.ck-toolbar {
            border-radius: 8px 8px 0 0 !important;
            background-color: var(--light) !important;
            border: 1px solid var(--border) !important;
            border-bottom: none !important;
        }
        
        .ck.ck-content {
            min-height: 200px;
            border-radius: 0 0 8px 8px !important;
            border: 1px solid var(--border) !important;
            border-top: none !important;
        }
        
        @media (max-width: 768px) {
            .form-group {
                margin-bottom: 20px;
            }
            
            .btn-warning {
                width: 100%;
            }
        }
    </style>
</head>

<body>

    <div id="wrapper">
        <?php include("assets/inc/nav.php");?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0);">Pharmaceuticals</a></li>
                                        <li class="breadcrumb-item active">Update Pharmaceutical</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">
                                    <?php 
                                        $phar_bcode = $_GET['phar_bcode'];
                                        $ret = "SELECT * FROM his_pharmaceuticals WHERE phar_bcode=?";
                                        $stmt = $mysqli->prepare($ret);
                                        $stmt->bind_param('s', $phar_bcode);
                                        $stmt->execute();
                                        $res = $stmt->get_result();
                                        $row = $res->fetch_object();
                                        echo "Update #" . htmlspecialchars($row->phar_bcode) . " - " . htmlspecialchars($row->phar_name);
                                    ?>
                                </h4>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Pharmaceutical Details</h4>
                                    
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="phar_name">Pharmaceutical Name</label>
                                                <input type="text" class="form-control" id="phar_name" name="phar_name" 
                                                    value="<?php echo htmlspecialchars($row->phar_name); ?>" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="phar_qty">Quantity (Cartons)</label>
                                                <input type="number" class="form-control" id="phar_qty" name="phar_qty" 
                                                    value="<?php echo htmlspecialchars($row->phar_qty); ?>" required>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="editor">Description</label>
                                            <textarea class="form-control" id="editor" name="phar_desc"><?php echo htmlspecialchars($row->phar_desc); ?></textarea>
                                        </div>
                                        
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="phar_vendor">Vendor</label>
                                                <input type="text" class="form-control" id="phar_vendor" name="phar_vendor" 
                                                    value="<?php echo htmlspecialchars($row->phar_vendor); ?>" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="phar_cat">Category</label>
                                                <select class="form-control" id="phar_cat" name="phar_cat" required>
                                                    <?php
                                                    $cat_query = "SELECT * FROM his_pharmaceuticals_categories ORDER BY pharm_cat_name";
                                                    $cat_stmt = $mysqli->prepare($cat_query);
                                                    $cat_stmt->execute();
                                                    $cat_res = $cat_stmt->get_result();
                                                    while($cat_row = $cat_res->fetch_object()) {
                                                        $selected = ($cat_row->pharm_cat_name == $row->phar_cat) ? 'selected' : '';
                                                        echo '<option value="' . htmlspecialchars($cat_row->pharm_cat_name) . '" ' . $selected . '>' 
                                                            . htmlspecialchars($cat_row->pharm_cat_name) . '</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <button type="submit" name="update_pharmaceutical" class="btn btn-warning ladda-button" data-style="expand-right">
                                            <i class="fas fa-save mr-1"></i> Update Pharmaceutical
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- CKEditor 5 -->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.3.0/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#editor'), {
                toolbar: {
                    items: [
                        'heading', '|',
                        'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                        'blockQuote', 'insertTable', '|',
                        'undo', 'redo'
                    ]
                },
                heading: {
                    options: [
                        { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                        { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                        { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' }
                    ]
                },
                table: {
                    contentToolbar: [ 'tableColumn', 'tableRow', 'mergeTableCells' ]
                }
            })
            .catch(error => {
                console.error(error);
            });
    </script>

    <!-- Vendor scripts -->
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>
    <script src="assets/js/pages/loading-btn.init.js"></script>
    <script src="assets/js/app.min.js"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>
</html>