<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid = $_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4361ee;
            --primary-light: #eef2ff;
            --secondary-color: #3a0ca3;
            --success-color: #00b46e;
            --light-bg: #f8f9fc;
            --card-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            --form-border: #e0e3ff;
            --dark-text: #2b2d42;
            --medium-text: #495057;
            --light-text: #6c757d;
        }
        
        body {
            background-color: var(--light-bg);
            font-family: 'Inter', sans-serif;
        }
        
        .pharma-card {
            background: white;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .pharma-card:hover {
            box-shadow: 0 10px 30px rgba(67, 97, 238, 0.15);
        }
        
        .page-title-box {
            padding: 15px 0;
        }
        
        .page-title {
            color: var(--dark-text);
            font-weight: 600;
        }
        
        .breadcrumb {
            background: transparent;
        }
        
        .breadcrumb-item a {
            color: var(--light-text);
            text-decoration: none;
            transition: all 0.2s ease;
        }
        
        .breadcrumb-item a:hover {
            color: var(--primary-color);
        }
        
        .breadcrumb-item.active {
            color: var(--primary-color);
            font-weight: 500;
        }
        
        .search-box {
            position: relative;
        }
        
        .search-box input {
            border: 1px solid var(--form-border);
            border-radius: 8px;
            padding: 8px 15px 8px 40px;
            transition: all 0.3s ease;
            background-color: white;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%236c757d' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: 15px center;
            background-size: 16px;
        }
        
        .search-box input:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(67, 97, 238, 0.1);
        }
        
        .pharma-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
        }
        
        .pharma-table th {
            background-color: var(--primary-light);
            color: var(--primary-color);
            font-weight: 600;
            padding: 15px;
            border-bottom: 2px solid var(--form-border);
            text-transform: uppercase;
            font-size: 0.75rem;
            letter-spacing: 0.5px;
        }
        
        .pharma-table td {
            padding: 15px;
            border-bottom: 1px solid var(--form-border);
            vertical-align: middle;
            color: var(--medium-text);
        }
        
        .pharma-table tr:last-child td {
            border-bottom: none;
        }
        
        .pharma-table tr:hover {
            background-color: rgba(67, 97, 238, 0.03);
        }
        
        .view-btn {
            background-color: rgba(0, 180, 110, 0.1);
            color: var(--success-color);
            border-radius: 6px;
            padding: 8px 12px;
            font-size: 0.75rem;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            transition: all 0.2s ease;
        }
        
        .view-btn:hover {
            background-color: var(--success-color);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 180, 110, 0.2);
            text-decoration: none;
        }
        
        .category-badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 20px;
            background-color: var(--primary-light);
            color: var(--primary-color);
            font-size: 0.75rem;
            font-weight: 500;
        }
        
        @media (max-width: 768px) {
            .pharma-table th, 
            .pharma-table td {
                padding: 10px 8px;
                font-size: 14px;
            }
            
            .view-btn {
                padding: 6px 8px;
                font-size: 0.7rem;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
            <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pharmaceuticals</a></li>
                                        <li class="breadcrumb-item active">View Categories</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Pharmaceutical Categories</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="pharma-card">
                                <div class="mb-3">
                                    <div class="row align-items-center">
                                        <div class="col-md-6">
                                            <h4 class="header-title mb-0">All Categories</h4>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="search-box">
                                                <input id="demo-foo-search" type="text" placeholder="Search categories..." class="form-control" autocomplete="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table pharma-table mb-0" data-page-size="10">
                                        <thead>
                                        <tr>
                                            <th style="width: 50px">#</th>
                                            <th data-toggle="true">Category Name</th>
                                            <th data-hide="phone">Vendor</th>
                                            <th style="width: 120px">Actions</th>
                                        </tr>
                                        </thead>
                                        <?php
                                            $ret = "SELECT * FROM his_pharmaceuticals_categories ORDER BY pharm_cat_name";
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            while($row = $res->fetch_object()) {
                                        ?>
                                            <tbody>
                                            <tr>
                                                <td><?php echo $cnt; ?></td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="category-badge mr-2">
                                                            <?php echo substr($row->pharm_cat_name, 0, 2); ?>
                                                        </span>
                                                        <?php echo htmlspecialchars($row->pharm_cat_name, ENT_QUOTES); ?>
                                                    </div>
                                                </td>
                                                <td><?php echo htmlspecialchars($row->pharm_cat_vendor, ENT_QUOTES); ?></td>
                                                <td>
                                                    <a href="view_single_pharm_category.php?pharm_cat_id=<?php echo (int)$row->pharm_cat_id; ?>" class="view-btn">
                                                        <i class="mdi mdi-eye mr-1"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                            </tbody>
                                        <?php $cnt++; } ?>
                                        <tfoot>
                                        <tr class="active">
                                            <td colspan="4">
                                                <div class="text-right">
                                                    <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                </div>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
             <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>
</html>