<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>
<!DOCTYPE html>
<html lang="en">
    
<?php include ('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <?php
                $lab_id=$_GET['lab_id'];
                $lab_number=$_GET['lab_number'];
                $ret="SELECT  * FROM his_laboratory WHERE lab_id = ?";
                $stmt= $mysqli->prepare($ret) ;
                $stmt->bind_param('i',$lab_id);
                $stmt->execute() ;//ok
                $res=$stmt->get_result();
                //$cnt=1;
                while($row=$res->fetch_object())
                {
                    $mysqlDateTime = $row->lab_date_rec;
            ?>

                <div class="content-page">
                    <div class="content">

                        <!-- Start Content-->
                        <div class="container-fluid">
                            
                            <!-- start page title -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-title-box">
                                        <div class="page-title-right">
                                            <ol class="breadcrumb m-0">
                                                <li class="breadcrumb-item"><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="javascript: void(0);"><i class="fas fa-flask"></i> Laboratory</a></li>
                                                <li class="breadcrumb-item active"><i class="fas fa-file-alt"></i> Record Details</li>
                                            </ol>
                                        </div>
                                        <h4 class="page-title"><i class="fas fa-microscope text-primary mr-2"></i> Laboratory Record #<?php echo $row->lab_number;?></h4>
                                    </div>
                                </div>
                            </div>     
                            <!-- end page title --> 

                            <div class="row">
                                <div class="col-12">
                                    <div class="card-box">
                                        <div class="row">
                                            <div class="col-xl-4">
                                                <div class="tab-content pt-0">
                                                    <div class="tab-pane active show" id="product-1-item">
                                                        <div class="card border-0 shadow-none">
                                                            <div class="card-body text-center">
                                                         
                                                                <div class="mt-3">
                                                                    <h3 class="mb-1"><i class="fas fa-user-injured mr-2 text-primary"></i><?php echo $row->lab_pat_name;?></h3>
                                                                    <p class="text-muted mb-2"><i class="fas fa-id-card mr-2"></i>Patient ID: <?php echo $row->lab_pat_number;?></p>
                                                                    <div class="badge badge-success p-1 mb-2"><i class="far fa-calendar-alt mr-1"></i><?php echo date("d/m/Y - h:i A", strtotime($mysqlDateTime));?></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> <!-- end col -->
                                            
                                            <div class="col-xl-8">
                                                <div class="pl-xl-3 mt-3 mt-xl-0">
                                                    <div class="card border-0 shadow-none">
                                                        <div class="card-body">
                                                            <ul class="nav nav-tabs nav-bordered">
                                                                <li class="nav-item">
                                                                    <a href="#patient-info" data-toggle="tab" aria-expanded="true" class="nav-link active">
                                                                        <i class="fas fa-user-circle mr-1"></i>Patient Information
                                                                    </a>
                                                                </li>
                                                                <li class="nav-item">
                                                                    <a href="#test-details" data-toggle="tab" aria-expanded="false" class="nav-link">
                                                                        <i class="fas fa-vial mr-1"></i>Test Details
                                                                    </a>
                                                                </li>
                                                                <li class="nav-item">
                                                                    <a href="#test-results" data-toggle="tab" aria-expanded="false" class="nav-link">
                                                                        <i class="fas fa-file-medical-alt mr-1"></i>Test Results
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                            
                                                            <div class="tab-content pt-3">
                                                                <div class="tab-pane show active" id="patient-info">
                                                                    <div class="table-responsive">
                                                                        <table class="table table-borderless table-sm mb-0">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <th width="150"><i class="fas fa-user mr-2 text-primary"></i>Patient Name:</th>
                                                                                    <td><?php echo $row->lab_pat_name;?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><i class="fas fa-id-badge mr-2 text-primary"></i>Patient ID:</th>
                                                                                    <td><?php echo $row->lab_pat_number;?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><i class="fas fa-disease mr-2 text-primary"></i>Primary Ailment:</th>
                                                                                    <td><span class="badge badge-danger-lighten"><i class="fas fa-exclamation-triangle mr-1"></i><?php echo $row->lab_pat_ailment;?></span></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><i class="far fa-clock mr-2 text-primary"></i>Record Date:</th>
                                                                                    <td><?php echo date("F j, Y, g:i a", strtotime($mysqlDateTime));?></td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                
                                                                <div class="tab-pane" id="test-details">
                                                                    <h5 class="mb-3"><i class="fas fa-vials mr-2 text-primary"></i>Laboratory Tests Performed</h5>
                                                                    <div class="border p-3 rounded bg-light">
                                                                        <?php echo nl2br($row->lab_pat_tests);?>
                                                                    </div>
                                                                </div>
                                                                
                                                                <div class="tab-pane" id="test-results">
                                                                    <h5 class="mb-3"><i class="fas fa-clipboard-check mr-2 text-primary"></i>Laboratory Test Results</h5>
                                                                    <div class="border p-3 rounded bg-light">
                                                                        <?php echo nl2br($row->lab_pat_results);?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="mt-4">
                                                                <button onclick="printLabRecord()" class="btn btn-primary mr-2">
                                                                    <i class="fas fa-print mr-1"></i> Print Record
                                                                </button>
                                                                <a href="lab_report.php" class="btn btn-secondary">
                                                                    <i class="fas fa-arrow-left mr-1"></i> Back to Records
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> <!-- end col -->
                                        </div>
                                        <!-- end row -->
                                    </div> <!-- end card-->
                                </div> <!-- end col-->
                            </div>
                            <!-- end row-->
                            
                            <!-- Hidden printable content -->
                            <div id="printable-content" style="display:none;">
                                <div class="print-header text-center mb-4">
                                    <h2>Hospital Laboratory Report</h2>
                                    <h4>Laboratory Record #<?php echo $row->lab_number;?></h4>
                                    <hr>
                                </div>
                                
                                <div class="print-patient-info mb-4">
                                    <h4 class="text-primary"><i class="fas fa-user-injured mr-2"></i>Patient Information</h4>
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="30%">Patient Name:</th>
                                            <td><?php echo $row->lab_pat_name;?></td>
                                        </tr>
                                        <tr>
                                            <th>Patient ID:</th>
                                            <td><?php echo $row->lab_pat_number;?></td>
                                        </tr>
                                        <tr>
                                            <th>Primary Ailment:</th>
                                            <td><?php echo $row->lab_pat_ailment;?></td>
                                        </tr>
                                        <tr>
                                            <th>Record Date:</th>
                                            <td><?php echo date("F j, Y, g:i a", strtotime($mysqlDateTime));?></td>
                                        </tr>
                                    </table>
                                </div>
                                
                                <div class="print-test-details mb-4">
                                    <h4 class="text-primary"><i class="fas fa-vials mr-2"></i>Laboratory Tests Performed</h4>
                                    <div class="p-3 border">
                                        <?php echo nl2br($row->lab_pat_tests);?>
                                    </div>
                                </div>
                                
                                <div class="print-test-results">
                                    <h4 class="text-primary"><i class="fas fa-clipboard-check mr-2"></i>Laboratory Test Results</h4>
                                    <div class="p-3 border">
                                        <?php echo nl2br($row->lab_pat_results);?>
                                    </div>
                                </div>
                                
                                <div class="print-footer mt-4 pt-4 border-top">
                                    <div class="row">
                                        <div class="col-6">
                                            <p>Printed on: <?php echo date("F j, Y, g:i a"); ?></p>
                                        </div>
                                        <div class="col-6 text-right">
                                            <p>Hospital Laboratory Department</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div> <!-- container -->

                    </div> <!-- content -->

                    <!-- Footer Start -->
                        <?php include('assets/inc/footer.php');?>
                    <!-- end Footer -->

                </div>
            <?php }?>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            @media print {
                body * {
                    visibility: hidden;
                }
                #printable-content, #printable-content * {
                    visibility: visible;
                }
                #printable-content {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                    padding: 20px;
                    font-size: 14px;
                }
                .print-header {
                    margin-bottom: 30px;
                }
                .print-header h2 {
                    font-size: 24px;
                    color: #333;
                }
                .print-header h4 {
                    font-size: 18px;
                    color: #555;
                }
                .print-patient-info h4,
                .print-test-details h4,
                .print-test-results h4 {
                    font-size: 16px;
                    margin-bottom: 10px;
                }
                .table-bordered {
                    border: 1px solid #dee2e6;
                }
                .table-bordered th,
                .table-bordered td {
                    border: 1px solid #dee2e6;
                    padding: 8px;
                }
                .border {
                    border: 1px solid #dee2e6 !important;
                }
                .p-3 {
                    padding: 1rem !important;
                }
                .mt-4 {
                    margin-top: 1.5rem !important;
                }
                .mb-4 {
                    margin-bottom: 1.5rem !important;
                }
            }
        </style>
        
        <script>
            function printLabRecord() {
                // Open print dialog
                var printContents = document.getElementById('printable-content').innerHTML;
                var originalContents = document.body.innerHTML;
                
                document.body.innerHTML = printContents;
                window.print();
                document.body.innerHTML = originalContents;
                
                // Restore the original page
                location.reload();
            }
        </script>
        
    </body>
</html>