<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>
<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

<body>
    <!-- Begin page -->
    <div id="wrapper">
        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <?php
            $s_number=$_GET['s_number'];
            $ret="SELECT  * FROM his_surgery WHERE s_number = ?";
            $stmt= $mysqli->prepare($ret);
            $stmt->bind_param('i',$s_number);
            $stmt->execute();
            $res=$stmt->get_result();
            
            while($row=$res->fetch_object()) {
                $mysqlDateTime = $row->s_pat_date;
        ?>
        <div class="content-page">
            <div class="content">
                <!-- Start Content-->
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Surgery</a></li>
                                        <li class="breadcrumb-item active">View Single Records</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Surgery Record #<?php echo $row->s_number;?></h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                       
                                        <div class="col-md-7">
                                            <div class="surgery-details mt-3 mt-md-0">
                                                <h2 class="mb-4 text-primary">Patient Details</h2>
                                                
                                                <div class="detail-item mb-3">
                                                    <h4 class="font-weight-bold">Patient's Name:</h4>
                                                    <p class="lead"><?php echo $row->s_pat_name;?></p>
                                                </div>
                                                
                                                <div class="detail-item mb-3">
                                                    <h4 class="font-weight-bold">Patient Number:</h4>
                                                    <p class="lead"><?php echo $row->s_pat_number;?></p>
                                                </div>
                                                
                                                <div class="detail-item mb-3">
                                                    <h4 class="font-weight-bold">Patient Ailment:</h4>
                                                    <p class="lead"><?php echo $row->s_pat_ailment;?></p>
                                                </div>
                                                
                                                <div class="detail-item mb-3">
                                                    <h4 class="font-weight-bold">Date Surgery Conducted:</h4>
                                                    <p class="lead"><?php echo date("d/m/Y", strtotime($mysqlDateTime));?></p>
                                                </div>
                                                
                                                <div class="detail-item mb-3">
                                                    <h4 class="font-weight-bold">Surgeon:</h4>
                                                    <p class="lead"><?php echo $row->s_doc;?></p>
                                                </div>
                                                
                                                <div class="detail-item mb-3">
                                                    <h4 class="font-weight-bold">Surgery Status:</h4>
                                                    <?php 
                                                        $statusClass = ($row->s_pat_status == 'Successful') ? 'success' : 'warning';
                                                    ?>
                                                    <span class="badge badge-<?php echo $statusClass; ?> badge-pill py-2 px-3" style="font-size: 1rem;">
                                                        <?php echo $row->s_pat_status;?>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row mt-4">
                                        <div class="col-12">
                                            <a href="javascript:history.back()" class="btn btn-secondary">
                                                <i class="mdi mdi-arrow-left"></i> Back to List
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row-->
                </div> <!-- container -->
            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->
        </div>
        <?php } ?>
        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>