<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

$pres_number = $_GET['pres_number'] ?? null;

// Fetch prescription data if IDs are provided
if ($pres_number) {
    $ret = "SELECT * FROM his_prescriptions WHERE pres_number = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $pres_number);
    $stmt->execute();
    $res = $stmt->get_result();
    $prescription = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <!-- Include Quill stylesheet -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #495057;
            --border: #e0e3ff;
        }
        
        body {
            background-color: var(--light);
            font-family: 'Inter', sans-serif;
            color: var(--dark);
        }
        
        .card-box {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
            overflow: hidden;
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .page-title {
            color: var(--dark);
            font-weight: 700;
        }
        
        .patient-img {
            width: 100%;
            max-width: 300px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border: 3px solid white;
        }
        
        .patient-info-card {
            background: linear-gradient(135deg, var(--primary-light) 0%, white 100%);
            border-radius: 12px;
            padding: 20px;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        
        .patient-detail {
            margin-bottom: 15px;
            padding-bottom: 15px;
            border-bottom: 1px solid var(--border);
        }
        
        .patient-detail:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        
        .detail-label {
            font-weight: 600;
            color: var(--secondary);
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 5px;
        }
        
        .detail-value {
            color: var(--dark);
            font-weight: 500;
            font-size: 1.1rem;
        }
        
        .prescription-header {
            background-color: var(--primary);
            color: white;
            padding: 15px 20px;
            border-radius: 8px 8px 0 0;
            margin-bottom: 20px;
        }
        
        .prescription-content {
            background-color: white;
            border-radius: 8px;
            padding: 20px;
            border-left: 4px solid var(--primary);
            min-height: 300px;
        }
        
        /* Quill editor styling for display only */
        .ql-container.ql-snow {
            border: none !important;
        }
        
        .ql-toolbar.ql-snow {
            display: none;
        }
        
        .empty-state {
            text-align: center;
            padding: 40px 20px;
        }
        
        .empty-state-icon {
            font-size: 60px;
            color: var(--gray);
            margin-bottom: 20px;
        }
        
        .print-btn {
            background-color: var(--success);
            color: white;
            border: none;
        }
        
        .print-btn:hover {
            background-color: #008a56;
            color: white;
        }
        
        @media (max-width: 768px) {
            .patient-img {
                margin-bottom: 20px;
            }
        }
        
        /* Prescription styling */
        .prescription-body {
            font-family: 'Courier New', monospace;
            line-height: 1.6;
        }
        
        .prescription-body h3 {
            color: var(--primary);
            border-bottom: 1px dashed var(--border);
            padding-bottom: 5px;
            margin-top: 20px;
        }
        
        .prescription-body ul {
            padding-left: 20px;
        }
        
        .prescription-body li {
            margin-bottom: 8px;
        }
        
        .doctor-signature {
            margin-top: 50px;
            text-align: right;
        }
        
        .signature-line {
            border-top: 1px solid var(--dark);
            display: inline-block;
            width: 200px;
            margin-top: 40px;
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pharmaceuticals</a></li>
                                        <li class="breadcrumb-item active">View Prescription</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">
                                    <?php echo isset($prescription) ? 'Prescription #' . htmlspecialchars($prescription->pres_number) : 'Prescription Details'; ?>
                                </h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <?php if (isset($prescription)): ?>
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <h4 class="header-title">Prescription Details</h4>
                                        </div>
                                        <div class="col-md-6 text-right">
                                            <button onclick="window.print()" class="btn btn-success print-btn">
                                                <i class="fas fa-print mr-2"></i> Print Prescription
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-lg-4 text-center">
                                            <img src="assets/images/users/patient.png" alt="Patient" class="patient-img mb-3">
                                            <div class="patient-info-card">
                                                <div class="patient-detail">
                                                    <div class="detail-label">Patient Name</div>
                                                    <div class="detail-value"><?php echo htmlspecialchars($prescription->pres_pat_name); ?></div>
                                                </div>
                                                
                                                <div class="patient-detail">
                                                    <div class="detail-label">Age</div>
                                                    <div class="detail-value"><?php echo htmlspecialchars($prescription->pres_pat_age); ?> Years</div>
                                                </div>
                                                
                                                <div class="patient-detail">
                                                    <div class="detail-label">Patient Number</div>
                                                    <div class="detail-value"><?php echo htmlspecialchars($prescription->pres_pat_number); ?></div>
                                                </div>
                                                
                                                <div class="patient-detail">
                                                    <div class="detail-label">Patient Category</div>
                                                    <div class="detail-value"><?php echo htmlspecialchars($prescription->pres_pat_type); ?></div>
                                                </div>
                                                
                                                <div class="patient-detail">
                                                    <div class="detail-label">Date</div>
                                                    <div class="detail-value"><?php echo date('F j, Y', strtotime($prescription->created_at)); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-8">
                                            <div class="prescription-header">
                                                <h3 class="m-0"><i class="fas fa-prescription mr-2"></i> Medical Prescription</h3>
                                            </div>
                                            
                                            <div class="patient-detail">
                                                <div class="detail-label">Diagnosis/Ailment</div>
                                                <div class="detail-value"><?php echo htmlspecialchars($prescription->pres_pat_ailment); ?></div>
                                            </div>
                                            
                                            <div class="patient-detail">
                                                <div class="detail-label">Prescription Instructions</div>
                                                <!-- Quill editor container for display only -->
                                                <div id="prescription-editor" class="prescription-content">
                                                    <?php echo $prescription->pres_ins; ?>
                                                </div>
                                            </div>
                                            
                                            <div class="doctor-signature">
                                                <div class="detail-label">Doctor's Signature</div>
                                                <div class="signature-line"></div>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="empty-state">
                                        <div class="empty-state-icon">
                                            <i class="fas fa-file-medical"></i>
                                        </div>
                                        <h3>No Prescription Found</h3>
                                        <p class="text-muted">The requested prescription could not be found or no prescription ID was provided.</p>
                                        <a href="manage_presc.php" class="btn btn-primary mt-3">
                                            <i class="fas fa-arrow-left mr-2"></i> Back to Prescriptions
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <!-- Font Awesome -->
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    
    <!-- Include Quill library -->
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    
    <script>
        // Initialize Quill editor for display only
        document.addEventListener('DOMContentLoaded', function() {
            // Check if prescription content exists
            const prescriptionContent = document.getElementById('prescription-editor');
            if (prescriptionContent) {
                // Create a Quill instance for display only
                const quill = new Quill('#prescription-editor', {
                    theme: 'snow',
                    readOnly: true,
                    modules: {
                        toolbar: false
                    }
                });
                
                // Set the content from the database
                quill.clipboard.dangerouslyPasteHTML(prescriptionContent.innerHTML);
            }
        });
    </script>
</body>
</html>