<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>
<!DOCTYPE html>
<html lang="en">
    
<?php include ('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <?php
                $v_number=$_GET['v_number'];
                $ret="SELECT * FROM his_vendor WHERE v_number = ?";
                $stmt= $mysqli->prepare($ret);
                $stmt->bind_param('i',$v_number);
                $stmt->execute();
                $res=$stmt->get_result();
                while($row=$res->fetch_object())
                {
            ?>

                <div class="content-page">
                    <div class="content">

                        <!-- Start Content-->
                        <div class="container-fluid">
                            
                            <!-- start page title -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-title-box">
                                        <div class="page-title-right">
                                            <ol class="breadcrumb m-0">
                                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="javascript: void(0);">Vendors</a></li>
                                                <li class="breadcrumb-item active">Vendor Details</li>
                                            </ol>
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h4 class="page-title">Vendor #<?php echo $row->v_number; ?></h4>
                                            <div class="btn-group">
                                                <button id="printBtn" class="btn btn-primary">
                                                    <i class="fas fa-print mr-1"></i> Print
                                                </button>
                                                <a href="update_single_vendor.php?v_number=<?php echo $row->v_number; ?>" class="btn btn-warning">
                                                    <i class="fas fa-edit mr-1"></i> Edit
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>     
                            <!-- end page title --> 

                            <div class="row">
                                <div class="col-12">
                                    <div class="card-box">
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="vendor-details-container">
                                                    <div class="vendor-header">
                                                        <div class="vendor-avatar">
                                                            <span><?php echo strtoupper(substr($row->v_name, 0, 1)); ?></span>
                                                        </div>
                                                        <div class="vendor-title">
                                                            <h2><?php echo $row->v_name; ?></h2>
                                                            <p>Vendor ID: <?php echo $row->v_number; ?></p>
                                                        </div>
                                                    </div>

                                                    <div class="vendor-info-grid">
                                                        <div class="info-card">
                                                            <div class="info-icon">
                                                                <i class="fas fa-phone"></i>
                                                            </div>
                                                            <div class="info-content">
                                                                <h5>Contact</h5>
                                                                <p><?php echo $row->v_phone; ?></p>
                                                            </div>
                                                        </div>

                                                        <div class="info-card">
                                                            <div class="info-icon">
                                                                <i class="fas fa-envelope"></i>
                                                            </div>
                                                            <div class="info-content">
                                                                <h5>Email</h5>
                                                                <p><a href="mailto:<?php echo $row->v_email; ?>"><?php echo $row->v_email; ?></a></p>
                                                            </div>
                                                        </div>

                                                        <div class="info-card">
                                                            <div class="info-icon">
                                                                <i class="fas fa-map-marker-alt"></i>
                                                            </div>
                                                            <div class="info-content">
                                                                <h5>Address</h5>
                                                                <p><?php echo $row->v_adr; ?></p>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="vendor-description">
                                                        <h4 class="section-title">Vendor Details</h4>
                                                        <div class="description-content">
                                                            <?php echo nl2br(htmlspecialchars($row->v_desc)); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Footer Start -->
                    <?php include('assets/inc/footer.php');?>
                    <!-- end Footer -->

                </div>
            <?php }?>

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            /* Custom styling */
            .vendor-details-container {
                padding: 20px;
            }
            
            .vendor-header {
                display: flex;
                align-items: center;
                margin-bottom: 30px;
                padding-bottom: 20px;
                border-bottom: 1px solid #eee;
            }
            
            .vendor-avatar {
                width: 80px;
                height: 80px;
                background-color: #3bafda;
                color: white;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 32px;
                font-weight: bold;
                margin-right: 20px;
            }
            
            .vendor-title h2 {
                color: #3bafda;
                margin-bottom: 5px;
            }
            
            .vendor-title p {
                color: #6c757d;
                margin: 0;
            }
            
            .vendor-info-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
                gap: 20px;
                margin-bottom: 30px;
            }
            
            .info-card {
                background: #f8f9fa;
                border-radius: 8px;
                padding: 20px;
                display: flex;
                align-items: center;
                transition: all 0.3s ease;
            }
            
            .info-card:hover {
                transform: translateY(-5px);
                box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            }
            
            .info-icon {
                width: 50px;
                height: 50px;
                background-color: rgba(59, 175, 218, 0.1);
                color: #3bafda;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 20px;
                margin-right: 15px;
            }
            
            .info-content h5 {
                color: #495057;
                margin-bottom: 5px;
                font-size: 16px;
            }
            
            .info-content p {
                color: #212529;
                margin: 0;
            }
            
            .section-title {
                color: #3bafda;
                margin-bottom: 15px;
                padding-bottom: 10px;
                border-bottom: 1px solid #eee;
            }
            
            .description-content {
                background: #f8f9fa;
                padding: 20px;
                border-radius: 8px;
                line-height: 1.6;
            }
            
            @media print {
                body * {
                    visibility: hidden;
                }
                
                .content-page, .content-page * {
                    visibility: visible;
                }
                
                .content-page {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                    padding: 0;
                    margin: 0;
                }
                
                .no-print, .page-title-right, .btn-group {
                    display: none !important;
                }
                
                .vendor-avatar {
                    width: 60px;
                    height: 60px;
                    font-size: 24px;
                }
                
                .info-card {
                    box-shadow: none !important;
                    transform: none !important;
                    page-break-inside: avoid;
                }
                
                .vendor-info-grid {
                    grid-template-columns: 1fr;
                }
            }
        </style>
        
    </body>
</html>