<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('./constant/connect.php'); ?>

<div class="page-wrapper" style="background-color: #f7f9fc; min-height: 100vh; padding: 20px;">

    <div class="row page-titles mb-4">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary" style="font-weight: 600; color: #4a6cf7;">Add New Product</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb" style="background: transparent; padding: 0;">
                <li class="breadcrumb-item"><a href="javascript:void(0)" style="color:#888;">Home</a></li>
                <li class="breadcrumb-item active" style="color:#4a6cf7;">Add Product</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
        <?php if (isset($_GET['status']) && $_GET['status']=='success'): ?>
        <div class="custom-alert success">
            <span class="icon">✔</span>
            Product successfully added.
        </div>

        <?php elseif (isset($_GET['status']) && $_GET['status']=='error'): ?>
        <div class="custom-alert error">
            <span class="icon">⚠</span>
            Error: <?= htmlspecialchars($_GET['msg']) ?>
        </div>
        <?php endif; ?>
        <style>
        /* Shared alert styling */
        .custom-alert {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 15px 20px;
            margin-bottom: 20px;
            border-radius: 12px;
            font-family: Arial, sans-serif;
            font-size: 16px;
            font-weight: 500;
            box-shadow: 2px 2px 10px rgba(0,0,0,0.1);
            animation: slideDown 0.5s ease forwards;
        }
        .custom-alert.success {
            background-color: #e6f9ec;
            color: #1d7a3c;
            border-left: 5px solid #28a745;
        }
        .custom-alert.error {
            background-color: #fdecea;
            color: #b71c1c;
            border-left: 5px solid #f44336;
        }
        .custom-alert .icon {
            font-size: 20px;
            font-weight: bold;
        }
        @keyframes slideDown {
          0% { opacity: 0; transform: translateY(-10px);}
          100% { opacity: 1; transform: translateY(0);}
        }
        </style>

        
            <div class="col-lg-12 mx-auto">
                <div class="card" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;">
                    <div class="card-body">
                        <form class="row" method="POST" id="submitMedicineForm" enctype="multipart/form-data">
                            
                            <!-- Medicine Name (Required) -->
                            <div class="form-group col-md-6">
                                <label class="control-label">Product Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control soft-input" name="productName" required>
                            </div>

                            <!-- HSN Code (Optional) -->
                            <div class="form-group col-md-6">
                                <label class="control-label">HSN Code</label>
                                <input type="text" class="form-control soft-input" name="hsnCode" pattern="^[0-9]*$" placeholder="Optional" value="">
                                <small class="text-muted">Leave blank if not applicable</small>
                            </div>

                            <!-- Manufacturer (Optional) -->
                            <div class="form-group col-md-6">
                                <label class="control-label">Manufacturer Name</label>
                                <select class="form-control soft-input" name="brandName" style="height:50px">
                                    <option value="">~~SELECT (Optional)~~</option>
                                    <?php 
                                    $sql = "SELECT brand_id, brand_name FROM brands WHERE brand_status = 1 AND brand_active = 1";
                                    $result = $connect->query($sql);
                                    while($row = $result->fetch_array()) {
                                        echo "<option value='".$row[0]."'>".$row[1]."</option>";
                                    } 
                                    ?>
                                </select>
                                <small class="text-muted">Optional - select if available</small>
                            </div>

                            <!-- Category (Required) -->
                            <div class="form-group col-md-6">
                                <label class="control-label">Category Name <span class="text-danger">*</span></label>
                                <select class="form-control soft-input" name="categoryName" required style="height:50px">
                                    <option value="">~~SELECT~~</option>
                                    <?php 
                                    $sql = "SELECT categories_id, categories_name FROM categories WHERE categories_status = 1 AND categories_active = 1";
                                    $result = $connect->query($sql);
                                    while($row = $result->fetch_array()) {
                                        echo "<option value='".$row[0]."'>".$row[1]."</option>";
                                    } 
                                    ?>
                                </select>
                            </div>
                               <div class="form-group col-md-6">
                                <label class="control-label" style="color:green">Product Image <span class="text-muted" >(Optional it takes long to submit because of system validation)</span></label>
                                <input type="file" class="form-control soft-input" name="Medicine">
                            </div>
                         
                            <!-- Status (Required) -->
                            <div class="form-group col-md-6">
                                <label class="control-label">Status <span class="text-danger">*</span></label>
                                <select class="form-control soft-input" name="productStatus" required style="height:50px">
                                    <option value="">~~SELECT~~</option>
                                    <option value="1">Available</option>
                                    <option value="2">Not Available</option>
                                </select>
                            </div>

                            <!-- Submit Button -->
                            <div class="col-12 text-center mt-3">
                                <button type="submit" id="createMedicineBtn" class="btn btn-primary soft-btn">Add Product</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Loader Overlay -->
<div id="loaderOverlay">
  <div class="loader"></div>
  <p>Please wait… uploading Product</p>
</div>

<style>
.soft-input {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 10px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
}
.soft-input:focus {
    border-color: #4a6cf7;
    box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
    outline: none;
}
.soft-btn {
    padding: 10px 20px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
}
.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}

/* Loader */
#loaderOverlay {
  display: none;
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(255, 255, 255, 0.9);
  z-index: 9999;
  text-align: center;
  padding-top: 200px;
  font-family: Arial, sans-serif;
  color: #4a6cf7;
  font-weight: 500;
}
.loader {
  border: 6px solid #f3f3f3;
  border-top: 6px solid #4a6cf7;
  border-radius: 50%;
  width: 60px;
  height: 60px;
  animation: spin 1s linear infinite;
  margin: 0 auto 15px auto;
}
@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}

.text-muted {
    font-size: 0.85em;
    color: #6c757d !important;
}
</style>

<script>
document.getElementById('submitMedicineForm').addEventListener('submit', function (e) {
    e.preventDefault();
    document.getElementById('loaderOverlay').style.display = 'block';

    let formData = new FormData(this);

    fetch('php_action/createMedicine.php', {
        method: 'POST',
        body: formData
    })
    .then(res => res.json())
    .then(data => {
        document.getElementById('loaderOverlay').style.display = 'none';
        if (data.status === 'success') {
            window.location.href = "add-product.php?status=success";
        } else {
            window.location.href = "add-product.php?status=error&msg=" + encodeURIComponent(data.msg);
        }
    })
    .catch(err => {
        document.getElementById('loaderOverlay').style.display = 'none';
        alert("Error: " + err);
    });
});
</script>

<?php include('./constant/layout/footer.php'); ?>