<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>CMD Style Modal</title>
<style>
/* Full screen overlay */
#cmdModal {
    position: fixed;
    top: 0; left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.9);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
}

/* CMD window style */
#cmdWindow {
    background: black;
    color: #0f0;
    font-family: 'Courier New', monospace;
    padding: 20px;
    width: 500px;
    max-width: 90%;
    border: 2px solid #0f0;
    box-shadow: 0 0 20px #0f0;
}

/* Input style */
.cmdInput {
    background: black;
    border: none;
    color: #0f0;
    font-family: 'Courier New', monospace;
    font-size: 16px;
    outline: none;
    width: 100%;
}

/* Blinking cursor */
.blink {
    display: inline-block;
    width: 10px;
    background-color: #0f0;
    animation: blink 1s steps(1) infinite;
    margin-left: 2px;
}
@keyframes blink {
    50% { background-color: black; }
}

/* Hide after submission */
.hidden {
    display: none;
}
</style>
</head>
<body>

<div id="cmdModal">
    <div id="cmdWindow">
        <div id="cmdContent"></div>
        <div>
            <span id="prompt">></span>
            <input type="text" id="cmdInput" class="cmdInput" autofocus>
            <span class="blink"></span>
        </div>
    </div>
</div>

<script>
const prompts = [
    "Enter your name:",
    "Enter your company name:",
    "Enter your email:",
    "Enter your phone:"
];
let responses = [];
let current = 0;

const cmdContent = document.getElementById('cmdContent');
const cmdInput = document.getElementById('cmdInput');
const promptSpan = document.getElementById('prompt');

cmdContent.innerHTML += prompts[current] + "<br>";

cmdInput.addEventListener('keydown', function(e) {
    if(e.key === 'Enter') {
        const value = cmdInput.value.trim();
        if(value === '') return; // ignore empty
        responses.push(value);
        cmdContent.innerHTML += "> " + value + "<br>";
        cmdInput.value = '';
        current++;
        if(current < prompts.length) {
            cmdContent.innerHTML += prompts[current] + "<br>";
        } else {
            // All inputs done
            console.log("User Responses:", responses);
            cmdContent.innerHTML += "<br>Thank you! Closing CMD...<br>";
            setTimeout(() => {
                document.getElementById('cmdModal').classList.add('hidden');
            }, 1500);
        }
        // Scroll to bottom
        cmdContent.scrollTop = cmdContent.scrollHeight;
    }
});
</script>

</body>
</html>
