<?php
include('./connect.php');
header('Content-Type: application/json');

$sql = "CREATE TABLE IF NOT EXISTS `chambers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chamber_name` varchar(255) NOT NULL,
  `location` varchar(255) DEFAULT NULL,
  `temperature_range` varchar(50) DEFAULT NULL,
  `capacity` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

if($connect->query($sql)) {
    // Insert sample data
    $sample_data = [
        "INSERT INTO `chambers` (`chamber_name`, `location`, `temperature_range`, `capacity`, `description`, `status`) VALUES
        ('Main Storage', 'Ground Floor, Room 101', '2-8', 500, 'Primary storage for temperature-sensitive medicines', 1)",
        "INSERT INTO `chambers` (`chamber_name`, `location`, `temperature_range`, `capacity`, `description`, `status`) VALUES
        ('Cold Chamber', 'Basement, Room B12', '2-5', 300, 'For vaccines and highly sensitive medicines', 1)",
        "INSERT INTO `chambers` (`chamber_name`, `location`, `temperature_range`, `capacity`, `description`, `status`) VALUES
        ('Room Temperature Storage', 'First Floor, Room 201', '15-25', 800, 'For medicines stable at room temperature', 1)",
        "INSERT INTO `chambers` (`chamber_name`, `location`, `temperature_range`, `capacity`, `description`, `status`) VALUES
        ('Quarantine Area', 'Back Room', '15-25', 100, 'For returned or questionable medicines', 0)"
    ];
    
    foreach($sample_data as $query) {
        $connect->query($query);
    }
    
    echo json_encode(['success' => true, 'message' => 'Chamber table created successfully']);
} else {
    echo json_encode(['success' => false, 'message' => $connect->error]);
}
?>