<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('./constant/connect.php'); ?>

<?php
// Ensure order_id is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<script>alert('Invalid invoice ID'); window.location.href='invoices.php';</script>";
    exit;
}

$order_id = mysqli_real_escape_string($connect, $_GET['id']);

// Debug: Log the order_id
error_log("Order ID: " . $order_id);

// Fetch order details
$order_query = "SELECT * FROM orders WHERE id = '$order_id' AND delete_status = 0";
$order_result = $connect->query($order_query);

if ($order_result === false) {
    error_log("Order query error: " . $connect->error);
    echo "<script>alert('Database error: Unable to fetch invoice'); window.location.href='invoices.php';</script>";
    exit;
}

if ($order_result->num_rows == 0) {
    error_log("No invoice found for ID: " . $order_id);
    echo "<script>alert('Invoice not found'); window.location.href='invoices.php';</script>";
    exit;
}

$order = $order_result->fetch_assoc();

// Debug: Log the fetched order data
error_log("Order data: " . print_r($order, true));

// Fetch order items
$order_items_query = "SELECT oi.*, p.product_name, p.chamber, p.unit_description, p.rate, p.mrp, p.quantity AS available_quantity 
                      FROM order_item oi 
                      LEFT JOIN product p ON oi.product_id = p.product_id 
                      WHERE oi.order_id = '$order_id'";
$order_items_result = $connect->query($order_items_query);

if ($order_items_result === false) {
    error_log("Order items query error: " . $connect->error);
    echo "<script>alert('Database error: Unable to fetch order items'); window.location.href='invoices.php';</script>";
    exit;
}

// Debug: Log the number of order items
error_log("Number of order items: " . $order_items_result->num_rows);
?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Edit Retailer Invoice</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item"><a href="invoices.php">Invoices</a></li>
                <li class="breadcrumb-item active">Edit Invoice</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-title"></div>
                    <div id="add-brand-messages"></div>
                    <div id="success-message" class="alert alert-success" style="display: none;">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <strong><i class="glyphicon glyphicon-ok-sign"></i></strong> Invoice updated successfully!
                    </div>
                    <div class="card-body">
                        <div class="input-states">
                            <form class="form-horizontal" method="POST" id="editOrderForm" action="php_action/editOrder.php">
                                <input type="hidden" name="order_id" value="<?php echo htmlspecialchars($order_id); ?>">
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice No</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" name="uno" value="<?php echo htmlspecialchars($order['uno'] ?? 'N/A'); ?>" readonly />
                                        </div>
                                        <label class="col-sm-2 control-label">GSTIN (Optional)</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="gstn" name="gstn" placeholder="GSTIN Number" autocomplete="off" value="<?php echo htmlspecialchars($order['gstn'] ?? ''); ?>" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice Date</label>
                                        <div class="col-sm-4">
                                            <input type="date" class="form-control soft-input" id="orderDate" name="orderDate" value="<?php echo htmlspecialchars($order['orderDate'] ?? date('Y-m-d')); ?>" autocomplete="off" required />
                                        </div>
                                        <label class="col-sm-2 control-label">Client Name</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="clientName" name="clientName" placeholder="Client Name" autocomplete="off" value="<?php echo htmlspecialchars($order['clientName'] ?? ''); ?>" required />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Client Contact No.</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="clientContact" name="clientContact" placeholder="Contact Number" autocomplete="off" value="<?php echo htmlspecialchars($order['clientContact'] ?? ''); ?>" pattern="^[0][1-9]\d{9}$|^[1-9]\d{9}$" required />
                                        </div>
                                        <input type="text" class="form-control" name="type" value="retail" hidden />
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table class="table" id="productTable">
                                        <thead>
                                            <tr>
                                                <th style="width:13%;">Product</th>
                                                <th style="width:8%;">Chamber</th>
                                                <th style="width:8%;">Rate</th>
                                                <th style="width:8%;">M.R.P</th>
                                                <th style="width:10%;">Pack/Unit Desc</th>
                                                <th style="width:8%;">Stock</th>
                                                <th style="width:10%;">Quantity</th>
                                                <th style="width:14%;">Discount %</th>
                                                <th style="width:10%;">Total</th>
                                                <th style="width:10%;">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $arrayNumber = 0;
                                            if ($order_items_result->num_rows > 0) {
                                                while ($item = $order_items_result->fetch_assoc()) {
                                                    $arrayNumber++;
                                                    ?>
                                                    <tr id="row<?php echo $arrayNumber; ?>" class="<?php echo $arrayNumber - 1; ?>">
                                                        <td>
                                                            <style>
                                                                .select2-container--default .select2-selection--single {
                                                                    height: 60px !important;
                                                                    line-height: 60px !important;
                                                                    font-size: 12px !important;
                                                                    padding-top: 10px !important;
                                                                    padding-bottom: 10px !important;
                                                                    border-radius: 12px;
                                                                    border: 1px solid #d1d9e6;
                                                                    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
                                                                }
                                                                .select2-container--default .select2-selection--single .select2-selection__rendered {
                                                                    line-height: 60px !important;
                                                                    font-size: 12px !important;
                                                                }
                                                                .select2-container--default .select2-selection--single .select2-selection__arrow {
                                                                    height: 60px !important;
                                                                }
                                                            </style>
                                                            <div class="form-group">
                                                                <select class="form-control select2-product" name="productName[]" id="productName<?php echo $arrayNumber; ?>" onchange="fetchProductData(<?php echo $arrayNumber; ?>)">
                                                                    <option value="">~~SELECT~~</option>
                                                                    <option value="<?php echo htmlspecialchars($item['product_id']); ?>" selected>
                                                                        <?php echo htmlspecialchars($item['product_name'] ?? 'Unknown Product'); ?>
                                                                    </option>
                                                                </select>
                                                                <input type="hidden" name="productId[]" id="productId<?php echo $arrayNumber; ?>" value="<?php echo htmlspecialchars($item['product_id']); ?>" />
                                                            </div>
                                                        </td>
                                                        <td><input type="text" name="chamber[]" id="chamber<?php echo $arrayNumber; ?>" class="form-control soft-input" value="<?php echo htmlspecialchars($item['chamber'] ?? ''); ?>" readonly /></td>
                                                        <td>
                                                            <input type="text" name="rate[]" id="rate<?php echo $arrayNumber; ?>" class="form-control soft-input" value="<?php echo number_format($item['rate'] ?? 0, 2); ?>" disabled />
                                                            <input type="hidden" name="rateValue[]" id="rateValue<?php echo $arrayNumber; ?>" value="<?php echo $item['rate'] ?? 0; ?>" />
                                                        </td>
                                                        <td>
                                                            <input type="text" name="mrp[]" id="mrp<?php echo $arrayNumber; ?>" class="form-control soft-input" value="<?php echo number_format($item['mrp'] ?? 0, 2); ?>" disabled />
                                                            <input type="hidden" name="mrpValue[]" id="mrpValue<?php echo $arrayNumber; ?>" value="<?php echo $item['mrp'] ?? 0; ?>" />
                                                        </td>
                                                        <td><input type="text" name="unit_description[]" id="unit_description<?php echo $arrayNumber; ?>" class="form-control soft-input" value="1*<?php echo htmlspecialchars($item['unit_description'] ?? ''); ?>" readonly /></td>
                                                        <td><div class="form-group"><p id="available_quantity<?php echo $arrayNumber; ?>"><?php echo $item['available_quantity'] ?? '-'; ?></p></div></td>
                                                        <td><div class="form-group"><input type="number" name="quantity[]" id="quantity<?php echo $arrayNumber; ?>" onkeyup="getTotal(<?php echo $arrayNumber; ?>)" class="form-control soft-input" min="1" value="<?php echo $item['quantity'] ?? 1; ?>" /></div></td>
                                                        <td><input type="number" name="discount_percentage_item[]" id="discount_percentage_item<?php echo $arrayNumber; ?>" onkeyup="getTotal(<?php echo $arrayNumber; ?>)" class="form-control soft-input" value="<?php echo $item['discount_percentage'] ?? 0; ?>" step="0.01" /></td>
                                                        <td>
                                                            <input type="text" name="total[]" id="total<?php echo $arrayNumber; ?>" class="form-control soft-input" value="<?php echo number_format($item['total'] ?? 0, 2); ?>" disabled />
                                                            <input type="hidden" name="totalValue[]" id="totalValue<?php echo $arrayNumber; ?>" value="<?php echo $item['total'] ?? 0; ?>" />
                                                        </td>
                                                        <td>
                                                            <button type="button" class="btn btn-primary btn-flat soft-btn" onclick="addRow()"><i class="fa fa-plus"></i></button>
                                                            <button type="button" class="btn btn-danger removeProductRowBtn soft-btn" onclick="removeProductRow(<?php echo $arrayNumber; ?>)"><i class="fa fa-trash"></i></button>
                                                        </td>
                                                    </tr>
                                                <?php
                                                }
                                            } else {
                                                // Default empty row
                                                $arrayNumber = 1;
                                                ?>
                                                <tr id="row1" class="0">
                                                    <td>
                                                        <style>
                                                            .select2-container--default .select2-selection--single {
                                                                height: 60px !important;
                                                                line-height: 60px !important;
                                                                font-size: 12px !important;
                                                                padding-top: 10px !important;
                                                                padding-bottom: 10px !important;
                                                                border-radius: 12px;
                                                                border: 1px solid #d1d9e6;
                                                                box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
                                                            }
                                                            .select2-container--default .select2-selection--single .select2-selection__rendered {
                                                                line-height: 60px !important;
                                                                font-size: 12px !important;
                                                            }
                                                            .select2-container--default .select2-selection--single .select2-selection__arrow {
                                                                height: 60px !important;
                                                            }
                                                        </style>
                                                        <div class="form-group">
                                                            <select class="form-control select2-product" name="productName[]" id="productName1" onchange="fetchProductData(1)">
                                                                <option value="">~~SELECT~~</option>
                                                            </select>
                                                            <input type="hidden" name="productId[]" id="productId1" />
                                                        </div>
                                                    </td>
                                                    <td><input type="text" name="chamber[]" id="chamber1" class="form-control soft-input" readonly /></td>
                                                    <td>
                                                        <input type="text" name="rate[]" id="rate1" class="form-control soft-input" disabled />
                                                        <input type="hidden" name="rateValue[]" id="rateValue1" />
                                                    </td>
                                                    <td>
                                                        <input type="text" name="mrp[]" id="mrp1" class="form-control soft-input" disabled />
                                                        <input type="hidden" name="mrpValue[]" id="mrpValue1" />
                                                    </td>
                                                    <td><input type="text" name="unit_description[]" id="unit_description1" class="form-control soft-input" readonly /></td>
                                                    <td><div class="form-group"><p id="available_quantity1">-</p></div></td>
                                                    <td><div class="form-group"><input type="number" name="quantity[]" id="quantity1" onkeyup="getTotal(1)" class="form-control soft-input" min="1" value="1" /></div></td>
                                                    <td><input type="number" name="discount_percentage_item[]" id="discount_percentage_item1" onkeyup="getTotal(1)" class="form-control soft-input" value="0" step="0.01" /></td>
                                                    <td>
                                                        <input type="text" name="total[]" id="total1" class="form-control soft-input" disabled value="0.00" />
                                                        <input type="hidden" name="totalValue[]" id="totalValue1" value="0" />
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-primary btn-flat soft-btn" onclick="addRow()"><i class="fa fa-plus"></i></button>
                                                        <button type="button" class="btn btn-danger removeProductRowBtn soft-btn" onclick="removeProductRow(1)"><i class="fa fa-trash"></i></button>
                                                    </td>
                                                </tr>
                                            <?php
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Sub Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="subTotal" name="subTotal" value="<?php echo number_format($order['subTotal'] ?? 0, 2); ?>" disabled />
                                            <input type="hidden" class="form-control" id="subTotalValue" name="subTotalValue" value="<?php echo $order['subTotal'] ?? 0; ?>" />
                                        </div>
                                        <label for="totalAmount" class="col-sm-2 control-label">Total Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="totalAmount" name="totalAmount" value="<?php echo number_format($order['totalAmount'] ?? 0, 2); ?>" disabled />
                                            <input type="hidden" class="form-control" id="totalAmountValue" name="totalAmountValue" value="<?php echo $order['totalAmount'] ?? 0; ?>" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label for="grandTotal" class="col-sm-2 control-label">Grand Total</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="grandTotal" name="grandTotal" value="<?php echo number_format($order['grandTotalValue'] ?? 0, 2); ?>" disabled />
                                            <input type="hidden" class="form-control" id="grandTotalValue" name="grandTotalValue" value="<?php echo $order['grandTotalValue'] ?? 0; ?>" />
                                        </div>
                                        <label for="paid" class="col-sm-2 control-label">Paid Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="paid" name="paid" value="<?php echo number_format($order['paid'] ?? 0, 2); ?>" autocomplete="off" onkeyup="paidAmount()" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label for="due" class="col-sm-2 control-label">Due Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="due" name="due" value="<?php echo number_format($order['dueValue'] ?? 0, 2); ?>" disabled />
                                            <input type="hidden" class="form-control" id="dueValue" name="dueValue" value="<?php echo $order['dueValue'] ?? 0; ?>" />
                                        </div>
                                        <label for="paymentType" class="col-sm-2 control-label">Payment Type</label>
                                        <div class="col-sm-4">
                                            <select class="form-control soft-input" name="paymentType" id="paymentType" required style="height:50px">
                                                <option value="">~~SELECT~~</option>
                                                <option value="2" <?php if ($order['paymentType'] == 2) echo 'selected'; ?>>Cash</option>
                                                <option value="4" <?php if ($order['paymentType'] == 4) echo 'selected'; ?>>UPI</option>
                                                <option value="5" <?php if ($order['paymentType'] == 5) echo 'selected'; ?>>Debit Card</option>
                                                <option value="6" <?php if ($order['paymentType'] == 6) echo 'selected'; ?>>Credit Card</option>
                                                <option value="1" <?php if ($order['paymentType'] == 1) echo 'selected'; ?>>Netbanking</option>
                                                <option value="3" <?php if ($order['paymentType'] == 3) echo 'selected'; ?>>Insurance</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label for="paymentStatus" class="col-sm-2 control-label">Payment Status</label>
                                        <div class="col-sm-4">
                                            <select class="form-control soft-input" name="paymentStatus" id="paymentStatus" required style="height:50px">
                                                <option value="">~~SELECT~~</option>
                                                <option value="1" <?php if ($order['paymentStatus'] == 1) echo 'selected'; ?>>Paid</option>
                                                <option value="2" <?php if ($order['paymentStatus'] == 2) echo 'selected'; ?>>Pending</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group submitButtonFooter">
                                    <div class="col-sm-offset-2 col-sm-10">
                                        <button type="submit" id="editOrderBtn" data-loading-text="Loading..." class="btn btn-success btn-flat soft-btn m-b-30 m-t-30"><i class="glyphicon glyphicon-ok-sign"></i> Update</button>
                                        <button type="reset" class="btn btn-danger btn-flat soft-btn m-b-30 m-t-30" onclick="resetOrderForm()"><i class="glyphicon glyphicon-erase"></i> Reset</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.soft-input {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 10px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
}
.soft-input:focus {
    border-color: #4a6cf7;
    box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
    outline: none;
}
.soft-btn {
    padding: 8px 16px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
}
.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}
.card { background: #f7f9fc; }
body, .page-wrapper { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; color: #4a4a4a; }
</style>

<?php include('./constant/layout/footer.php'); ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
// Cache product data globally
var productDataCache = [];

$(document).ready(function() {
    // Initialize select2 for all product dropdowns
    $('.select2-product').select2({
        placeholder: "Search for a product",
        allowClear: true,
        width: '100%'
    });

    // Focus on select2 search input when opened
    $(document).on('select2:open', () => {
        document.querySelector('.select2-container--open .select2-search__field').focus();
    });

    // Show success message if set
    if (sessionStorage.getItem('showSuccessMessage') === 'true') {
        $('#success-message').show();
        sessionStorage.removeItem('showSuccessMessage');
    }

    // Debug: Log initial field values
    console.log("Initial field values:", {
        uno: $("input[name='uno']").val(),
        gstn: $("#gstn").val(),
        orderDate: $("#orderDate").val(),
        clientName: $("#clientName").val(),
        clientContact: $("#clientContact").val(),
        paymentType: $("#paymentType").val(),
        paymentStatus: $("#paymentStatus").val()
    });

    // Load product data for all rows
    <?php
    if ($order_items_result->num_rows > 0) {
        $order_items_result->data_seek(0);
        for ($i = 1; $i <= $order_items_result->num_rows; $i++) {
            echo "fetchProductData($i, true);\n";
        }
    } else {
        echo "fetchProductData(1, true);\n";
    }
    ?>

    // Recalculate totals after a short delay to ensure data is loaded
    setTimeout(subAmount, 500);
});

/* ================= CALCULATION FUNCTIONS =================== */
function getTotal(row) {
    if (!row) {
        console.error('No row specified for getTotal');
        return;
    }

    var rate = Number($("#rateValue" + row).val()) || 0;
    var quantity = Number($("#quantity" + row).val()) || 0;
    var discountPercentage = Number($("#discount_percentage_item" + row).val()) || 0;

    if (rate <= 0 || quantity <= 0) {
        $("#total" + row).val("0.00");
        $("#totalValue" + row).val("0");
        subAmount();
        return;
    }

    var baseAmount = rate * quantity;
    var discountAmount = (baseAmount * discountPercentage) / 100;
    var total = baseAmount - discountAmount;
    total = total.toFixed(2);

    $("#total" + row).val(total);
    $("#totalValue" + row).val(total);

    subAmount();
}

function subAmount() {
    var totalSubAmount = 0;
    $("#productTable tbody tr").each(function() {
        var rowId = $(this).attr('id').replace('row', '');
        var total = Number($("#totalValue" + rowId).val()) || 0;
        totalSubAmount += total;
    });

    totalSubAmount = totalSubAmount.toFixed(2);
    $("#subTotal").val(totalSubAmount);
    $("#subTotalValue").val(totalSubAmount);
    $("#totalAmount").val(totalSubAmount);
    $("#totalAmountValue").val(totalSubAmount);

    // Round grand total to nearest integer
    var grandTotal = Math.round(totalSubAmount);
    $("#grandTotal").val(grandTotal.toFixed(2));
    $("#grandTotalValue").val(grandTotal);

    paidAmount();
}

function paidAmount() {
    var grandTotal = Number($("#grandTotalValue").val()) || 0;
    var paid = Number($("#paid").val()) || 0;
    var dueAmount = grandTotal - paid;
    dueAmount = dueAmount.toFixed(2);
    $("#due").val(dueAmount);
    $("#dueValue").val(dueAmount);
}

/* ================= DYNAMIC ROWS =================== */
function addRow() {
    console.log('Adding new row...');
    var tableLength = $("#productTable tbody tr").length;
    var count = tableLength > 0 ? parseInt($("#productTable tbody tr:last").attr('id').replace('row', '')) + 1 : 1;

    var tr = '<tr id="row' + count + '" class="' + (count - 1) + '">' +
        '<td>' +
        '<div class="form-group">' +
        '<select class="form-control select2-product" name="productName[]" id="productName' + count + '" onchange="fetchProductData(' + count + ')">' +
        '<option value="">~~SELECT~~</option>' +
        '</select>' +
        '<input type="hidden" name="productId[]" id="productId' + count + '" />' +
        '</div>' +
        '</td>' +
        '<td><input type="text" name="chamber[]" id="chamber' + count + '" class="form-control soft-input" readonly /></td>' +
        '<td>' +
        '<input type="text" name="rate[]" id="rate' + count + '" class="form-control soft-input" disabled />' +
        '<input type="hidden" name="rateValue[]" id="rateValue' + count + '" />' +
        '</td>' +
        '<td>' +
        '<input type="text" name="mrp[]" id="mrp' + count + '" class="form-control soft-input" disabled />' +
        '<input type="hidden" name="mrpValue[]" id="mrpValue' + count + '" />' +
        '</td>' +
        '<td><input type="text" name="unit_description[]" id="unit_description' + count + '" class="form-control soft-input" readonly /></td>' +
        '<td><div class="form-group"><p id="available_quantity' + count + '">-</p></div></td>' +
        '<td><div class="form-group"><input type="number" name="quantity[]" id="quantity' + count + '" onkeyup="getTotal(' + count + ')" class="form-control soft-input" min="1" value="1" /></div></td>' +
        '<td><input type="number" name="discount_percentage_item[]" id="discount_percentage_item' + count + '" onkeyup="getTotal(' + count + ')" class="form-control soft-input" value="0" step="0.01" /></td>' +
        '<td>' +
        '<input type="text" name="total[]" id="total' + count + '" class="form-control soft-input" disabled value="0.00" />' +
        '<input type="hidden" name="totalValue[]" id="totalValue' + count + '" value="0" />' +
        '</td>' +
        '<td>' +
        '<button type="button" class="btn btn-primary btn-flat soft-btn" onclick="addRow()"><i class="fa fa-plus"></i></button> ' +
        '<button type="button" class="btn btn-danger removeProductRowBtn soft-btn" onclick="removeProductRow(' + count + ')"><i class="fa fa-trash"></i></button>' +
        '</td>' +
        '</tr>';

    $("#productTable tbody").append(tr);

    // Populate dropdown and initialize select2
    populateProductDropdown(count);
    $("#productName" + count).select2({
        placeholder: "Search for a product",
        allowClear: true,
        width: '100%'
    });
}

function populateProductDropdown(rowId) {
    var selectElement = $('#productName' + rowId);
    selectElement.empty();
    selectElement.append('<option value="">~~SELECT~~</option>');

    if (productDataCache.length > 0) {
        $.each(productDataCache, function(index, product) {
            selectElement.append('<option value="' + product.product_id + '" ' +
                'data-chamber="' + (product.chamber || '') + '" ' +
                'data-unit_description="' + (product.unit_description || '') + '" ' +
                'data-rate="' + (product.rate || '0') + '" ' +
                'data-mrp="' + (product.mrp || '0') + '" ' +
                'data-quantity="' + (product.quantity || '0') + '">' +
                product.product_name + (product.categories_name ? ' - ' + product.categories_name : '') +
                '</option>');
        });
    } else {
        selectElement.append('<option value="">Loading...</option>');
    }
}

function removeProductRow(row) {
    if ($("#productTable tbody tr").length <= 1) {
        alert('You must have at least one product row');
        return;
    }

    $("#row" + row).fadeOut(300, function() {
        $(this).remove();
        subAmount();
    });
}

/* ================= PRODUCT DATA FETCHING =================== */
function fetchProductData(row, isInitialLoad = false) {
    var productId = isInitialLoad ? null : $("#productName" + row).val();
    console.log(isInitialLoad ? 'Fetching all products for row ' + row : 'Fetching product data for row ' + row + ', product ID: ' + productId);

    if (!isInitialLoad && !productId) {
        resetProductRow(row);
        return;
    }

    if (isInitialLoad && productDataCache.length > 0) {
        populateProductDropdown(row);
        $("#productName" + row).select2({
            placeholder: "Search for a product",
            allowClear: true,
            width: '100%'
        });
        return;
    }

    $.ajax({
        url: 'php_action/fetchProductDatag.php',
        type: 'GET',
        data: isInitialLoad ? {} : { productId: productId },
        dataType: 'json',
        success: function(response) {
            console.log('Products loaded for row ' + row, response);

            if (isInitialLoad) {
                productDataCache = response;
                populateProductDropdown(row);
                $("#productName" + row).select2({
                    placeholder: "Search for a product",
                    allowClear: true,
                    width: '100%'
                });
            } else {
                var product = response.find(p => p.product_id == productId) || {};
                $("#productId" + row).val(product.product_id || '');
                $("#chamber" + row).val(product.chamber || '');
                $("#unit_description" + row).val(product.unit_description || '');
                $("#rate" + row).val(Number(product.rate || 0).toFixed(2));
                $("#rateValue" + row).val(Number(product.rate || 0));
                $("#mrp" + row).val(Number(product.mrp || 0).toFixed(2));
                $("#mrpValue" + row).val(Number(product.mrp || 0));
                $("#available_quantity" + row).text(product.quantity || '-');
                $("#quantity" + row).val(1);
                $("#discount_percentage_item" + row).val("0");

                getTotal(row);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching products for row ' + row + ':', error);
            alert('Error loading products. Please try again.');
            if (!isInitialLoad) resetProductRow(row);
        }
    });
}

function resetProductRow(row) {
    $("#productId" + row).val("");
    $("#chamber" + row).val("");
    $("#rate" + row).val("");
    $("#rateValue" + row).val("");
    $("#mrp" + row).val("");
    $("#mrpValue" + row).val("");
    $("#unit_description" + row).val("");
    $("#available_quantity" + row).text("-");
    $("#quantity" + row).val("");
    $("#discount_percentage_item" + row).val("0");
    $("#total" + row).val("0.00");
    $("#totalValue" + row).val("0");
    subAmount();
}

/* ================= FORM SUBMISSION =================== */
$("#editOrderForm").on('submit', function(e) {
    e.preventDefault();
    var form = $(this);
    $('.form-group').removeClass('has-error').removeClass('has-success');
    $('.text-danger').remove();

    var isValid = true;
    ['orderDate', 'clientName', 'clientContact', 'paymentType', 'paymentStatus'].forEach(function(field) {
        if (!$("#" + field).val()) {
            $("#" + field).after('<p class="text-danger">This field is required</p>');
            $("#" + field).closest('.form-group').addClass('has-error');
            isValid = false;
        } else {
            $("#" + field).closest('.form-group').addClass('has-success');
        }
    });

    var productRows = $("#productTable tbody tr");
    if (productRows.length === 0) {
        $("#productTable").after('<p class="text-danger">At least one product is required</p>');
        isValid = false;
    }

    productRows.each(function() {
        var row = $(this);
        var productId = row.find('input[name="productId[]"]').val();
        var quantity = Number(row.find('input[name="quantity[]"]').val()) || 0;
        var availableQuantity = Number(row.find('p[id^="available_quantity"]').text()) || 0;

        if (!productId) {
            row.find('select[name="productName[]"]').after('<p class="text-danger">Product is required</p>');
            isValid = false;
        }
        if (quantity < 1) {
            row.find('input[name="quantity[]"]').after('<p class="text-danger">Valid quantity is required</p>');
            isValid = false;
        } else if (availableQuantity !== '-' && quantity > availableQuantity) {
            row.find('input[name="quantity[]"]').after('<p class="text-danger">Quantity exceeds stock</p>');
            isValid = false;
        }
    });

    if (!isValid) return;

    $("#editOrderBtn").button('loading');

    $.ajax({
        url: form.attr('action'),
        type: form.attr('method'),
        data: form.serialize(),
        dataType: 'json',
        success: function(response) {
            $("#editOrderBtn").button('reset');
            if (response.success) {
                $('#success-message').show();
                sessionStorage.setItem('showSuccessMessage', 'true');
                $("html, body").animate({ scrollTop: 0 }, "slow");
            } else {
                alert(response.messages || 'Error updating invoice.');
            }
        },
        error: function(xhr) {
            $("#editOrderBtn").button('reset');
            console.error('Update error:', xhr.status, xhr.responseText);
            alert('Error submitting form. Please try again.');
        }
    });
});

function resetOrderForm() {
    $("#editOrderForm")[0].reset();
    $("#productTable tbody tr:not(:first)").remove();
    $("#subTotal, #subTotalValue, #totalAmount, #totalAmountValue, #grandTotal, #grandTotalValue, #due, #dueValue").val("0.00");
    $("#success-message").hide();
    sessionStorage.removeItem('showSuccessMessage');
    $("#productName1").select2({
        placeholder: "Search for a product",
        allowClear: true,
        width: '100%'
    });
    resetProductRow(1);
}
</script>