<?php 
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('./constant/connect.php');

// ✅ Get product ID from URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<script>alert('Invalid Product ID'); window.location='product.php';</script>";
    exit();
}
$id = intval($_GET['id']);

// ✅ Fetch current product data
$sql = "SELECT * FROM product WHERE product_id = '$id' LIMIT 1";
$result = $connect->query($sql);
if (!$result || $result->num_rows == 0) {
    echo "<script>alert('Product not found'); window.location='view-medicine.php';</script>";
    exit();
}
$product = $result->fetch_assoc();

// ✅ Function to return value or defaults
function val($field, $defaultText = 'N/A', $defaultNum = '0') {
    global $product;
    if (!isset($product[$field]) || $product[$field] === '' || is_null($product[$field])) {
        // Decide default based on numeric or string
        return is_numeric($defaultNum) ? $defaultNum : $defaultText;
    }
    return $product[$field];
}
?>

<div class="page-wrapper" style="background-color: #f7f9fc; min-height: 100vh; padding: 20px;">
    <div class="row page-titles mb-4">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary" style="font-weight: 600; color: #4a6cf7;">Edit Medicine</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb" style="background: transparent; padding: 0;">
                <li class="breadcrumb-item"><a href="javascript:void(0)" style="color:#888;">Home</a></li>
                <li class="breadcrumb-item active" style="color:#4a6cf7;">Edit Medicine</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="card" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;">
                    <div class="card-body">
                        <form class="row" method="POST" action="php_action/editProduct.php" enctype="multipart/form-data">
                            <input type="hidden" name="product_id" value="<?php echo $product['product_id']; ?>">

                            <!-- Supplier -->
                            <div class="form-group col-md-3">
                                <label>Supplier Name</label>
                                <select class="form-control soft-input" name="supplierName">
                                    <option value="">~~SELECT~~</option>
                                    <?php 
                                    $sql = "SELECT supplier_id, supplier_name FROM suppliers WHERE supplier_status=1 AND supplier_active=1";
                                    $suppliers = $connect->query($sql);
                                    while($row = $suppliers->fetch_array()) {
                                        $selected = ($product['supplier_id'] == $row[0]) ? 'selected' : '';
                                        echo "<option value='".$row[0]."' $selected>".$row[1]."</option>";
                                    }
                                    ?>
                                </select>
                            </div>

                            <!-- Medicine Name -->
                            <div class="form-group col-md-3">
                                <label>Medicine Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control soft-input" name="productName" required 
                                value="<?php echo val('product_name'); ?>">
                            </div>

                            <!-- HSN -->
                            <div class="form-group col-md-3">
                                <label>HSN Code</label>
                                <input type="text" class="form-control soft-input" name="hsnCode" 
                                value="<?php echo val('hsn_code','N/A'); ?>">
                            </div>

                            <!-- Quantity + Unit -->
                            <div class="form-group col-md-3">
                                <label>Quantity</label>
                                <div class="input-group">
                                    <input type="text" class="form-control soft-input same-height" name="quantity" 
                                    value="<?php echo val('quantity','',0); ?>">
                                    <select class="form-control soft-input same-height" name="unit">
                                        <?php 
                                        $units = ['pcs','strips','bottles','boxes','tubes','packs','jars','units'];
                                        foreach($units as $u){
                                            $sel = ($product['unit']==$u)?'selected':'';
                                            echo "<option $sel>$u</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>

                            <!-- Rates -->
                            <div class="form-group col-md-3">
                                <label>Purchase Rate</label>
                                <input type="text" class="form-control soft-input" name="purchaseRate" 
                                value="<?php echo val('purchase_rate','',0); ?>">
                            </div>

                            <div class="form-group col-md-3">
                                <label>Selling Rate</label>
                                <input type="text" class="form-control soft-input" name="rate" 
                                value="<?php echo val('rate','',0); ?>">
                            </div>

                            <div class="form-group col-md-3">
                                <label>SGST %</label>
                                <input type="number" class="form-control soft-input" name="sgst" 
                                value="<?php echo val('sgst','',0); ?>">
                            </div>

                            <div class="form-group col-md-3">
                                <label>CGST %</label>
                                <input type="number" class="form-control soft-input" name="cgst" 
                                value="<?php echo val('cgst','',0); ?>">
                            </div>

                            <div class="form-group col-md-3">
                                <label>MRP</label>
                                <input type="text" class="form-control soft-input" name="mrp" 
                                value="<?php echo val('mrp','',0); ?>">
                            </div>

                            <!-- Batch / Expiry -->
                            <div class="form-group col-md-3">
                                <label>Batch No</label>
                                <input type="text" class="form-control soft-input" name="bno" 
                                value="<?php echo val('bno','N/A'); ?>">
                            </div>

                            <div class="form-group col-md-3">
                                <label>Expiry Date</label>
                                <input type="date" class="form-control soft-input" name="expdate" 
                                value="<?php echo val('expdate'); ?>">
                            </div>

                            <!-- Chamber -->
                               <!-- Chamber (Optional) -->
                            <div class="form-group col-md-3">
                                <label class="control-label">Chamber <span class="text-muted">(Optional)</span></label>
                                <select class="form-control soft-input select2-chamber" id="chamber" name="chamber" style="height:50px">
                                    <option value="">~~SELECT~~</option>
                                    <?php
                                    // Fetch chambers from database
                                    $chamber_sql = "SELECT id,  column_number, row_no 
                                                    FROM chambers 
                                                    WHERE deleted = 0 
                                                   ";
                                    $chamber_result = $connect->query($chamber_sql);

                                    if ($chamber_result && $chamber_result->num_rows > 0) {
                                        while ($chamber_row = $chamber_result->fetch_assoc()) {
                                            // Build display text
                                            $display_text = $chamber_row['column_number'].' , '.$chamber_row['row_no'];

                                            // Optional: append column & row for clarity
                                            if (!empty($chamber_row['column_number']) || !empty($chamber_row['row_no'])) {
                                                $display_text .= " (Col: " . $chamber_row['column_number'] . ", Row: " . $chamber_row['row_no'] . ")";
                                            }

                                            // Use row_no or column_number in data-location attribute
                                            $data_location = "Column: " . $chamber_row['column_number'] . " | Row: " . $chamber_row['row_no'];

                                            echo "<option value='" . $chamber_row['id'] . "' data-location='" . $data_location . "'>" . $display_text . "</option>";
                                        }
                                    } else {
                                        // Fallback options if no chambers exist
                                        echo "<option value='main' data-location='Main Building'>Main Chamber</option>
                                              <option value='storage' data-location='Storage Area'>Storage Room</option>
                                              <option value='refrigerated' data-location='Cold Storage'>Refrigerated Chamber</option>
                                              <option value='quarantine' data-location='Isolation Area'>Quarantine Area</option>";
                                    }
                                    ?>
                                </select>
                            </div>


                            <!-- Brand -->
                            <div class="form-group col-md-3">
                                <label>Manufacturer</label>
                                <select class="form-control soft-input" name="brandName">
                                    <option value="">~~SELECT~~</option>
                                    <?php 
                                    $brands = $connect->query("SELECT brand_id,brand_name FROM brands WHERE brand_status=1 AND brand_active=1");
                                    while($row=$brands->fetch_array()) {
                                        $sel=($product['brand_id']==$row[0])?'selected':'';
                                        echo "<option value='".$row[0]."' $sel>".$row[1]."</option>";
                                    }
                                    ?>
                                </select>
                            </div>

                            <!-- Category -->
                            <div class="form-group col-md-3">
                                <label>Category</label>
                                <select class="form-control soft-input" name="categoryName">
                                    <option value="">~~SELECT~~</option>
                                    <?php 
                                    $cats = $connect->query("SELECT categories_id,categories_name FROM categories WHERE categories_status=1 AND categories_active=1");
                                    while($row=$cats->fetch_array()) {
                                        $sel=($product['categories_id']==$row[0])?'selected':'';
                                        echo "<option value='".$row[0]."' $sel>".$row[1]."</option>";
                                    }
                                    ?>
                                </select>
                            </div>

                            <!-- Current Image + Upload New -->
                            <div class="form-group col-md-3">
                                <label>Current Image</label><br>
                                <?php 
                                $img='assets/myimages/'.$product['product_image'];
                                if(!empty($product['product_image']) && file_exists($img)){
                                    echo "<img src='$img' style='width:100px;height:100px;border-radius:12px;object-fit:cover;'>";
                                } else {
                                    echo "<div style='width:100px;height:100px;border-radius:12px;background:#f0f4f8;display:flex;align-items:center;justify-content:center;'>
                                            <i class='fa fa-pills' style='font-size:30px;color:#4a6cf7;'></i>
                                          </div>";
                                }
                                ?>
                                <input type="hidden" name="old_image" value="<?php echo $product['product_image']; ?>">
                                <input type="file" class="form-control mt-2" name="productImage">
                            </div>

                            <!-- Status -->
                            <div class="form-group col-md-3">
                                <label>Status</label>
                                <select class="form-control soft-input" name="productStatus">
                                    <option value="1" <?php echo ($product['active']==1)?'selected':''; ?>>Available</option>
                                    <option value="2" <?php echo ($product['active']==2)?'selected':''; ?>>Not Available</option>
                                </select>
                            </div>

                            <!-- Submit -->
                            <div class="col-12 text-center mt-3">
                                <button type="submit" class="btn btn-primary soft-btn">Update Medicine</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('./constant/layout/footer.php'); ?>
