<?php
include('./constant/connect.php');

if(isset($_POST['product_id'])) {
    $product_id = $_POST['product_id'];
    
    $sql = "SELECT p.*, c.chamber_name, c.column_number, c.row_no,
            cat.categories_name, b.brand_name, s.supplier_name,
            DATEDIFF(p.expdate, CURDATE()) as days_to_expire
            FROM product p 
            LEFT JOIN chambers c ON p.chamber = c.id 
            LEFT JOIN categories cat ON p.categories_id = cat.categories_id
            LEFT JOIN brands b ON p.brand_id = b.brand_id
            LEFT JOIN suppliers s ON p.supplier_id = s.supplier_id
            WHERE p.product_id = ? AND p.status = 1";
    
    $stmt = $connect->prepare($sql);
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows > 0) {
        $product = $result->fetch_assoc();
        $stock_value = (float)$product['quantity'] * (float)$product['purchase_rate'];
        
        echo '<div class="row">';
        echo '<div class="col-md-6">';
        echo '<h6>Basic Information</h6>';
        echo '<table class="table table-bordered">';
        echo '<tr><td><strong>Medicine Name:</strong></td><td>'.$product['product_name'].'</td></tr>';
        echo '<tr><td><strong>Batch No:</strong></td><td>'.$product['bno'].'</td></tr>';
        echo '<tr><td><strong>HSN Code:</strong></td><td>'.$product['hsn_code'].'</td></tr>';
        echo '<tr><td><strong>Category:</strong></td><td>'.$product['categories_name'].'</td></tr>';
        echo '<tr><td><strong>Manufacturer:</strong></td><td>'.$product['brand_name'].'</td></tr>';
        echo '<tr><td><strong>Supplier:</strong></td><td>'.$product['supplier_name'].'</td></tr>';
        echo '</table>';
        echo '</div>';
        
        echo '<div class="col-md-6">';
        echo '<h6>Stock Information</h6>';
        echo '<table class="table table-bordered">';
        echo '<tr><td><strong>Quantity:</strong></td><td>'.$product['quantity'].' '.$product['unit'].'</td></tr>';
        echo '<tr><td><strong>Purchase Rate:</strong></td><td>₹'.number_format($product['purchase_rate'], 2).'</td></tr>';
        echo '<tr><td><strong>Selling Rate:</strong></td><td>₹'.number_format($product['rate'], 2).'</td></tr>';
        echo '<tr><td><strong>MRP:</strong></td><td>₹'.number_format($product['mrp'], 2).'</td></tr>';
        echo '<tr><td><strong>CGST:</strong></td><td>'.$product['cgst'].'%</td></tr>';
        echo '<tr><td><strong>SGST:</strong></td><td>'.$product['sgst'].'%</td></tr>';
        echo '</table>';
        echo '</div>';
        echo '</div>';
        
        echo '<div class="row mt-3">';
        echo '<div class="col-md-6">';
        echo '<h6>Location & Expiry</h6>';
        echo '<table class="table table-bordered">';
        echo '<tr><td><strong>Chamber:</strong></td><td>'.$product['chamber_name'].' (C:'.$product['column_number'].', R:'.$product['row_no'].')</td></tr>';
        echo '<tr><td><strong>Expiry Date:</strong></td><td>'.date('d M Y', strtotime($product['expdate'])).'</td></tr>';
        echo '<tr><td><strong>Days to Expire:</strong></td><td>'.$product['days_to_expire'].' days</td></tr>';
        echo '</table>';
        echo '</div>';
        
        echo '<div class="col-md-6">';
        echo '<h6>Financial Information</h6>';
        echo '<table class="table table-bordered">';
        echo '<tr><td><strong>Stock Value:</strong></td><td>₹'.number_format($stock_value, 2).'</td></tr>';
        echo '<tr><td><strong>Added Date:</strong></td><td>'.date('d M Y', strtotime($product['added_date'])).'</td></tr>';
        echo '<tr><td><strong>Status:</strong></td><td>'.($product['active'] ? 'Active' : 'Inactive').'</td></tr>';
        echo '</table>';
        echo '</div>';
        echo '</div>';
    } else {
        echo '<div class="alert alert-danger">Product not found!</div>';
    }
}
?>