<?php include('./constant/layout/head.php');?>
<?php include('./constant/layout/header.php');?>
<?php include('./constant/layout/sidebar.php');?>
<?php include('./constant/connect.php'); ?>
<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Invoice Management</h3> 
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item active">Invoice Management</li>
            </ol>
        </div>
    </div>
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12" >
                <div class="card">
                    <div class="card-title"></div>
                    <div id="add-brand-messages"></div>
                    <!-- Success message container -->
                    <div id="success-message" class="alert alert-success" style="display: none;">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <strong><i class="glyphicon glyphicon-ok-sign"></i></strong> Invoice added successfully!
                    </div>
                    <div class="card-body">
                        <div class="input-states">
                            <form class="form-horizontal" method="POST" id="createOrderForm" action="php_action/order.php">
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice No</label>
                                        <div class="col-sm-4">
                                            <?php 
                                            $user = "SELECT * FROM orders WHERE id=(SELECT MAX(id) FROM orders)";
                                            $result = $connect->query($user);
                                            $res = $result->fetch_assoc();
                                            
                                            $n = "INV-000";
                                            $l = $res['id'] + 1;
                                            $stall_no = $n."".$l; 
                                            ?>
                                            <input type="text" class="form-control" placeholder="Invoice Number" value="<?php echo $stall_no; ?>" autocomplete="off" name="uno" required/>
                                        </div>

                                        <label class="col-sm-2 control-label">Invoice Date</label>
                                        <div class="col-sm-4">
                                            <input type="date" class="form-control" value="<?php echo date('Y-m-d');?>" id="orderDate" name="orderDate" autocomplete="off" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice Time</label>
                                        <div class="col-sm-4">
                                            <input type="time" class="form-control" value="<?php echo date('H:i');?>" id="orderTime" name="orderTime" autocomplete="off" />
                                        </div>

                                        <label class="col-sm-2 control-label">Client Contact No.</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="clientContact" name="clientContact" placeholder="Contact Number" autocomplete="off" pattern="^[0][1-9]\d{9}$|^[1-9]\d{9}$" required/>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Client Name</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="clientName" name="clientName" placeholder="Client Name" autocomplete="off" />
                                        </div>

                                        <label class="col-sm-2 control-label">GSTIN (Optional)</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="gstn" name="gstn" placeholder="GSTIN Number" autocomplete="off" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">               
                                    <table class="table" id="productTable">
                                        <thead>
                                            <tr>              
                                                <th style="width:20%;">Medicine</th>
                                                <th style="width:12%;">Chamber</th>
                                                <th style="width:8%;">Rate</th>
                                                <th style="width:8%;">Avail.</th>
                                                <th style="width:8%;">Quantity</th>
                                                <th style="width:8%;">SGST %</th>
                                                <th style="width:8%;">CGST %</th>
                                                <th style="width:8%;">Discount %</th>
                                                <th style="width:10%;">Total</th>             
                                                <th style="width:10%;">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $arrayNumber = 0;
                                            for($x = 1; $x < 2; $x++) { ?>
                                                <tr id="row<?php echo $x; ?>" class="<?php echo $arrayNumber; ?>">                
                                                    <td>
                                                    <style>
                                                    /* Bigger Select2 single select box */
.select2-container--default .select2-selection--single {
  height: 60px !important;          /* container height */
  line-height: 60px !important;     /* center the text vertically */
  font-size: 12px !important;       /* bigger text */
  padding-top: 10px !important;
  padding-bottom: 10px !important;
}

/* Make the rendered text centered vertically */
.select2-container--default .select2-selection--single .select2-selection__rendered {
  line-height: 60px !important;
  font-size: 12px !important;
}

/* Make the dropdown arrow area same height */
.select2-container--default .select2-selection--single .select2-selection__arrow {
  height: 60px !important;
}

                                                    </style>
                                                        <div class="form-group">
                                                         <select class="form-control select2-product" 
        name="productName[]" 
        id="productName<?php echo $x; ?>" 
        onchange="getProductData(<?php echo $x; ?>)" 
        style="height:60px; font-size:12px; padding-top:10px; padding-bottom:10px;">
    <option value="">~~SELECT~~</option>
    <?php
    $productSql = "SELECT * FROM product WHERE active = 1 AND status = 1 AND quantity != 0";
    $productData = $connect->query($productSql);

    while($row = $productData->fetch_array()) {                     
        echo "<option value='".$row['product_id']."' 
                data-chamber='".$row['chamber']."'
                id='changeProduct".$row['product_id']."'>".$row['product_name']."</option>";
    }
    ?>
</select>


                                                        </div>
                                                    </td>
                                                    <td>
                                                     <input type="text" name="chamber[]" id="chamber<?php echo $x; ?>" autocomplete="off" class="form-control" readonly />

                                                    </td>
                                                    <td>                 
                                                        <input type="text" name="rate[]" id="rate<?php echo $x; ?>" autocomplete="off" disabled="true" class="form-control" />                  
                                                        <input type="hidden" name="rateValue[]" id="rateValue<?php echo $x; ?>" autocomplete="off" class="form-control" />                  
                                                    </td>
                                                    <td>
                                                        <div class="form-group">
                                                            <p id="available_quantity<?php echo $x; ?>"></p>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="form-group">
                                                            <input type="number" name="quantity[]" id="quantity<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control" min="1" />
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="number" name="sgst_percentage[]" id="sgst_percentage<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control" value="0" step="0.01" />
                                                    </td>
                                                    <td>
                                                        <input type="number" name="cgst_percentage[]" id="cgst_percentage<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control" value="0" step="0.01" />
                                                    </td>
                                                    <td>
                                                        <input type="number" name="discount_percentage_item[]" id="discount_percentage_item<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control" value="0" step="0.01" />
                                                    </td>
                                                    <td>                 
                                                        <input type="text" name="total[]" id="total<?php echo $x; ?>" autocomplete="off" class="form-control" disabled="true" />                  
                                                        <input type="hidden" name="totalValue[]" id="totalValue<?php echo $x; ?>" autocomplete="off" class="form-control" />                  
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-primary btn-flat" onclick="addRow()" id="addRowBtn"><i class="fa fa-plus"></i></button>
                                                        <button type="button" class="btn btn-danger removeProductRowBtn" onclick="removeProductRow(<?php echo $x; ?>)"><i class="fa fa-trash"></i></button>
                                                    </td>
                                                </tr>
                                            <?php
                                            $arrayNumber++;
                                            }
                                            ?>
                                        </tbody>          
                                    </table>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Sub Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="subTotal" name="subTotal" disabled="true" />
                                            <input type="hidden" class="form-control" id="subTotalValue" name="subTotalValue" />
                                        </div>

                                        <label for="totalAmount" class="col-sm-2 control-label">Total Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="totalAmount" name="totalAmount" disabled="true"/>
                                            <input type="hidden" class="form-control" id="totalAmountValue" name="totalAmountValue" />
                                        </div>
                                    </div>
                                </div>
                               
                                <div class="form-group">
                                    <div class="row">
                                        <label for="discount_percentage" class="col-sm-2 control-label">Overall Discount %</label>
                                        <div class="col-sm-4">
                                            <input type="number" class="form-control" id="discount_percentage" name="discount_percentage" onkeyup="discountFunc()" autocomplete="off" value="0" step="0.01" />
                                        </div>
                                        <label for="grandTotal" class="col-sm-2 control-label">Grand Total</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="grandTotal" name="grandTotal" disabled="true" />
                                            <input type="hidden" class="form-control" id="grandTotalValue" name="grandTotalValue" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label for="sgst_total" class="col-sm-2 control-label">Total SGST</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="sgst_total" name="sgst_total" readonly="true" />
                                            <input type="hidden" class="form-control" id="sgst_totalValue" name="sgst_totalValue" />
                                        </div>

                                        <label for="cgst_total" class="col-sm-2 control-label">Total CGST</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="cgst_total" name="cgst_total" readonly="true" />
                                            <input type="hidden" class="form-control" id="cgst_totalValue" name="cgst_totalValue" />
                                        </div>
                                    </div>
                                </div>
                               
                                <div class="form-group">
                                    <div class="row">
                                        <label for="paid" class="col-sm-2 control-label">Paid Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="paid" name="paid" autocomplete="off" onkeyup="paidAmount()" />
                                        </div>

                                        <label for="due" class="col-sm-2 control-label">Due Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="due" name="due" disabled="true" />
                                            <input type="hidden" class="form-control" id="dueValue" name="dueValue" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label for="paymentType" class="col-sm-2 control-label">Payment Type</label>
                                        <div class="col-sm-4">
                                            <select class="form-control" name="paymentType" id="paymentType">
                                                <option value="">~~SELECT~~</option>
                                                <option value="2">Cash</option>
                                                <option value="4">Phone Pe</option>
                                                <option value="5">Google Pay</option>
                                                <option value="6">Amazon Pay</option>
                                                <option value="1">Cheque</option>
                                                <option value="3">Credit Card</option>
                                            </select>
                                        </div>
                                       
                                        <label for="paymentStatus" class="col-sm-2 control-label">Payment Status</label>
                                        <div class="col-sm-4">
                                            <select class="form-control" name="paymentStatus" id="paymentStatus">
                                                <option value="">~~SELECT~~</option>
                                                <option value="1">Full Payment</option>
                                                <option value="2">Advance Payment</option>
                                                <option value="3">No Payment</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group submitButtonFooter">
                                    <div class="col-sm-offset-2 col-sm-10">
                                        <button type="submit" id="createOrderBtn" data-loading-text="Loading..." class="btn btn-success btn-flat m-b-30 m-t-30"><i class="glyphicon glyphicon-ok-sign"></i> Submit</button>
                                        <button type="reset" class="btn btn-danger btn-flat m-b-30 m-t-30" onclick="resetOrderForm()"><i class="glyphicon glyphicon-erase"></i> Reset</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* ------------- Soft UI Inputs & Buttons ------------- */
.soft-input {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 10px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
}

.soft-input:focus {
    border-color: #4a6cf7;
    box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
    outline: none;
}

.soft-btn {
    padding: 8px 16px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
}

.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}

/* Card */
.card {
    background: #f7f9fc;
}

/* Smooth font & general */
body, .page-wrapper {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #4a4a4a;
}

/* Select2 styling */
.select2-container--default .select2-selection--single {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 6px 12px;
    height: auto;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 100%;
}
</style>

<?php include('./constant/layout/footer.php');?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
var manageOrderTable;

$(document).ready(function () {
    $('.select2-product').select2({
        placeholder: "Search for a medicine",
        allowClear: true
    });
    
    $('.select2-chamber').select2({
        placeholder: "Select chamber",
        allowClear: true
    });

    // Auto focus search field when select2 opens
    $(document).on('select2:open', () => {
        document.querySelector('.select2-container--open .select2-search__field').focus();
    });

    // Check if we should show success message from session storage
    if (sessionStorage.getItem('showSuccessMessage') === 'true') {
        $('#success-message').show();
        sessionStorage.removeItem('showSuccessMessage');
    }
});

/* ================= CALCULATION FUNCTIONS =================== */
function getTotal(row = null) {
    if (!row) { alert('no row !! please refresh the page'); return; }

    var rate = Number($("#rate" + row).val());
    var quantity = Number($("#quantity" + row).val());
    var sgstPercentage = Number($("#sgst_percentage" + row).val());
    var cgstPercentage = Number($("#cgst_percentage" + row).val());
    var discountPercentage = Number($("#discount_percentage_item" + row).val());

    var baseAmount = rate * quantity;
    var discountAmount = (baseAmount * discountPercentage) / 100;
    var discountedAmount = baseAmount - discountAmount;

    var sgstAmount = (discountedAmount * sgstPercentage) / 100;
    var cgstAmount = (discountedAmount * cgstPercentage) / 100;

    var total = discountedAmount + sgstAmount + cgstAmount;
    total = total.toFixed(2);

    $("#total" + row).val(total);
    $("#totalValue" + row).val(total);

    subAmount();
}

function subAmount() {
    var tableProductLength = $("#productTable tbody tr").length;
    var totalSubAmount = 0, totalSgst = 0, totalCgst = 0, totalDiscount = 0;

    for (x = 0; x < tableProductLength; x++) {
        var tr = $("#productTable tbody tr")[x];
        var count = $(tr).attr('id');
        count = count.substring(3);

        totalSubAmount += Number($("#total" + count).val());

        var rate = Number($("#rate" + count).val());
        var quantity = Number($("#quantity" + count).val());
        var sgstPercentage = Number($("#sgst_percentage" + count).val());
        var cgstPercentage = Number($("#cgst_percentage" + count).val());
        var discountPercentage = Number($("#discount_percentage_item" + count).val());

        var productSubtotal = rate * quantity;
        var productDiscount = (productSubtotal * discountPercentage) / 100;
        totalDiscount += productDiscount;

        var discountedAmount = productSubtotal - productDiscount;
        totalSgst += (discountedAmount * sgstPercentage) / 100;
        totalCgst += (discountedAmount * cgstPercentage) / 100;
    }

    totalSubAmount = totalSubAmount.toFixed(2);
    totalSgst = totalSgst.toFixed(2);
    totalCgst = totalCgst.toFixed(2);
    totalDiscount = totalDiscount.toFixed(2);

    $("#subTotal, #subTotalValue").val(totalSubAmount);
    $("#sgst_total, #sgst_totalValue").val(totalSgst);
    $("#cgst_total, #cgst_totalValue").val(totalCgst);

    var totalAmount = Number(totalSubAmount).toFixed(2);
    $("#totalAmount, #totalAmountValue").val(totalAmount);

    var discountPercentage = $("#discount_percentage").val();
    if (discountPercentage) {
        var discountAmount = (Number(totalAmount) * Number(discountPercentage)) / 100;
        var grandTotal = Number(totalAmount) - discountAmount;
        grandTotal = grandTotal.toFixed(2);
        $("#grandTotal, #grandTotalValue").val(grandTotal);
    } else {
        $("#grandTotal, #grandTotalValue").val(totalAmount);
    }

    var paidAmount = $("#paid").val();
    if (paidAmount) {
        paidAmount = Number($("#grandTotal").val()) - Number(paidAmount);
        paidAmount = paidAmount.toFixed(2);
        $("#due, #dueValue").val(paidAmount);
    } else {
        $("#due, #dueValue").val($("#grandTotal").val());
    }
}

function discountFunc() {
    var discountPercentage = $("#discount_percentage").val();
    var totalAmount = Number($("#totalAmount").val()).toFixed(2);

    if (totalAmount) {
        var discountAmount = (Number(totalAmount) * Number(discountPercentage)) / 100;
        var grandTotal = Number(totalAmount) - discountAmount;
        grandTotal = grandTotal.toFixed(2);
        $("#grandTotal, #grandTotalValue").val(grandTotal);
    }

    var paid = $("#paid").val();
    var dueAmount;
    if (paid) {
        dueAmount = Number($("#grandTotal").val()) - Number($("#paid").val());
        dueAmount = dueAmount.toFixed(2);
        $("#due, #dueValue").val(dueAmount);
    } else {
        $("#due, #dueValue").val($("#grandTotal").val());
    }
}

function paidAmount() {
    var grandTotal = $("#grandTotal").val();
    if (grandTotal) {
        var dueAmount = Number($("#grandTotal").val()) - Number($("#paid").val());
        dueAmount = dueAmount.toFixed(2);
        $("#due, #dueValue").val(dueAmount);
    }
}

/* ================= DYNAMIC ROWS =================== */
function addRow() {
    $("#addRowBtn").button("loading");

    var tableLength = $("#productTable tbody tr").length;
    var count = tableLength > 0 ? Number($("#productTable tbody tr:last").attr('id').substring(3)) + 1 : 1;
    var arrayNumber = tableLength > 0 ? Number($("#productTable tbody tr:last").attr('class')) + 1 : 0;

    $.ajax({
        url: 'php_action/fetchProductData.php',
        type: 'post',
        dataType: 'json',
        success: function (response) {
            $("#addRowBtn").button("reset");
            
            // Fetch chambers for the dropdown
            $.ajax({
                url: 'php_action/fetchChambers.php',
                type: 'get',
                dataType: 'json',
                success: function(chambers) {
                    var chamberOptions = '<option value="">~~SELECT~~</option>';
                    $.each(chambers, function(index, chamber) {
                        var chamberDisplay = chamber.chamber_name + " - R" + chamber.row_no + "C" + chamber.column_number;
                        chamberOptions += '<option value="' + chamber.id + '">' + chamberDisplay + '</option>';
                    });

                    var tr = '<tr id="row' + count + '" class="' + arrayNumber + '">' +
                        '<td><select class="form-control select2-product" name="productName[]" id="productName' + count + '" onchange="getProductData(' + count + ')" >' +
                        '<option value="">~~SELECT~~</option>';
                    $.each(response, function (index, value) {
                        tr += '<option value="' + value[0] + '">' + value[1] + '</option>';
                    });
                    tr += '</select></td>' +
                  
   '<td><input type="text" name="chamber[]" id="chamber' + count + '" autocomplete="off" class="form-control" readonly /></td>' +
                     
                        '<td><input type="text" name="rate[]" id="rate' + count + '" disabled class="form-control"/>' +
                        '<input type="hidden" name="rateValue[]" id="rateValue' + count + '"/></td>' +
                        '<td><p id="available_quantity' + count + '"></p></td>' +
                        '<td><input type="number" name="quantity[]" id="quantity' + count + '" onkeyup="getTotal(' + count + ')" min="1" class="form-control"/></td>' +
                        '<td><input type="number" name="sgst_percentage[]" id="sgst_percentage' + count + '" onkeyup="getTotal(' + count + ')" value="0" step="0.01" class="form-control"/></td>' +
                        '<td><input type="number" name="cgst_percentage[]" id="cgst_percentage' + count + '" onkeyup="getTotal(' + count + ')" value="0" step="0.01" class="form-control"/></td>' +
                        '<td><input type="number" name="discount_percentage_item[]" id="discount_percentage_item' + count + '" onkeyup="getTotal(' + count + ')" value="0" step="0.01" class="form-control"/></td>' +
                        '<td><input type="text" name="total[]" id="total' + count + '" disabled class="form-control"/>' +
                        '<input type="hidden" name="totalValue[]" id="totalValue' + count + '"/></td>' +
                        '<td><button type="button" class="btn btn-primary btn-flat" onclick="addRow()" id="addRowBtn"><i class="fa fa-plus"></i></button>' +
                        '<button type="button" class="btn btn-danger removeProductRowBtn" onclick="removeProductRow(' + count + ')"><i class="fa fa-trash"></i></button></td>' +
                        '</tr>';

                    if (tableLength > 0) {
                        $("#productTable tbody tr:last").after(tr);
                    } else {
                        $("#productTable tbody").append(tr);
                    }

                    $('.select2-product').select2({
                        placeholder: "Search for a medicine",
                        allowClear: true
                    });
                    
                    $('.select2-chamber').select2({
                        placeholder: "Select chamber",
                        allowClear: true
                    });
                },
                error: function(xhr) {
                    console.error('fetchChambers.php failed', xhr.responseText);
                }
            });
        },
        error: function (xhr) {
            $("#addRowBtn").button("reset");
            console.error('fetchProductData.php failed', xhr.responseText);
            alert('Could not load product list.');
        }
    });
}

function removeProductRow(row = null) {
    if (!row) { alert('error! Refresh the page again'); return; }
    $("#row" + row).remove();
    subAmount();
}

/* ================= FETCH SELECTED PRODUCT =================== */
function getProductData(row = null) {
    if (!row) { alert('no row! please refresh the page'); return; }

    var productId = $("#productName" + row).val();
    if (productId === "") {
        $("#rate" + row).val("");
        $("#quantity" + row).val("");
        $("#total" + row).val("");
        return;
    }

    $.ajax({
        url: 'php_action/fetchSelectedProduct.php',
        type: 'post',
        data: { productId: productId },
        dataType: 'json',
        success: function (response) {
            $("#rate" + row).val(response.rate);
            $("#rateValue" + row).val(response.rate);
            $("#quantity" + row).val(1);
            $("#available_quantity" + row).text(response.quantity);
                $("#chamber" + row).val(response.chamber);
            
            // Set default GST values from database if available
            if (response.sgst && response.sgst > 0) {
                $("#sgst_percentage" + row).val(response.sgst);
            }
            if (response.cgst && response.cgst > 0) {
                $("#cgst_percentage" + row).val(response.cgst);
            }
            
            getTotal(row);
        },
        error: function (xhr) {
            console.error('fetchSelectedProduct.php failed', xhr.responseText);
            alert('Could not fetch product data.');
        }
    });
}

/* ================= FORM SUBMISSION =================== */
$("#createOrderForm").unbind('submit').bind('submit', function () {
    var form = $(this);
    $('.form-group').removeClass('has-error').removeClass('has-success');
    $('.text-danger').remove();

    // Validate required fields
    var requiredFields = ['orderDate', 'orderTime', 'clientName', 'clientContact', 'paymentType', 'paymentStatus'];
    var isValid = true;

    $.each(requiredFields, function (index, field) {
        var value = $("#" + field).val();
        if (value == "") {
            $("#" + field).after('<p class="text-danger"> This field is required </p>');
            $("#" + field).closest('.form-group').addClass('has-error');
            isValid = false;
        } else {
            $("#" + field).closest('.form-group').addClass('has-success');
        }
    });

    // Validate product rows
    var productRows = $("#productTable tbody tr");
    if (productRows.length == 0) {
        $("#productTable").after('<p class="text-danger"> At least one product is required </p>');
        isValid = false;
    }

    productRows.each(function () {
        var row = $(this);
        var productName = row.find('select[name="productName[]"]').val();
        var quantity = row.find('input[name="quantity[]"]').val();
        if (!productName) {
            row.find('select[name="productName[]"]').after('<p class="text-danger"> Product is required </p>');
            isValid = false;
        }
        if (!quantity || quantity < 1) {
            row.find('input[name="quantity[]"]').after('<p class="text-danger"> Valid quantity is required </p>');
            isValid = false;
        }
    });

    if (!isValid) return false;

    // Submit via AJAX
    $("#createOrderBtn").button('loading');

    $.ajax({
        url: form.attr('action'),
        type: form.attr('method'),
        data: form.serialize(),
        dataType: 'json',
        success: function (response) {
            $("#createOrderBtn").button('reset');
            $(".text-danger").remove();
            $('.form-group').removeClass('has-error').removeClass('has-success');

            if (response.success === true) {
                // Show success message
                $('#success-message').show();
                
                // Store success state in session storage for page refresh
                sessionStorage.setItem('showSuccessMessage', 'true');
                
                // Reset the form
                form[0].reset();
                
                // Reset the product table to one row
                $("#productTable tbody tr:not(:first)").remove();
                
                // Reset calculations
                $("#subTotal, #subTotalValue").val("0");
                $("#totalAmount, #totalAmountValue").val("0");
                $("#grandTotal, #grandTotalValue").val("0");
                $("#sgst_total, #sgst_totalValue").val("0");
                $("#cgst_total, #cgst_totalValue").val("0");
                $("#due, #dueValue").val("0");
                
                // Scroll to top to show the success message
                $("html, body").animate({ scrollTop: 0 }, "slow");
                
                // Optionally redirect or refresh after success
                setTimeout(function() {
                    // You can redirect to a different page or refresh
                    // window.location.href = 'invoice-management.php';
                }, 2000);
            } else {
                alert(response.messages);
            }
        },
        error: function (xhr) {
            $("#createOrderBtn").button('reset');
            console.error('create order failed', xhr.status, xhr.responseText);
            alert('Error submitting form. Server says:\n' + xhr.responseText);
        }
    });

    return false;
});

// Function to reset the order form
function resetOrderForm() {
    document.getElementById("createOrderForm").reset();
    $("#productTable tbody tr:not(:first)").remove();
    $("#subTotal, #subTotalValue").val("0");
    $("#totalAmount, #totalAmountValue").val("0");
    $("#grandTotal, #grandTotalValue").val("0");
    $("#sgst_total, #sgst_totalValue").val("0");
    $("#cgst_total, #cgst_totalValue").val("0");
    $("#due, #dueValue").val("0");
    $("#success-message").hide();
    sessionStorage.removeItem('showSuccessMessage');
}
</script>