<?php 
include('./constant/layout/head.php'); 
include('./constant/layout/header.php'); 
include('./constant/layout/sidebar.php'); 
include('./constant/connect.php'); 

// Handle restock securely
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['restock_product_id'])) {
    $productId = intval($_POST['restock_product_id']);
    $addQuantity = intval($_POST['add_quantity']);

    if ($addQuantity > 0) {
        // Fetch current stock
        $stmt = $connect->prepare("SELECT quantity FROM product WHERE product_id = ?");
        $stmt->bind_param("i", $productId);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $newQuantity = (int)$row['quantity'] + $addQuantity;

            // Update stock safely
            $updateStmt = $connect->prepare("UPDATE product SET quantity = ? WHERE product_id = ?");
            $updateStmt->bind_param("ii", $newQuantity, $productId);
            if ($updateStmt->execute()) {
                $successMsg = "Product restocked successfully!";
            } else {
                $errorMsg = "Error updating stock: " . $connect->error;
            }
            $updateStmt->close();
        } else {
            $errorMsg = "Product not found.";
        }
        $stmt->close();
    } else {
        $errorMsg = "Quantity must be greater than 0.";
    }
}

// Get low stock products
$lowStockQuery = "
    SELECT p.*, b.brand_name, c.categories_name 
    FROM product p 
    LEFT JOIN brands b ON p.brand_id = b.brand_id 
    LEFT JOIN categories c ON p.categories_id = c.categories_id 
    WHERE p.status = 1 
      AND p.active = 1 
      AND CAST(p.quantity AS UNSIGNED) <= 10 
    ORDER BY CAST(p.quantity AS UNSIGNED) ASC";
$lowStockResult = $connect->query($lowStockQuery);
$lowStockProducts = [];
if ($lowStockResult && $lowStockResult->num_rows > 0) {
    while($row = $lowStockResult->fetch_assoc()) {
        $lowStockProducts[] = $row;
    }
}
?>

<div class="page-wrapper" style="background-color: #f7f9fc; min-height: 100vh; padding: 20px;">

    <div class="row page-titles mb-4">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary" style="font-weight: 600; color: #4a6cf7;">Low Stock Alerts</h3>
        </div>
    </div>

    <div class="container-fluid">
        <?php if(isset($successMsg)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($successMsg); ?></div>
        <?php elseif(isset($errorMsg)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($errorMsg); ?></div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-12">
                <div class="card" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h4 class="card-title">Low Stock Medicines</h4>
                            <span class="badge badge-danger"><?php echo count($lowStockProducts); ?> Items</span>
                        </div>

                        <?php if(count($lowStockProducts) > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-hover" id="lowStockTable">
                                    <thead style="background: linear-gradient(45deg, #ffa502, #ff6348); color: white;">
                                        <tr>
                                            <th>Medicine Name</th>
                                            <th>Brand</th>
                                            <th>Category</th>
                                            <th>Current Stock</th>
                                            <th>Unit</th>
                                            <th>Batch No</th>
                                            <th>Expiry Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($lowStockProducts as $product): ?>
                                            <tr style="<?php echo $product['quantity'] <= 5 ? 'background-color: #fff5f5;' : 'background-color: #fffbf0;' ?>">
                                                <td><?php echo htmlspecialchars($product['product_name']); ?></td>
                                                <td><?php echo htmlspecialchars($product['brand_name']); ?></td>
                                                <td><?php echo htmlspecialchars($product['categories_name']); ?></td>
                                                <td>
                                                    <span class="badge <?php echo $product['quantity'] <= 5 ? 'badge-danger' : 'badge-warning'; ?>">
                                                        <?php echo htmlspecialchars($product['quantity']); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo htmlspecialchars($product['unit']); ?></td>
                                                <td><?php echo htmlspecialchars($product['bno']); ?></td>
                                                <td><?php echo date('d M Y', strtotime($product['expdate'])); ?></td>
                                                <td>
                                                    <!-- Button to open modal -->
                                                    <button class="btn btn-sm btn-primary soft-btn" data-toggle="modal" data-target="#restockModal<?php echo $product['product_id']; ?>">
                                                       <i class="fas fa-plus-circle"></i> Restock
                                                    </button>

                                                    <!-- Modal -->
                                                  <!-- Modal -->
<div class="modal fade" id="restockModal<?php echo $product['product_id']; ?>" tabindex="-1" role="dialog" onclick="closeModal(event)">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Restock <?php echo htmlspecialchars($product['product_name']); ?></h5>
                <button type="button" class="close" data-dismiss="modal" onclick="closeModal(event)">&times;</button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="restock_product_id" value="<?php echo $product['product_id']; ?>">
                    <div class="form-group">
                        <label>Add Quantity</label>
                        <input type="number" name="add_quantity" class="form-control" required min="1">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Update Stock</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="closeModal(event)">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                                <h4 class="text-muted">No Low Stock Alerts</h4>
                                <p class="text-muted">All medicines are sufficiently stocked.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    body {
        font-family: 'Arial', sans-serif;
        background-color: #f7f9fc;
        color: #333;
    }

    .page-wrapper {
        padding: 20px;
    }

    .text-primary {
        color: #4a6cf7 !important;
    }

    .card {
        border-radius: 15px;
        box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;
    }

    .alert {
        border-radius: 5px;
        margin-bottom: 20px;
    }

    .table thead th {
        background: linear-gradient(45deg, #ffa502, #ff6348);
        color: white;
    }

    .table tbody tr {
        transition: background-color 0.3s;
    }

    .table tbody tr:hover {
        background-color: #f1f1f1;
    }

    .badge-danger {
        background-color: #dc3545;
    }

    .badge-warning {
        background-color: #ffc107;
    }

    .modal-header {
        background-color: #4a6cf7;
        color: white;
    }

    .modal-footer .btn {
        border-radius: 5px;
    }

    .soft-btn {
        border-radius: 5px;
    }
</style>


<script>
$(document).ready(function () {
    // Close modals after submit
    $('form').on('submit', function () {
        setTimeout(function () {
            $('.modal').modal('hide'); // close all modals
        }, 500);
    });

    // DataTable initialization
    $('#lowStockTable').DataTable({
        "pageLength": 10,
        "order": [[3, 'asc']],
        "language": {
            "search": "Search medicines:",
            "paginate": {
                "previous": "←",
                "next": "→"
            }
        }
    });
});
</script>

<?php include('./constant/layout/footer.php'); ?>
