<?php
require_once 'core.php';

$valid['success'] = array('success' => false, 'messages' => array());

if ($_POST) {	

    // ✅ Optional fields – set default empty or NULL
    $supplierId   = !empty($_POST['supplierName']) ? $_POST['supplierName'] : NULL;
    $chamber      = !empty($_POST['chamber']) ? $_POST['chamber'] : NULL;
    $hsnCode      = !empty($_POST['hsnCode']) ? $_POST['hsnCode'] : NULL;
    $brandName    = !empty($_POST['brandName']) ? $_POST['brandName'] : NULL;

    // ✅ Mandatory fields
    $productName  = $_POST['productName'];
    $quantity     = $_POST['quantity'];
    $rate         = !empty($_POST['rate']) ? $_POST['rate'] : 0;
    $categoryName = $_POST['categoryName'];
    $mrp          = !empty($_POST['mrp']) ? $_POST['mrp'] : 0;
    $bno          = $_POST['bno'];
    $expdate      = $_POST['expdate'];
    $productStatus= $_POST['productStatus'];

    // ✅ New fields with defaults
    $purchaseRate = !empty($_POST['purchaseRate']) ? $_POST['purchaseRate'] : 0;
    $cgst         = !empty($_POST['cgst']) ? $_POST['cgst'] : 0;
    $sgst         = !empty($_POST['sgst']) ? $_POST['sgst'] : 0;
    $unit         = $_POST['unit']; // Unit of measurement

    // ✅ Handle optional image
    $image = "";
    if (!empty($_FILES['Medicine']['name'])) {
        $image  = $_FILES['Medicine']['name'];
        $target = "../assets/myimages/" . basename($image);

        if (!move_uploaded_file($_FILES['Medicine']['tmp_name'], $target)) {
            $valid['success'] = false;
            $valid['messages'] = "Failed to upload image";
            echo json_encode($valid);
            exit();
        }
    }

    $orderDate = date('Y-m-d');

    // ✅ Build SQL safely (NULL for optional fields)
    $sql = sprintf(
        "INSERT INTO product (
            product_name, supplier_id, product_image, brand_id, categories_id, 
            quantity, unit, rate, purchase_rate, mrp, bno, expdate, added_date, 
            active, status, hsn_code, cgst, sgst, chamber
        ) VALUES (
            '%s', %s, %s, %s, '%s', 
            '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', 
            '%s', 1, %s, '%s', '%s', %s
        )",
        $connect->real_escape_string($productName),
        $supplierId !== NULL ? "'" . $connect->real_escape_string($supplierId) . "'" : "NULL",
        !empty($image) ? "'" . $connect->real_escape_string($image) . "'" : "NULL",
        $brandName !== NULL ? "'" . $connect->real_escape_string($brandName) . "'" : "NULL",
        $connect->real_escape_string($categoryName),
        $connect->real_escape_string($quantity),
        $connect->real_escape_string($unit),
        $connect->real_escape_string($rate),
        $connect->real_escape_string($purchaseRate),
        $connect->real_escape_string($mrp),
        $connect->real_escape_string($bno),
        $connect->real_escape_string($expdate),
        $orderDate,
        $connect->real_escape_string($productStatus),
        $hsnCode !== NULL ? "'" . $connect->real_escape_string($hsnCode) . "'" : "NULL",
        $connect->real_escape_string($cgst),
        $connect->real_escape_string($sgst),
        $chamber !== NULL ? "'" . $connect->real_escape_string($chamber) . "'" : "NULL"
    );

    if ($connect->query($sql) === TRUE) {
        $valid['success'] = true;
        $valid['messages'] = "Successfully Added";
        header('location:../product.php');	
    } else {
        $valid['success'] = false;
        $valid['messages'] = "Error while adding product: " . $connect->error;
    }

    $connect->close();
    echo json_encode($valid);
}
?>