<?php
// php_action/delete_wholesale_order.php
require_once '../constant/connect.php';

$response = array('success' => false, 'message' => '');

if ($_POST) {
    $order_id = intval($_POST['order_id']);
    
    if (!$order_id) {
        $response['message'] = 'Invalid order ID!';
        echo json_encode($response);
        exit();
    }

    // Start transaction
    $connect->autocommit(FALSE);
    
    try {
        // First, get order items to restore stock
        $itemsSql = "SELECT product_id, quantity FROM wholesale_order_items WHERE wholesale_order_id = ?";
        $itemsStmt = $connect->prepare($itemsSql);
        $itemsStmt->bind_param("i", $order_id);
        $itemsStmt->execute();
        $itemsResult = $itemsStmt->get_result();
        
        // Restore stock quantities
        while ($item = $itemsResult->fetch_assoc()) {
            $restoreSql = "UPDATE product SET quantity = quantity + ? WHERE product_id = ?";
            $restoreStmt = $connect->prepare($restoreSql);
            $restoreStmt->bind_param("ii", $item['quantity'], $item['product_id']);
            if (!$restoreStmt->execute()) {
                throw new Exception("Error restoring stock!");
            }
        }
        
        // Soft delete the order (set delete_status = 1)
        $deleteSql = "UPDATE wholesale_orders SET delete_status = 1, updated_at = NOW() WHERE id = ?";
        $deleteStmt = $connect->prepare($deleteSql);
        $deleteStmt->bind_param("i", $order_id);
        
        if (!$deleteStmt->execute()) {
            throw new Exception("Error deleting order!");
        }
        
        $connect->commit();
        $response['success'] = true;
        $response['message'] = "Invoice deleted successfully!";
        
    } catch (Exception $e) {
        $connect->rollback();
        $response['message'] = $e->getMessage();
    }
    
    $connect->autocommit(TRUE);
} else {
    $response['message'] = "No data received!";
}

echo json_encode($response);
?>