<?php
require_once 'core.php';

$valid['success'] = array('success' => false, 'messages' => array());
$productId = (int)$_GET['id'];

if ($_POST) {

    // ✅ Optional supplier & chamber
    $supplier_id  = !empty($_POST['editSupplierName']) ? $_POST['editSupplierName'] : NULL;
    $chamber      = !empty($_POST['chamber']) ? $_POST['chamber'] : NULL;

    // ✅ Mandatory fields with defaults
    $productName  = $_POST['editProductName']; 
    $quantity     = $_POST['editQuantity'];
    $rate         = !empty($_POST['editRate']) ? $_POST['editRate'] : 0;
    $brandName    = $_POST['editBrandName'];
    $categoryName = $_POST['editCategoryName'];
    $productStatus= $_POST['editProductStatus'];
    $mrp          = !empty($_POST['mrp']) ? $_POST['mrp'] : 0;
    $bno          = $_POST['bno'];
    $expdate      = $_POST['expdate'];

    // ✅ New fields with defaults
    $hsnCode      = $_POST['hsnCode'];
    $purchaseRate = !empty($_POST['purchaseRate']) ? $_POST['purchaseRate'] : 0;
    $cgst         = !empty($_POST['cgst']) ? $_POST['cgst'] : 0;
    $sgst         = !empty($_POST['sgst']) ? $_POST['sgst'] : 0;
    $unit         = $_POST['unit'];

    // ✅ Optional image upload
    $imageSql = "";
    if (!empty($_FILES['Medicine']['name'])) {
        $image  = $_FILES['Medicine']['name'];
        $target = "../assets/myimages/" . basename($image);

        if (move_uploaded_file($_FILES['Medicine']['tmp_name'], $target)) {
            // include in update only if uploaded
            $imageSql = ", product_image = '" . $connect->real_escape_string($image) . "'";
        } else {
            $valid['success'] = false;
            $valid['messages'] = "Failed to upload new image";
            echo json_encode($valid);
            exit();
        }
    }

    // ✅ Build SQL safely
    $sql = sprintf(
        "UPDATE product SET 
            product_name = '%s', 
            supplier_id = %s, 
            brand_id = '%s', 
            categories_id = '%s', 
            quantity = '%s', 
            unit = '%s',
            rate = '%s', 
            purchase_rate = '%s',
            mrp = '%s', 
            bno = '%s', 
            expdate = '%s', 
            hsn_code = '%s',
            cgst = '%s',
            sgst = '%s',
            chamber = %s,
            active = '%s', 
            status = 1
            %s
        WHERE product_id = %d",
        $connect->real_escape_string($productName),
        $supplier_id !== NULL ? "'" . $connect->real_escape_string($supplier_id) . "'" : "NULL",
        $connect->real_escape_string($brandName),
        $connect->real_escape_string($categoryName),
        $connect->real_escape_string($quantity),
        $connect->real_escape_string($unit),
        $connect->real_escape_string($rate),
        $connect->real_escape_string($purchaseRate),
        $connect->real_escape_string($mrp),
        $connect->real_escape_string($bno),
        $connect->real_escape_string($expdate),
        $connect->real_escape_string($hsnCode),
        $connect->real_escape_string($cgst),
        $connect->real_escape_string($sgst),
        $chamber !== NULL ? "'" . $connect->real_escape_string($chamber) . "'" : "NULL",
        $connect->real_escape_string($productStatus),
        $imageSql, // only adds product_image if uploaded
        $productId
    );

    if ($connect->query($sql) === TRUE) {
        $valid['success'] = true;
        $valid['messages'] = "Successfully Updated";	
        header('location:../product.php');
    } else {
        $valid['success'] = false;
        $valid['messages'] = "Error while updating product info: " . $connect->error;
    }

} // /$_POST

$connect->close();
echo json_encode($valid);
?>
