<?php
include('../connect.php');

if(isset($_POST['order_id'])) {
    $order_id = $_POST['order_id'];
    
    $order_sql = "SELECT * FROM orders WHERE id = $order_id";
    $order_result = $connect->query($order_sql);
    $order = $order_result->fetch_assoc();
    
    $items_sql = "SELECT oi.*, p.product_name 
                  FROM order_item oi 
                  LEFT JOIN product p ON oi.productName = p.product_id 
                  WHERE oi.order_id = $order_id";
    $items_result = $connect->query($items_sql);
    
    // Create data array
    $data = [];
    
    // Add header
    $data[] = ['Invoice No', $order['uno']];
    $data[] = ['Invoice Date', $order['orderDate']];
    $data[] = ['Client Name', $order['clientName']];
    $data[] = ['Client Contact', $order['clientContact']];
    $data[] = [''];
    
    // Add items header
    $data[] = ['Product', 'Quantity', 'Rate', 'SGST %', 'CGST %', 'Discount %', 'Total'];
    
    // Add items
    while($item = $items_result->fetch_assoc()) {
        $data[] = [
            $item['product_name'],
            $item['quantity'],
            $item['rate'],
            $item['sgst_percentage'],
            $item['cgst_percentage'],
            $item['discount_percentage'],
            $item['total']
        ];
    }
    
    $data[] = [''];
    
    // Add totals
    $data[] = ['Sub Total', '', '', '', '', '', $order['subTotal']];
    $data[] = ['SGST Total', '', '', '', '', '', $order['sgst_total']];
    $data[] = ['CGST Total', '', '', '', '', '', $order['cgst_total']];
    $data[] = ['Discount %', '', '', '', '', '', $order['discount_percentage'] . '%'];
    $data[] = ['Grand Total', '', '', '', '', '', $order['grandTotalValue']];
    $data[] = ['Paid Amount', '', '', '', '', '', $order['paid']];
    $data[] = ['Due Amount', '', '', '', '', '', $order['dueValue']];
    $data[] = ['Payment Status', '', '', '', '', '', getPaymentStatus($order['paymentStatus'])];
    $data[] = ['Payment Type', '', '', '', '', '', getPaymentType($order['paymentType'])];
    
    // Create PHPExcel object (using PHPExcel library)
    require_once('../PHPExcel/PHPExcel.php');
    
    $objPHPExcel = new PHPExcel();
    $objPHPExcel->getActiveSheet()->fromArray($data, NULL, 'A1');
    
    // Set column widths
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
    
    // Set headers
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="Invoice_' . $order['uno'] . '.xlsx"');
    header('Cache-Control: max-age=0');
    
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $objWriter->save('php://output');
    exit();
}

function getPaymentStatus($status) {
    $statuses = [1 => 'Full Payment', 2 => 'Advance Payment', 3 => 'No Payment'];
    return $statuses[$status] ?? 'Unknown';
}

function getPaymentType($type) {
    $types = [1 => 'Cheque', 2 => 'Cash', 3 => 'Credit Card', 4 => 'Phone Pe', 5 => 'Google Pay', 6 => 'Amazon Pay'];
    return $types[$type] ?? 'Unknown';
}
?>