<?php
include('../connect.php');

if(isset($_POST['order_id'])) {
    $order_id = $_POST['order_id'];
    
    $order_sql = "SELECT * FROM orders WHERE id = $order_id";
    $order_result = $connect->query($order_sql);
    $order = $order_result->fetch_assoc();
    
    $items_sql = "SELECT oi.*, p.product_name 
                  FROM order_item oi 
                  LEFT JOIN product p ON oi.productName = p.product_id 
                  WHERE oi.order_id = $order_id";
    $items_result = $connect->query($items_sql);
    
    // Include TCPDF library
    require_once('../tcpdf/tcpdf.php');
    
    // Create new PDF document
    $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    
    // Set document information
    $pdf->SetCreator('Pharmacy Management System');
    $pdf->SetAuthor('Pharmacy Management System');
    $pdf->SetTitle('Invoice ' . $order['uno']);
    $pdf->SetSubject('Invoice');
    
    // Add a page
    $pdf->AddPage();
    
    // Set content
    $html = '
    <h1 style="text-align:center;color:#4a6cf7;">TAX INVOICE</h1>
    <h2 style="text-align:center;">' . $order['uno'] . '</h2>
    
    <table border="0" cellpadding="5">
        <tr>
            <td width="50%">
                <strong>Client:</strong> ' . $order['clientName'] . '<br>
                <strong>Contact:</strong> ' . $order['clientContact'] . '<br>
                <strong>Date:</strong> ' . date('d M Y', strtotime($order['orderDate'])) . '
            </td>
            <td width="50%" style="text-align:right;">
                <strong>Grand Total:</strong> ₹' . number_format($order['grandTotalValue'], 2) . '<br>
                <strong>Paid:</strong> ₹' . number_format($order['paid'], 2) . '<br>
                <strong>Due:</strong> ₹' . number_format($order['dueValue'], 2) . '
            </td>
        </tr>
    </table>
    
    <br>
    
    <table border="1" cellpadding="5">
        <thead>
            <tr style="background-color:#f0f4f8;">
                <th>Product</th>
                <th>Qty</th>
                <th>Rate</th>
                <th>SGST</th>
                <th>CGST</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>';
        
        while($item = $items_result->fetch_assoc()) {
            $html .= '<tr>
                <td>' . $item['product_name'] . '</td>
                <td>' . $item['quantity'] . '</td>
                <td>₹' . number_format($item['rate'], 2) . '</td>
                <td>' . $item['sgst_percentage'] . '%</td>
                <td>' . $item['cgst_percentage'] . '%</td>
                <td>₹' . number_format($item['total'], 2) . '</td>
            </tr>';
        }
        
        $html .= '</tbody>
    </table>
    
    <br>
    
    <table border="0" cellpadding="5">
        <tr>
            <td width="50%">
                <strong>Payment Status:</strong> ' . getPaymentStatus($order['paymentStatus']) . '<br>
                <strong>Payment Type:</strong> ' . getPaymentType($order['paymentType']) . '
            </td>
            <td width="50%" style="text-align:right;">
                <strong>Sub Total:</strong> ₹' . number_format($order['subTotal'], 2) . '<br>
                <strong>SGST:</strong> ₹' . number_format($order['sgst_total'], 2) . '<br>
                <strong>CGST:</strong> ₹' . number_format($order['cgst_total'], 2) . '<br>
                <strong>Discount:</strong> ' . $order['discount_percentage'] . '%<br>
                <h3>Grand Total: ₹' . number_format($order['grandTotalValue'], 2) . '</h3>
            </td>
        </tr>
    </table>
    
    <br><br>
    
    <div style="text-align:center;">
        <p>Thank you for your business!</p>
        <p>Generated on: ' . date('d M Y H:i:s') . '</p>
    </div>';
    
    // Output HTML content
    $pdf->writeHTML($html, true, false, true, false, '');
    
    // Close and output PDF
    $pdf->Output('Invoice_' . $order['uno'] . '.pdf', 'D');
    exit();
}

function getPaymentStatus($status) {
    $statuses = [1 => 'Full Payment', 2 => 'Advance Payment', 3 => 'No Payment'];
    return $statuses[$status] ?? 'Unknown';
}

function getPaymentType($type) {
    $types = [1 => 'Cheque', 2 => 'Cash', 3 => 'Credit Card', 4 => 'Phone Pe', 5 => 'Google Pay', 6 => 'Amazon Pay'];
    return $types[$type] ?? 'Unknown';
}
?>