<?php
header('Content-Type: text/html');
require_once '../constant/connect.php';

$order_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($order_id <= 0) {
    die('Invalid order ID');
}

try {
    $orderQuery = "SELECT orderDate, clientName, clientContact, gstn, subTotal, totalAmount, grandTotalValue, paid, dueValue, paymentType, paymentStatus, type 
                   FROM orders WHERE id = ?";
    $orderStmt = $connect->prepare($orderQuery);
    $orderStmt->bind_param("i", $order_id);
    $orderStmt->execute();
    $orderResult = $orderStmt->get_result();
    $order = $orderResult->fetch_assoc();

    $itemQuery = "SELECT productName, quantity, rate, total, discount_percentage 
                  FROM order_item WHERE order_id = ?";
    $itemStmt = $connect->prepare($itemQuery);
    $itemStmt->bind_param("i", $order_id);
    $itemStmt->execute();
    $itemResult = $itemStmt->get_result();
    $items = $itemResult->fetch_all(MYSQLI_ASSOC);
} catch (Exception $e) {
    die('Error fetching data: ' . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - INV-<?php echo sprintf('%05d', $order_id); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .invoice {
            max-width: 800px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border: 1px solid #ddd;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #007bff;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            color: #007bff;
            font-size: 24px;
        }
        .company-details, .client-details {
            margin: 10px 0;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .table th {
            background-color: #f8f9fa;
            color: #333;
        }
        .totals {
            text-align: right;
            margin-top: 20px;
        }
        .totals p {
            margin: 5px 0;
            font-size: 16px;
        }
        .totals .grand-total {
            font-weight: bold;
            color: #dc3545;
        }
        @media print {
            body {
                background-color: #fff;
            }
            .invoice {
                box-shadow: none;
                border: none;
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="invoice">
        <div class="header">
            <h1>Pharmacy Invoice</h1>
            <p>Invoice No: INV-<?php echo sprintf('%05d', $order_id); ?> | Date: <?php echo htmlspecialchars($order['orderDate']); ?></p>
        </div>
        <div class="company-details">
            <p><strong>Pharmacy Name</strong><br>
            Contact: 9123949494<br>
            Address: Your Address Here</p>
        </div>
        <div class="client-details">
            <p><strong>Client: <?php echo htmlspecialchars($order['clientName']); ?></strong><br>
            Contact: <?php echo htmlspecialchars($order['clientContact']); ?></p>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Quantity</th>
                    <th>Rate</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($items as $item): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($item['productName']); ?></td>
                        <td><?php echo htmlspecialchars($item['quantity']); ?></td>
                        <td><?php echo number_format($item['rate'], 2); ?></td>
                        <td><?php echo number_format($item['total'], 2); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div class="totals">
            <p>Sub Total: <?php echo number_format($order['subTotal'], 2); ?></p>
            <p>Total Amount: <?php echo number_format($order['totalAmount'], 2); ?></p>
            <p class="grand-total">Grand Total: <?php echo number_format($order['grandTotalValue'], 2); ?></p>
            <p>Paid: <?php echo number_format($order['paid'], 2); ?></p>
            <p>Due: <?php echo number_format($order['dueValue'], 2); ?></p>
        </div>
        <div style="text-align: center; margin-top: 20px;">
            <p>Thank you for your business!</p>
        </div>
    </div>
    <script>
        window.print();
    </script>
</body>
</html>
<?php
$connect->close();
?>