<?php
// php_action/update_wholesale_order.php
require_once '../constant/connect.php';

$response = array('success' => false, 'message' => '');

if ($_POST) {
    $order_id = intval($_POST['order_id']);
    $edit_reason = trim($_POST['edit_reason']);
    
    if (!$order_id || empty($edit_reason)) {
        $response['message'] = 'Invalid order ID or missing edit reason!';
        echo json_encode($response);
        exit();
    }

    // Get form data
    $invoice_date = $_POST['invoice_date'];
    $vendor_name = trim($_POST['vendor_name']);
    $vendor_contact = trim($_POST['vendor_contact']);
    $vendor_gstn = trim($_POST['vendor_gstn']);
    $sub_total = floatval($_POST['sub_total_value']);
    $total_amount = floatval($_POST['total_amount_value']);
    $discount_percentage = floatval($_POST['discount_percentage']);
    $grand_total = floatval($_POST['grand_total_value']);
    $paid_amount = floatval($_POST['paid_amount']);
    $due_amount = floatval($_POST['due_amount_value']);
    $payment_type = intval($_POST['payment_type']);
    $payment_status = intval($_POST['payment_status']);
    $sgst_total = floatval($_POST['sgst_total_value']);
    $cgst_total = floatval($_POST['cgst_total_value']);
    
    // Start transaction
    $connect->autocommit(FALSE);
    
    try {
        // First, get original quantities to restore stock
        $originalItemsSql = "SELECT product_id, quantity FROM wholesale_order_items WHERE wholesale_order_id = ?";
        $originalStmt = $connect->prepare($originalItemsSql);
        $originalStmt->bind_param("i", $order_id);
        $originalStmt->execute();
        $originalResult = $originalStmt->get_result();
        $original_items = $originalResult->fetch_all(MYSQLI_ASSOC);
        
        // Restore original stock quantities
        foreach ($original_items as $original_item) {
            $restoreSql = "UPDATE product SET quantity = quantity + ? WHERE product_id = ?";
            $restoreStmt = $connect->prepare($restoreSql);
            $restoreStmt->bind_param("ii", $original_item['quantity'], $original_item['product_id']);
            if (!$restoreStmt->execute()) {
                throw new Exception("Error restoring stock for product ID: " . $original_item['product_id']);
            }
        }
        
        // Delete existing order items
        $deleteItemsSql = "DELETE FROM wholesale_order_items WHERE wholesale_order_id = ?";
        $deleteStmt = $connect->prepare($deleteItemsSql);
        $deleteStmt->bind_param("i", $order_id);
        if (!$deleteStmt->execute()) {
            throw new Exception("Error deleting old order items!");
        }
        
        // Update wholesale order
        $updateOrderSql = "UPDATE wholesale_orders SET 
                          invoice_date = ?, vendor_name = ?, vendor_contact = ?, vendor_gstn = ?,
                          sub_total = ?, total_amount = ?, discount_percentage = ?, grand_total = ?,
                          paid_amount = ?, due_amount = ?, payment_type = ?, payment_status = ?,
                          sgst_total = ?, cgst_total = ?, is_edited = 1, edit_reason = ?, updated_at = NOW()
                          WHERE id = ?";
        
        $updateStmt = $connect->prepare($updateOrderSql);
        $updateStmt->bind_param("ssssddddddiiddsi", 
            $invoice_date, $vendor_name, $vendor_contact, $vendor_gstn,
            $sub_total, $total_amount, $discount_percentage, $grand_total,
            $paid_amount, $due_amount, $payment_type, $payment_status,
            $sgst_total, $cgst_total, $edit_reason, $order_id
        );
        
        if (!$updateStmt->execute()) {
            throw new Exception("Error updating order: " . $updateStmt->error);
        }
        
        // Insert new order items and update stock
        if (isset($_POST['productName']) && is_array($_POST['productName'])) {
            $itemSql = "INSERT INTO wholesale_order_items (
                wholesale_order_id, product_id, product_name, quantity, unit_price,
                total_price, sgst_percentage, cgst_percentage, discount_percentage
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            
            $itemStmt = $connect->prepare($itemSql);
            
            for ($i = 0; $i < count($_POST['productName']); $i++) {
                $product_id = intval($_POST['productName'][$i]);
                $quantity = intval($_POST['quantity'][$i]);
                $unit_price = floatval($_POST['unit_price_value'][$i]);
                $total_price = floatval($_POST['total_value'][$i]);
                $sgst_percentage = floatval($_POST['sgst_percentage'][$i]);
                $cgst_percentage = floatval($_POST['cgst_percentage'][$i]);
                $discount_percentage_item = floatval($_POST['discount_percentage_item'][$i]);
                
                // Get product name
                $productNameSql = "SELECT product_name FROM product WHERE product_id = ?";
                $productNameStmt = $connect->prepare($productNameSql);
                $productNameStmt->bind_param("i", $product_id);
                $productNameStmt->execute();
                $productNameResult = $productNameStmt->get_result();
                $productNameRow = $productNameResult->fetch_assoc();
                $product_name = $productNameRow['product_name'];
                
                $itemStmt->bind_param("iisiddddd", 
                    $order_id, $product_id, $product_name, $quantity, $unit_price,
                    $total_price, $sgst_percentage, $cgst_percentage, $discount_percentage_item
                );
                
                if (!$itemStmt->execute()) {
                    throw new Exception("Error adding product item!");
                }
                
                // Update product quantity (reduce stock)
                $updateQuantitySql = "UPDATE product SET quantity = quantity - ? WHERE product_id = ?";
                $updateQtyStmt = $connect->prepare($updateQuantitySql);
                $updateQtyStmt->bind_param("ii", $quantity, $product_id);
                
                if (!$updateQtyStmt->execute()) {
                    throw new Exception("Error updating product quantity!");
                }
            }
        }
        
        // Commit transaction
        $connect->commit();
        $response['success'] = true;
        $response['message'] = "Wholesale invoice updated successfully!";
        
    } catch (Exception $e) {
        // Rollback transaction on error
        $connect->rollback();
        $response['success'] = false;
        $response['message'] = $e->getMessage();
    }
    
    $connect->autocommit(TRUE);
} else {
    $response['message'] = "No data received!";
}

echo json_encode($response);
?>