
<?php
error_reporting(E_ALL);
ini_set('display_errors', 1); // Enable error display for debugging
include('./constant/connect.php');

$response = array('success' => false, 'table' => '', 'pagination' => '', 'error' => '');

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method.');
    }

    $search = isset($_POST['search']) ? trim($_POST['search']) : '';
    $page = isset($_POST['page']) && is_numeric($_POST['page']) ? (int)$_POST['page'] : 1;
    $limit = 10;
    $start = ($page - 1) * $limit;

    // Build the WHERE clause for search
    $whereClause = "WHERE p.status = 1 AND p.active = 1";
    if (!empty($search)) {
        $search = $connect->real_escape_string($search);
        $whereClause .= " AND (
            p.product_name LIKE '%$search%' OR
            p.hsn_code LIKE '%$search%' OR
            b.brand_name LIKE '%$search%' OR
            c.categories_name LIKE '%$search%' OR
            s.supplier_name LIKE '%$search%'
        )";
    }

    // Count total rows for pagination
    $countSql = "
        SELECT COUNT(*) AS total
        FROM product p
        LEFT JOIN brands b ON p.brand_id = b.brand_id
        LEFT JOIN categories c ON p.categories_id = c.categories_id
        LEFT JOIN suppliers s ON p.supplier_id = s.supplier_id
        $whereClause
    ";
    $countResult = $connect->query($countSql);
    if (!$countResult) {
        throw new Exception('Count query failed: ' . $connect->error);
    }
    $totalRows = $countResult->fetch_assoc()['total'];
    $totalPages = ceil($totalRows / $limit);

    // Main query with search and pagination
    $sql = "
        SELECT 
            p.*,
            COALESCE(b.brand_name, 'N/A') AS brand_name,
            COALESCE(c.categories_name, 'N/A') AS categories_name,
            COALESCE(s.supplier_name, 'N/A') AS supplier_name,
            COALESCE(ch.column_number, 'N/A') AS column_number,
            COALESCE(ch.row_no, 'N/A') AS row_no
        FROM product p
        LEFT JOIN brands b ON p.brand_id = b.brand_id
        LEFT JOIN categories c ON p.categories_id = c.categories_id
        LEFT JOIN suppliers s ON p.supplier_id = s.supplier_id
        LEFT JOIN chambers ch ON p.chamber = ch.id
        $whereClause
        ORDER BY p.product_name
        LIMIT $start, $limit
    ";
    $result = $connect->query($sql);
    if (!$result) {
        throw new Exception('Main query failed: ' . $connect->error);
    }

    // Build table HTML
    $table = '';
    if ($result && $result->num_rows > 0) {
        $counter = $start + 1;
        while ($row = $result->fetch_assoc()) {
            $expiry_class = '';
            $today = new DateTime();
            $expiry_date = !empty($row['expdate']) ? new DateTime($row['expdate']) : null;
            if ($expiry_date && $expiry_date < $today) {
                $expiry_class = 'text-danger';
            } elseif ($expiry_date && $expiry_date->diff($today)->days < 30) {
                $expiry_class = 'text-warning';
            }

            $table .= '
            <tr>
                <td class="text-center">' . $counter++ . '</td>
                <td>
                    <div class="d-flex align-items-center">
                        <div class="mr-3">';
            if (!empty($row['product_image']) && file_exists('assets/myimages/' . $row['product_image'])) {
                $table .= '<img src="assets/myimages/' . htmlspecialchars($row['product_image']) . '" 
                                style="width:60px; height:60px; border-radius:8px; object-fit:cover;" 
                                alt="' . htmlspecialchars($row['product_name']) . '">';
            } else {
                $table .= '<div style="width:60px; height:60px; border-radius:8px; background:#f0f4f8; display:flex; align-items:center; justify-content:center;">
                               <i class="fa fa-pills" style="font-size:20px; color:#4a6cf7;"></i>
                           </div>';
            }
            $table .= '</div>
                        <div>
                            <strong class="d-block">' . htmlspecialchars($row['product_name']) . '</strong>
                            <small class="text-muted">';
            if (!empty($row['bno'])) {
                $table .= 'Batch: ' . htmlspecialchars($row['bno']);
            }
            $table .= '</small>
                        </div>
                    </div>
                </td>
                <td>
                    <div class="text-center">';
            if (!empty($row['hsn_code'])) {
                $table .= '<span class="badge badge-light">' . htmlspecialchars($row['hsn_code']) . '</span>';
            } else {
                $table .= '<span class="text-muted">N/A</span>';
            }
            $table .= '</div>
                </td>
                <td>
                    <div class="manufacturer-info">
                        <strong>' . htmlspecialchars($row['brand_name']) . '</strong>';
            if (!empty($row['supplier_name']) && $row['supplier_name'] != 'N/A') {
                $table .= '<br><small class="text-muted">Supplier: ' . htmlspecialchars($row['supplier_name']) . '</small>';
            }
            $table .= '</div>
                </td>
                <td>
                    <div class="category-info">
                        <span class="badge badge-info">' . htmlspecialchars($row['categories_name']) . '</span>';
            if (!empty($row['row_no']) && $row['row_no'] != 'N/A') {
                $table .= '<br><small class="text-muted">Storage: ' . htmlspecialchars($row['row_no'] . ' , ' . $row['column_number']) . '</small>';
            }
            $table .= '</div>
                </td>
                <td class="text-center">
                    <span class="badge soft-badge ' . ($row['active'] == 1 ? 'badge-success' : 'badge-secondary') . '">
                        ' . ($row['active'] == 1 ? 'Available' : 'Not Available') . '
                    </span>
                    <div class="stock-info mt-1">
                        <small class="' . ($row['quantity'] < 10 ? 'text-danger' : 'text-muted') . '">
                            Stock: ' . htmlspecialchars($row['quantity']) . ' ' . (!empty($row['unit']) ? htmlspecialchars($row['unit']) : 'Pcs') . '
                        </small>
                    </div>
                </td>
                <td>
                    <div class="btn-group-vertical">
                        <button class="btn btn-sm btn-warning mb-1" onclick="editProduct(' . $row['product_id'] . ')" title="Edit Medicine">
                            <i class="fas fa-edit"></i> Edit
                        </button>
                        <button class="btn btn-sm btn-danger" onclick="deleteProduct(' . $row['product_id'] . ')" title="Delete Medicine">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </div>
                </td>
            </tr>';
        }
        $response['success'] = true;
    } else {
        $table = '
        <tr>
            <td colspan="7" class="text-center py-4">
                <div class="text-muted">
                    <i class="fa fa-pills fa-3x mb-3"></i>
                    <h5>No Products Found</h5>
                    <p>No products match your search criteria.</p>
                </div>
            </td>
        </tr>';
    }
    $response['table'] = $table;

    // Build pagination HTML
    $pagination = '';
    if ($totalPages > 1) {
        $pagination .= '<ul class="pagination justify-content-center">';
        for ($i = 1; $i <= $totalPages; $i++) {
            $pagination .= '<li class="page-item ' . ($i == $page ? 'active' : '') . '">
                                <a class="page-link" href="?page=' . $i . '">' . $i . '</a>
                            </li>';
        }
        $pagination .= '</ul>';
    }
    $response['pagination'] = $pagination;

} catch (Exception $e) {
    $response['error'] = $e->getMessage();
}

header('Content-Type: application/json');
echo json_encode($response);
$connect->close();
?>