<?php 
// edit_order.php
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('./constant/connect.php');

// Check if order ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: Order.php');
    exit();
}

$order_id = $_GET['id'];

// Fetch order details
$order_sql = "SELECT * FROM orders WHERE id = $order_id";
$order_result = $connect->query($order_sql);

if ($order_result->num_rows == 0) {
    echo "<script>alert('Order not found!'); window.location.href='Order.php';</script>";
    exit();
}

$order_data = $order_result->fetch_assoc();

// Fetch order items
$items_sql = "SELECT oi.*, p.product_name, p.product_image 
              FROM order_item oi 
              LEFT JOIN product p ON oi.productName = p.product_id 
              WHERE oi.order_id = $order_id";
$items_result = $connect->query($items_sql);
$order_items = array();
while($row = $items_result->fetch_assoc()) {
    $order_items[] = $row;
}

// Fetch ledger entries for this order
$ledger_sql = "SELECT * FROM his_ledger WHERE order_id = $order_id ORDER BY created_at DESC";
$ledger_result = $connect->query($ledger_sql);
$ledger_entries = array();
while($row = $ledger_result->fetch_assoc()) {
    $ledger_entries[] = $row;
}
?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Edit Invoice #<?php echo $order_data['uno']; ?></h3> 
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item"><a href="Order.php">Invoice Management</a></li>
                <li class="breadcrumb-item active">Edit Invoice</li>
            </ol>
        </div>
    </div>
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <button type="button" class="btn btn-info soft-btn" onclick="printInvoice()">
                                    <i class="fa fa-print"></i> Print Invoice
                                </button>
                                <button type="button" class="btn btn-secondary soft-btn ml-2" onclick="viewLedger()">
                                    <i class="fa fa-book"></i> View Ledger
                                </button>
                            </div>
                            <div id="edit-brand-messages"></div>
                        </div>

                        <!-- Success message container -->
                        <div id="success-message" class="alert alert-success" style="display: none;">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <strong><i class="glyphicon glyphicon-ok-sign"></i></strong> Invoice updated successfully!
                        </div>

                        <div class="input-states">
                            <form class="form-horizontal" method="POST" id="editOrderForm" action="php_action/editOrder.php">
                                <input type="hidden" name="order_id" value="<?php echo $order_id; ?>">
                                
                                <!-- Invoice Header Section -->
                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">Invoice No</label>
                                            <input type="text" class="form-control soft-input" value="<?php echo $order_data['uno']; ?>" readonly/>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Invoice Date</label>
                                            <input type="date" class="form-control soft-input" value="<?php echo $order_data['orderDate']; ?>" id="orderDate" name="orderDate" required/>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">Client Name</label>
                                            <input type="text" class="form-control soft-input" id="clientName" name="clientName" value="<?php echo $order_data['clientName']; ?>" required/>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Client Contact No.</label>
                                            <input type="text" class="form-control soft-input" id="clientContact" name="clientContact" value="<?php echo $order_data['clientContact']; ?>" required/>
                                        </div>
                                    </div>
                                </div>

                                <!-- Products Table -->
                                <div class="table-responsive mb-4">                
                                    <table class="table" id="productTable">
                                        <thead>
                                            <tr>              
                                                <th>Medicine</th>
                                                <th>Rate</th>
                                                <th>Avail.</th>
                                                <th>Qty</th>
                                                <th>SGST %</th>
                                                <th>CGST %</th>
                                                <th>Disc. %</th>
                                                <th>Total</th>             
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $arrayNumber = 0;
                                            foreach ($order_items as $index => $item) { 
                                                $x = $index + 1;
                                                // Get product details
                                                $product_id = $item['productName'];
                                                $product_sql = "SELECT * FROM product WHERE product_id = '$product_id'";
                                                $product_result = $connect->query($product_sql);
                                                $product_data = $product_result->fetch_assoc();
                                                ?>
                                                <tr id="row<?php echo $x; ?>" class="<?php echo $arrayNumber; ?>">                
                                                    <td>
                                                        <select class="form-control select2-product" name="productName[]" id="productName<?php echo $x; ?>" onchange="getProductData(<?php echo $x; ?>)" >
                                                            <option value="">~~SELECT~~</option>
                                                            <?php
                                                            $productSql = "SELECT * FROM product WHERE active = 1 AND status = 1";
                                                            $productData = $connect->query($productSql);

                                                            while($row = $productData->fetch_array()) {                     
                                                                $selected = ($row['product_id'] == $item['productName']) ? 'selected' : '';
                                                                echo "<option value='".$row['product_id']."' $selected>".$row['product_name']."</option>";
                                                            }
                                                            ?>
                                                        </select>
                                                    </td>
                                                    <td>                 
                                                        <input type="text" name="rate[]" id="rate<?php echo $x; ?>" value="<?php echo $item['rate']; ?>" disabled class="form-control" />                  
                                                        <input type="hidden" name="rateValue[]" id="rateValue<?php echo $x; ?>" value="<?php echo $item['rate']; ?>" />                  
                                                    </td>
                                                    <td>
                                                        <p id="available_quantity<?php echo $x; ?>"><?php echo $product_data['quantity']; ?></p>
                                                    </td>
                                                    <td>
                                                        <input type="number" name="quantity[]" id="quantity<?php echo $x; ?>" value="<?php echo $item['quantity']; ?>" onkeyup="getTotal(<?php echo $x ?>)" class="form-control" min="1" />
                                                    </td>
                                                    <td>
                                                        <input type="number" name="sgst_percentage[]" id="sgst_percentage<?php echo $x; ?>" value="<?php echo $item['sgst_percentage']; ?>" onkeyup="getTotal(<?php echo $x ?>)" class="form-control" step="0.01" />
                                                    </td>
                                                    <td>
                                                        <input type="number" name="cgst_percentage[]" id="cgst_percentage<?php echo $x; ?>" value="<?php echo $item['cgst_percentage']; ?>" onkeyup="getTotal(<?php echo $x ?>)" class="form-control" step="0.01" />
                                                    </td>
                                                    <td>
                                                        <input type="number" name="discount_percentage_item[]" id="discount_percentage_item<?php echo $x; ?>" value="<?php echo $item['discount_percentage']; ?>" onkeyup="getTotal(<?php echo $x ?>)" class="form-control" step="0.01" />
                                                    </td>
                                                    <td>                 
                                                        <input type="text" name="total[]" id="total<?php echo $x; ?>" value="<?php echo $item['total']; ?>" disabled class="form-control" />                  
                                                        <input type="hidden" name="totalValue[]" id="totalValue<?php echo $x; ?>" value="<?php echo $item['total']; ?>" />                  
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-primary btn-sm soft-btn" onclick="addRow()"><i class="fa fa-plus"></i></button>
                                                        <?php if($x > 1): ?>
                                                        <button type="button" class="btn btn-danger btn-sm soft-btn" onclick="removeProductRow(<?php echo $x; ?>)"><i class="fa fa-trash"></i></button>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php
                                            $arrayNumber++;
                                            }
                                            ?>
                                        </tbody>          
                                    </table>
                                </div>

                                <!-- Totals Section -->
                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">Sub Amount</label>
                                            <input type="text" class="form-control soft-input" id="subTotal" value="<?php echo $order_data['subTotal']; ?>" disabled />
                                            <input type="hidden" id="subTotalValue" name="subTotalValue" value="<?php echo $order_data['subTotal']; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Total Amount</label>
                                            <input type="text" class="form-control soft-input" id="totalAmount" value="<?php echo $order_data['totalAmount']; ?>" disabled/>
                                            <input type="hidden" id="totalAmountValue" name="totalAmountValue" value="<?php echo $order_data['totalAmount']; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">Overall Discount %</label>
                                            <input type="number" class="form-control soft-input" id="discount_percentage" name="discount_percentage" value="<?php echo $order_data['discount_percentage']; ?>" onkeyup="discountFunc()" step="0.01" />
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Grand Total</label>
                                            <input type="text" class="form-control soft-input" id="grandTotal" value="<?php echo $order_data['grandTotalValue']; ?>" disabled />
                                            <input type="hidden" id="grandTotalValue" name="grandTotalValue" value="<?php echo $order_data['grandTotalValue']; ?>" />
                                        </div>
                                    </div>
                                </div>

                                <!-- Tax Section -->
                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">Total SGST</label>
                                            <input type="text" class="form-control soft-input" id="sgst_total" value="<?php echo $order_data['sgst_total']; ?>" readonly />
                                            <input type="hidden" id="sgst_totalValue" name="sgst_totalValue" value="<?php echo $order_data['sgst_total']; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">Total CGST</label>
                                            <input type="text" class="form-control soft-input" id="cgst_total" value="<?php echo $order_data['cgst_total']; ?>" readonly />
                                            <input type="hidden" id="cgst_totalValue" name="cgst_totalValue" value="<?php echo $order_data['cgst_total']; ?>" />
                                        </div>
                                    </div>
                                </div>

                                <!-- Payment Section -->
                                <div class="row mb-4">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label">Paid Amount</label>
                                            <input type="text" class="form-control soft-input" id="paid" name="paid" value="<?php echo $order_data['paid']; ?>" onkeyup="paidAmount()" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label">Due Amount</label>
                                            <input type="text" class="form-control soft-input" id="due" value="<?php echo $order_data['dueValue']; ?>" disabled />
                                            <input type="hidden" id="dueValue" name="dueValue" value="<?php echo $order_data['dueValue']; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label">Payment Type</label>
                                            <select class="form-control soft-input" name="paymentType" id="paymentType">
                                                <option value="">~~SELECT~~</option>
                                                <option value="2" <?php echo ($order_data['paymentType'] == 2) ? 'selected' : ''; ?>>Cash</option>
                                                <option value="4" <?php echo ($order_data['paymentType'] == 4) ? 'selected' : ''; ?>>Phone Pe</option>
                                                <option value="5" <?php echo ($order_data['paymentType'] == 5) ? 'selected' : ''; ?>>Google Pay</option>
                                                <option value="6" <?php echo ($order_data['paymentType'] == 6) ? 'selected' : ''; ?>>Amazon Pay</option>
                                                <option value="1" <?php echo ($order_data['paymentType'] == 1) ? 'selected' : ''; ?>>Cheque</option>
                                                <option value="3" <?php echo ($order_data['paymentType'] == 3) ? 'selected' : ''; ?>>Credit Card</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="control-label">Payment Status</label>
                                    <select class="form-control soft-input" name="paymentStatus" id="paymentStatus">
                                        <option value="">~~SELECT~~</option>
                                        <option value="1" <?php echo ($order_data['paymentStatus'] == 1) ? 'selected' : ''; ?>>Full Payment</option>
                                        <option value="2" <?php echo ($order_data['paymentStatus'] == 2) ? 'selected' : ''; ?>>Advance Payment</option>
                                        <option value="3" <?php echo ($order_data['paymentStatus'] == 3) ? 'selected' : ''; ?>>No Payment</option>
                                    </select>
                                </div>

                                <div class="form-group submitButtonFooter text-center mt-4">
                                    <button type="submit" id="updateOrderBtn" class="btn btn-success soft-btn m-2">
                                        <i class="glyphicon glyphicon-ok-sign"></i> Update Invoice
                                    </button>
                                    <button type="reset" class="btn btn-danger soft-btn m-2" onclick="resetOrderForm()">
                                        <i class="glyphicon glyphicon-erase"></i> Reset
                                    </button>
                                    <a href="Order.php" class="btn btn-secondary soft-btn m-2">Cancel</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Ledger Section -->
                <div class="card mt-4" id="ledgerSection" style="display: none;">
                    <div class="card-header">
                        <h4 class="card-title">Transaction Ledger</h4>
                        <button type="button" class="close" onclick="$('#ledgerSection').hide()">&times;</button>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Description</th>
                                        <th>Debit</th>
                                        <th>Credit</th>
                                        <th>Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(count($ledger_entries) > 0): ?>
                                        <?php foreach($ledger_entries as $entry): ?>
                                        <tr>
                                            <td><?php echo date('d M Y', strtotime($entry['transaction_date'])); ?></td>
                                            <td><?php echo $entry['description']; ?></td>
                                            <td class="text-danger"><?php echo $entry['debit'] > 0 ? '₹' . number_format($entry['debit'], 2) : '-'; ?></td>
                                            <td class="text-success"><?php echo $entry['credit'] > 0 ? '₹' . number_format($entry['credit'], 2) : '-'; ?></td>
                                            <td class="text-primary">₹<?php echo number_format($entry['balance'], 2); ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="5" class="text-center">No ledger entries found</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden div for printing -->
<div id="printableArea" style="display:none;">
    <!-- Content will be generated by JavaScript -->
</div>

<style>
.soft-input {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 10px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
}

.soft-input:focus {
    border-color: #4a6cf7;
    box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
    outline: none;
}

.soft-btn {
    padding: 8px 16px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
    border: none;
}

.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}

.card {
    background: #f7f9fc;
    border-radius: 15px;
    box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;
}

/* Print Styles */
@media print {
    body * {
        visibility: hidden;
    }
    #printableArea, #printableArea * {
        visibility: visible;
    }
    #printableArea {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        padding: 20px;
        font-size: 14px;
    }
    .no-print {
        display: none !important;
    }
    
    /* Invoice print styles */
    .invoice-header {
        text-align: center;
        margin-bottom: 20px;
        border-bottom: 2px solid #333;
        padding-bottom: 10px;
    }
    
    .invoice-details {
        margin-bottom: 20px;
    }
    
    .invoice-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }
    
    .invoice-table th, .invoice-table td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: left;
    }
    
    .invoice-table th {
        background-color: #f2f2f2;
    }
    
    .invoice-totals {
        margin-top: 20px;
        text-align: right;
    }
    
    .invoice-footer {
        margin-top: 30px;
        text-align: center;
        font-size: 12px;
        color: #666;
    }
}
</style>

<?php include('./constant/layout/footer.php');?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function () {
    $('.select2-product').select2({
        placeholder: "Search for a medicine",
        allowClear: true
    });

    // Initialize calculations
    var tableProductLength = $("#productTable tbody tr").length;
    for (x = 1; x <= tableProductLength; x++) {
        getProductData(x);
    }
    subAmount();
});

// Simple Print Invoice Function
function printInvoice() {
    // Create printable content
    var printableContent = `
        <div class="invoice-header">
            <h2>Pharmacy Management System</h2>
            <h3>TAX INVOICE</h3>
            <h4>Invoice #: <?php echo $order_data['uno']; ?></h4>
        </div>
        
        <div class="invoice-details">
            <table width="100%">
                <tr>
                    <td width="50%">
                        <strong>Client:</strong> <?php echo $order_data['clientName']; ?><br>
                        <strong>Contact:</strong> <?php echo $order_data['clientContact']; ?><br>
                        <strong>Date:</strong> <?php echo $order_data['orderDate']; ?>
                    </td>
                    <td width="50%" style="text-align:right;">
                        <strong>Grand Total:</strong> ₹<?php echo number_format($order_data['grandTotalValue'], 2); ?><br>
                        <strong>Paid:</strong> ₹<?php echo number_format($order_data['paid'], 2); ?><br>
                        <strong>Due:</strong> ₹<?php echo number_format($order_data['dueValue'], 2); ?>
                    </td>
                </tr>
            </table>
        </div>
        
        <table class="invoice-table">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Rate</th>
                    <th>SGST %</th>
                    <th>CGST %</th>
                    <th>Discount %</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>`;
    
    // Add items
    <?php foreach ($order_items as $item): ?>
    printableContent += `
                <tr>
                    <td><?php echo $item['product_name']; ?></td>
                    <td><?php echo $item['quantity']; ?></td>
                    <td>₹<?php echo number_format($item['rate'], 2); ?></td>
                    <td><?php echo $item['sgst_percentage']; ?>%</td>
                    <td><?php echo $item['cgst_percentage']; ?>%</td>
                    <td><?php echo $item['discount_percentage']; ?>%</td>
                    <td>₹<?php echo number_format($item['total'], 2); ?></td>
                </tr>`;
    <?php endforeach; ?>
    
    printableContent += `
            </tbody>
        </table>
        
        <div class="invoice-totals">
            <p><strong>Sub Total:</strong> ₹<?php echo number_format($order_data['subTotal'], 2); ?></p>
            <p><strong>SGST Total:</strong> ₹<?php echo number_format($order_data['sgst_total'], 2); ?></p>
            <p><strong>CGST Total:</strong> ₹<?php echo number_format($order_data['cgst_total'], 2); ?></p>
            <p><strong>Discount:</strong> <?php echo $order_data['discount_percentage']; ?>%</p>
            <h3><strong>Grand Total:</strong> ₹<?php echo number_format($order_data['grandTotalValue'], 2); ?></h3>
        </div>
        
        <div class="invoice-footer">
            <p>Payment Status: <?php 
                $statuses = [1 => 'Full Payment', 2 => 'Advance Payment', 3 => 'No Payment'];
                echo $statuses[$order_data['paymentStatus']] ?? 'Unknown'; 
            ?></p>
            <p>Payment Type: <?php 
                $types = [1 => 'Cheque', 2 => 'Cash', 3 => 'Credit Card', 4 => 'Phone Pe', 5 => 'Google Pay', 6 => 'Amazon Pay'];
                echo $types[$order_data['paymentType']] ?? 'Unknown'; 
            ?></p>
            <p>Generated on: <?php echo date('d M Y H:i:s'); ?></p>
            <p>Thank you for your business!</p>
        </div>`;
    
    // Set the printable content
    document.getElementById('printableArea').innerHTML = printableContent;
    
    // Print the document
    window.print();
}

// View Ledger Function
function viewLedger() {
    $('#ledgerSection').slideToggle();
}

// All other functions (getTotal, subAmount, discountFunc, paidAmount, addRow, removeProductRow, getProductData) remain the same
// ... [Include all the calculation functions from your original code here] ...

/* ================= FORM SUBMISSION =================== */
$("#editOrderForm").unbind('submit').bind('submit', function (e) {
    e.preventDefault();
    var form = $(this);
    
    // Validate form
    var isValid = true;
    $('.text-danger').remove();
    
    // Validation logic here...
    
    if (!isValid) return false;

    $("#updateOrderBtn").button('loading');

    $.ajax({
        url: form.attr('action'),
        type: form.attr('method'),
        data: form.serialize(),
        dataType: 'json',
        success: function (response) {
            $("#updateOrderBtn").button('reset');
            if (response.success === true) {
                $('#success-message').show();
                setTimeout(function() {
                    window.location.href = 'Order.php';
                }, 2000);
            } else {
                alert(response.message);
            }
        },
        error: function (xhr) {
            $("#updateOrderBtn").button('reset');
            alert('Error updating order: ' + xhr.responseText);
        }
    });

    return false;
});

function resetOrderForm() {
    location.reload();
}
</script>