<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('./constant/connect.php'); ?>

<div class="page-wrapper" style="background-color: #f7f9fc; min-height: 100vh; padding: 20px;">

    <div class="row page-titles mb-4">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary" style="font-weight: 600; color: #4a6cf7;">Stock Management</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb" style="background: transparent; padding: 0;">
                <li class="breadcrumb-item"><a href="javascript:void(0)" style="color:#888;">Home</a></li>
                <li class="breadcrumb-item active" style="color:#4a6cf7;">Stock Management</li>
            </ol>
        </div>
    </div>

    <!-- Success/Error Messages -->
    <div class="row">
        <div class="col-lg-12">
            <?php
            if (isset($_SESSION['success_message'])) {
                echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                    ' . $_SESSION['success_message'] . '
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>';
                unset($_SESSION['success_message']);
            }
            
            if (isset($_SESSION['error_message'])) {
                echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                    ' . $_SESSION['error_message'] . '
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>';
                unset($_SESSION['error_message']);
            }
            ?>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <!-- Filter Section - Left Side -->
            <div class="col-lg-3">
                <div class="card" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff; height: fit-content;">
                    <div class="card-header bg-light">
                        <h5 class="mb-0" style="color:blue"><i class="fas fa-filter"></i> Filter Stock</h5>
                    </div>
                    <div class="card-body">
                        <form id="filterForm">
                            <div class="form-group">
                                <label>Chamber</label>
                                <select class="form-control soft-input" id="filterChamber" name="chamber" style="height:50px">
                                    <option value="">All Chambers</option>
                                    <?php
                                    $chamber_sql = "SELECT * FROM chambers WHERE deleted = 0 ";
                                    $chamber_result = $connect->query($chamber_sql);
                                    while($chamber = $chamber_result->fetch_assoc()) {
                                        echo "<option value='{$chamber['id']}'> (C:{$chamber['column_number']}, R:{$chamber['row_no']})</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Category</label>
                                <select class="form-control soft-input" id="filterCategory" name="category" style="height:50px">
                                    <option value="">All Categories</option>
                                    <?php
                                    $category_sql = "SELECT * FROM categories WHERE categories_status = 1 ORDER BY categories_name";
                                    $category_result = $connect->query($category_sql);
                                    while($category = $category_result->fetch_assoc()) {
                                        echo "<option value='{$category['categories_id']}'>{$category['categories_name']}</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Manufacturer</label>
                                <select class="form-control soft-input" id="filterBrand" name="brand" style="height:50px">
                                    <option value="">All Manufacturers</option>
                                    <?php
                                    $brand_sql = "SELECT * FROM brands WHERE brand_status = 1 ORDER BY brand_name";
                                    $brand_result = $connect->query($brand_sql);
                                    while($brand = $brand_result->fetch_assoc()) {
                                        echo "<option value='{$brand['brand_id']}'>{$brand['brand_name']}</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Supplier</label>
                                <select class="form-control soft-input" id="filterSupplier" name="supplier" style="height:50px">
                                    <option value="">All Suppliers</option>
                                    <?php
                                    $supplier_sql = "SELECT * FROM suppliers WHERE supplier_status = 1 ORDER BY supplier_name";
                                    $supplier_result = $connect->query($supplier_sql);
                                    while($supplier = $supplier_result->fetch_assoc()) {
                                        echo "<option value='{$supplier['supplier_id']}'>{$supplier['supplier_name']}</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Expiry Date From</label>
                                <input type="date" class="form-control soft-input" id="filterExpiryFrom" name="expiry_from">
                            </div>
                            <div class="form-group">
                                <label>Expiry Date To</label>
                                <input type="date" class="form-control soft-input" id="filterExpiryTo" name="expiry_to">
                            </div>
                            <div class="form-group">
                                <label>Stock Status</label>
                                <select class="form-control soft-input" id="filterStatus" name="status" style="height:50px">
                                    <option value="">All Status</option>
                                    <option value="active">Active</option>
                                    <option value="low">Low Stock</option>
                                    <option value="expiring">Expiring Soon</option>
                                    <option value="expired">Expired</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <button type="button" class="btn btn-primary soft-btn btn-block mb-2" onclick="applyFilters()">
                                    <i class="fas fa-search"></i> Apply Filters
                                </button>
                                <button type="button" class="btn btn-secondary soft-btn btn-block" onclick="resetFilters()">
                                    <i class="fas fa-redo"></i> Reset
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Stock Summary Cards -->
                <div class="mt-4">
                    <div class="card bg-primary text-white mb-3">
                        <div class="card-body py-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-0">Total Medicines</h6>
                                    <h4 class="mb-0" id="totalMedicines">
                                        <?php
                                        $total_sql = "SELECT COUNT(*) as total FROM product WHERE status = 1";
                                        $total_result = $connect->query($total_sql);
                                        $total = $total_result->fetch_assoc()['total'];
                                        echo $total;
                                        ?>
                                    </h4>
                                </div>
                                <i class="fas fa-pills fa-2x"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card bg-success text-white mb-3">
                        <div class="card-body py-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-0">Low Stock Items</h6>
                                    <h4 class="mb-0" id="lowStockItems">
                                        <?php
                                        $low_stock_sql = "SELECT COUNT(*) as low_stock FROM product WHERE quantity <= 10 AND status = 1";
                                        $low_stock_result = $connect->query($low_stock_sql);
                                        $low_stock = $low_stock_result->fetch_assoc()['low_stock'];
                                        echo $low_stock;
                                        ?>
                                    </h4>
                                </div>
                                <i class="fas fa-exclamation-triangle fa-2x"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card bg-warning text-white mb-3">
                        <div class="card-body py-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-0">Expiring Soon</h6>
                                    <h4 class="mb-0" id="expiringSoon">
                                        <?php
                                        $expiring_sql = "SELECT COUNT(*) as expiring FROM product WHERE DATEDIFF(expdate, CURDATE()) <= 30 AND DATEDIFF(expdate, CURDATE()) >= 0 AND status = 1";
                                        $expiring_result = $connect->query($expiring_sql);
                                        $expiring = $expiring_result->fetch_assoc()['expiring'];
                                        echo $expiring;
                                        ?>
                                    </h4>
                                </div>
                                <i class="fas fa-clock fa-2x"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card bg-danger text-white">
                        <div class="card-body py-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-0">Expired Items</h6>
                                    <h4 class="mb-0" id="expiredItems">
                                        <?php
                                        $expired_sql = "SELECT COUNT(*) as expired FROM product WHERE expdate < CURDATE() AND status = 1";
                                        $expired_result = $connect->query($expired_sql);
                                        $expired = $expired_result->fetch_assoc()['expired'];
                                        echo $expired;
                                        ?>
                                    </h4>
                                </div>
                                <i class="fas fa-times-circle fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stock List Table - Right Side -->
            <div class="col-lg-9">
                <!-- Master Search Bar -->
                <div class="card mb-3" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;">
                    <div class="card-body p-2">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-primary text-white border-0">
                                            <i class="fas fa-search"></i>
                                        </span>
                                    </div>
                                    <input type="text" class="form-control soft-input border-0"  id="stockSearch" placeholder="Search across all fields (medicine name, batch, category, manufacturer, supplier, chamber, etc.)" style="height: 35px;">
                                </div>
                                    
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex justify-content-end">
                                    <button class="btn btn-outline-secondary btn-sm mr-2" onclick="clearMasterSearch()" title="Clear Search">
                                        <i class="fas fa-times"></i> Clear
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-1">
                            <div class="col-12">
                                      
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;">
                    <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                        <h4 class="mb-0"><i class="fas fa-list"></i> Current Stock</h4>
                        <div>
                            <button class="btn btn-light btn-sm" onclick="printStockReport()">
                                <i class="fas fa-print"></i> Print Report
                            </button>
                            <button class="btn btn-light btn-sm" onclick="exportToExcel()">
                                <i class="fas fa-file-excel"></i> Export Excel
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive" style="max-height: 1200px; overflow-y: auto;">
               

                            <table class="table table-bordered table-hover" id="stockTable">
                                <thead class="thead-light" style="position: sticky; top: 0; z-index: 10; background-color: #f8f9fa;">
                                    <tr>
                                        <th style="position: sticky; left: 0; background-color: #f8f9fa; z-index: 11;">#</th>
                                        <th>Medicine Info</th>
                                        <th>Stock Details</th>
                                        <th>Pricing</th>
                                        <th>Location & Status</th>
                                        <th style="position: sticky; right: 0; background-color: #f8f9fa; z-index: 11;">Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="stockTableBody">
                                    <?php
                                    $stock_sql = "SELECT p.*,c.column_number, c.row_no,
                                                 cat.categories_name, b.brand_name, s.supplier_name,
                                                 DATEDIFF(p.expdate, CURDATE()) as days_to_expire
                                                 FROM product p 
                                                 LEFT JOIN chambers c ON p.chamber = c.id 
                                                 LEFT JOIN categories cat ON p.categories_id = cat.categories_id
                                                 LEFT JOIN brands b ON p.brand_id = b.brand_id
                                                 LEFT JOIN suppliers s ON p.supplier_id = s.supplier_id
                                                 WHERE p.status = 1 
                                                 ORDER BY p.product_name, p.expdate LIMIT 10";

                                    $stock_result = $connect->query($stock_sql);
                                    $counter = 1;

                                    if ($stock_result && $stock_result->num_rows > 0) {
                                        while ($stock = $stock_result->fetch_assoc()) {
                                            $stock_value = (float)$stock['quantity'] * (float)$stock['purchase_rate'];

                                            $expiry_status = '';
                                            $status_badge = '';

                                            // Check expiry date first
                                            $expiry_date = !empty($stock['expdate']) && $stock['expdate'] != '0000-00-00' ? $stock['expdate'] : null;
                                            
                                            if ($expiry_date && $stock['days_to_expire'] < 0) {
                                                $expiry_status = 'text-danger';
                                                $status_badge = '<span class="badge badge-danger">Expired</span>';
                                            } elseif ($expiry_date && $stock['days_to_expire'] <= 30) {
                                                $expiry_status = 'text-warning';
                                                $status_badge = '<span class="badge badge-warning">Expiring Soon</span>';
                                            } else {
                                                $status_badge = '<span class="badge badge-success">Active</span>';
                                            }

                                            // low stock
                                            if ($stock['quantity'] <= 10) {
                                                $status_badge .= ' <span class="badge badge-warning">Low Stock</span>';
                                            }

                                            $chamber_info = $stock['column_number'] ? 
                                                $stock['column_number'] . ' (C:' . $stock['column_number'] . ', R:' . $stock['row_no'] . ')' : 
                                                'Not Assigned';

                                            // Format expiry date properly
                                            $formatted_expiry = $expiry_date ? date('d M Y', strtotime($expiry_date)) : 'Not Set';

                                            echo "<tr data-chamber='{$stock['chamber']}' data-category='{$stock['categories_id']}' 
                                                  data-brand='{$stock['brand_id']}' data-supplier='{$stock['supplier_id']}'
                                                  data-expiry='{$stock['expdate']}' data-quantity='{$stock['quantity']}'
                                                  data-days-to-expire='{$stock['days_to_expire']}'
                                                  data-search-data='" . htmlspecialchars(json_encode([
                                                      'medicine' => $stock['product_name'],
                                                      'batch' => $stock['bno'],
                                                      'category' => $stock['categories_name'],
                                                      'manufacturer' => $stock['brand_name'],
                                                      'supplier' => $stock['supplier_name'],
                                                      'chamber' => $chamber_info,
                                                      'quantity' => $stock['quantity'],
                                                      'unit' => $stock['unit'],
                                                      'expiry' => $formatted_expiry,
                                                      'purchase' => number_format($stock['purchase_rate'], 2),
                                                      'selling' => number_format($stock['rate'], 2),
                                                      'mrp' => number_format($stock['mrp'], 2)
                                                  ]), ENT_QUOTES, 'UTF-8') . "'>
                                                <td style='position: sticky; left: 0; background-color: white; z-index: 9;'>{$counter}</td>
                                                <td>
                                                    <strong>{$stock['product_name']}</strong><br>
                                                    <small class='text-muted'>
                                                        Batch: {$stock['bno']}<br>
                                                        Category: {$stock['categories_name']}<br>
                                                        Manufacturer: {$stock['brand_name']}<br>
                                                        Supplier: {$stock['supplier_name']}
                                                    </small>
                                                </td>
                                                <td>
                                                    Quantity: <strong>{$stock['quantity']} {$stock['unit']}</strong><br>
                                                    Expiry: <span class='{$expiry_status}'><strong>{$formatted_expiry}</strong></span><br>
                                                    Stock Value: ₹" . number_format($stock_value, 2) . "
                                                </td>
                                                <td>
                                                    Purchase: ₹" . number_format($stock['purchase_rate'], 2) . "<br>
                                                    Selling: ₹" . number_format($stock['rate'], 2) . "<br>
                                                    MRP: ₹" . number_format($stock['mrp'], 2) . "
                                                </td>
                                                <td>
                                                    Chamber: {$chamber_info}<br>
                                                    Status: {$status_badge}
                                                </td>
                                                <td style='position: sticky; right: 0; background-color: white; z-index: 9;'>
                                                    <div class='btn-group-vertical'>
                                                        <button class='btn btn-sm btn-info mb-1' onclick='viewStockDetails({$stock['product_id']})' title='View Details'>
                                                            <i class='fas fa-eye'></i> View
                                                        </button> 
                                                        <button class='btn btn-sm btn-warning mb-1' onclick='editStock({$stock['product_id']})' title='Upload Image'>
                                                            <i class='fas fa-upload'></i> Stock
                                                        </button>
                                                        <button class='btn btn-sm btn-warning mb-1' onclick='editStock({$stock['product_id']})' title='Edit Stock'>
                                                            <i class='fas fa-edit'></i> Edit
                                                        </button>
                                                        <button class='btn btn-sm btn-danger' onclick='deleteStock({$stock['product_id']})' title='Delete Stock'>
                                                            <i class='fas fa-trash'></i> Delete
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>";
                                            $counter++;
                                        }
                                    } else {
                                        echo "<tr><td colspan='6' class='text-center'>No stock available</td></tr>";
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Optional: Add a scroll indicator -->
                        <div class="scroll-indicator mt-2 text-center" style="display: none;">
                            <small class="text-muted"><i class="fas fa-arrows-alt-v"></i> Scroll to see more rows</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Stock Details Modal -->
<div class="modal fade" id="stockDetailsModal" tabindex="-1" role="dialog" aria-labelledby="stockDetailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="stockDetailsModalLabel">Stock Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="closeModal('stockDetailsModal')">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="stockDetailsContent">
                <!-- Details will be loaded here via AJAX -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="closeModal('stockDetailsModal')">Close</button>
            </div>
        </div>
    </div>
</div>

<style>
.soft-input {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 10px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
    width: 100%;
}

.soft-input:focus {
    border-color: #4a6cf7;
    box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
    outline: none;
}

.soft-btn {
    padding: 10px 20px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
    border: none;
}

.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}

.table th {
    background-color: #f8f9fa;
    border-top: none;
    font-weight: 600;
}

.card {
    border: none;
}

.badge {
    font-size: 0.75em;
}

.hidden-row {
    display: none;
}

.btn-group-vertical .btn {
    margin-bottom: 2px;
    text-align: left;
    width: 100%;
}

.table td {
    vertical-align: middle;
}

.search-highlight {
    background-color: #fff3cd;
    font-weight: bold;
}

#searchResultsCount {
    font-size: 0.9rem;
}

.dropdown-item.active {
    background-color: #f8f9fa;
    color: #495057;
    font-weight: bold;
}

/* Custom scrollbar styling */
.table-responsive::-webkit-scrollbar {
    width: 8px;
    height: 8px;
}

.table-responsive::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
}

.table-responsive::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 10px;
}

.table-responsive::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

/* Ensure table headers stay visible */
.table thead th {
    border-bottom: 2px solid #dee2e6;
}

/* Sticky column styling */
.table tbody td[style*="sticky"] {
    box-shadow: 2px 0 5px rgba(0,0,0,0.1);
}

.table thead th[style*="sticky"] {
    box-shadow: 2px 2px 5px rgba(0,0,0,0.1);
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .table-responsive {
        max-height: 400px;
        font-size: 0.9rem;
    }
    
    .btn-group-vertical .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.8rem;
    }
}

/* Hover effects for better UX */
.table tbody tr:hover td[style*="sticky"] {
    background-color: #f8f9fa !important;
}
</style>

<!-- SIMPLIFIED SCRIPT SECTION -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
// Fix SweetAlert error by removing problematic initialization
if (typeof Swal !== 'undefined') {
    // If SweetAlert is loaded, override any problematic initialization
    console.log('SweetAlert detected, ensuring proper initialization');
}

// Wait for document to be fully loaded
document.addEventListener('DOMContentLoaded', function() {
    console.log("DOM loaded - initializing search functionality");
    
    // Initialize search functionality
    initializeMasterSearch();
    
    // Initialize search results count
    updateSearchResultsCount(document.querySelectorAll('#stockTableBody tr').length);
    
    // Initialize scroll functionality
    initializeScrollFunctionality();
    
    // Add event listeners for filter changes
    const filterChamber = document.getElementById('filterChamber');
    const filterCategory = document.getElementById('filterCategory');
    const filterBrand = document.getElementById('filterBrand');
    const filterSupplier = document.getElementById('filterSupplier');
    const filterStatus = document.getElementById('filterStatus');
    const filterExpiryFrom = document.getElementById('filterExpiryFrom');
    const filterExpiryTo = document.getElementById('filterExpiryTo');
    
    if (filterChamber) filterChamber.addEventListener('change', applyFilters);
    if (filterCategory) filterCategory.addEventListener('change', applyFilters);
    if (filterBrand) filterBrand.addEventListener('change', applyFilters);
    if (filterSupplier) filterSupplier.addEventListener('change', applyFilters);
    if (filterStatus) filterStatus.addEventListener('change', applyFilters);
    if (filterExpiryFrom) filterExpiryFrom.addEventListener('change', applyFilters);
    if (filterExpiryTo) filterExpiryTo.addEventListener('change', applyFilters);
});

let searchTimeout = null;

function initializeMasterSearch() {
    const searchInput = document.getElementById('masterSearch');
    
    if (!searchInput) {
        console.error('Search input not found');
        return;
    }
    
    searchInput.addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase().trim();
        console.log("Searching for:", searchTerm);
        
        // Clear any existing timeout
        if (searchTimeout) {
            clearTimeout(searchTimeout);
        }
        
        // Set a new timeout to perform the search after 300ms of inactivity
        searchTimeout = setTimeout(function() {
            performMasterSearch();
        }, 300);
    });
    
    // Also trigger search on keyup for immediate response when clearing
    searchInput.addEventListener('keyup', function() {
        const searchTerm = this.value.toLowerCase().trim();
        if (searchTerm === '') {
            performMasterSearch();
        }
    });
}

function performMasterSearch() {
    const searchTerm = document.getElementById('masterSearch').value.toLowerCase().trim();
    const rows = document.querySelectorAll('#stockTableBody tr');
    let visibleCount = 0;
    
    console.log("Performing search for:", searchTerm, "across", rows.length, "rows");
    
    if (searchTerm === '') {
        // Show all rows if search is empty
        rows.forEach(row => {
            row.classList.remove('hidden-row');
            removeHighlights(row);
            visibleCount++;
        });
    } else {
        // Perform search across all fields
        rows.forEach(row => {
            const searchDataAttr = row.getAttribute('data-search-data');
            let matches = false;
            
            if (searchDataAttr) {
                try {
                    const searchData = JSON.parse(searchDataAttr);
                    // Search across all fields in the search data
                    const searchString = Object.values(searchData).join(' ').toLowerCase();
                    matches = searchString.includes(searchTerm);
                } catch (e) {
                    console.error("Error parsing search data:", e);
                }
            }
            
            if (matches) {
                row.classList.remove('hidden-row');
                highlightSearchTerm(row, searchTerm);
                visibleCount++;
            } else {
                row.classList.add('hidden-row');
                removeHighlights(row);
            }
        });
    }
    
    // Update search results count
    updateSearchResultsCount(visibleCount);
    
    // Also update the summary cards based on visible rows
    updateSummaryCards();
    
    console.log("Search completed. Found:", visibleCount, "items");
}

function highlightSearchTerm(row, term) {
    // Remove previous highlights
    removeHighlights(row);
    
    if (!term) return;
    
    // Highlight the term in all td elements
    const cells = row.querySelectorAll('td');
    cells.forEach(cell => {
        const html = cell.innerHTML;
        const escapedTerm = term.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
        const regex = new RegExp(`(${escapedTerm})`, 'gi');
        const newHtml = html.replace(regex, '<span class="search-highlight">$1</span>');
        cell.innerHTML = newHtml;
    });
}

function removeHighlights(row) {
    const highlights = row.querySelectorAll('.search-highlight');
    highlights.forEach(highlight => {
        highlight.outerHTML = highlight.textContent;
    });
}

function updateSearchResultsCount(count) {
    const total = document.querySelectorAll('#stockTableBody tr').length;
    const countElement = document.getElementById('searchResultsCount');
    if (countElement) {
        countElement.textContent = `${count} of ${total} items`;
    }
}

function clearMasterSearch() {
    const searchInput = document.getElementById('masterSearch');
    if (searchInput) {
        searchInput.value = '';
        performMasterSearch();
        searchInput.focus();
    }
}

function updateSummaryCards() {
    let lowStockCount = 0;
    let expiringCount = 0;
    let expiredCount = 0;
    
    const visibleRows = document.querySelectorAll('#stockTableBody tr:not(.hidden-row)');
    
    visibleRows.forEach(row => {
        const quantity = parseInt(row.getAttribute('data-quantity')) || 0;
        const daysToExpire = parseInt(row.getAttribute('data-days-to-expire')) || 0;
        
        if (quantity <= 10) lowStockCount++;
        if (daysToExpire <= 30 && daysToExpire >= 0) expiringCount++;
        if (daysToExpire < 0) expiredCount++;
    });
    
    const visibleCount = visibleRows.length;
    
    const totalMedicines = document.getElementById('totalMedicines');
    const lowStockItems = document.getElementById('lowStockItems');
    const expiringSoon = document.getElementById('expiringSoon');
    const expiredItems = document.getElementById('expiredItems');
    
    if (totalMedicines) totalMedicines.textContent = visibleCount;
    if (lowStockItems) lowStockItems.textContent = lowStockCount;
    if (expiringSoon) expiringSoon.textContent = expiringCount;
    if (expiredItems) expiredItems.textContent = expiredCount;
}

function closeModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) {
        // Use Bootstrap's modal hide method if available
        if (typeof bootstrap !== 'undefined') {
            const bsModal = bootstrap.Modal.getInstance(modal);
            if (bsModal) {
                bsModal.hide();
            } else {
                const bsModalNew = new bootstrap.Modal(modal);
                bsModalNew.hide();
            }
        } else {
            // Fallback if Bootstrap is not available
            modal.style.display = 'none';
            modal.classList.remove('show');
            document.body.classList.remove('modal-open');
            
            // Remove backdrop
            const backdrop = document.querySelector('.modal-backdrop');
            if (backdrop) {
                backdrop.remove();
            }
        }
    }
}

function applyFilters() {
    const chamber = document.getElementById('filterChamber')?.value || '';
    const category = document.getElementById('filterCategory')?.value || '';
    const brand = document.getElementById('filterBrand')?.value || '';
    const supplier = document.getElementById('filterSupplier')?.value || '';
    const expiryFrom = document.getElementById('filterExpiryFrom')?.value || '';
    const expiryTo = document.getElementById('filterExpiryTo')?.value || '';
    const status = document.getElementById('filterStatus')?.value || '';
    
    const rows = document.querySelectorAll('#stockTableBody tr');
    let visibleCount = 0;
    
    rows.forEach(row => {
        let showRow = true;
        
        // Chamber filter
        if (chamber && row.getAttribute('data-chamber') !== chamber) {
            showRow = false;
        }
        
        // Category filter
        if (category && row.getAttribute('data-category') !== category) {
            showRow = false;
        }
        
        // Brand filter
        if (brand && row.getAttribute('data-brand') !== brand) {
            showRow = false;
        }
        
        // Supplier filter
        if (supplier && row.getAttribute('data-supplier') !== supplier) {
            showRow = false;
        }
        
        // Expiry date filter
        const expiryDate = row.getAttribute('data-expiry');
        if (expiryFrom && expiryDate < expiryFrom) {
            showRow = false;
        }
        if (expiryTo && expiryDate > expiryTo) {
            showRow = false;
        }
        
        // Status filter
        const daysToExpire = parseInt(row.getAttribute('data-days-to-expire')) || 0;
        const quantity = parseInt(row.getAttribute('data-quantity')) || 0;
        
        if (status === 'active' && (daysToExpire <= 30 || daysToExpire < 0 || quantity <= 10)) {
            showRow = false;
        } else if (status === 'low' && quantity > 10) {
            showRow = false;
        } else if (status === 'expiring' && (daysToExpire > 30 || daysToExpire < 0)) {
            showRow = false;
        } else if (status === 'expired' && daysToExpire >= 0) {
            showRow = false;
        }
        
        if (showRow) {
            row.classList.remove('hidden-row');
            visibleCount++;
        } else {
            row.classList.add('hidden-row');
        }
    });
    
    // Update search results count
    updateSearchResultsCount(visibleCount);
    updateSummaryCards();
    
    // Show message if no results
    const noResultsMessage = document.getElementById('noResultsMessage');
    if (visibleCount === 0) {
        if (!noResultsMessage) {
            const tbody = document.getElementById('stockTableBody');
            const messageRow = document.createElement('tr');
            messageRow.id = 'noResultsMessage';
            messageRow.innerHTML = '<td colspan="6" class="text-center">No stock items match the selected filters</td>';
            tbody.appendChild(messageRow);
        }
    } else if (noResultsMessage) {
        noResultsMessage.remove();
    }
}

function resetFilters() {
    const filterForm = document.getElementById('filterForm');
    if (filterForm) {
        filterForm.reset();
    }
    
    const rows = document.querySelectorAll('#stockTableBody tr');
    rows.forEach(row => {
        row.classList.remove('hidden-row');
    });
    
    const noResultsMessage = document.getElementById('noResultsMessage');
    if (noResultsMessage) {
        noResultsMessage.remove();
    }
    
    // Reset summary cards to original values
    updateSearchResultsCount(rows.length);
    updateSummaryCards();
}

function viewStockDetails(productId) {
    // Using fetch API instead of jQuery
    fetch('getStockDetails.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'product_id=' + productId
    })
    .then(response => response.text())
    .then(data => {
        document.getElementById('stockDetailsContent').innerHTML = data;
        
        // Show modal using Bootstrap
        const modal = new bootstrap.Modal(document.getElementById('stockDetailsModal'));
        modal.show();
    })
    .catch(error => {
        alert('Error loading stock details');
        console.error('Error:', error);
    });
}

function editStock(productId) {
    window.location.href = 'editproduct.php?id=' + productId;
}

function deleteStock(productId) {
    if (confirm('Are you sure you want to delete this stock item?')) {
        fetch('deleteStock.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: 'product_id=' + productId
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Stock deleted successfully');
                location.reload();
            } else {
                alert('Error deleting stock: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error deleting stock');
            console.error('Error:', error);
        });
    }
}

function printStockReport() {
    window.print();
}

function exportToExcel() {
    const table = document.getElementById('stockTable');
    const wb = XLSX.utils.table_to_book(table, {sheet: "Stock Report"});
    XLSX.writeFile(wb, "Stock_Report_" + new Date().toISOString().split('T')[0] + ".xlsx");
}

function initializeScrollFunctionality() {
    const tableContainer = document.querySelector('.table-responsive');
    const scrollIndicator = document.querySelector('.scroll-indicator');
    
    if (!tableContainer || !scrollIndicator) return;
    
    // Show/hide scroll indicator based on content height
    function checkScrollable() {
        const tableHeight = document.getElementById('stockTable').offsetHeight;
        const containerHeight = tableContainer.offsetHeight;
        
        if (tableHeight > containerHeight) {
            scrollIndicator.style.display = 'block';
        } else {
            scrollIndicator.style.display = 'none';
        }
    }
    
    // Initial check
    checkScrollable();
    
    // Check on window resize
    window.addEventListener('resize', checkScrollable);
    
    // Add scrolling behavior
    tableContainer.addEventListener('scroll', function() {
        const scrollTop = this.scrollTop;
        const scrollHeight = this.scrollHeight;
        const clientHeight = this.clientHeight;
        
        // Hide indicator when user starts scrolling
        if (scrollTop > 10) {
            scrollIndicator.style.display = 'none';
        }
        
        // Show indicator when near top
        if (scrollTop < 10 && scrollHeight > clientHeight + 20) {
            scrollIndicator.style.display = 'block';
        }
    });
}

// Function to scroll to specific row
function scrollToRow(rowIndex) {
    const tableContainer = document.querySelector('.table-responsive');
    const rows = document.querySelectorAll('#stockTableBody tr');
    const targetRow = rows[rowIndex];
    
    if (targetRow && tableContainer) {
        const rowPosition = targetRow.offsetTop;
        tableContainer.scrollTo({
            top: rowPosition - 50,
            behavior: 'smooth'
        });
        
        // Highlight the row temporarily
        targetRow.classList.add('table-primary');
        setTimeout(() => {
            targetRow.classList.remove('table-primary');
        }, 2000);
    }
}
</script>
<script>
document.getElementById("stockSearch").addEventListener("keyup", function() {
    let query = this.value.toLowerCase();
    let rows = document.querySelectorAll("#stockTableBody tr");

    rows.forEach(function(row) {
        let searchData = row.getAttribute("data-search-data");
        if (searchData && searchData.toLowerCase().includes(query)) {
            row.style.display = "";
        } else {
            row.style.display = "none";
        }
    });
});
</script>

<?php include('./constant/layout/footer.php'); ?>