
<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('./constant/connect.php'); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stock Management</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <!-- Custom Styles -->
    <style>
        .soft-input {
            border-radius: 12px;
            border: 1px solid #d1d9e6;
            padding: 10px 12px;
            box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
            transition: all 0.3s ease;
        }
        .soft-input:focus {
            border-color: #4a6cf7;
            box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
            outline: none;
        }
        .soft-btn {
            padding: 10px 20px;
            border-radius: 12px;
            box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        .soft-btn:hover {
            transform: translateY(-2px);
            box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
        }
        .input-group-text {
            background-color: #f8f9fa;
            border: 1px solid #d1d9e6;
            border-radius: 12px 0 0 12px !important;
        }
        .alert-info {
            border-radius: 8px;
            margin-bottom: 0;
        }
        .select2-container--default .select2-selection--single {
            height: 50px !important;
            padding: 10px 12px !important;
            display: flex !important;
            align-items: center !important;
            border-radius: 12px;
            border: 1px solid #d1d9e6;
        }
        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 48px !important;
        }
        .select2-dropdown {
            border-radius: 12px;
            border: 1px solid #d1d9e6;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-check {
            margin-top: 10px;
        }
        .form-check-input {
            margin-right: 8px;
        }
        .table th, .table td {
            vertical-align: middle;
        }
    </style>
    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous" defer></script>
    <!-- Inline JavaScript -->
    <script defer>
        // Ensure DOM is fully loaded
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Select2
            if (typeof $.fn.select2 !== 'undefined') {
                $('.select2-medicine').select2({
                    placeholder: "Type to search medicines...",
                    allowClear: true,
                    width: '100%'
                });
                $('.select2-chamber').select2({
                    placeholder: "Type to search chambers...",
                    allowClear: true,
                    width: '100%'
                });
            } else {
                console.error('Select2 is not loaded');
            }

            // Set default expiry date to 1 year from now if not in edit mode
            <?php if (!$editMode) { ?>
            const nextYear = new Date();
            nextYear.setFullYear(nextYear.getFullYear() + 1);
            document.getElementById('expdate').value = nextYear.toISOString().split('T')[0];
            <?php } ?>

            // Show toast notification if success message exists
            const message = '<?php echo $message; ?>';
            if (message === 'success') {
                const toastHTML = `
                    <div class="toast align-items-center text-bg-success border-0 position-fixed top-0 end-0 m-3" role="alert" aria-live="assertive" aria-atomic="true">
                        <div class="d-flex">
                            <div class="toast-body">
                                Stock <?php echo $editMode ? 'updated' : 'added'; ?> successfully!
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                        </div>
                    </div>`;
                document.body.insertAdjacentHTML('beforeend', toastHTML);
                const toastEl = document.querySelector('.toast');
                if (typeof bootstrap !== 'undefined') {
                    const toast = new bootstrap.Toast(toastEl);
                    toast.show();
                } else {
                    console.error('Bootstrap is not loaded');
                }
            }

            // Function to calculate total quantity
            function calculateTotalQuantity() {
                const numberOfUnits = parseInt(document.getElementById('numberOfUnits').value) || 0;
                const unitDescription = parseInt(document.getElementById('unitDescription').value) || 0;
                const totalQuantity = numberOfUnits * unitDescription;

                // Update display
                document.getElementById('totalQuantityDisplay').textContent = totalQuantity;
                document.getElementById('calculatedQuantity').value = totalQuantity;
                document.getElementById('quantity').value = totalQuantity;

                // Update pack field
                document.getElementById('pack').value = `1*${unitDescription}`;

                // Recalculate prices if auto-calculate is enabled
                if (document.getElementById('autoCalculate').checked) {
                    calculatePerItemPrices();
                }
            }

            // Function to calculate per item prices from pack prices
            function calculatePerItemPrices() {
                if (!document.getElementById('autoCalculate').checked) return;

                const unitDescription = parseInt(document.getElementById('unitDescription').value) || 1;
                const packPurchaseRate = parseFloat(document.getElementById('packPurchaseRate').value) || 0;
                const packSellingRate = parseFloat(document.getElementById('packSellingRate').value) || 0;
                const packMRP = parseFloat(document.getElementById('packMRP').value) || 0;

                // Calculate per item prices
                const perItemPurchase = unitDescription > 0 ? (packPurchaseRate / unitDescription) : 0;
                const perItemSelling = unitDescription > 0 ? (packSellingRate / unitDescription) : 0;
                const perItemMRP = unitDescription > 0 ? (packMRP / unitDescription) : 0;

                // Update per item input fields
                document.getElementById('perItemPurchaseInput').value = perItemPurchase.toFixed(2);
                document.getElementById('perItemSellingInput').value = perItemSelling.toFixed(2);
                document.getElementById('perItemMRPInput').value = perItemMRP.toFixed(2);
            }

            // Function to calculate pack prices from per item prices
            function calculatePackPricesFromPerItem(type) {
                if (!document.getElementById('autoCalculate').checked) return;

                const unitDescription = parseInt(document.getElementById('unitDescription').value) || 1;

                switch (type) {
                    case 'purchase':
                        const perItemPurchase = parseFloat(document.getElementById('perItemPurchaseInput').value) || 0;
                        const packPurchaseRate = perItemPurchase * unitDescription;
                        document.getElementById('packPurchaseRate').value = packPurchaseRate.toFixed(2);
                        break;
                    case 'selling':
                        const perItemSelling = parseFloat(document.getElementById('perItemSellingInput').value) || 0;
                        const packSellingRate = perItemSelling * unitDescription;
                        document.getElementById('packSellingRate').value = packSellingRate.toFixed(2);
                        break;
                    case 'mrp':
                        const perItemMRP = parseFloat(document.getElementById('perItemMRPInput').value) || 0;
                        const packMRP = perItemMRP * unitDescription;
                        document.getElementById('packMRP').value = packMRP.toFixed(2);
                        break;
                }
            }

            // Function to generate unit description
            function generateUnitDescription() {
                const unitType = document.getElementById('unitType').value || 'Units';
                const unitDescription = document.getElementById('unitDescription').value || '1';
                document.getElementById('pack').value = `1*${unitDescription}`;
                calculateTotalQuantity();
            }

            // Attach event listeners
            document.getElementById('unitType').addEventListener('input', generateUnitDescription);
            document.getElementById('itemsPerUnit').addEventListener('input', generateUnitDescription);
            document.getElementById('unitDescription').addEventListener('input', function() {
                calculateTotalQuantity();
                generateUnitDescription();
            });
            document.getElementById('numberOfUnits').addEventListener('input', calculateTotalQuantity);
            document.getElementById('packPurchaseRate').addEventListener('input', calculatePerItemPrices);
            document.getElementById('packSellingRate').addEventListener('input', calculatePerItemPrices);
            document.getElementById('packMRP').addEventListener('input', calculatePerItemPrices);
            document.getElementById('perItemPurchaseInput').addEventListener('input', function() {
                calculatePackPricesFromPerItem('purchase');
            });
            document.getElementById('perItemSellingInput').addEventListener('input', function() {
                calculatePackPricesFromPerItem('selling');
            });
            document.getElementById('perItemMRPInput').addEventListener('input', function() {
                calculatePackPricesFromPerItem('mrp');
            });
            document.getElementById('autoCalculate').addEventListener('change', function() {
                if (this.checked) {
                    calculatePerItemPrices();
                }
            });

            // Initialize calculations on page load
            calculateTotalQuantity();
            calculatePerItemPrices();
            generateUnitDescription();

            // Form validation before submission
            document.getElementById('submitStockForm').addEventListener('submit', function(e) {
                const totalQuantity = parseInt(document.getElementById('quantity').value) || 0;
                if (totalQuantity <= 0) {
                    e.preventDefault();
                    alert('Please enter valid quantity values. Total quantity must be greater than 0.');
                    return false;
                }

                const packPurchaseRate = parseFloat(document.getElementById('packPurchaseRate').value) || 0;
                const packSellingRate = parseFloat(document.getElementById('packSellingRate').value) || 0;
                const packMRP = parseFloat(document.getElementById('packMRP').value) || 0;
                const perItemPurchase = parseFloat(document.getElementById('perItemPurchaseInput').value) || 0;
                const perItemSelling = parseFloat(document.getElementById('perItemSellingInput').value) || 0;
                const perItemMRP = parseFloat(document.getElementById('perItemMRPInput').value) || 0;

                if (packPurchaseRate <= 0 || packSellingRate <= 0 || packMRP <= 0 ||
                    perItemPurchase <= 0 || perItemSelling <= 0 || perItemMRP <= 0) {
                    e.preventDefault();
                    alert('Please enter valid price values. All prices must be greater than 0.');
                    return false;
                }

                return true;
            });
        });
    </script>
</head>
<body>
    <div class="page-wrapper" style="background-color: #f7f9fc; min-height: 100vh; padding: 20px;">
        <div class="row page-titles mb-4">
            <div class="col-md-5 align-self-center">
                <h3 class="text-primary" style="font-weight: 600; color: #4a6cf7;">Stock Management</h3>
            </div>
            <div class="col-md-7 align-self-center">
                <ol class="breadcrumb" style="background: transparent; padding: 0;">
                    <li class="breadcrumb-item"><a href="javascript:void(0)" style="color:#888;">Home</a></li>
                    <li class="breadcrumb-item active" style="color:#4a6cf7;">Stock Management</li>
                </ol>
            </div>
        </div>

        <div class="container-fluid">
            <?php
            $message = '';
            if (isset($_GET['message'])) {
                $message = $_GET['message'];
                echo "<script>
                    if (window.history.replaceState) {
                        window.history.replaceState(null, null, window.location.pathname);
                    }
                </script>";
            }

            // Check if editing an existing product
            $editMode = false;
            $productData = [];
            if (isset($_GET['edit_id'])) {
                $editMode = true;
                $product_id = $_GET['edit_id'];
                $sql = "SELECT * FROM product WHERE product_id = '$product_id'";
                $result = $connect->query($sql);
                if ($result->num_rows > 0) {
                    $productData = $result->fetch_assoc();
                }
            }
            ?>

            <div class="row">
                <div class="col-lg-12 mx-auto">
                    <div class="card" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;">
                        <div class="card-body">
                            <form class="row" method="POST" id="submitStockForm" action="php_action/createStock.php" enctype="multipart/form-data">
                                <input type="hidden" name="currnt_date" class="form-control">
                                <input type="hidden" name="product_id" value="<?php echo $editMode ? $productData['product_id'] : ''; ?>">
                                <input type="hidden" name="editMode" value="<?php echo $editMode ? '1' : '0'; ?>">

                                <!-- Supplier and Medicine Selection -->
                                <div class="form-group col-md-6">
                                    <label class="control-label">Supplier Name <span class="text-danger">*</span></label>
                                    <select class="form-control soft-input select2-medicine" id="supplierName" name="supplierName" required style="height:50px">
                                        <option value="">~~SELECT~~</option>
                                        <?php
                                        $sql = "SELECT supplier_id, supplier_name FROM suppliers WHERE supplier_status = 1 AND supplier_active = 1";
                                        $result = $connect->query($sql);
                                        while ($row = $result->fetch_array()) {
                                            $selected = $editMode && $productData['supplier_id'] == $row[0] ? 'selected' : '';
                                            echo "<option value='" . $row[0] . "' $selected>" . $row[1] . "</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="control-label">Select Product <span class="text-danger">*</span></label>
                                    <select class="form-control soft-input select2-medicine" id="medicineName" name="medicineName" required style="height:50px" <?php echo $editMode ? 'disabled' : ''; ?>>
                                        <option value="">~~SELECT~~</option>
                                        <?php
                                        $sql = "SELECT p.product_id, p.product_name, c.categories_name 
                                                FROM product p 
                                                INNER JOIN categories c ON p.categories_id = c.categories_id 
                                                WHERE p.status = 1";
                                        $result = $connect->query($sql);
                                        while ($row = $result->fetch_assoc()) {
                                            $selected = $editMode && $productData['product_id'] == $row['product_id'] ? 'selected' : '';
                                            echo "<option value='" . $row['product_id'] . "' $selected>" . $row['product_name'] . " - " . $row['categories_name'] . "</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <!-- Unit Configuration (Rearranged Order) -->
                            <div class="form-group col-md-3">
    <label class="control-label">Unit Type <span class="text-danger">*</span></label>
    <select class="form-control soft-input select2" id="unitType" name="unitType" required style="height:50px">
        <option value="">Select Unit Type</option>
        <?php
        // Fetch units from database where deleted = 0
        $sql = "SELECT * FROM units WHERE deleted = 0 ORDER BY unit_name";
        $result = $connect->query($sql);
        
        $currentUnit = $editMode ? $productData['unit'] : '';
        
        while ($row = $result->fetch_assoc()) {
            $selected = ($currentUnit == $row['unit_name']) ? 'selected' : '';
            echo '<option value="' . htmlspecialchars($row['unit_name']) . '" ' . $selected . '>' . htmlspecialchars($row['unit_name']) . '</option>';
        }
        ?>
    </select>
</div>

                                <div class="form-group col-md-2">
                                    <label class="control-label">Items per Unit <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control soft-input" id="itemsPerUnit" name="itemsPerUnit" required placeholder="Items per Unit" value="<?php echo $editMode ? $productData['units_per_pack'] : '1'; ?>" min="1" autocomplete="off">
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="control-label">Unit Description <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control soft-input" id="unitDescription" name="unitDescription" required placeholder="Number of items" value="<?php echo $editMode ? $productData['unit_description'] : '1'; ?>" min="1" autocomplete="off">
                                </div>

                                <div class="form-group col-md-2">
                                    <label class="control-label">Pack</label>
                                    <input type="text" class="form-control soft-input" id="pack" name="pack"  value="<?php echo $editMode ? '1*' . $productData['unit_description'] : '1*1'; ?>">
                                </div>

                                <div class="form-group col-md-2">
                                    <label class="control-label">Unit Stock <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control soft-input" id="numberOfUnits" name="numberOfUnits" required placeholder="Number of units" value="<?php echo $editMode ? ($productData['quantity'] / $productData['unit_description']) : '1'; ?>" min="1" autocomplete="off">
                                </div>

                                <div class="form-group col-md-2">
                                    <label class="control-label">Final Stock</label>
                                    <input type="text" class="form-control soft-input" id="quantity" name="quantity" value="<?php echo $editMode ? $productData['quantity'] : '1'; ?>" readonly>
                                </div>

                                <!-- Total Quantity Display -->
                                <div class="col-md-12 mb-3">
                                    <div class="alert alert-info">
                                        <strong>Total Quantity: <span id="totalQuantityDisplay"><?php echo $editMode ? $productData['quantity'] : '1'; ?></span> items</strong>
                                        <small class="text-muted">(Unit Stock × Unit Description)</small>
                                        <input type="hidden" id="calculatedQuantity" name="calculatedQuantity" value="<?php echo $editMode ? $productData['quantity'] : '1'; ?>">
                                    </div>
                                </div>

                                <!-- Pack Purchase Rates -->
                                <div class="form-group col-md-3">
                                    <label class="control-label">Pack Purchase Rate <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">₹</span>
                                        <input type="number" class="form-control soft-input" id="packPurchaseRate" name="packPurchaseRate" placeholder="Pack purchase rate" value="<?php echo $editMode ? $productData['pack_purchase_rate'] : '0'; ?>" step="0.01" min="0" required autocomplete="off">
                                    </div>
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="control-label">Per Item Purchase <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">₹</span>
                                        <input type="number" class="form-control soft-input" id="perItemPurchaseInput" name="purchaseRate" placeholder="Per item purchase" value="<?php echo $editMode ? $productData['purchase_rate'] : '0'; ?>" step="0.01" min="0" required autocomplete="off">
                                    </div>
                                </div>

                                <!-- Pack Selling Rates -->
                                <div class="form-group col-md-3">
                                    <label class="control-label">Pack Selling Rate <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">₹</span>
                                        <input type="number" class="form-control soft-input" id="packSellingRate" name="packSellingRate" placeholder="Pack selling rate" value="<?php echo $editMode ? $productData['pack_selling_rate'] : '0'; ?>" step="0.01" min="0" required autocomplete="off">
                                    </div>
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="control-label">Per Item Selling <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">₹</span>
                                        <input type="number" class="form-control soft-input" id="perItemSellingInput" name="rate" placeholder="Per item selling" value="<?php echo $editMode ? $productData['rate'] : '0'; ?>" step="0.01" min="0" required autocomplete="off">
                                    </div>
                                </div>

                                <!-- Pack MRP Rates -->
                                <div class="form-group col-md-3">
                                    <label class="control-label">Pack MRP <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">₹</span>
                                        <input type="number" class="form-control soft-input" id="packMRP" name="packMRP" placeholder="Pack MRP" value="<?php echo $editMode ? $productData['pack_mrp'] : '0'; ?>" step="0.01" min="0" required autocomplete="off">
                                    </div>
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="control-label">Per Item MRP <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">₹</span>
                                        <input type="number" class="form-control soft-input" id="perItemMRPInput" name="mrp" placeholder="Per item MRP" value="<?php echo $editMode ? $productData['mrp'] : '0'; ?>" step="0.01" min="0" required autocomplete="off">
                                    </div>
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="control-label">&nbsp;</label>
                                    <button type="button" class="btn btn-outline-primary btn-block" onclick="calculatePerItemPrices()" style="height: 46px; margin-top: 8px;">
                                        <i class="fas fa-sync-alt"></i> Sync Prices
                                    </button>
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="control-label">Auto Calculate</label>
                                    <div class="form-check mt-2">
                                        <input class="form-check-input" type="checkbox" id="autoCalculate" checked>
                                        <label class="form-check-label" for="autoCalculate">
                                            Enable auto calculation
                                        </label>
                                    </div>
                                </div>

                                <!-- Tax Information -->
                                <div class="form-group col-md-3">
                                    <label class="control-label">SGST % <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control soft-input" id="sgst" name="sgst" placeholder="SGST %" value="<?php echo $editMode ? $productData['sgst'] : '0'; ?>" step="0.01" min="0" required autocomplete="off">
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="control-label">CGST % <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control soft-input" id="cgst" name="cgst" placeholder="CGST %" value="<?php echo $editMode ? $productData['cgst'] : '0'; ?>" step="0.01" min="0" required autocomplete="off">
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="control-label">Batch No <span class="text-muted">(Optional)</span></label>
                                    <input type="text" class="form-control soft-input" id="bno" name="bno" placeholder="Batch No" value="<?php echo $editMode ? $productData['bno'] : 'ABC123'; ?>" pattern="^[a-zA-Z0-9]+$" autocomplete="off">
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="control-label">Expiry Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control soft-input" id="expdate" name="expdate" value="<?php echo $editMode ? $productData['expdate'] : ''; ?>" required>
                                </div>

                                <!-- Chamber -->
                                <div class="form-group col-md-6">
                                    <label class="control-label">Chamber <span class="text-muted">(Optional)</span></label>
                                    <select class="form-control soft-input select2-chamber" id="chamber" name="chamber" style="height:50px">
                                        <option value="">~~SELECT~~</option>
                                        <?php
                                        $chamber_sql = "SELECT id, column_number, row_no 
                                                        FROM chambers 
                                                        WHERE deleted = 0";
                                        $chamber_result = $connect->query($chamber_sql);
                                        if ($chamber_result && $chamber_result->num_rows > 0) {
                                            while ($chamber_row = $chamber_result->fetch_assoc()) {
                                                $selected = $editMode && $productData['chamber'] == $chamber_row['id'] ? 'selected' : '';
                                                $display_text = $chamber_row['column_number'] . ' , ' . $chamber_row['row_no'];
                                                $data_location = "Column: " . $chamber_row['column_number'] . " | Row: " . $chamber_row['row_no'];
                                                echo "<option value='" . $chamber_row['id'] . "' data-location='" . $data_location . "' $selected>" . $display_text . "</option>";
                                            }
                                        } else {
                                            echo "<option value='main' data-location='Main Building'>Main Chamber</option>
                                                  <option value='storage' data-location='Storage Area'>Storage Room</option>
                                                  <option value='refrigerated' data-location='Cold Storage'>Refrigerated Chamber</option>
                                                  <option value='quarantine' data-location='Isolation Area'>Quarantine Area</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <!-- Submit Button -->
                                <div class="form-group col-md-6 d-flex align-items-end">
                                    <button type="submit" name="create" id="createStockBtn" class="btn btn-primary soft-btn w-100" style="height: 50px;">
                                        <i class="fas fa-plus-circle"></i> <?php echo $editMode ? 'Update Stock' : 'Add Stock'; ?>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stock List Table -->
            <div class="row mt-4">
                <div class="col-lg-12 mx-auto">
                    <div class="card" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;">
                        <div class="card-body">
                            <h4 class="card-title">Stock List</h4>
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Product Name</th>
                                        <th>Unit Type</th>
                                        <th>Items per Unit</th>
                                        <th>Unit Description</th>
                                        <th>Pack</th>
                                        <th>Unit Stock</th>
                                        <th>Final Stock</th>
                                        <th>Per Item Purchase</th>
                                        <th>Per Item Selling</th>
                                        <th>Per Item MRP</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = "SELECT p.product_id, p.product_name, p.unit, p.units_per_pack, p.unit_description, p.quantity, p.purchase_rate, p.rate, p.mrp 
                                            FROM product p 
                                            WHERE p.status = 1";
                                    $result = $connect->query($sql);
                                    $index = 1;
                                    while ($row = $result->fetch_assoc()) {
                                        $unitStock = $row['unit_description'] ? $row['quantity'] / $row['unit_description'] : 0;
                                        $pack = '1*' . $row['unit_description'];
                                        echo "<tr>
                                            <td>$index</td>
                                            <td>{$row['product_name']}</td>
                                            <td>{$row['unit']}</td>
                                            <td>{$row['units_per_pack']}</td>
                                            <td>{$row['unit_description']}</td>
                                            <td>$pack</td>
                                            <td>$unitStock</td>
                                            <td>{$row['quantity']}</td>
                                            <td>{$row['purchase_rate']}</td>
                                            <td>{$row['rate']}</td>
                                            <td>{$row['mrp']}</td>
                                            <td>
                                                <a href='stock_management.php?edit_id={$row['product_id']}' class='btn btn-sm btn-primary'>Edit</a>
                                                <a href='php_action/deleteStock.php?id={$row['product_id']}' class='btn btn-sm btn-danger' onclick='return confirm(\"Are you sure you want to delete this stock?\");'>Delete</a>
                                            </td>
                                        </tr>";
                                        $index++;
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include('./constant/layout/footer.php'); ?>
</body>
</html>
