<?php 
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('../constant/connect.php');

// Check if supplier ID is provided
if(!isset($_GET['supplier_id']) || empty($_GET['supplier_id'])) {
    header("Location: suppliers.php");
    exit();
}

$supplier_id = intval($_GET['supplier_id']);

// Get supplier details
$supplier_query = $connect->query("SELECT * FROM suppliers WHERE supplier_id = '$supplier_id'");
if($supplier_query->num_rows == 0) {
    echo "<script>alert('Supplier not found!'); window.location.href='suppliers.php';</script>";
    exit();
}
$supplier = $supplier_query->fetch_assoc();

// Handle ledger entry form submission
if($_POST && isset($_POST['add_ledger_entry'])) {
    $transaction_date = $_POST['transaction_date'];
    $transaction_type = $_POST['transaction_type'];
    $description = $_POST['description'];
    $amount = floatval($_POST['amount']);
    $reference = $_POST['reference'];
    $created_by = $_SESSION['user_id'] ?? 1; // Replace with actual session user ID
    
    // Calculate new balance
    $last_balance_query = $connect->query("SELECT balance FROM supplier_ledger WHERE supplier_id = '$supplier_id' ORDER BY ledger_id DESC LIMIT 1");
    $last_balance = $last_balance_query->num_rows > 0 ? $last_balance_query->fetch_assoc()['balance'] : 0;
    
    $debit = 0;
    $credit = 0;
    $new_balance = $last_balance;
    
    if($transaction_type == 'purchase') {
        $debit = $amount;
        $new_balance += $amount;
    } else if($transaction_type == 'payment') {
        $credit = $amount;
        $new_balance -= $amount;
    } else if($transaction_type == 'adjustment') {
        // For adjustments, positive amount increases balance, negative decreases
        if($amount > 0) {
            $debit = $amount;
            $new_balance += $amount;
        } else {
            $credit = abs($amount);
            $new_balance += $amount; // amount is negative here
        }
    }
    
    // Insert ledger entry
    $connect->query("INSERT INTO supplier_ledger (supplier_id, transaction_date, transaction_type, description, debit, credit, balance, reference, created_by) 
                    VALUES ('$supplier_id', '$transaction_date', '$transaction_type', '$description', '$debit', '$credit', '$new_balance', '$reference', '$created_by')");
    
    $message = '<div class="alert alert-success">Ledger entry added successfully!</div>';
}

// Get ledger entries
$ledger_query = $connect->query("SELECT * FROM supplier_ledger WHERE supplier_id = '$supplier_id' ORDER BY transaction_date DESC, ledger_id DESC");
$total_balance = 0;
$last_balance_query = $connect->query("SELECT balance FROM supplier_ledger WHERE supplier_id = '$supplier_id' ORDER BY ledger_id DESC LIMIT 1");
if($last_balance_query->num_rows > 0) {
    $total_balance = $last_balance_query->fetch_assoc()['balance'];
}
?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">
                <i class="fas fa-book me-2"></i>Supplier Ledger: <?php echo $supplier['supplier_name']; ?>
            </h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item"><a href="suppliers.php">Suppliers</a></li>
                <li class="breadcrumb-item active">Ledger</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <?php if(isset($message)) echo $message; ?>
        
        <!-- Supplier Info Card -->
        <div class="row mb-4">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3">
                                <h6>Supplier Information</h6>
                                <p><strong>Name:</strong> <?php echo $supplier['supplier_name']; ?></p>
                                <p><strong>Contact:</strong> <?php echo $supplier['contact_person']; ?></p>
                            </div>
                            <div class="col-md-3">
                                <h6>Contact Details</h6>
                                <p><strong>Phone:</strong> <?php echo $supplier['phone']; ?></p>
                                <p><strong>Email:</strong> <?php echo $supplier['email']; ?></p>
                            </div>
                            <div class="col-md-3">
                                <h6>Address</h6>
                                <p><?php echo $supplier['address']; ?></p>
                            </div>
                            <div class="col-md-3 text-center">
                                <div class="bg-<?php echo $total_balance > 0 ? 'danger' : 'success'; ?> text-white p-3 rounded">
                                    <h5>Current Balance</h5>
                                    <h3>₹ <?php echo number_format(abs($total_balance), 2); ?></h3>
                                    <small><?php echo $total_balance > 0 ? 'You owe' : 'Credit balance'; ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Add Ledger Entry Form -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Add Ledger Entry</h5>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <div class="mb-3">
                                <label class="form-label">Transaction Date</label>
                                <input type="datetime-local" name="transaction_date" class="form-control" required 
                                       value="<?php echo date('Y-m-d\TH:i'); ?>">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Transaction Type</label>
                                <select name="transaction_type" class="form-control" required>
                                    <option value="purchase">Purchase (You owe supplier)</option>
                                    <option value="payment">Payment (You pay supplier)</option>
                                    <option value="adjustment">Adjustment</option>
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <input type="text" name="description" class="form-control" required 
                                       placeholder="e.g., Purchase of medicines, Payment made, etc.">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Amount (₹)</label>
                                <input type="number" step="0.01" name="amount" class="form-control" required 
                                       placeholder="0.00" min="0.01">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Reference</label>
                                <input type="text" name="reference" class="form-control" 
                                       placeholder="Invoice #, Receipt #, etc.">
                            </div>
                            
                            <button type="submit" name="add_ledger_entry" class="btn btn-primary w-100">
                                <i class="fas fa-plus-circle me-1"></i> Add Entry
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Ledger Entries -->
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title">Ledger Transactions</h5>
                        <div>
                            <button class="btn btn-sm btn-outline-primary" onclick="printLedger()">
                                <i class="fas fa-print me-1"></i> Print
                            </button>
                            <button class="btn btn-sm btn-outline-secondary" onclick="exportToExcel()">
                                <i class="fas fa-download me-1"></i> Export
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="ledgerTable">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Description</th>
                                        <th>Reference</th>
                                        <th>Debit</th>
                                        <th>Credit</th>
                                        <th>Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $running_balance = 0;
                                    if($ledger_query->num_rows > 0):
                                        while($entry = $ledger_query->fetch_assoc()): 
                                            $running_balance = $entry['balance'];
                                    ?>
                                    <tr>
                                        <td><?php echo date('M d, Y h:i A', strtotime($entry['transaction_date'])); ?></td>
                                        <td>
                                            <span class="badge bg-<?php 
                                                echo $entry['transaction_type'] == 'purchase' ? 'warning' : 
                                                     ($entry['transaction_type'] == 'payment' ? 'success' : 'info'); 
                                            ?>">
                                                <?php echo ucfirst($entry['transaction_type']); ?>
                                            </span>
                                        </td>
                                        <td><?php echo $entry['description']; ?></td>
                                        <td><?php echo $entry['reference'] ?: '-'; ?></td>
                                        <td class="text-danger"><?php echo $entry['debit'] > 0 ? number_format($entry['debit'], 2) : '-'; ?></td>
                                        <td class="text-success"><?php echo $entry['credit'] > 0 ? number_format($entry['credit'], 2) : '-'; ?></td>
                                        <td class="fw-bold <?php echo $entry['balance'] > 0 ? 'text-danger' : 'text-success'; ?>">
                                            ₹ <?php echo number_format(abs($entry['balance']), 2); ?>
                                            <small><?php echo $entry['balance'] > 0 ? '(You owe)' : '(Credit)'; ?></small>
                                        </td>
                                    </tr>
                                    <?php 
                                        endwhile;
                                    else:
                                    ?>
                                    <tr>
                                        <td colspan="7" class="text-center py-4">
                                            <i class="fas fa-receipt fa-3x text-muted mb-3"></i>
                                            <p class="text-muted">No ledger entries found for this supplier.</p>
                                            <p class="text-muted">Add your first transaction using the form on the left.</p>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                                <?php if($ledger_query->num_rows > 0): ?>
                                <tfoot>
                                    <tr class="fw-bold">
                                        <td colspan="4" class="text-end">Current Balance:</td>
                                        <td class="text-danger">₹ <?php echo number_format($connect->query("SELECT SUM(debit) as total_debit FROM supplier_ledger WHERE supplier_id = '$supplier_id'")->fetch_assoc()['total_debit'] ?? 0, 2); ?></td>
                                        <td class="text-success">₹ <?php echo number_format($connect->query("SELECT SUM(credit) as total_credit FROM supplier_ledger WHERE supplier_id = '$supplier_id'")->fetch_assoc()['total_credit'] ?? 0, 2); ?></td>
                                        <td class="<?php echo $total_balance > 0 ? 'text-danger' : 'text-success'; ?>">
                                            ₹ <?php echo number_format(abs($total_balance), 2); ?>
                                            <small><?php echo $total_balance > 0 ? '(You owe)' : '(Credit)'; ?></small>
                                        </td>
                                    </tr>
                                </tfoot>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.bg-danger { background: linear-gradient(45deg, #dc3545, #c82333); }
.bg-success { background: linear-gradient(45deg, #28a745, #20c997); }
.bg-warning { background: linear-gradient(45deg, #ffc107, #fd7e14); }
.bg-info { background: linear-gradient(45deg, #17a2b8, #138496); }

.card {
    border: none;
    border-radius: 10px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    margin-bottom: 24px;
}

.card-header {
    background: linear-gradient(120deg, #f8f9fa 0%, #ffffff 100%);
    border-bottom: 1px solid #e3e6f0;
    padding: 15px 20px;
    border-radius: 10px 10px 0 0 !important;
}

.table th {
    background-color: #f8f9fa;
    font-weight: 600;
    color: #495057;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}

.badge {
    padding: 6px 10px;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 600;
}
</style>

<script>
function printLedger() {
    const printContent = document.getElementById('ledgerTable').outerHTML;
    const originalContent = document.body.innerHTML;
    
    document.body.innerHTML = `
        <html>
            <head>
                <title>Supplier Ledger - <?php echo $supplier['supplier_name']; ?></title>
                <style>
                    body { font-family: Arial, sans-serif; }
                    table { width: 100%; border-collapse: collapse; }
                    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                    th { background-color: #f8f9fa; font-weight: bold; }
                    .text-danger { color: #dc3545; }
                    .text-success { color: #28a745; }
                    .badge { padding: 4px 8px; border-radius: 4px; font-size: 12px; }
                </style>
            </head>
            <body>
                <h2>Supplier Ledger: <?php echo $supplier['supplier_name']; ?></h2>
                <p>Generated on: <?php echo date('F j, Y, g:i a'); ?></p>
                ${printContent}
            </body>
        </html>
    `;
    
    window.print();
    document.body.innerHTML = originalContent;
    window.location.reload();
}

function exportToExcel() {
    const table = document.getElementById('ledgerTable');
    let csv = [];
    
    // Add headers
    const headers = [];
    for (let i = 0; i < table.rows[0].cells.length; i++) {
        headers.push(table.rows[0].cells[i].textContent);
    }
    csv.push(headers.join(','));
    
    // Add rows
    for (let i = 1; i < table.rows.length; i++) {
        const row = [];
        for (let j = 0; j < table.rows[i].cells.length; j++) {
            row.push('"' + table.rows[i].cells[j].textContent.replace(/"/g, '""') + '"');
        }
        csv.push(row.join(','));
    }
    
    // Create download link
    const csvString = csv.join('\n');
    const link = document.createElement('a');
    link.href = 'data:text/csv;charset=utf-8,' + encodeURIComponent(csvString);
    link.download = 'supplier_ledger_<?php echo $supplier['supplier_name']; ?>_<?php echo date('Y-m-d'); ?>.csv';
    link.click();
}
</script>

<?php include('./constant/layout/footer.php'); ?>