<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('../constant/connect.php'); ?>

<?php
// Handle form submission for suppliers
if($_POST && isset($_POST['supplier_name'])) {
    $supplier_name = $_POST['supplier_name'];
    $contact_person = $_POST['contact_person'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $address = $_POST['address'];

    if(isset($_POST['supplier_id']) && $_POST['supplier_id'] != '') {
        // Update supplier
        $supplier_id = $_POST['supplier_id'];
        $connect->query("UPDATE suppliers SET
            supplier_name='$supplier_name',
            contact_person='$contact_person',
            email='$email',
            phone='$phone',
            address='$address'
            WHERE supplier_id='$supplier_id'
        ");
        $message = '<div class="alert alert-success alert-modern">Supplier updated successfully!</div>';
    } else {
        // Insert new supplier
        $connect->query("INSERT INTO suppliers (supplier_name, contact_person, email, phone, address) VALUES
        ('$supplier_name','$contact_person','$email','$phone','$address')");
        $message = '<div class="alert alert-success alert-modern">Supplier added successfully!</div>';
    }
}

// Handle medicine addition for suppliers
if($_POST && isset($_POST['medicine_name'])) {
    $supplier_id = $_POST['supplier_id_med'];
    $medicine_name = $_POST['medicine_name'];
    $category = $_POST['category'];
    $price = $_POST['price'];

    // Insert new medicine for supplier
    $connect->query("INSERT INTO supplier_medicines (supplier_id, medicine_name, category, price) VALUES
    ('$supplier_id','$medicine_name','$category','$price')");
    
    $message = '<div class="alert alert-success alert-modern">Medicine added successfully!</div>';
}

// Handle delete supplier
if(isset($_GET['delete'])) {
    $delete_id = $_GET['delete'];
    $connect->query("DELETE FROM suppliers WHERE supplier_id='$delete_id'");
    $message = '<div class="alert alert-success alert-modern">Supplier deleted successfully!</div>';
}

// Handle delete medicine
if(isset($_GET['delete_med'])) {
    $delete_id = $_GET['delete_med'];
    $connect->query("DELETE FROM supplier_medicines WHERE id='$delete_id'");
    $message = '<div class="alert alert-success alert-modern">Medicine deleted successfully!</div>';
}

// Fetch all suppliers
$suppliers = $connect->query("SELECT * FROM suppliers ORDER BY supplier_id DESC");

// Fetch all categories for medicine form
$categories = $connect->query("SELECT * FROM categories ORDER BY categories_name");
?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary"><i class="fas fa-truck-loading me-2"></i>Supplier Management</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item active">Suppliers</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <?php if(isset($message)) echo $message; ?>
        
        <!-- Stats Overview -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-primary">
                                <i class="fas fa-truck"></i>
                            </div>
                            <div class="ms-3">
                                <h5 class="card-title mb-0">Total Suppliers</h5>
                                <p class="card-text"><?php echo $suppliers->num_rows; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-success">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div class="ms-3">
                                <h5 class="card-title mb-0">Active</h5>
                                <p class="card-text"><?php echo $suppliers->num_rows; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-info">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="ms-3">
                                <h5 class="card-title mb-0">With Contact</h5>
                                <p class="card-text"><?php echo $suppliers->num_rows; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-warning">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <div class="ms-3">
                                <h5 class="card-title mb-0">With Email</h5>
                                <p class="card-text"><?php echo $suppliers->num_rows; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card card-modern">
                    <div class="card-header card-header-modern d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="card-title"><i class="fas fa-list me-2"></i>Suppliers List</h4>
                            <p class="card-subtitle">Manage all your suppliers in one place</p>
                        </div>
                        <div class="d-flex">
                            <button class="btn btn-primary-modern me-2" data-bs-toggle="modal" data-bs-target="#addSupplierModal">
                                <i class="fas fa-plus-circle me-1"></i> Add Supplier
                            </button>
                           
                            <input type="text" id="searchInput" class="form-control-modern me-2" placeholder="Search suppliers...">
                            <button class="btn btn-primary-modern" id="refreshBtn">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table-modern" id="suppliersTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Contact Person</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Address</th>
                                        <th>Medicines</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($row = $suppliers->fetch_assoc()): 
                                        // Fetch medicines for this supplier
                                        $supplier_id = $row['supplier_id'];
                                        $medicines = $connect->query("SELECT * FROM supplier_medicines WHERE supplier_id='$supplier_id'");
                                        $medicine_count = $medicines->num_rows;
                                    ?>
                                    <tr>
                                        <td><?php echo $row['supplier_id']; ?></td>
                                        <td><?php echo $row['supplier_name']; ?></td>
                                        <td><?php echo $row['contact_person']; ?></td>
                                        <td><?php echo $row['email']; ?></td>
                                        <td><?php echo $row['phone']; ?></td>
                                        <td><?php echo strlen($row['address']) > 30 ? substr($row['address'], 0, 30) . '...' : $row['address']; ?></td>
                                        <td>
                                            <span class="badge bg-primary"><?php echo $medicine_count; ?> medicines</span>
                                            <?php if($medicine_count > 0): ?>
                                            <button class="btn btn-sm btn-info-modern view-medicines-btn" 
                                                data-supplier-id="<?php echo $row['supplier_id']; ?>"
                                                data-supplier-name="<?php echo $row['supplier_name']; ?>">
                                                <i class="fas fa-eye me-1"></i> View
                                            </button>
                                            <?php endif; ?>
                                        </td>
                                        <td>  <a href="supledger.php?supplier_id=<?php echo $row['supplier_id']; ?>" class="btn btn-sm btn-danger-modern">
        <i class="fas fa-book me-1"></i> Ledger
    </a>
                                        
                                            <button class="btn btn-sm btn-success-modern edit-btn" 
                                                data-id="<?php echo $row['supplier_id']; ?>"
                                                data-name="<?php echo $row['supplier_name']; ?>"
                                                data-contact="<?php echo $row['contact_person']; ?>"
                                                data-email="<?php echo $row['email']; ?>"
                                                data-phone="<?php echo $row['phone']; ?>"
                                                data-address="<?php echo $row['address']; ?>"
                                                data-bs-toggle="modal" data-bs-target="#addSupplierModal"
                                            >
                                                <i class="fas fa-edit me-1"></i> Edit
                                            </button>
                                            <a href="?delete=<?php echo $row['supplier_id']; ?>" class="btn btn-sm btn-danger-modern" onclick="return confirm('Are you sure you want to delete this supplier?')">
                                                <i class="fas fa-trash-alt me-1"></i> Delete
                                            </a>
                                            <button class="btn btn-sm btn-primary-modern add-med-btn" 
                                                data-supplier-id="<?php echo $row['supplier_id']; ?>"
                                                data-supplier-name="<?php echo $row['supplier_name']; ?>"
                                                data-bs-toggle="modal" data-bs-target="#addMedicineModal"
                                            >
                                                <i class="fas fa-pills me-1"></i> Add Medicine
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php if($suppliers->num_rows == 0): ?>
                        <div class="text-center py-4">
                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No suppliers found. Add your first supplier.</p>
                            <button class="btn btn-primary-modern" data-bs-toggle="modal" data-bs-target="#addSupplierModal">
                                <i class="fas fa-plus-circle me-1"></i> Add Supplier
                            </button>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add/Edit Supplier Modal -->
<div class="modal fade" id="addSupplierModal" tabindex="-1" aria-labelledby="addSupplierModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addSupplierModalLabel">Add New Supplier</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="post" class="form-modern" id="supplierForm">
                    <input type="hidden" name="supplier_id" id="supplier_id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group-modern">
                                <label class="form-label">Supplier Name <span class="text-danger">*</span></label>
                                <div class="input-with-icon">
                                    <i class="fas fa-building"></i>
                                    <input type="text" name="supplier_name" id="supplier_name" class="form-control-modern" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group-modern">
                                <label class="form-label">Contact Person</label>
                                <div class="input-with-icon">
                                    <i class="fas fa-user"></i>
                                    <input type="text" name="contact_person" id="contact_person" class="form-control-modern">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group-modern">
                                <label class="form-label">Email</label>
                                <div class="input-with-icon">
                                    <i class="fas fa-envelope"></i>
                                    <input type="email" name="email" id="email" class="form-control-modern">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group-modern">
                                <label class="form-label">Phone</label>
                                <div class="input-with-icon">
                                    <i class="fas fa-phone"></i>
                                    <input type="text" name="phone" id="phone" class="form-control-modern">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group-modern mt-3">
                        <label class="form-label">Address</label>
                        <div class="input-with-icon">
                            <i class="fas fa-map-marker-alt"></i>
                            <textarea name="address" id="address" class="form-control-modern" rows="3"></textarea>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="submit" form="supplierForm" class="btn btn-primary-modern">
                    <i class="fas fa-save me-1"></i> Save Supplier
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Add Medicine Modal -->
<div class="modal fade" id="addMedicineModal" tabindex="-1" aria-labelledby="addMedicineModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addMedicineModalLabel">Add New Medicine</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="post" id="medicineForm">
                    <input type="hidden" name="supplier_id_med" id="supplier_id_med">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="supplier_select" class="form-label">Supplier <span class="text-danger">*</span></label>
                                <select class="form-control" id="supplier_select" name="supplier_select" required>
                                    <option value="">Select Supplier</option>
                                    <?php 
                                    $suppliers_list = $connect->query("SELECT * FROM suppliers ORDER BY supplier_name");
                                    while($supplier = $suppliers_list->fetch_assoc()): 
                                    ?>
                                    <option value="<?php echo $supplier['supplier_id']; ?>"><?php echo $supplier['supplier_name']; ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="medicine_name" class="form-label">Medicine Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="medicine_name" name="medicine_name" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="category" class="form-label">Category</label>
                                <select class="form-control" id="category" name="category">
                                    <option value="">Select Category</option>
                                    <?php 
                                    // Reset pointer for categories
                                    $categories->data_seek(0);
                                    while($cat = $categories->fetch_assoc()): ?>
                                    <option value="<?php echo $cat['categories_name']; ?>"><?php echo $cat['categories_name']; ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="price" class="form-label">Price</label>
                                <input type="number" step="0.01" class="form-control" id="price" name="price" placeholder="0.00">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="submit" form="medicineForm" class="btn btn-primary">Add Medicine</button>
            </div>
        </div>
    </div>
</div>

<!-- View Medicines Modal -->
<div class="modal fade" id="viewMedicinesModal" tabindex="-1" aria-labelledby="viewMedicinesModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewMedicinesModalLabel">Medicines for <span id="supplierNameTitle"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="medicinesTable">
                        <thead>
                            <tr>
                                <th>Medicine Name</th>
                                <th>Category</th>
                                <th>Price</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="medicinesList">
                            <!-- Medicines will be loaded here via AJAX -->
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<style>
/* Modern Design System */
:root {
    --primary: #4361ee;
    --primary-light: #4895ef;
    --secondary: #3f37c9;
    --success: #4cc9f0;
    --danger: #f72585;
    --warning: #f8961e;
    --info: #560bad;
    --dark: #212529;
    --light: #f8f9fa;
    --gray: #6c757d;
    --border: #dee2e6;
    --card-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    --transition: all 0.3s ease;
}

/* Stats Cards */
.stat-card {
    border: none;
    border-radius: 12px;
    box-shadow: var(--card-shadow);
    transition: var(--transition);
    margin-bottom: 0;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
}

.stat-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
}

.bg-primary { background: var(--primary); }
.bg-success { background: var(--success); }
.bg-info { background: var(--info); }
.bg-warning { background: var(--warning); }

/* Modern Card */
.card-modern {
    border: none;
    border-radius: 12px;
    box-shadow: var(--card-shadow);
    transition: var(--transition);
    margin-bottom: 24px;
}

.card-modern:hover {
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
}

.card-header-modern {
    background: linear-gradient(120deg, #f8f9fa 0%, #ffffff 100%);
    border-bottom: 1px solid var(--border);
    padding: 20px 25px;
    border-radius: 12px 12px 0 0 !important;
}

.card-header-modern .card-title {
    font-weight: 600;
    color: var(--dark);
    margin-bottom: 5px;
}

.card-header-modern .card-subtitle {
    color: var(--gray);
    font-size: 0.875rem;
    margin: 0;
}

/* Form Elements */
.form-modern {
    padding: 0 5px;
}

.form-group-modern {
    margin-bottom: 20px;
}

.form-label {
    font-weight: 500;
    color: var(--dark);
    margin-bottom: 8px;
    display: block;
}

.input-with-icon {
    position: relative;
}

.input-with-icon i {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--gray);
    z-index: 1;
}

.form-control-modern {
    width: 100%;
    padding: 12px 15px 12px 45px;
    border: 1px solid var(--border);
    border-radius: 8px;
    background-color: #fff;
    transition: var(--transition);
    font-size: 0.95rem;
}

.form-control-modern:focus {
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15);
    outline: none;
}

textarea.form-control-modern {
    min-height: 100px;
    resize: vertical;
}

/* Buttons */
.form-actions {
    padding: 20px 0 10px;
}

.btn-primary-modern {
    background: var(--primary);
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 8px;
    font-weight: 500;
    transition: var(--transition);
    box-shadow: 0 4px 10px rgba(67, 97, 238, 0.3);
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-primary-modern:hover {
    background: var(--secondary);
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(67, 97, 238, 0.4);
    color: white;
}

.btn-secondary-modern {
    background: white;
    color: var(--dark);
    border: 1px solid var(--border);
    padding: 10px 20px;
    border-radius: 8px;
    font-weight: 500;
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-secondary-modern:hover {
    background: var(--light);
}

.btn-success-modern {
    background: var(--success);
    color: white;
    border: none;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 0.875rem;
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-success-modern:hover {
    background: #3aafd9;
    color: white;
    transform: translateY(-2px);
}

.btn-danger-modern {
    background: var(--danger);
    color: white;
    border: none;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 0.875rem;
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-danger-modern:hover {
    background: #e30b67;
    color: white;
    transform: translateY(-2px);
}

.btn-info-modern {
    background: var(--info);
    color: white;
    border: none;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 0.875rem;
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-info-modern:hover {
    background: #4a08a0;
    color: white;
    transform: translateY(-2px);
}

/* Table */
.table-modern {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

.table-modern th, .table-modern td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid var(--border);
}

.table-modern th {
    background: #f8f9fa;
    font-weight: 600;
    color: var(--dark);
    position: sticky;
    top: 0;
}

.table-modern tr:hover {
    background-color: #f8f9fa;
}

/* Badge */
.badge {
    padding: 5px 10px;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 600;
}

/* Alert */
.alert-modern {
    border-radius: 8px;
    border: none;
    box-shadow: var(--card-shadow);
    padding: 15px 20px;
    margin-bottom: 20px;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Responsive */
@media (max-width: 768px) {
    .card-header-modern .d-flex {
        flex-direction: column;
    }
    
    .card-header-modern .d-flex .btn {
        margin-top: 10px;
        width: 100%;
    }
    
    .table-modern {
        display: block;
        overflow-x: auto;
    }
}
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>

function printSuppliers() {
    // Clone the table container
    var printContents = document.querySelector('.table-responsive').innerHTML;
    
    // Open a new window for printing
    var originalContents = document.body.innerHTML;
    var printWindow = window.open('', '', 'height=600,width=1000');
    
    printWindow.document.write('<html><head><title>Suppliers List</title>');
    printWindow.document.write('<style>');
    printWindow.document.write('table { width: 100%; border-collapse: collapse; }');
    printWindow.document.write('th, td { border: 1px solid #000; padding: 8px; text-align: left; }');
    printWindow.document.write('th { background-color: #f8f9fa; }');
    printWindow.document.write('</style>');
    printWindow.document.write('</head><body>');
    printWindow.document.write('<h3>Suppliers List</h3>');
    printWindow.document.write(printContents);
    printWindow.document.write('</body></html>');
    
    printWindow.document.close();
    printWindow.print();
}

$(document).ready(function() {
    // Fill edit form when edit button is clicked
    $('.edit-btn').click(function(){
        $('#supplier_id').val($(this).data('id'));
        $('#supplier_name').val($(this).data('name'));
        $('#contact_person').val($(this).data('contact'));
        $('#email').val($(this).data('email'));
        $('#phone').val($(this).data('phone'));
        $('#address').val($(this).data('address'));
        
        // Update modal title
        $('#addSupplierModalLabel').text('Edit Supplier');
    });
    
    // Reset form when modal is hidden
    $('#addSupplierModal').on('hidden.bs.modal', function () {
        $('#supplierForm')[0].reset();
        $('#supplier_id').val('');
        $('#addSupplierModalLabel').text('Add New Supplier');
    });
    
    // Set supplier ID when Add Medicine button is clicked for a specific supplier
    $('.add-med-btn').click(function(){
        $('#supplier_select').val($(this).data('supplier-id'));
        $('#supplier_id_med').val($(this).data('supplier-id'));
    });
    
    // Search functionality
    $('#searchInput').on('keyup', function() {
        const searchText = $(this).val().toLowerCase();
        $('#suppliersTable tbody tr').each(function() {
            const text = $(this).text().toLowerCase();
            $(this).toggle(text.includes(searchText));
        });
    });
    
    // Refresh button
    $('#refreshBtn').click(function() {
        window.location.reload();
    });
    
    // View medicines button
    $('.view-medicines-btn').click(function(){
        const supplierId = $(this).data('supplier-id');
        const supplierName = $(this).data('supplier-name');
        
        // Set the supplier name in the modal title
        $('#supplierNameTitle').text(supplierName);
        
        // Load medicines via AJAX
        $.ajax({
            url: 'get_medicines.php',
            type: 'GET',
            data: { supplier_id: supplierId },
            success: function(response) {
                $('#medicinesList').html(response);
                
                // Open the modal
                $('#viewMedicinesModal').modal('show');
            },
            error: function() {
                alert('Error loading medicines');
            }
        });
    });
    
    // Auto-hide alerts after 5 seconds
    setTimeout(() => {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>

<?php include('./constant/layout/footer.php'); ?>