<?php 
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('./constant/connect.php'); 
?>
<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Unit Management</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Unit Management</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12" >
                <div class="card">
                    <div class="card-title d-flex justify-content-between align-items-center">
                        <h4>Manage Units</h4>
                        <button type="button" class="btn btn-primary btn-add" onclick="openModal('addUnitModal')">
                            <i class="fa fa-plus"></i> Add New Unit
                        </button>
                    </div>
                    <div id="add-unit-messages"></div>
                    <div id="success-message" class="alert alert-success" style="display: none;">
                        <button type="button" class="close" onclick="this.parentElement.style.display='none';">&times;</button>
                        <strong><i class="glyphicon glyphicon-ok-sign"></i></strong> Operation completed successfully!
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="unitTable" class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Unit Name</th>
                                        <th>Created At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = "SELECT * FROM units WHERE deleted = 0 ORDER BY id DESC";
                                    $result = $connect->query($sql);
                                    if ($result->num_rows > 0) {
                                        while($row = $result->fetch_assoc()) {
                                            echo '<tr>
                                                <td>'.$row["id"].'</td>
                                                <td>'.$row["unit_name"].'</td>
                                                <td>'.date('M j, Y', strtotime($row["created_at"])).'</td>
                                                <td>
                                                    <button type="button" class="btn btn-info btn-sm editBtn" data-id="'.$row["id"].'">
                                                        <i class="fa fa-pencil"></i> Edit
                                                    </button>
                                                    <button type="button" class="btn btn-danger btn-sm deleteBtn" data-id="'.$row["id"].'">
                                                        <i class="fa fa-trash"></i> Delete
                                                    </button>
                                                </td>
                                            </tr>';
                                        }
                                    } else {
                                        echo '<tr><td colspan="4" class="text-center">No units found</td></tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
/* Global Body */
body {
    background: #f5f7fa;
    font-family: 'Segoe UI', sans-serif;
    color: #333;
}

/* Card Styling */
.card {
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0, 0, 0, .1);
    transition: .3s ease-in-out;
    border: none;
}
.card:hover {
    transform: translateY(-3px);
}

/* Table Styling */
#unitTable {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
    text-align: center;
}
#unitTable thead th {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: #fff;
    padding: 12px 8px;
    text-transform: uppercase;
    border-bottom: 2px solid #ddd;
}
#unitTable tbody td {
    padding: 10px;
    border: 1px solid #ddd;
}
#unitTable tbody tr:nth-child(even) {
    background-color: #f9f9f9;
}
#unitTable tbody tr:hover {
    background-color: #eef3ff;
    cursor: pointer;
}

/* Buttons */
.btn {
    border: none;
    transition: all .3s ease-in-out;
}
.btn-primary {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: #fff;
}
.btn-primary:hover {
    background: linear-gradient(135deg, #556cd6, #5b379a);
}
.btn-info {
    background: linear-gradient(135deg, #17a2b8, #39c0d6);
    color: #fff;
}
.btn-info:hover {
    background: linear-gradient(135deg, #138496, #2faec7);
}
.btn-danger {
    background: linear-gradient(135deg, #dc3545, #f66);
    color: #fff;
}
.btn-danger:hover {
    background: linear-gradient(135deg, #bd2130, #e55353);
}
.btn-secondary {
    background: #6c757d;
    color: #fff;
}
.btn-secondary:hover {
    background: #565e64;
}

/* Inputs */
.soft-input {
    border-radius: 12px;
    padding: 10px;
    border: 1px solid #ccc;
    transition: all .3s ease-in-out;
}
.soft-input:focus {
    border-color: #667eea;
    box-shadow: 0 0 5px rgba(102,126,234,0.5);
    outline: none;
}

/* Modals */
.modal-content {
    border-radius: 15px;
    overflow: hidden;
}
.modal-header {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: #fff;
}
.modal-footer {
    border-top: none;
}
.close {
    text-shadow: none;
    color: #fff;
    opacity: 1;
}
.close:hover {
    color: #ffd6e0;
}

/* Alerts */
.alert-success {
    border-radius: 10px;
    border: none;
    background: linear-gradient(135deg, #28a745, #58d68d);
    color: #fff;
    box-shadow: 0 5px 15px rgba(40,167,69,0.3);
}
</style>

<!-- Add Unit Modal -->
<div class="modal fade" id="addUnitModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Unit</h5>
                <button type="button" class="close text-white" onclick="closeModal('addUnitModal')">&times;</button>
            </div>
            <form id="addUnitForm" method="POST">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Unit Name</label>
                        <input type="text" class="form-control soft-input" name="unit_name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save Unit</button>
                    <button type="button" class="btn btn-secondary" onclick="closeModal('addUnitModal')" style="background-color:red">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Unit Modal -->
<div class="modal fade" id="editUnitModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Unit</h5>
                <button type="button" class="close text-white" onclick="closeModal('editUnitModal')">&times;</button>
            </div>
            <form id="editUnitForm" method="POST">
                <div class="modal-body">
                    <input type="hidden" id="edit_id" name="id">
                    <div class="form-group">
                        <label>Unit Name</label>
                        <input type="text" class="form-control soft-input" id="edit_unit_name" name="unit_name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary mr-auto">Update Unit</button>
                    <button type="button" class="btn btn-secondary" onclick="closeModal('editUnitModal')" style="background-color:red">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteUnitModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="close text-white" onclick="closeModal('deleteUnitModal')">&times;</button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this unit?</p>
                <input type="hidden" id="delete_id">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('deleteUnitModal')">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">Delete</button>
            </div>
        </div>
    </div>
</div>

<script>
function openModal(id){
    $('#'+id).modal('show');
}
function closeModal(id){
    $('#'+id).modal('hide');
}

$(document).ready(function() {
    $('#unitTable').DataTable();

    if (sessionStorage.getItem('showSuccessMessage') === 'true') {
        $('#success-message').show();
        sessionStorage.removeItem('showSuccessMessage');
        setTimeout(()=>$('#success-message').fadeOut(),3000);
    }

    // ADD
    $('#addUnitForm').submit(function(e){
        e.preventDefault();
        $.post('createUnit.php', $(this).serialize(), function(response){
            if(response.success){
                closeModal('addUnitModal');
                sessionStorage.setItem('showSuccessMessage','true');
                location.reload();
            } else alert(response.message);
        },'json');
    });

    // EDIT
    $(document).on('click','.editBtn',function(){
        var id=$(this).data('id');
        $.post('getUnit.php',{id:id},function(res){
            if(res.success){
                $('#edit_id').val(res.data.id);
                $('#edit_unit_name').val(res.data.unit_name);
                openModal('editUnitModal');
            } else alert(res.message);
        },'json');
    });

    $('#editUnitForm').submit(function(e){
        e.preventDefault();
        $.post('updateUnit.php', $(this).serialize(), function(response){
            if(response.success){
                closeModal('editUnitModal');
                sessionStorage.setItem('showSuccessMessage','true');
                location.reload();
            } else alert(response.message);
        },'json');
    });

    // DELETE
    $(document).on('click','.deleteBtn',function(){
        $('#delete_id').val($(this).data('id'));
        openModal('deleteUnitModal');
    });

    $('#confirmDelete').click(function(){
        $.post('deleteUnit.php',{id:$('#delete_id').val()},function(response){
            if(response.success){
                closeModal('deleteUnitModal');
                sessionStorage.setItem('showSuccessMessage','true');
                location.reload();
            } else alert(response.message);
        },'json');
    });
});
</script>
<?php include('./constant/layout/footer.php');?>
