<?php
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('./constant/connect.php');
?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Wholesale Invoices</h3> 
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item active">Wholesale Invoices</li>
            </ol>
        </div>
    </div>
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-title">
                        <h4>Manage Wholesale Invoices</h4>
                        <a href="wholesale-invoice.php" class="btn btn-success float-right">
                            <i class="fa fa-plus"></i> Create New Invoice
                        </a>
                    </div>
                    
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="wholesaleOrdersTable">
                                <thead>
                                    <tr>
                                        <th>Invoice No</th>
                                        <th>Vendor Name</th>
                                        <th>Date</th>
                                        <th>Grand Total</th>
                                        <th>Paid Amount</th>
                                        <th>Due Amount</th>
                                        <th>Payment Status</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = "SELECT * FROM wholesale_orders WHERE delete_status = 0 ORDER BY created_at DESC";
                                    $result = $connect->query($sql);
                                    
                                    while ($row = $result->fetch_assoc()):
                                        $status_badge = $row['is_edited'] ? 
                                            '<span class="badge badge-warning">Edited</span>' : 
                                            '<span class="badge badge-success">Original</span>';
                                        
                                        $payment_status = '';
                                        switch ($row['payment_status']) {
                                            case 1: $payment_status = '<span class="badge badge-success">Full Payment</span>'; break;
                                            case 2: $payment_status = '<span class="badge badge-info">Advance Payment</span>'; break;
                                            case 3: $payment_status = '<span class="badge badge-warning">Part Payment</span>'; break;
                                            case 4: $payment_status = '<span class="badge badge-danger">No Payment</span>'; break;
                                        }
                                    ?>
                                        <tr>
                                            <td><?php echo $row['invoice_no']; ?></td>
                                            <td><?php echo htmlspecialchars($row['vendor_name']); ?></td>
                                            <td><?php echo date('M j, Y', strtotime($row['invoice_date'])); ?></td>
                                            <td>₹<?php echo number_format($row['grand_total'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['paid_amount'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['due_amount'], 2); ?></td>
                                            <td><?php echo $payment_status; ?></td>
                                            <td><?php echo $status_badge; ?></td>
                                            <td>
                                                <a href="wholesale_edit.php?id=<?php echo $row['id']; ?>" 
                                                   class="btn btn-primary btn-sm" title="Edit">
                                                    <i class="fa fa-edit"></i>
                                                </a>
                                                <a href="view_wholesale_invoice.php?id=<?php echo $row['id']; ?>" 
                                                   class="btn btn-info btn-sm" title="View">
                                                    <i class="fa fa-eye"></i>
                                                </a>
                                                <button onclick="deleteInvoice(<?php echo $row['id']; ?>)" 
                                                        class="btn btn-danger btn-sm" title="Delete">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('./constant/layout/footer.php'); ?>

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap4.min.css">
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap4.min.js"></script>

<script>
$(document).ready(function() {
    $('#wholesaleOrdersTable').DataTable({
        "order": [[2, "desc"]]
    });
});

function deleteInvoice(orderId) {
    if (confirm('Are you sure you want to delete this invoice? This action cannot be undone!')) {
        $.ajax({
            url: 'php_action/delete_wholesale_order.php',
            type: 'POST',
            data: { order_id: orderId },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    alert('Invoice deleted successfully!');
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            }
        });
    }
}
</script>