<?php include('./constant/layout/head.php');?>
<?php include('./constant/layout/header.php');?>
<?php include('./constant/layout/sidebar.php');?>
<?php include('./constant/connect.php'); ?>
<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Wholesale Invoice Management</h3> 
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item active">Wholesale Invoice</li>
            </ol>
        </div>
    </div>
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-title"></div>
                    <div id="add-brand-messages"></div>
                    <!-- Success message container -->
                    <div id="success-message" class="alert alert-success" style="display: none;">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <strong><i class="glyphicon glyphicon-ok-sign"></i></strong> Wholesale invoice added successfully!
                    </div>
                    <div class="card-body">
                        <div class="input-states">
                            <form class="form-horizontal" method="POST" id="createWholesaleOrderForm" action="php_action/wholesale_order.php">
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice No</label>
                                        <div class="col-sm-4">
                                            <?php 
                                            $wholesaleQuery = "SELECT * FROM wholesale_orders WHERE id=(SELECT MAX(id) FROM wholesale_orders)";
                                            $wholesaleResult = $connect->query($wholesaleQuery);
                                            $wholesaleRes = $wholesaleResult->fetch_assoc();
                                            
                                            $n = "WS-INV-000";
                                            $l = ($wholesaleRes ? $wholesaleRes['id'] : 0) + 1;
                                            $invoice_no = $n."".$l; 
                                            ?>
                                            <input type="text" class="form-control soft-input" placeholder="Invoice Number" value="<?php echo $invoice_no; ?>" autocomplete="off" name="invoice_no" required readonly/>
                                        </div>
                                        <label class="col-sm-2 control-label">Vendor GSTIN</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="vendor_gstn" name="vendor_gstn" placeholder="Vendor GSTIN Number" autocomplete="off" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice Date</label>
                                        <div class="col-sm-4">
                                            <input type="date" class="form-control soft-input" value="<?php echo date('Y-m-d');?>" id="invoice_date" name="invoice_date" autocomplete="off" required />
                                        </div>
                                        <label class="col-sm-2 control-label">Invoice Time</label>
                                        <div class="col-sm-4">
                                            <input type="time" class="form-control soft-input" value="<?php echo date('H:i');?>" id="invoice_time" name="invoice_time" autocomplete="off" required />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Vendor Name</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="vendor_name" name="vendor_name" placeholder="Vendor Name" autocomplete="off" required />
                                        </div>
                                        <label class="col-sm-2 control-label">Vendor Contact No.</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="vendor_contact" name="vendor_contact" placeholder="Contact Number" autocomplete="off" pattern="^[0][1-9]\d{9}$|^[1-9]\d{9}$" required/>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">               
                                    <table class="table" id="productTable">
                                        <thead>
                                            <tr>              
                                                <th style="width:25%;">Medicine</th>
                                                <th style="width:10%;">Batch No</th>
                                                <th style="width:10%;">Expiry</th>
                                                <th style="width:8%;">Unit Price</th>
                                                <th style="width:8%;">Avail.</th>
                                                <th style="width:8%;">Quantity</th>
                                                <th style="width:8%;">SGST %</th>
                                                <th style="width:8%;">CGST %</th>
                                                <th style="width:8%;">Discount %</th>
                                                <th style="width:10%;">Total</th>             
                                                <th style="width:5%;">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $arrayNumber = 0;
                                            for($x = 1; $x < 2; $x++) { ?>
                                                <tr id="row<?php echo $x; ?>" class="<?php echo $arrayNumber; ?>">                
                                                    <td>
                                                       <style>
/* Increase Select2 container height */
.select2-container--default .select2-selection--single {
    height: 50px !important;
    line-height: 50px !important; /* vertically center text */
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 50px !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 50px !important;
}
</style>

<div class="form-group">
    <select class="form-control select2-product" 
            name="productName[]" 
            id="productName<?php echo $x; ?>" 
            onchange="getProductData(<?php echo $x; ?>)" 
            required>
        <option value="">~~SELECT~~</option>
        <?php
        $productSql = "
            SELECT 
                p.product_id,
                p.product_name,
                p.bno,
                p.expdate,
                p.quantity,
                p.pack_selling_rate as rate,
                p.sgst,
                p.cgst,
                c.categories_name
            FROM product p
            INNER JOIN categories c ON p.categories_id = c.categories_id
            WHERE p.active = 1 AND p.status = 1 AND p.quantity != 0
            ORDER BY p.product_name
        ";
        $productData = $connect->query($productSql);

        while ($row = $productData->fetch_assoc()) {                     
            echo "<option value='".$row['product_id']."' 
                    data-bno='".$row['bno']."'
                    data-expdate='".$row['expdate']."'
                    data-rate='".$row['rate']."'
                    data-sgst='".$row['sgst']."'
                    data-cgst='".$row['cgst']."'
                    data-quantity='".$row['quantity']."'>
                    ".$row['product_name']." - ".$row['categories_name']."
                 </option>";
        }
        ?>
    </select>
</div>

<script>
$(document).ready(function() {
    $('.select2-product').select2();
});
</script>

                                                    </td>
                                                    <td>
                                                        <input type="text" name="batch_no[]" id="batch_no<?php echo $x; ?>" autocomplete="off" class="form-control soft-input" readonly />
                                                    </td>
                                                    <td>
                                                        <input type="text" name="expiry_date[]" id="expiry_date<?php echo $x; ?>" autocomplete="off" class="form-control soft-input" readonly />
                                                    </td>
                                                    <td>                 
                                                        <input type="text" name="unit_price[]" id="unit_price<?php echo $x; ?>" autocomplete="off" class="form-control soft-input" readonly />
                                                        <input type="hidden" name="unit_price_value[]" id="unit_price_value<?php echo $x; ?>" autocomplete="off" class="form-control" />                  
                                                    </td>
                                                    <td>
                                                        <div class="form-group">
                                                            <p id="available_quantity<?php echo $x; ?>" class="form-control-static">0</p>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="form-group">
                                                            <input type="number" name="quantity[]" id="quantity<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control soft-input" min="1" required />
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="number" name="sgst_percentage[]" id="sgst_percentage<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control soft-input" value="0" step="0.01" />
                                                    </td>
                                                    <td>
                                                        <input type="number" name="cgst_percentage[]" id="cgst_percentage<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control soft-input" value="0" step="0.01" />
                                                    </td>
                                                    <td>
                                                        <input type="number" name="discount_percentage_item[]" id="discount_percentage_item<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control soft-input" value="0" step="0.01" />
                                                    </td>
                                                    <td>                 
                                                        <input type="text" name="total[]" id="total<?php echo $x; ?>" autocomplete="off" class="form-control soft-input" readonly />
                                                        <input type="hidden" name="total_value[]" id="total_value<?php echo $x; ?>" autocomplete="off" class="form-control" />                  
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-primary btn-flat soft-btn" onclick="addRow()" id="addRowBtn"><i class="fa fa-plus"></i></button>
                                                        <button type="button" class="btn btn-danger removeProductRowBtn soft-btn" onclick="removeProductRow(<?php echo $x; ?>)"><i class="fa fa-trash"></i></button>
                                                    </td>
                                                </tr>
                                            <?php
                                            $arrayNumber++;
                                            }
                                            ?>
                                        </tbody>          
                                    </table>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Sub Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="sub_total" name="sub_total" readonly />
                                            <input type="hidden" class="form-control" id="sub_total_value" name="sub_total_value" />
                                        </div>
                                        <label for="total_amount" class="col-sm-2 control-label">Total Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="total_amount" name="total_amount" readonly/>
                                            <input type="hidden" class="form-control" id="total_amount_value" name="total_amount_value" />
                                        </div>
                                    </div>
                                </div>
                               
                                <div class="form-group">
                                    <div class="row">
                                        <label for="discount_percentage" class="col-sm-2 control-label">Overall Discount %</label>
                                        <div class="col-sm-4">
                                            <input type="number" class="form-control soft-input" id="discount_percentage" name="discount_percentage" onkeyup="discountFunc()" autocomplete="off" value="0" step="0.01" />
                                        </div>
                                        <label for="grand_total" class="col-sm-2 control-label">Grand Total</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="grand_total" name="grand_total" readonly />
                                            <input type="hidden" class="form-control" id="grand_total_value" name="grand_total_value" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label for="sgst_total" class="col-sm-2 control-label">Total SGST</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="sgst_total" name="sgst_total" readonly />
                                            <input type="hidden" class="form-control" id="sgst_total_value" name="sgst_total_value" />
                                        </div>
                                        <label for="cgst_total" class="col-sm-2 control-label">Total CGST</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="cgst_total" name="cgst_total" readonly />
                                            <input type="hidden" class="form-control" id="cgst_total_value" name="cgst_total_value" />
                                        </div>
                                    </div>
                                </div>
                               
                                <div class="form-group">
                                    <div class="row">
                                        <label for="paid_amount" class="col-sm-2 control-label">Paid Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="paid_amount" name="paid_amount" autocomplete="off" onkeyup="paidAmount()" required />
                                        </div>
                                        <label for="due_amount" class="col-sm-2 control-label">Due Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control soft-input" id="due_amount" name="due_amount" readonly />
                                            <input type="hidden" class="form-control" id="due_amount_value" name="due_amount_value" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label for="payment_type" class="col-sm-2 control-label">Payment Type</label>
                                        <div class="col-sm-4">
                                            <select class="form-control soft-input" name="payment_type" id="payment_type" required style="height:50px !important">
                                                <option value="">~~SELECT~~</option>
                                                <option value="2">Cash</option>
                                                <option value="4">Phone Pe</option>
                                                <option value="5">Google Pay</option>
                                                <option value="6">Amazon Pay</option>
                                                <option value="1">Cheque</option>
                                                <option value="3">Credit Card</option>
                                                <option value="7">Bank Transfer</option>
                                            </select>
                                        </div>
                                        <label for="payment_status" class="col-sm-2 control-label">Payment Status</label>
                                        <div class="col-sm-4">
                                            <select class="form-control soft-input" name="payment_status" id="payment_status" required style="height:50px !important">
                                                <option value="">~~SELECT~~</option>
                                                <option value="1">Full Payment</option>
                                                <option value="2">Advance Payment</option>
                                                <option value="3">No Payment</option>
                                                <option value="4">Part Payment</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group submitButtonFooter">
                                    <div class="col-sm-offset-2 col-sm-10">
                                        <button type="submit" id="createWholesaleOrderBtn" data-loading-text="Loading..." class="btn btn-success btn-flat m-b-30 m-t-30 soft-btn">
                                            <i class="glyphicon glyphicon-ok-sign"></i> Create Wholesale Invoice
                                        </button>
                                        <button type="reset" class="btn btn-danger btn-flat m-b-30 m-t-30 soft-btn" onclick="resetOrderForm()">
                                            <i class="glyphicon glyphicon-erase"></i> Reset
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.soft-input {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 10px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
}

.soft-input:focus {
    border-color: #4a6cf7;
    box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
    outline: none;
}

.soft-btn {
    padding: 8px 16px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
}

.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}

.select2-container--default .select2-selection--single {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    height: 44px;
    padding: 6px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 42px;
}
</style>

<?php include('./constant/layout/footer.php');?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function () {
    $('.select2-product').select2({
        placeholder: "Search for a medicine",
        allowClear: true
    });

    // Auto focus search field when select2 opens
    $(document).on('select2:open', () => {
        document.querySelector('.select2-container--open .select2-search__field').focus();
    });

    // Check if we should show success message from session storage
    if (sessionStorage.getItem('showWholesaleSuccessMessage') === 'true') {
        $('#success-message').show();
        sessionStorage.removeItem('showWholesaleSuccessMessage');
    }
});

/* ================= CALCULATION FUNCTIONS =================== */
function getTotal(row = null) {
    if (!row) { alert('no row !! please refresh the page'); return; }

    var unitPrice = Number($("#unit_price" + row).val());
    var quantity = Number($("#quantity" + row).val());
    var sgstPercentage = Number($("#sgst_percentage" + row).val());
    var cgstPercentage = Number($("#cgst_percentage" + row).val());
    var discountPercentage = Number($("#discount_percentage_item" + row).val());

    var baseAmount = unitPrice * quantity;
    var discountAmount = (baseAmount * discountPercentage) / 100;
    var discountedAmount = baseAmount - discountAmount;

    var sgstAmount = (discountedAmount * sgstPercentage) / 100;
    var cgstAmount = (discountedAmount * cgstPercentage) / 100;

    var total = discountedAmount + sgstAmount + cgstAmount;
    total = total.toFixed(2);

    $("#total" + row).val(total);
    $("#total_value" + row).val(total);

    subAmount();
}

function subAmount() {
    var tableProductLength = $("#productTable tbody tr").length;
    var totalSubAmount = 0, totalSgst = 0, totalCgst = 0;

    for (x = 0; x < tableProductLength; x++) {
        var tr = $("#productTable tbody tr")[x];
        var count = $(tr).attr('id');
        count = count.substring(3);

        totalSubAmount += Number($("#total" + count).val());

        var unitPrice = Number($("#unit_price" + count).val());
        var quantity = Number($("#quantity" + count).val());
        var sgstPercentage = Number($("#sgst_percentage" + count).val());
        var cgstPercentage = Number($("#cgst_percentage" + count).val());
        var discountPercentage = Number($("#discount_percentage_item" + count).val());

        var productSubtotal = unitPrice * quantity;
        var productDiscount = (productSubtotal * discountPercentage) / 100;

        var discountedAmount = productSubtotal - productDiscount;
        totalSgst += (discountedAmount * sgstPercentage) / 100;
        totalCgst += (discountedAmount * cgstPercentage) / 100;
    }

    totalSubAmount = totalSubAmount.toFixed(2);
    totalSgst = totalSgst.toFixed(2);
    totalCgst = totalCgst.toFixed(2);

    $("#sub_total, #sub_total_value").val(totalSubAmount);
    $("#sgst_total, #sgst_total_value").val(totalSgst);
    $("#cgst_total, #cgst_total_value").val(totalCgst);

    var totalAmount = Number(totalSubAmount).toFixed(2);
    $("#total_amount, #total_amount_value").val(totalAmount);

    var discountPercentage = $("#discount_percentage").val();
    if (discountPercentage) {
        var discountAmount = (Number(totalAmount) * Number(discountPercentage)) / 100;
        var grandTotal = Number(totalAmount) - discountAmount;
        grandTotal = grandTotal.toFixed(2);
        $("#grand_total, #grand_total_value").val(grandTotal);
    } else {
        $("#grand_total, #grand_total_value").val(totalAmount);
    }

    var paidAmount = $("#paid_amount").val();
    if (paidAmount) {
        var dueAmount = Number($("#grand_total").val()) - Number(paidAmount);
        dueAmount = dueAmount.toFixed(2);
        $("#due_amount, #due_amount_value").val(dueAmount);
    } else {
        $("#due_amount, #due_amount_value").val($("#grand_total").val());
    }
}

function discountFunc() {
    var discountPercentage = $("#discount_percentage").val();
    var totalAmount = Number($("#total_amount").val()).toFixed(2);

    if (totalAmount) {
        var discountAmount = (Number(totalAmount) * Number(discountPercentage)) / 100;
        var grandTotal = Number(totalAmount) - discountAmount;
        grandTotal = grandTotal.toFixed(2);
        $("#grand_total, #grand_total_value").val(grandTotal);
    }

    var paid = $("#paid_amount").val();
    var dueAmount;
    if (paid) {
        dueAmount = Number($("#grand_total").val()) - Number($("#paid_amount").val());
        dueAmount = dueAmount.toFixed(2);
        $("#due_amount, #due_amount_value").val(dueAmount);
    } else {
        $("#due_amount, #due_amount_value").val($("#grand_total").val());
    }
}

function paidAmount() {
    var grandTotal = $("#grand_total").val();
    if (grandTotal) {
        var dueAmount = Number($("#grand_total").val()) - Number($("#paid_amount").val());
        dueAmount = dueAmount.toFixed(2);
        $("#due_amount, #due_amount_value").val(dueAmount);
    }
}

/* ================= DYNAMIC ROWS =================== */
function addRow() {
    $("#addRowBtn").button("loading");

    var tableLength = $("#productTable tbody tr").length;
    var count = tableLength > 0 ? Number($("#productTable tbody tr:last").attr('id').substring(3)) + 1 : 1;
    var arrayNumber = tableLength > 0 ? Number($("#productTable tbody tr:last").attr('class')) + 1 : 0;

    var tr = '<tr id="row' + count + '" class="' + arrayNumber + '">' +
        '<td><select class="form-control select2-product" name="productName[]" id="productName' + count + '" onchange="getProductData(' + count + ')" required>' +
        '<option value="">~~SELECT~~</option>' +
        <?php
        $productOptions = "";
        $productSql = "SELECT product_id, product_name, categories_name FROM product p INNER JOIN categories c ON p.categories_id = c.categories_id WHERE p.active = 1 AND p.status = 1 ORDER BY p.product_name";
        $productData = $connect->query($productSql);
        while ($row = $productData->fetch_assoc()) {
            $productOptions .= '<option value="'.$row['product_id'].'">'.$row['product_name'].' - '.$row['categories_name'].'</option>';
        }
        echo "'".addslashes($productOptions)."'";
        ?> +
        '</select></td>' +
        '<td><input type="text" name="batch_no[]" id="batch_no' + count + '" class="form-control soft-input" readonly /></td>' +
        '<td><input type="text" name="expiry_date[]" id="expiry_date' + count + '" class="form-control soft-input" readonly /></td>' +
        '<td><input type="text" name="unit_price[]" id="unit_price' + count + '" class="form-control soft-input" readonly />' +
        '<input type="hidden" name="unit_price_value[]" id="unit_price_value' + count + '"/></td>' +
        '<td><p id="available_quantity' + count + '" class="form-control-static">0</p></td>' +
        '<td><input type="number" name="quantity[]" id="quantity' + count + '" onkeyup="getTotal(' + count + ')" min="1" class="form-control soft-input" required/></td>' +
        '<td><input type="number" name="sgst_percentage[]" id="sgst_percentage' + count + '" onkeyup="getTotal(' + count + ')" value="0" step="0.01" class="form-control soft-input"/></td>' +
        '<td><input type="number" name="cgst_percentage[]" id="cgst_percentage' + count + '" onkeyup="getTotal(' + count + ')" value="0" step="0.01" class="form-control soft-input"/></td>' +
        '<td><input type="number" name="discount_percentage_item[]" id="discount_percentage_item' + count + '" onkeyup="getTotal(' + count + ')" value="0" step="0.01" class="form-control soft-input"/></td>' +
        '<td><input type="text" name="total[]" id="total' + count + '" class="form-control soft-input" readonly/>' +
        '<input type="hidden" name="total_value[]" id="total_value' + count + '"/></td>' +
        '<td><button type="button" class="btn btn-primary btn-flat soft-btn" onclick="addRow()"><i class="fa fa-plus"></i></button>' +
        '<button type="button" class="btn btn-danger removeProductRowBtn soft-btn" onclick="removeProductRow(' + count + ')"><i class="fa fa-trash"></i></button></td>' +
        '</tr>';

    if (tableLength > 0) {
        $("#productTable tbody tr:last").after(tr);
    } else {
        $("#productTable tbody").append(tr);
    }

    $('.select2-product').select2({
        placeholder: "Search for a medicine",
        allowClear: true
    });

    $("#addRowBtn").button("reset");
}

function removeProductRow(row = null) {
    if (!row) { alert('error! Refresh the page again'); return; }
    $("#row" + row).remove();
    subAmount();
}

/* ================= FETCH SELECTED PRODUCT =================== */
function getProductData(row = null) {
    if (!row) { alert('no row! please refresh the page'); return; }

    var productId = $("#productName" + row).val();
    if (productId === "") {
        $("#unit_price" + row).val("");
        $("#quantity" + row).val("");
        $("#total" + row).val("");
        $("#batch_no" + row).val("");
        $("#expiry_date" + row).val("");
        $("#available_quantity" + row).text("0");
        return;
    }

    var selectedOption = $("#productName" + row + " option:selected");
    
    // Get data from data attributes
    var batchNo = selectedOption.data('bno');
    var expiryDate = selectedOption.data('expdate');
    var unitPrice = selectedOption.data('rate');
    var sgst = selectedOption.data('sgst');
    var cgst = selectedOption.data('cgst');
    var availableQty = selectedOption.data('quantity');

    $("#batch_no" + row).val(batchNo);
    $("#expiry_date" + row).val(expiryDate);
    $("#unit_price" + row).val(unitPrice);
    $("#unit_price_value" + row).val(unitPrice);
    $("#available_quantity" + row).text(availableQty);
    
    // Set default GST values from database if available
    if (sgst && sgst > 0) {
        $("#sgst_percentage" + row).val(sgst);
    }
    if (cgst && cgst > 0) {
        $("#cgst_percentage" + row).val(cgst);
    }
    
    $("#quantity" + row).val(1);
    getTotal(row);
}

/* ================= FORM SUBMISSION =================== */
$("#createWholesaleOrderForm").unbind('submit').bind('submit', function () {
    var form = $(this);
    $('.form-group').removeClass('has-error').removeClass('has-success');
    $('.text-danger').remove();

    // Validate required fields
    var requiredFields = ['invoice_date', 'invoice_time', 'vendor_name', 'vendor_contact', 'payment_type', 'payment_status', 'paid_amount'];
    var isValid = true;

    $.each(requiredFields, function (index, field) {
        var value = $("#" + field).val();
        if (value == "") {
            $("#" + field).after('<p class="text-danger"> This field is required </p>');
            $("#" + field).closest('.form-group').addClass('has-error');
            isValid = false;
        } else {
            $("#" + field).closest('.form-group').addClass('has-success');
        }
    });

    // Validate product rows
    var productRows = $("#productTable tbody tr");
    if (productRows.length == 0) {
        $("#productTable").after('<p class="text-danger"> At least one product is required </p>');
        isValid = false;
    }

    productRows.each(function () {
        var row = $(this);
        var productName = row.find('select[name="productName[]"]').val();
        var quantity = row.find('input[name="quantity[]"]').val();
        if (!productName) {
            row.find('select[name="productName[]"]').after('<p class="text-danger"> Product is required </p>');
            isValid = false;
        }
        if (!quantity || quantity < 1) {
            row.find('input[name="quantity[]"]').after('<p class="text-danger"> Valid quantity is required </p>');
            isValid = false;
        }
    });

    if (!isValid) return false;

    // Submit via AJAX
    $("#createWholesaleOrderBtn").button('loading');

    $.ajax({
        url: form.attr('action'),
        type: form.attr('method'),
        data: form.serialize(),
        dataType: 'json',
        success: function (response) {
            $("#createWholesaleOrderBtn").button('reset');
            $(".text-danger").remove();
            $('.form-group').removeClass('has-error').removeClass('has-success');

            if (response.success === true) {
                // Show success message
                $('#success-message').show();
                
                // Store success state in session storage for page refresh
                sessionStorage.setItem('showWholesaleSuccessMessage', 'true');
                
                // Reset the form
                form[0].reset();
                
                // Reset the product table to one row
                $("#productTable tbody tr:not(:first)").remove();
                
                // Reset calculations
                $("#sub_total, #sub_total_value").val("0");
                $("#total_amount, #total_amount_value").val("0");
                $("#grand_total, #grand_total_value").val("0");
                $("#sgst_total, #sgst_total_value").val("0");
                $("#cgst_total, #cgst_total_value").val("0");
                $("#due_amount, #due_amount_value").val("0");
                
                // Scroll to top to show the success message
                $("html, body").animate({ scrollTop: 0 }, "slow");
                
            } else {
                alert(response.messages);
            }
        },
        error: function (xhr) {
            $("#createWholesaleOrderBtn").button('reset');
            console.error('create wholesale order failed', xhr.status, xhr.responseText);
            alert('Error submitting form. Server says:\n' + xhr.responseText);
        }
    });

    return false;
});

// Function to reset the order form
function resetOrderForm() {
    document.getElementById("createWholesaleOrderForm").reset();
    $("#productTable tbody tr:not(:first)").remove();
    $("#sub_total, #sub_total_value").val("0");
    $("#total_amount, #total_amount_value").val("0");
    $("#grand_total, #grand_total_value").val("0");
    $("#sgst_total, #sgst_total_value").val("0");
    $("#cgst_total, #cgst_total_value").val("0");
    $("#due_amount, #due_amount_value").val("0");
    $("#success-message").hide();
    sessionStorage.removeItem('showWholesaleSuccessMessage');
}
</script>