<?php 
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('./constant/connect.php');

// Get order ID from URL
$order_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if (!$order_id) {
    echo "<script>alert('Invalid order ID!'); window.history.back();</script>";
    exit();
}

// Fetch order details
$orderSql = "SELECT * FROM wholesale_orders WHERE id = ? AND delete_status = 0";
$orderStmt = $connect->prepare($orderSql);
$orderStmt->bind_param("i", $order_id);
$orderStmt->execute();
$orderResult = $orderStmt->get_result();
$order = $orderResult->fetch_assoc();

if (!$order) {
    echo "<script>alert('Order not found!'); window.history.back();</script>";
    exit();
}

// Fetch order items
$itemsSql = "SELECT oi.*, p.product_name, p.bno, p.expdate, p.quantity as available_qty 
             FROM wholesale_order_items oi 
             LEFT JOIN product p ON oi.product_id = p.product_id 
             WHERE oi.wholesale_order_id = ?";
$itemsStmt = $connect->prepare($itemsSql);
$itemsStmt->bind_param("i", $order_id);
$itemsStmt->execute();
$itemsResult = $itemsStmt->get_result();
$order_items = $itemsResult->fetch_all(MYSQLI_ASSOC);
?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Edit Wholesale Invoice</h3> 
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item"><a href="wholesale-invoice.php">Wholesale Invoices</a></li>
                <li class="breadcrumb-item active">Edit Invoice</li>
            </ol>
        </div>
    </div>
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-title">
                        <h4>Edit Wholesale Invoice: <?php echo $order['invoice_no']; ?></h4>
                    </div>
                    
                    <!-- Success/Error Messages -->
                    <div id="success-message" class="alert alert-success alert-dismissible fade show" style="display: none;">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <strong><i class="fa fa-check-circle"></i></strong> <span id="success-text"></span>
                    </div>
                    
                    <div id="error-message" class="alert alert-danger alert-dismissible fade show" style="display: none;">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <strong><i class="fa fa-exclamation-circle"></i></strong> <span id="error-text"></span>
                    </div>
                    
                    <div class="card-body">
                        <div class="input-states">
                            <form class="form-horizontal" method="POST" id="editWholesaleOrderForm" action="php_action/update_wholesale_order.php">
                                <input type="hidden" name="order_id" value="<?php echo $order_id; ?>">
                                
                                <!-- Invoice Basic Information -->
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <label class="control-label">Invoice No</label>
                                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($order['invoice_no']); ?>" readonly />
                                        </div>
                                        <div class="col-sm-6">
                                            <label class="control-label">Vendor GSTIN</label>
                                            <input type="text" class="form-control" id="vendor_gstn" name="vendor_gstn" 
                                                   value="<?php echo htmlspecialchars($order['vendor_gstn']); ?>" placeholder="Vendor GSTIN Number" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <label class="control-label">Invoice Date *</label>
                                            <input type="date" class="form-control" id="invoice_date" name="invoice_date" 
                                                   value="<?php echo $order['invoice_date']; ?>" required />
                                        </div>
                                        <div class="col-sm-6">
                                            <label class="control-label">Original Created Date</label>
                                            <input type="text" class="form-control" value="<?php echo date('Y-m-d H:i', strtotime($order['created_at'])); ?>" readonly />
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Vendor Information -->
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <label class="control-label">Vendor Name *</label>
                                            <input type="text" class="form-control" id="vendor_name" name="vendor_name" 
                                                   value="<?php echo htmlspecialchars($order['vendor_name']); ?>" required />
                                        </div>
                                        <div class="col-sm-6">
                                            <label class="control-label">Vendor Contact No. *</label>
                                            <input type="text" class="form-control" id="vendor_contact" name="vendor_contact" 
                                                   value="<?php echo htmlspecialchars($order['vendor_contact']); ?>" required />
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Edit Reason -->
                                <div class="form-group">
                                    <label class="control-label">Reason for Editing *</label>
                                    <textarea class="form-control" id="edit_reason" name="edit_reason" 
                                              placeholder="Please specify the reason for editing this invoice..." required></textarea>
                                </div>
                                
                                <!-- Products Table -->
                                <div class="form-group">
                                    <label class="control-label">Products *</label>
                                    <div class="table-responsive">               
                                        <table class="table table-bordered" id="productTable">
                                            <thead class="thead-light">
                                                <tr>              
                                                    <th>Medicine</th>
                                                    <th>Batch No</th>
                                                    <th>Expiry</th>
                                                    <th>Unit Price</th>
                                                    <th>Avail.</th>
                                                    <th>Quantity</th>
                                                    <th>SGST %</th>
                                                    <th>CGST %</th>
                                                    <th>Discount %</th>
                                                    <th>Total</th>             
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php 
                                                $item_count = 0;
                                                foreach ($order_items as $item): 
                                                    $item_count++;
                                                ?>
                                                    <tr id="row<?php echo $item_count; ?>">
                                                        <td>
                                                            <select class="form-control select2-product" name="productName[]" 
                                                                    id="productName<?php echo $item_count; ?>" 
                                                                    onchange="getProductData(<?php echo $item_count; ?>)" required>
                                                                <option value="">~~SELECT MEDICINE~~</option>
                                                                <?php
                                                                $productSql = "SELECT product_id, product_name, categories_name 
                                                                              FROM product p 
                                                                              INNER JOIN categories c ON p.categories_id = c.categories_id 
                                                                              WHERE p.active = 1 AND p.status = 1 
                                                                              ORDER BY p.product_name";
                                                                $productData = $connect->query($productSql);
                                                                while ($product = $productData->fetch_assoc()): 
                                                                    $selected = ($product['product_id'] == $item['product_id']) ? 'selected' : '';
                                                                ?>
                                                                    <option value="<?php echo $product['product_id']; ?>" 
                                                                            data-bno="<?php echo htmlspecialchars($item['bno']); ?>"
                                                                            data-expdate="<?php echo $item['expdate']; ?>"
                                                                            data-rate="<?php echo $item['unit_price']; ?>"
                                                                            data-sgst="<?php echo $item['sgst_percentage']; ?>"
                                                                            data-cgst="<?php echo $item['cgst_percentage']; ?>"
                                                                            data-quantity="<?php echo $item['available_qty']; ?>"
                                                                            <?php echo $selected; ?>>
                                                                        <?php echo $product['product_name'] . ' - ' . $product['categories_name']; ?>
                                                                    </option>
                                                                <?php endwhile; ?>
                                                            </select>
                                                            <input type="hidden" name="item_id[]" value="<?php echo $item['id']; ?>">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="batch_no[]" id="batch_no<?php echo $item_count; ?>" 
                                                                   class="form-control" value="<?php echo htmlspecialchars($item['bno']); ?>" readonly />
                                                        </td>
                                                        <td>
                                                            <input type="text" name="expiry_date[]" id="expiry_date<?php echo $item_count; ?>" 
                                                                   class="form-control" value="<?php echo $item['expdate']; ?>" readonly />
                                                        </td>
                                                        <td>
                                                            <input type="text" name="unit_price[]" id="unit_price<?php echo $item_count; ?>" 
                                                                   class="form-control" value="<?php echo $item['unit_price']; ?>" readonly />
                                                            <input type="hidden" name="unit_price_value[]" id="unit_price_value<?php echo $item_count; ?>" 
                                                                   value="<?php echo $item['unit_price']; ?>" />
                                                        </td>
                                                        <td>
                                                            <span id="available_quantity<?php echo $item_count; ?>" class="badge badge-info">
                                                                <?php echo $item['available_qty']; ?>
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <input type="number" name="quantity[]" id="quantity<?php echo $item_count; ?>" 
                                                                   onkeyup="getTotal(<?php echo $item_count; ?>)" 
                                                                   class="form-control" value="<?php echo $item['quantity']; ?>" min="1" required />
                                                        </td>
                                                        <td>
                                                            <input type="number" name="sgst_percentage[]" id="sgst_percentage<?php echo $item_count; ?>" 
                                                                   onkeyup="getTotal(<?php echo $item_count; ?>)" 
                                                                   class="form-control" value="<?php echo $item['sgst_percentage']; ?>" step="0.01" min="0" max="100" />
                                                        </td>
                                                        <td>
                                                            <input type="number" name="cgst_percentage[]" id="cgst_percentage<?php echo $item_count; ?>" 
                                                                   onkeyup="getTotal(<?php echo $item_count; ?>)" 
                                                                   class="form-control" value="<?php echo $item['cgst_percentage']; ?>" step="0.01" min="0" max="100" />
                                                        </td>
                                                        <td>
                                                            <input type="number" name="discount_percentage_item[]" id="discount_percentage_item<?php echo $item_count; ?>" 
                                                                   onkeyup="getTotal(<?php echo $item_count; ?>)" 
                                                                   class="form-control" value="<?php echo $item['discount_percentage']; ?>" step="0.01" min="0" max="100" />
                                                        </td>
                                                        <td>
                                                            <input type="text" name="total[]" id="total<?php echo $item_count; ?>" 
                                                                   class="form-control" value="<?php echo $item['total_price']; ?>" readonly />
                                                            <input type="hidden" name="total_value[]" id="total_value<?php echo $item_count; ?>" 
                                                                   value="<?php echo $item['total_price']; ?>" />
                                                        </td>
                                                        <td>
                                                            <?php if ($item_count > 1): ?>
                                                                <button type="button" class="btn btn-danger btn-sm" onclick="removeProductRow(<?php echo $item_count; ?>)">
                                                                    <i class="fa fa-times"></i>
                                                                </button>
                                                            <?php else: ?>
                                                                <button type="button" class="btn btn-primary btn-sm" onclick="addRow()">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>          
                                        </table>
                                    </div>
                                </div>
                                
                                <!-- Amount Calculations -->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">Sub Amount</label>
                                            <input type="text" class="form-control bg-light" id="sub_total" name="sub_total" 
                                                   value="<?php echo $order['sub_total']; ?>" readonly />
                                            <input type="hidden" id="sub_total_value" name="sub_total_value" value="<?php echo $order['sub_total']; ?>" />
                                        </div>
                                        
                                        <div class="form-group">
                                            <label class="control-label">Overall Discount %</label>
                                            <input type="number" class="form-control" id="discount_percentage" name="discount_percentage" 
                                                   onkeyup="discountFunc()" value="<?php echo $order['discount_percentage']; ?>" step="0.01" min="0" max="100" />
                                        </div>
                                        
                                        <div class="form-group">
                                            <label class="control-label">Total SGST</label>
                                            <input type="text" class="form-control bg-light" id="sgst_total" name="sgst_total" 
                                                   value="<?php echo $order['sgst_total']; ?>" readonly />
                                            <input type="hidden" id="sgst_total_value" name="sgst_total_value" value="<?php echo $order['sgst_total']; ?>" />
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">Total Amount</label>
                                            <input type="text" class="form-control bg-light" id="total_amount" name="total_amount" 
                                                   value="<?php echo $order['total_amount']; ?>" readonly />
                                            <input type="hidden" id="total_amount_value" name="total_amount_value" value="<?php echo $order['total_amount']; ?>" />
                                        </div>
                                        
                                        <div class="form-group">
                                            <label class="control-label">Grand Total</label>
                                            <input type="text" class="form-control bg-light font-weight-bold" id="grand_total" name="grand_total" 
                                                   value="<?php echo $order['grand_total']; ?>" readonly />
                                            <input type="hidden" id="grand_total_value" name="grand_total_value" value="<?php echo $order['grand_total']; ?>" />
                                        </div>
                                        
                                        <div class="form-group">
                                            <label class="control-label">Total CGST</label>
                                            <input type="text" class="form-control bg-light" id="cgst_total" name="cgst_total" 
                                                   value="<?php echo $order['cgst_total']; ?>" readonly />
                                            <input type="hidden" id="cgst_total_value" name="cgst_total_value" value="<?php echo $order['cgst_total']; ?>" />
                                        </div>
                                    </div>
                                </div>
                               
                                <!-- Payment Information -->
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <label class="control-label">Paid Amount *</label>
                                            <input type="number" class="form-control" id="paid_amount" name="paid_amount" 
                                                   onkeyup="paidAmount()" value="<?php echo $order['paid_amount']; ?>" required min="0" step="0.01" />
                                        </div>
                                        <div class="col-sm-4">
                                            <label class="control-label">Due Amount</label>
                                            <input type="text" class="form-control bg-light" id="due_amount" name="due_amount" 
                                                   value="<?php echo $order['due_amount']; ?>" readonly />
                                            <input type="hidden" id="due_amount_value" name="due_amount_value" value="<?php echo $order['due_amount']; ?>" />
                                        </div>
                                        <div class="col-sm-4">
                                            <label class="control-label">Payment Type *</label>
                                            <select class="form-control" name="payment_type" id="payment_type" required>
                                                <option value="">~~SELECT~~</option>
                                                <option value="1" <?php echo $order['payment_type'] == 1 ? 'selected' : ''; ?>>Cash</option>
                                                <option value="2" <?php echo $order['payment_type'] == 2 ? 'selected' : ''; ?>>Cheque</option>
                                                <option value="3" <?php echo $order['payment_type'] == 3 ? 'selected' : ''; ?>>Credit Card</option>
                                                <option value="4" <?php echo $order['payment_type'] == 4 ? 'selected' : ''; ?>>Phone Pe</option>
                                                <option value="5" <?php echo $order['payment_type'] == 5 ? 'selected' : ''; ?>>Google Pay</option>
                                                <option value="6" <?php echo $order['payment_type'] == 6 ? 'selected' : ''; ?>>Amazon Pay</option>
                                                <option value="7" <?php echo $order['payment_type'] == 7 ? 'selected' : ''; ?>>Bank Transfer</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <label class="control-label">Payment Status *</label>
                                            <select class="form-control" name="payment_status" id="payment_status" required>
                                                <option value="">~~SELECT~~</option>
                                                <option value="1" <?php echo $order['payment_status'] == 1 ? 'selected' : ''; ?>>Full Payment</option>
                                                <option value="2" <?php echo $order['payment_status'] == 2 ? 'selected' : ''; ?>>Advance Payment</option>
                                                <option value="3" <?php echo $order['payment_status'] == 3 ? 'selected' : ''; ?>>Part Payment</option>
                                                <option value="4" <?php echo $order['payment_status'] == 4 ? 'selected' : ''; ?>>No Payment</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Submit Buttons -->
                                <div class="form-group submitButtonFooter text-center">
                                    <button type="submit" id="updateWholesaleOrderBtn" class="btn btn-success btn-lg mr-3">
                                        <i class="fa fa-save"></i> Update Invoice
                                    </button>
                                    <button type="button" class="btn btn-secondary btn-lg mr-3" onclick="window.history.back()">
                                        <i class="fa fa-arrow-left"></i> Back
                                    </button>
                                    <a href="wholesale-invoice.php" class="btn btn-danger btn-lg">
                                        <i class="fa fa-times"></i> Cancel
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.select2-container--default .select2-selection--single {
    border: 1px solid #ddd;
    border-radius: 4px;
    height: 38px;
}

.badge {
    font-size: 12px;
    padding: 5px 10px;
}

.table th {
    background-color: #f8f9fa;
    font-weight: 600;
}

.bg-light {
    background-color: #f8f9fa !important;
}
</style>

<?php include('./constant/layout/footer.php');?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
var rowCount = <?php echo $item_count; ?>;

$(document).ready(function () {
    // Initialize Select2
    $('.select2-product').select2({
        placeholder: "Search for a medicine",
        allowClear: true,
        width: '100%'
    });

    // Initialize calculations
    subAmount();
});

// Include all the JavaScript functions from the previous code (getTotal, subAmount, discountFunc, paidAmount, addRow, removeProductRow, getProductData, resetProductRow)

// Form submission
$("#editWholesaleOrderForm").on('submit', function (e) {
    e.preventDefault();
    
    if (!validateForm()) {
        return false;
    }

    var submitBtn = $("#updateWholesaleOrderBtn");
    var originalText = submitBtn.html();
    submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...');

    $.ajax({
        url: $(this).attr('action'),
        type: 'POST',
        data: $(this).serialize(),
        dataType: 'json',
        success: function (response) {
            if (response.success) {
                $('#success-text').text(response.message);
                $('#success-message').fadeIn();
                
                setTimeout(() => {
                    window.location.href = 'view-wholesale-orders.php';
                }, 2000);
            } else {
                $('#error-text').text(response.message);
                $('#error-message').fadeIn();
            }
        },
        error: function (xhr, status, error) {
            $('#error-text').text('Error updating invoice: ' + error);
            $('#error-message').fadeIn();
        },
        complete: function () {
            submitBtn.prop('disabled', false).html(originalText);
        }
    });
});

function validateForm() {
    var isValid = true;
    $('.text-danger').remove();
    $('.form-group').removeClass('has-error');

    // Required fields validation
    var requiredFields = ['vendor_name', 'vendor_contact', 'payment_type', 'payment_status', 'paid_amount', 'edit_reason'];
    requiredFields.forEach(function(field) {
        var value = $("#" + field).val();
        if (!value) {
            $("#" + field).after('<span class="text-danger">This field is required</span>');
            $("#" + field).closest('.form-group').addClass('has-error');
            isValid = false;
        }
    });

    // Product validation
    var hasProducts = false;
    $("#productTable tbody tr").each(function() {
        var productId = $(this).find('select[name="productName[]"]').val();
        var quantity = $(this).find('input[name="quantity[]"]').val();
        
        if (productId && quantity > 0) {
            hasProducts = true;
        }
    });

    if (!hasProducts) {
        $("#productTable").after('<span class="text-danger">At least one product with quantity is required</span>');
        isValid = false;
    }

    return isValid;
}



var rowCount = 1;

$(document).ready(function () {
    // Initialize Select2
    $('.select2-product').select2({
        placeholder: "Search for a medicine",
        allowClear: true,
        width: '100%'
    });

    // Auto focus search field when select2 opens
    $(document).on('select2:open', () => {
        document.querySelector('.select2-container--open .select2-search__field').focus();
    });

    // Check if we should show success message from session storage
    if (sessionStorage.getItem('showWholesaleSuccessMessage') === 'true') {
        $('#success-message').fadeIn();
        setTimeout(() => {
            $('#success-message').fadeOut();
        }, 5000);
        sessionStorage.removeItem('showWholesaleSuccessMessage');
    }

    // Initialize calculations
    subAmount();
});

/* ================= CALCULATION FUNCTIONS =================== */
function getTotal(row = null) {
    if (!row) { 
        console.error('No row specified'); 
        return; 
    }

    var unitPrice = parseFloat($("#unit_price" + row).val()) || 0;
    var quantity = parseInt($("#quantity" + row).val()) || 0;
    var sgstPercentage = parseFloat($("#sgst_percentage" + row).val()) || 0;
    var cgstPercentage = parseFloat($("#cgst_percentage" + row).val()) || 0;
    var discountPercentage = parseFloat($("#discount_percentage_item" + row).val()) || 0;

    // Validate quantity against available quantity
    var availableQty = parseInt($("#available_quantity" + row).text()) || 0;
    if (quantity > availableQty) {
        alert('Quantity cannot exceed available quantity (' + availableQty + ')');
        $("#quantity" + row).val(availableQty);
        quantity = availableQty;
    }

    var baseAmount = unitPrice * quantity;
    var discountAmount = (baseAmount * discountPercentage) / 100;
    var discountedAmount = baseAmount - discountAmount;

    var sgstAmount = (discountedAmount * sgstPercentage) / 100;
    var cgstAmount = (discountedAmount * cgstPercentage) / 100;

    var total = discountedAmount + sgstAmount + cgstAmount;
    total = total.toFixed(2);

    $("#total" + row).val(total);
    $("#total_value" + row).val(total);

    subAmount();
}

function subAmount() {
    var tableProductLength = $("#productTable tbody tr").length;
    var totalSubAmount = 0, totalSgst = 0, totalCgst = 0;

    for (var x = 1; x <= tableProductLength; x++) {
        if (!$("#row" + x).length) continue;

        var totalValue = parseFloat($("#total_value" + x).val()) || 0;
        totalSubAmount += totalValue;

        var unitPrice = parseFloat($("#unit_price" + x).val()) || 0;
        var quantity = parseInt($("#quantity" + x).val()) || 0;
        var sgstPercentage = parseFloat($("#sgst_percentage" + x).val()) || 0;
        var cgstPercentage = parseFloat($("#cgst_percentage" + x).val()) || 0;
        var discountPercentage = parseFloat($("#discount_percentage_item" + x).val()) || 0;

        var productSubtotal = unitPrice * quantity;
        var productDiscount = (productSubtotal * discountPercentage) / 100;
        var discountedAmount = productSubtotal - productDiscount;
        
        totalSgst += (discountedAmount * sgstPercentage) / 100;
        totalCgst += (discountedAmount * cgstPercentage) / 100;
    }

    $("#sub_total, #sub_total_value").val(totalSubAmount.toFixed(2));
    $("#sgst_total, #sgst_total_value").val(totalSgst.toFixed(2));
    $("#cgst_total, #cgst_total_value").val(totalCgst.toFixed(2));

    var totalAmount = totalSubAmount.toFixed(2);
    $("#total_amount, #total_amount_value").val(totalAmount);

    discountFunc(); // Recalculate with discount
}

function discountFunc() {
    var discountPercentage = parseFloat($("#discount_percentage").val()) || 0;
    var totalAmount = parseFloat($("#total_amount").val()) || 0;

    var discountAmount = (totalAmount * discountPercentage) / 100;
    var grandTotal = totalAmount - discountAmount;

    $("#grand_total, #grand_total_value").val(grandTotal.toFixed(2));
    paidAmount(); // Recalculate due amount
}

function paidAmount() {
    var grandTotal = parseFloat($("#grand_total").val()) || 0;
    var paidAmount = parseFloat($("#paid_amount").val()) || 0;

    var dueAmount = grandTotal - paidAmount;
    $("#due_amount, #due_amount_value").val(dueAmount.toFixed(2));
}

/* ================= DYNAMIC ROWS =================== */
function addRow() {
    rowCount++;
    var newRow = `
        <tr id="row${rowCount}">
            <td>
                <select class="form-control select2-product" name="productName[]" id="productName${rowCount}" onchange="getProductData(${rowCount})" required>
                    <option value="">~~SELECT MEDICINE~~</option>
                    <?php
                    $productOptions = "";
                    $productSql = "SELECT product_id, product_name, categories_name FROM product p INNER JOIN categories c ON p.categories_id = c.categories_id WHERE p.active = 1 AND p.status = 1 ORDER BY p.product_name";
                    $productData = $connect->query($productSql);
                    while ($row = $productData->fetch_assoc()) {
                        $productOptions .= '<option value="'.$row['product_id'].'">'.$row['product_name'].' - '.$row['categories_name'].'</option>';
                    }
                    echo $productOptions;
                    ?>
                </select>
            </td>
            <td><input type="text" name="batch_no[]" id="batch_no${rowCount}" class="form-control" readonly /></td>
            <td><input type="text" name="expiry_date[]" id="expiry_date${rowCount}" class="form-control" readonly /></td>
            <td>
                <input type="text" name="unit_price[]" id="unit_price${rowCount}" class="form-control" readonly />
                <input type="hidden" name="unit_price_value[]" id="unit_price_value${rowCount}" />
            </td>
            <td><span id="available_quantity${rowCount}" class="badge badge-info">0</span></td>
            <td><input type="number" name="quantity[]" id="quantity${rowCount}" onkeyup="getTotal(${rowCount})" class="form-control" min="1" required /></td>
            <td><input type="number" name="sgst_percentage[]" id="sgst_percentage${rowCount}" onkeyup="getTotal(${rowCount})" class="form-control" value="0" step="0.01" min="0" max="100" /></td>
            <td><input type="number" name="cgst_percentage[]" id="cgst_percentage${rowCount}" onkeyup="getTotal(${rowCount})" class="form-control" value="0" step="0.01" min="0" max="100" /></td>
            <td><input type="number" name="discount_percentage_item[]" id="discount_percentage_item${rowCount}" onkeyup="getTotal(${rowCount})" class="form-control" value="0" step="0.01" min="0" max="100" /></td>
            <td>
                <input type="text" name="total[]" id="total${rowCount}" class="form-control" readonly />
                <input type="hidden" name="total_value[]" id="total_value${rowCount}" />
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeProductRow(${rowCount})" title="Remove Row">
                    <i class="fa fa-times"></i>
                </button>
            </td>
        </tr>
    `;

    $("#productTable tbody").append(newRow);
    $(`#productName${rowCount}`).select2({
        placeholder: "Search for a medicine",
        allowClear: true,
        width: '100%'
    });
}

function removeProductRow(row) {
    if ($("#productTable tbody tr").length <= 1) {
        alert("You cannot remove the last row!");
        return;
    }
    
    $(`#row${row}`).remove();
    subAmount();
}

/* ================= FETCH SELECTED PRODUCT =================== */
function getProductData(row) {
    var productId = $(`#productName${row}`).val();
    if (!productId) {
        resetProductRow(row);
        return;
    }

    var selectedOption = $(`#productName${row} option:selected`);
    
    var batchNo = selectedOption.data('bno') || 'N/A';
    var expiryDate = selectedOption.data('expdate') || 'N/A';
    var unitPrice = parseFloat(selectedOption.data('rate')) || 0;
    var sgst = parseFloat(selectedOption.data('sgst')) || 0;
    var cgst = parseFloat(selectedOption.data('cgst')) || 0;
    var availableQty = parseInt(selectedOption.data('quantity')) || 0;

    $(`#batch_no${row}`).val(batchNo);
    $(`#expiry_date${row}`).val(expiryDate);
    $(`#unit_price${row}`).val(unitPrice.toFixed(2));
    $(`#unit_price_value${row}`).val(unitPrice.toFixed(2));
    $(`#available_quantity${row}`).text(availableQty);
    
    // Set default GST values
    if (sgst > 0) $(`#sgst_percentage${row}`).val(sgst);
    if (cgst > 0) $(`#cgst_percentage${row}`).val(cgst);
    
    $(`#quantity${row}`).val(1);
    getTotal(row);
}

function resetProductRow(row) {
    $(`#batch_no${row}`).val('');
    $(`#expiry_date${row}`).val('');
    $(`#unit_price${row}`).val('');
    $(`#unit_price_value${row}`).val('');
    $(`#available_quantity${row}`).text('0');
    $(`#quantity${row}`).val('');
    $(`#sgst_percentage${row}`).val('0');
    $(`#cgst_percentage${row}`).val('0');
    $(`#discount_percentage_item${row}`).val('0');
    $(`#total${row}`).val('');
    $(`#total_value${row}`).val('');
}

/* ================= FORM VALIDATION & SUBMISSION =================== */
$("#createWholesaleOrderForm").on('submit', function (e) {
    e.preventDefault();
    
    if (!validateForm()) {
        return false;
    }

    var submitBtn = $("#createWholesaleOrderBtn");
    var originalText = submitBtn.html();
    submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');

    $.ajax({
        url: $(this).attr('action'),
        type: 'POST',
        data: $(this).serialize(),
        dataType: 'json',
        success: function (response) {
            if (response.success) {
                showSuccessMessage();
                resetOrderForm();
            } else {
                alert('Error: ' + response.messages);
            }
        },
        error: function (xhr, status, error) {
            alert('Error submitting form: ' + error);
            console.error('AJAX Error:', xhr.responseText);
        },
        complete: function () {
            submitBtn.prop('disabled', false).html(originalText);
        }
    });
});

function validateForm() {
    var isValid = true;
    $('.text-danger').remove();
    $('.form-group').removeClass('has-error');

    // Required fields validation
    var requiredFields = ['vendor_name', 'vendor_contact', 'payment_type', 'payment_status', 'paid_amount'];
    requiredFields.forEach(function(field) {
        var value = $("#" + field).val();
        if (!value) {
            $("#" + field).after('<span class="text-danger">This field is required</span>');
            $("#" + field).closest('.form-group').addClass('has-error');
            isValid = false;
        }
    });

    // Product validation
    var hasProducts = false;
    $("#productTable tbody tr").each(function() {
        var productId = $(this).find('select[name="productName[]"]').val();
        var quantity = $(this).find('input[name="quantity[]"]').val();
        
        if (productId && quantity > 0) {
            hasProducts = true;
        }
    });

    if (!hasProducts) {
        $("#productTable").after('<span class="text-danger">At least one product with quantity is required</span>');
        isValid = false;
    }

    return isValid;
}

function showSuccessMessage() {
    $('#success-message').fadeIn();
    setTimeout(() => {
        $('#success-message').fadeOut();
    }, 5000);
    
    sessionStorage.setItem('showWholesaleSuccessMessage', 'true');
}

function resetOrderForm() {
    // Reset form but keep the first product row
    document.getElementById("createWholesaleOrderForm").reset();
    
    // Remove additional rows
    $("#productTable tbody tr:gt(0)").remove();
    
    // Reset first row product data
    resetProductRow(1);
    
    // Reset calculations
    $("#sub_total, #sub_total_value").val("0.00");
    $("#total_amount, #total_amount_value").val("0.00");
    $("#grand_total, #grand_total_value").val("0.00");
    $("#sgst_total, #sgst_total_value").val("0.00");
    $("#cgst_total, #cgst_total_value").val("0.00");
    $("#due_amount, #due_amount_value").val("0.00");
    
    // Reset row count
    rowCount = 1;
    
    // Reinitialize Select2 for first row
    $("#productName1").select2({
        placeholder: "Search for a medicine",
        allowClear: true,
        width: '100%'
    });
}
</script>